/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.zclient.ZFolder;
import com.zimbra.cs.zclient.ZJSONObject;
import com.zimbra.cs.zclient.ZMailbox;
import com.zimbra.cs.zclient.event.ZModifyEvent;
import com.zimbra.cs.zclient.event.ZModifyFolderEvent;
import com.zimbra.cs.zclient.event.ZModifyMountpointEvent;
import org.json.JSONException;

public class ZMountpoint
extends ZFolder {
    private String mOwnerId;
    private String mOwnerDisplayName;
    private String mRemoteId;

    public ZMountpoint(Element e, ZFolder parent, ZMailbox mailbox) throws ServiceException {
        super(e, parent, mailbox);
        this.mOwnerDisplayName = e.getAttribute("owner", null);
        this.mRemoteId = e.getAttribute("rid");
        this.mOwnerId = e.getAttribute("zid");
    }

    public void modifyNotification(ZModifyEvent e) throws ServiceException {
        if (e instanceof ZModifyMountpointEvent) {
            ZModifyMountpointEvent mpe = (ZModifyMountpointEvent)e;
            if (mpe.getId().equals(this.getId())) {
                this.mOwnerDisplayName = mpe.getOwnerDisplayName(this.mOwnerDisplayName);
                this.mRemoteId = mpe.getRemoteId(this.mRemoteId);
                this.mOwnerId = mpe.getOwnerId(this.mOwnerId);
                super.modifyNotification(e);
            }
        } else if (e instanceof ZModifyFolderEvent) {
            super.modifyNotification(e);
        }
    }

    public String toString() {
        return String.format("[ZMountpoint %s]", this.getPath());
    }

    public ZJSONObject toZJSONObject() throws JSONException {
        ZJSONObject jo = super.toZJSONObject();
        jo.put("ownerId", this.mOwnerId);
        jo.put("ownerDisplayName", this.mOwnerDisplayName);
        jo.put("remoteId", this.mRemoteId);
        return jo;
    }

    public String getOwnerDisplayName() {
        return this.mOwnerDisplayName;
    }

    public String getOwnerId() {
        return this.mOwnerId;
    }

    public String getRemoteId() {
        return this.mRemoteId;
    }

    public String getCanonicalRemoteId() {
        return this.mOwnerId + ":" + this.mRemoteId;
    }
}

