/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.zclient.ZEmailAddress;
import com.zimbra.cs.zclient.ZJSONObject;
import com.zimbra.cs.zclient.ZMessage;
import com.zimbra.cs.zclient.ZSearchHit;
import com.zimbra.cs.zclient.event.ZModifyEvent;
import com.zimbra.cs.zclient.event.ZModifyMessageEvent;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZMessageHit
implements ZSearchHit {
    private String mId;
    private String mFlags;
    private String mFragment;
    private String mSubject;
    private String mSortField;
    private String mTags;
    private String mConvId;
    private String mFolderId;
    private float mScore;
    private long mDate;
    private int mSize;
    private boolean mContentMatched;
    private List<String> mMimePartHits;
    private ZEmailAddress mSender;
    private List<ZEmailAddress> mAddresses;
    private ZMessage mMessage;
    private boolean mIsInvite;

    public ZMessageHit(Element e) throws ServiceException {
        this.mId = e.getAttribute("id");
        this.mFolderId = e.getAttribute("l");
        this.mFlags = e.getAttribute("f", null);
        this.mDate = e.getAttributeLong("d");
        this.mTags = e.getAttribute("t", null);
        this.mFragment = e.getAttribute("fr", null);
        this.mSubject = e.getAttribute("su", null);
        this.mSortField = e.getAttribute("sf", null);
        this.mSize = (int)e.getAttributeLong("s");
        this.mConvId = e.getAttribute("cid");
        this.mScore = (float)e.getAttributeDouble("score", 0.0);
        this.mContentMatched = e.getAttributeBool("cm", false);
        this.mMimePartHits = new ArrayList<String>();
        for (Element hp : e.listElements("hp")) {
            this.mMimePartHits.add(hp.getAttribute("part"));
        }
        for (Element emailEl : e.listElements("e")) {
            String t = emailEl.getAttribute("t", null);
            if (!"f".equals(t)) continue;
            this.mSender = new ZEmailAddress(emailEl);
            break;
        }
        this.mAddresses = new ArrayList<ZEmailAddress>();
        for (Element emailEl : e.listElements("e")) {
            this.mAddresses.add(new ZEmailAddress(emailEl));
        }
        Element mp = e.getOptionalElement("mp");
        if (mp != null) {
            this.mMessage = new ZMessage(e, null);
        }
        this.mIsInvite = e.getOptionalElement("inv") != null;
    }

    @Override
    public String getId() {
        return this.mId;
    }

    public boolean getContentMatched() {
        return this.mContentMatched;
    }

    public boolean getIsInvite() {
        return this.mIsInvite;
    }

    @Override
    public ZJSONObject toZJSONObject() throws JSONException {
        ZJSONObject zjo = new ZJSONObject();
        zjo.put("id", this.mId);
        zjo.put("conversationId", this.mConvId);
        zjo.put("flags", this.mFlags);
        zjo.put("isInvite", this.mIsInvite);
        zjo.put("fragment", this.mFragment);
        zjo.put("subject", this.mSubject);
        zjo.put("date", this.mDate);
        zjo.put("size", this.mSize);
        zjo.put("sender", this.mSender);
        zjo.put("sortField", this.mSortField);
        zjo.put("score", this.mScore);
        zjo.putList("mimePartHits", this.mMimePartHits);
        zjo.put("addresses", this.mAddresses);
        zjo.put("message", this.mMessage);
        return zjo;
    }

    public String toString() {
        return String.format("[ZMessageHit %s]", this.mId);
    }

    public String dump() {
        return ZJSONObject.toString(this);
    }

    public String getFlags() {
        return this.mFlags;
    }

    public long getDate() {
        return this.mDate;
    }

    public String getFragment() {
        return this.mFragment;
    }

    @Override
    public String getSortField() {
        return this.mSortField;
    }

    public String getSubject() {
        return this.mSubject;
    }

    public String getTagIds() {
        return this.mTags;
    }

    public String getConversationId() {
        return this.mConvId;
    }

    public List<String> getMimePartHits() {
        return this.mMimePartHits;
    }

    public ZMessage getMessage() {
        return this.mMessage;
    }

    @Override
    public float getScore() {
        return this.mScore;
    }

    public List<ZEmailAddress> getAddresses() {
        return this.mAddresses;
    }

    public ZEmailAddress getSender() {
        return this.mSender;
    }

    public long getSize() {
        return this.mSize;
    }

    public boolean hasFlags() {
        return this.mFlags != null && this.mFlags.length() > 0;
    }

    public boolean hasTags() {
        return this.mTags != null && this.mTags.length() > 0;
    }

    public boolean hasAttachment() {
        return this.hasFlags() && this.mFlags.indexOf(ZMessage.Flag.attachment.getFlagChar()) != -1;
    }

    public boolean isDeleted() {
        return this.hasFlags() && this.mFlags.indexOf(ZMessage.Flag.deleted.getFlagChar()) != -1;
    }

    public boolean isDraft() {
        return this.hasFlags() && this.mFlags.indexOf(ZMessage.Flag.draft.getFlagChar()) != -1;
    }

    public boolean isFlagged() {
        return this.hasFlags() && this.mFlags.indexOf(ZMessage.Flag.flagged.getFlagChar()) != -1;
    }

    public boolean isHighPriority() {
        return this.hasFlags() && this.mFlags.indexOf(ZMessage.Flag.highPriority.getFlagChar()) != -1;
    }

    public boolean isLowPriority() {
        return this.hasFlags() && this.mFlags.indexOf(ZMessage.Flag.lowPriority.getFlagChar()) != -1;
    }

    public boolean isForwarded() {
        return this.hasFlags() && this.mFlags.indexOf(ZMessage.Flag.forwarded.getFlagChar()) != -1;
    }

    public boolean isNotificationSent() {
        return this.hasFlags() && this.mFlags.indexOf(ZMessage.Flag.notificationSent.getFlagChar()) != -1;
    }

    public boolean isRepliedTo() {
        return this.hasFlags() && this.mFlags.indexOf(ZMessage.Flag.replied.getFlagChar()) != -1;
    }

    public boolean isSentByMe() {
        return this.hasFlags() && this.mFlags.indexOf(ZMessage.Flag.sentByMe.getFlagChar()) != -1;
    }

    public boolean isUnread() {
        return this.hasFlags() && this.mFlags.indexOf(ZMessage.Flag.unread.getFlagChar()) != -1;
    }

    public String getFolderId() {
        return this.mFolderId;
    }

    @Override
    public void modifyNotification(ZModifyEvent event) throws ServiceException {
        if (event instanceof ZModifyMessageEvent) {
            ZModifyMessageEvent mevent = (ZModifyMessageEvent)event;
            this.mFlags = mevent.getFlags(this.mFlags);
            this.mTags = mevent.getTagIds(this.mTags);
            this.mFolderId = mevent.getFolderId(this.mFolderId);
            this.mConvId = mevent.getConversationId(this.mConvId);
            if (this.getMessage() != null) {
                this.getMessage().modifyNotification(event);
            }
        }
    }
}

