/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.zclient.ZClientException;
import com.zimbra.cs.zclient.ToZJSONObject;
import com.zimbra.cs.zclient.ZEmailAddress;
import com.zimbra.cs.zclient.ZFolder;
import com.zimbra.cs.zclient.ZInvite;
import com.zimbra.cs.zclient.ZItem;
import com.zimbra.cs.zclient.ZJSONObject;
import com.zimbra.cs.zclient.ZMailbox;
import com.zimbra.cs.zclient.ZShare;
import com.zimbra.cs.zclient.ZTag;
import com.zimbra.cs.zclient.event.ZModifyEvent;
import com.zimbra.cs.zclient.event.ZModifyMessageEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZMessage
implements ZItem,
ToZJSONObject {
    private String mId;
    private String mFlags;
    private String mSubject;
    private String mFragment;
    private String mTags;
    private String mFolderId;
    private String mConversationId;
    private String mPartName;
    private long mReceivedDate;
    private long mSentDate;
    private String mMessageIdHeader;
    private List<ZEmailAddress> mAddresses;
    private ZMimePart mMimeStructure;
    private String mContent;
    private String mContentURL;
    private long mSize;
    private String mReplyType;
    private String mInReplyTo;
    private String mOrigId;
    private ZInvite mInvite;
    private ZShare mShare;
    private ZMailbox mMailbox;
    private Map<String, String> mReqHdrs;

    public ZMessage(Element e, ZMailbox mailbox) throws ServiceException {
        String shareContent;
        Element shrEl;
        Element inviteEl;
        Element mp;
        this.mMailbox = mailbox;
        this.mId = e.getAttribute("id");
        this.mFlags = e.getAttribute("f", null);
        this.mTags = e.getAttribute("t", null);
        this.mReplyType = e.getAttribute("rt", null);
        this.mOrigId = e.getAttribute("origid", null);
        this.mSubject = e.getAttribute("su", null);
        this.mFragment = e.getAttribute("fr", null);
        this.mMessageIdHeader = e.getAttribute("mid", null);
        this.mInReplyTo = e.getAttribute("irt", null);
        this.mReceivedDate = e.getAttributeLong("d", 0L);
        this.mSentDate = e.getAttributeLong("sd", 0L);
        this.mFolderId = e.getAttribute("l", null);
        this.mConversationId = e.getAttribute("cid", null);
        this.mPartName = e.getAttribute("part", null);
        this.mSize = e.getAttributeLong("s", -1L);
        Element content = e.getOptionalElement("content");
        if (content != null) {
            this.mContent = content.getText();
            this.mContentURL = content.getAttribute("url", null);
        }
        this.mAddresses = new ArrayList<ZEmailAddress>();
        for (Element emailEl : e.listElements("e")) {
            this.mAddresses.add(new ZEmailAddress(emailEl));
        }
        this.mReqHdrs = new HashMap<String, String>();
        Element attrsEl = e.getOptionalElement("_attrs");
        if (attrsEl != null) {
            for (Element.Attribute eHdr : attrsEl.listAttributes()) {
                this.mReqHdrs.put(eHdr.getKey(), eHdr.getValue());
            }
        }
        if ((mp = e.getOptionalElement("mp")) != null) {
            this.mMimeStructure = new ZMimePart(null, mp);
        }
        if ((inviteEl = e.getOptionalElement("inv")) != null) {
            this.mInvite = new ZInvite(inviteEl);
        }
        if ((shrEl = e.getOptionalElement("shr")) != null && (shareContent = shrEl.getAttribute("content")) != null) {
            this.mShare = ZShare.parseXml(shareContent);
        }
    }

    @Override
    public void modifyNotification(ZModifyEvent event) throws ServiceException {
        ZModifyMessageEvent mevent;
        if (event instanceof ZModifyMessageEvent && (mevent = (ZModifyMessageEvent)event).getId().equals(this.mId)) {
            this.mFlags = mevent.getFlags(this.mFlags);
            this.mTags = mevent.getTagIds(this.mTags);
            this.mFolderId = mevent.getFolderId(this.mFolderId);
            this.mConversationId = mevent.getConversationId(this.mConversationId);
        }
    }

    public ZMailbox getMailbox() {
        return this.mMailbox;
    }

    public ZShare getShare() {
        return this.mShare;
    }

    public ZInvite getInvite() {
        return this.mInvite;
    }

    public String getOriginalId() {
        return this.mOrigId;
    }

    public String getInReplyTo() {
        return this.mInReplyTo;
    }

    public String getReplyType() {
        return this.mReplyType;
    }

    public long getSize() {
        return this.mSize;
    }

    @Override
    public String getId() {
        return this.mId;
    }

    public boolean hasFlags() {
        return this.mFlags != null && this.mFlags.length() > 0;
    }

    public boolean hasTags() {
        return this.mTags != null && this.mTags.length() > 0;
    }

    @Override
    public ZJSONObject toZJSONObject() throws JSONException {
        ZJSONObject zjo = new ZJSONObject();
        zjo.put("id", this.mId);
        zjo.put("flags", this.mFlags);
        zjo.put("tagIds", this.mTags);
        zjo.put("inReplyTo", this.mInReplyTo);
        zjo.put("originalId", this.mOrigId);
        zjo.put("subject", this.mSubject);
        zjo.put("fragment", this.mFragment);
        zjo.put("partName", this.mPartName);
        zjo.put("messageIdHeader", this.mMessageIdHeader);
        zjo.put("receivedDate", this.mReceivedDate);
        zjo.put("sentDate", this.mSentDate);
        zjo.put("folderId", this.mFolderId);
        zjo.put("conversationId", this.mConversationId);
        zjo.put("size", this.mSize);
        zjo.put("content", this.mContent);
        zjo.put("contentURL", this.mContentURL);
        zjo.put("addresses", this.mAddresses);
        zjo.put("mimeStructure", this.mMimeStructure);
        zjo.put("invite", this.mInvite);
        zjo.put("share", this.mShare);
        zjo.put("isInvite", this.getInvite() != null);
        zjo.put("hasAttachment", this.hasAttachment());
        zjo.put("hasFlags", this.hasFlags());
        zjo.put("hasTags", this.hasTags());
        zjo.put("isDeleted", this.isDeleted());
        zjo.put("isDraft", this.isDraft());
        zjo.put("isFlagged", this.isFlagged());
        zjo.put("isHighPriority", this.isHighPriority());
        zjo.put("isLowPriority", this.isLowPriority());
        zjo.put("isForwarded", this.isForwarded());
        zjo.put("isNotificationSent", this.isNotificationSent());
        zjo.put("isRepliedTo", this.isRepliedTo());
        zjo.put("isSentByMe", this.isSentByMe());
        zjo.put("isUnread", this.isUnread());
        zjo.putMap("requestHeaders", this.mReqHdrs);
        return zjo;
    }

    public String toString() {
        return String.format("[ZMessage %s]", this.mId);
    }

    public String dump() {
        return ZJSONObject.toString(this);
    }

    public String getPartName() {
        return this.mPartName;
    }

    public String getFlags() {
        return this.mFlags;
    }

    public String getSubject() {
        return this.mSubject;
    }

    public String getFragment() {
        return this.mFragment;
    }

    public String getTagIds() {
        return this.mTags;
    }

    public String getConversationId() {
        return this.mConversationId;
    }

    public Map<String, String> getRequestHeader() {
        return this.mReqHdrs;
    }

    public List<ZEmailAddress> getEmailAddresses() {
        return this.mAddresses;
    }

    public String getFolderId() {
        return this.mFolderId;
    }

    public String getMessageIdHeader() {
        return this.mMessageIdHeader;
    }

    public ZMimePart getMimeStructure() {
        return this.mMimeStructure;
    }

    public long getReceivedDate() {
        return this.mReceivedDate;
    }

    public long getSentDate() {
        return this.mSentDate;
    }

    public String getContent() {
        return this.mContent;
    }

    public String getContentURL() {
        return this.mContentURL;
    }

    public boolean hasAttachment() {
        return this.hasFlags() && this.mFlags.indexOf(Flag.attachment.getFlagChar()) != -1;
    }

    public boolean isDeleted() {
        return this.hasFlags() && this.mFlags.indexOf(Flag.deleted.getFlagChar()) != -1;
    }

    public boolean isDraft() {
        return this.hasFlags() && this.mFlags.indexOf(Flag.draft.getFlagChar()) != -1;
    }

    public boolean isFlagged() {
        return this.hasFlags() && this.mFlags.indexOf(Flag.flagged.getFlagChar()) != -1;
    }

    public boolean isForwarded() {
        return this.hasFlags() && this.mFlags.indexOf(Flag.forwarded.getFlagChar()) != -1;
    }

    public boolean isNotificationSent() {
        return this.hasFlags() && this.mFlags.indexOf(Flag.notificationSent.getFlagChar()) != -1;
    }

    public boolean isRepliedTo() {
        return this.hasFlags() && this.mFlags.indexOf(Flag.replied.getFlagChar()) != -1;
    }

    public boolean isSentByMe() {
        return this.hasFlags() && this.mFlags.indexOf(Flag.sentByMe.getFlagChar()) != -1;
    }

    public boolean isUnread() {
        return this.hasFlags() && this.mFlags.indexOf(Flag.unread.getFlagChar()) != -1;
    }

    public boolean isHighPriority() {
        return this.hasFlags() && this.mFlags.indexOf(Flag.highPriority.getFlagChar()) != -1;
    }

    public boolean isLowPriority() {
        return this.hasFlags() && this.mFlags.indexOf(Flag.lowPriority.getFlagChar()) != -1;
    }

    public void delete() throws ServiceException {
        this.getMailbox().deleteMessage(this.getId());
    }

    public void deleteItem() throws ServiceException {
        this.delete();
    }

    public void trash() throws ServiceException {
        this.getMailbox().trashMessage(this.getId());
    }

    public void markRead(boolean read) throws ServiceException {
        this.getMailbox().markMessageRead(this.getId(), read);
    }

    public void flag(boolean flag) throws ServiceException {
        this.getMailbox().flagMessage(this.getId(), flag);
    }

    public void tag(String nameOrId, boolean tagged) throws ServiceException {
        ZTag tag = this.mMailbox.getTag(nameOrId);
        if (tag == null) {
            throw ZClientException.CLIENT_ERROR("unknown tag: " + nameOrId, null);
        }
        this.tag(tag, tagged);
    }

    public void tag(ZTag tag, boolean tagged) throws ServiceException {
        this.mMailbox.tagMessage(this.mId, tag.getId(), tagged);
    }

    public void move(String pathOrId) throws ServiceException {
        ZFolder destFolder = this.mMailbox.getFolder(pathOrId);
        if (destFolder == null) {
            throw ZClientException.CLIENT_ERROR("unknown folder: " + pathOrId, null);
        }
        this.move(destFolder);
    }

    public void move(ZFolder destFolder) throws ServiceException {
        this.mMailbox.moveMessage(this.mId, destFolder.getId());
    }

    public void markSpam(boolean spam, String pathOrId) throws ServiceException {
        ZFolder destFolder = this.mMailbox.getFolder(pathOrId);
        if (destFolder == null) {
            throw ZClientException.CLIENT_ERROR("unknown folder: " + pathOrId, null);
        }
        this.markSpam(spam, destFolder);
    }

    public void markSpam(boolean spam, ZFolder destFolder) throws ServiceException {
        this.getMailbox().markMessageSpam(this.getId(), spam, destFolder == null ? null : destFolder.getId());
    }

    public void update(String destFolderId, String tagList, String flags) throws ServiceException {
        this.getMailbox().updateMessage(this.getId(), destFolderId, tagList, flags);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ZMimePart
    implements ToZJSONObject {
        private String mPartName;
        private String mName;
        private String mContentType;
        private String mContentDisposition;
        private String mFileName;
        private String mContentId;
        private String mContentLocation;
        private String mContentDescription;
        private String mContent;
        private boolean mIsBody;
        private List<ZMimePart> mChildren;
        private long mSize;
        private ZMimePart mParent;
        private boolean mTruncated;

        public ZMimePart(ZMimePart parent, Element e) throws ServiceException {
            this.mParent = parent;
            this.mPartName = e.getAttribute("part");
            this.mName = e.getAttribute("name", null);
            this.mContentType = e.getAttribute("ct", null);
            this.mContentDisposition = e.getAttribute("cd", null);
            this.mFileName = e.getAttribute("filename", null);
            this.mContentId = e.getAttribute("ci", null);
            this.mContentDescription = e.getAttribute("cde", null);
            this.mContentLocation = e.getAttribute("cl", null);
            this.mIsBody = e.getAttributeBool("body", false);
            this.mSize = e.getAttributeLong("s", 0L);
            this.mContent = e.getAttribute("content", null);
            this.mChildren = new ArrayList<ZMimePart>();
            for (Element mpEl : e.listElements("mp")) {
                this.mChildren.add(new ZMimePart(this, mpEl));
            }
            this.mTruncated = e.getAttributeBool("truncated", false);
        }

        @Override
        public ZJSONObject toZJSONObject() throws JSONException {
            ZJSONObject zjo = new ZJSONObject();
            zjo.put("partName", this.mPartName);
            zjo.put("content", this.mContent);
            zjo.put("contentType", this.mContentType);
            zjo.put("contentDisposition", this.mContentDisposition);
            zjo.put("contentId", this.mContentId);
            zjo.put("contentLocation", this.mContentLocation);
            zjo.put("contentDescription", this.mContentDescription);
            zjo.put("isBody", this.mIsBody);
            zjo.put("size", this.mSize);
            zjo.put("name", this.mName);
            zjo.put("fileName", this.mFileName);
            zjo.put("children", this.mChildren);
            return zjo;
        }

        public String toString() {
            return String.format("[ZMimePart %s]", this.mPartName);
        }

        public String dump() {
            return ZJSONObject.toString(this);
        }

        public ZMimePart getParent() {
            return this.mParent;
        }

        public String getPartName() {
            return this.mPartName;
        }

        public String getName() {
            return this.mName;
        }

        public String getContentType() {
            return this.mContentType;
        }

        public String getContentDispostion() {
            return this.mContentDisposition;
        }

        public String getFileName() {
            return this.mFileName;
        }

        public String getContentId() {
            return this.mContentId;
        }

        public String getContentLocation() {
            return this.mContentLocation;
        }

        public String getContentDescription() {
            return this.mContentDescription;
        }

        public String getContent() {
            return this.mContent;
        }

        public boolean isBody() {
            return this.mIsBody;
        }

        public List<ZMimePart> getChildren() {
            return this.mChildren;
        }

        public long getSize() {
            return this.mSize;
        }

        public boolean wasTruncated() {
            return this.mTruncated;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Flag {
        unread('u'),
        flagged('f'),
        highPriority('!'),
        lowPriority('?'),
        attachment('a'),
        replied('r'),
        sentByMe('s'),
        forwarded('w'),
        draft('d'),
        deleted('x'),
        notificationSent('n');

        private char mFlagChar;

        public char getFlagChar() {
            return this.mFlagChar;
        }

        public static String toNameList(String flags) {
            if (flags == null || flags.length() == 0) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < flags.length(); ++i) {
                String v = null;
                for (Flag f : Flag.values()) {
                    if (f.getFlagChar() != flags.charAt(i)) continue;
                    v = f.name();
                    break;
                }
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(v == null ? flags.substring(i, i + 1) : v);
            }
            return sb.toString();
        }

        private Flag(char flagChar) {
            this.mFlagChar = flagChar;
        }
    }
}

