/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient;

import com.zimbra.common.auth.ZAuthToken;
import com.zimbra.common.localconfig.LC;
import com.zimbra.common.mailbox.ContactConstants;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.SoapProtocol;
import com.zimbra.common.soap.SoapTransport;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.CliUtil;
import com.zimbra.common.util.DateUtil;
import com.zimbra.common.util.EmailUtil;
import com.zimbra.common.util.HttpUtil;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.zclient.ZClientException;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.RightManager;
import com.zimbra.cs.account.accesscontrol.UserRight;
import com.zimbra.cs.account.soap.SoapAccountInfo;
import com.zimbra.cs.account.soap.SoapProvisioning;
import com.zimbra.cs.mailbox.Contact;
import com.zimbra.cs.util.BuildInfo;
import com.zimbra.cs.util.SoapCLI;
import com.zimbra.cs.zclient.ZAce;
import com.zimbra.cs.zclient.ZAppointmentHit;
import com.zimbra.cs.zclient.ZAutoCompleteMatch;
import com.zimbra.cs.zclient.ZContact;
import com.zimbra.cs.zclient.ZContactHit;
import com.zimbra.cs.zclient.ZConversation;
import com.zimbra.cs.zclient.ZConversationHit;
import com.zimbra.cs.zclient.ZDocument;
import com.zimbra.cs.zclient.ZDocumentHit;
import com.zimbra.cs.zclient.ZEmailAddress;
import com.zimbra.cs.zclient.ZFilterRule;
import com.zimbra.cs.zclient.ZFilterRules;
import com.zimbra.cs.zclient.ZFolder;
import com.zimbra.cs.zclient.ZGetMessageParams;
import com.zimbra.cs.zclient.ZGrant;
import com.zimbra.cs.zclient.ZIdentity;
import com.zimbra.cs.zclient.ZMailbox;
import com.zimbra.cs.zclient.ZMessage;
import com.zimbra.cs.zclient.ZMessageHit;
import com.zimbra.cs.zclient.ZMountpoint;
import com.zimbra.cs.zclient.ZSearchFolder;
import com.zimbra.cs.zclient.ZSearchHit;
import com.zimbra.cs.zclient.ZSearchPagerResult;
import com.zimbra.cs.zclient.ZSearchParams;
import com.zimbra.cs.zclient.ZSearchResult;
import com.zimbra.cs.zclient.ZSignature;
import com.zimbra.cs.zclient.ZTag;
import com.zimbra.cs.zclient.event.ZCreateEvent;
import com.zimbra.cs.zclient.event.ZDeleteEvent;
import com.zimbra.cs.zclient.event.ZEventHandler;
import com.zimbra.cs.zclient.event.ZModifyEvent;
import com.zimbra.cs.zclient.event.ZRefreshEvent;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZMailboxUtil
implements SoapTransport.DebugListener {
    private boolean mInteractive = false;
    private boolean mGlobalVerbose = false;
    private boolean mDebug = false;
    private String mAdminAccountName = null;
    private String mMailboxName = null;
    private String mPassword = null;
    private ZAuthToken mAdminAuthToken = null;
    private static final String DEFAULT_ADMIN_URL = "https://" + LC.zimbra_zmprov_default_soap_server.value() + ":" + LC.zimbra_admin_service_port.intValue() + "/";
    private static final String DEFAULT_URL = "http://" + LC.zimbra_zmprov_default_soap_server.value() + "/";
    private static final int ADMIN_PORT = LC.zimbra_admin_service_port.intValue();
    private String mUrl = DEFAULT_URL;
    private Map<String, Command> mCommandIndex;
    private ZMailbox mMbox;
    private String mPrompt = "mbox> ";
    ZSearchParams mSearchParams;
    int mSearchPage;
    ZSearchParams mConvSearchParams;
    ZSearchResult mConvSearchResult;
    SoapProvisioning mProv;
    SoapProtocol mRequestProto = SoapProtocol.SoapJS;
    SoapProtocol mResponseProto = SoapProtocol.SoapJS;
    private int mTimeout = LC.httpclient_connmgr_so_timeout.intValue();
    private Map<Integer, String> mIndexToId = new HashMap<Integer, String>();
    private Command mCommand;
    private CommandLine mCommandLine;
    private CommandLineParser mParser = new GnuParser();
    static Option O_AFTER = new Option("a", "after", true, "add after filter-name");
    static Option O_BEFORE = new Option("b", "before", true, "add before filter-name");
    static Option O_COLOR = new Option("c", "color", true, "color");
    static Option O_CONTENT_TYPE = new Option("c", "contentType", true, "content-type");
    static Option O_CURRENT = new Option("c", "current", false, "current page of search results");
    static Option O_DATE = new Option("d", "date", true, "received date (msecs since epoch)");
    static Option O_FIRST = new Option("f", "first", false, "add as first filter rule");
    static Option O_FLAGS = new Option("F", "flags", true, "flags");
    static Option O_FOLDER = new Option("f", "folder", true, "folder-path-or-id");
    static Option O_IGNORE = new Option("i", "ignore", false, "ignore unknown contact attrs");
    static Option O_IGNORE_ERROR = new Option("i", "ignore", false, "ignore and continue on error during ics import");
    static Option O_LAST = new Option("l", "last", false, "add as last filter rule");
    static Option O_LIMIT = new Option("l", "limit", true, "max number of results to return");
    static Option O_NEXT = new Option("n", "next", false, "next page of search results");
    static Option O_OUTPUT_FILE = new Option("o", "output", true, "output filename");
    static Option O_PRESERVE_ALARMS = new Option(null, "preserveAlarms", false, "preserve existing calendar alarms during ics import (default is to use alarms in ics file)");
    static Option O_START_TIME = new Option(null, "startTime", true, "start time for ics export");
    static Option O_END_TIME = new Option(null, "endTime", true, "end time for ics export");
    static Option O_PREVIOUS = new Option("p", "previous", false, "previous page of search results");
    static Option O_SORT = new Option("s", "sort", true, "sort order TODO");
    static Option O_REPLACE = new Option("r", "replace", false, "replace contact (default is to merge)");
    static Option O_TAGS = new Option("T", "tags", true, "list of tag ids/names");
    static Option O_TYPES = new Option("t", "types", true, "list of types to search for (message,conversation,contact,appointment,document,task,wiki)");
    static Option O_URL = new Option("u", "url", true, "url to connect to");
    static Option O_VERBOSE = new Option("v", "verbose", false, "verbose output");
    static Option O_VIEW = new Option("V", "view", true, "default type for folder (appointment,contact,conversation,document,message,task,wiki)");
    static Option O_NO_VALIDATION = new Option(null, "noValidation", false, "don't validate file content");
    private static final long KBYTES = 1024L;
    private static final long MBYTES = 0x100000L;
    private static final long GBYTES = 0x40000000L;
    Pattern sTargetConstraint = Pattern.compile("\\{(.*)\\}$");
    private ZEventHandler mTraceHandler = new TraceHandler();
    private static PrintWriter stdout;
    private static PrintWriter stderr;
    private static Session mSession;
    String mConvSearchConvId;
    private long mSendStart;

    public void setDebug(boolean debug) {
        this.mDebug = debug;
    }

    public void setVerbose(boolean verbose) {
        this.mGlobalVerbose = verbose;
    }

    public void setInteractive(boolean interactive) {
        this.mInteractive = interactive;
    }

    public void setAdminAccountName(String account) {
        this.mAdminAccountName = account;
    }

    public void setMailboxName(String account) {
        this.mMailboxName = account;
    }

    public void setPassword(String password) {
        this.mPassword = password;
    }

    public void setAdminAuthToken(ZAuthToken authToken) {
        this.mAdminAuthToken = authToken;
    }

    private SoapProtocol parseProto(String proto) throws ZClientException {
        if ("soap11".equals(proto)) {
            return SoapProtocol.Soap11;
        }
        if ("soap12".equals(proto)) {
            return SoapProtocol.Soap12;
        }
        if ("json".equals(proto)) {
            return SoapProtocol.SoapJS;
        }
        throw ZClientException.CLIENT_ERROR("unknown protocol: " + proto, null);
    }

    public void setProtocol(String proto) throws ZClientException {
        if (proto.indexOf(47) != -1) {
            String[] protos = proto.split("/");
            this.mRequestProto = this.parseProto(protos[0]);
            this.mResponseProto = this.parseProto(protos[1]);
        } else {
            this.mRequestProto = this.mResponseProto = this.parseProto(proto);
        }
    }

    public void setUrl(String url, boolean admin) throws ServiceException {
        this.mUrl = ZMailbox.resolveUrl(url, admin);
    }

    public void setTimeout(String timeout) throws ServiceException {
        int num;
        try {
            num = Integer.parseInt(timeout);
        }
        catch (NumberFormatException e) {
            throw ServiceException.INVALID_REQUEST("Invalid timeout value " + timeout, e);
        }
        if (num < 0) {
            throw ServiceException.INVALID_REQUEST("Timeout can't be negative", null);
        }
        this.mTimeout = num * 1000;
    }

    private void usage() {
        if (this.mCommand != null) {
            stdout.printf("usage:%n%n%s%n", this.mCommand.getFullUsage());
        }
        if (this.mInteractive) {
            return;
        }
        stdout.println("");
        stdout.println("zmmailbox [args] [cmd] [cmd-args ...]");
        stdout.println("");
        stdout.println("  -h/--help                                display usage");
        stdout.println("  -f/--file                                use file as input stream");
        stdout.println("  -u/--url      http[s]://{host}[:{port}]  server hostname and optional port. must use admin port with -z/-a");
        stdout.println("  -a/--admin    {name}                     admin account name to auth as");
        stdout.println("  -z/--zadmin                              use zimbra admin name/password from localconfig for admin/password");
        stdout.println("  -y/--authtoken {authtoken}               " + SoapCLI.OPT_AUTHTOKEN.getDescription());
        stdout.println("  -Y/--authtokenfile {authtoken file}      " + SoapCLI.OPT_AUTHTOKENFILE.getDescription());
        stdout.println("  -m/--mailbox  {name}                     mailbox to open");
        stdout.println("  -p/--password {pass}                     password for admin account and/or mailbox");
        stdout.println("  -P/--passfile {file}                     read password from file");
        stdout.println("  -r/--protocol {proto|req-proto/response-proto} specify request/response protocol [soap11,soap12,json]");
        stdout.println("  -t/--timeout                             timeout (in seconds)");
        stdout.println("  -v/--verbose                             verbose mode (dumps full exception stack trace)");
        stdout.println("  -d/--debug                               debug mode (dumps SOAP messages)");
        stdout.println("");
        this.doHelp(null);
        System.exit(1);
    }

    public static Option getOption(String shortName, String longName, boolean hasArgs, String help) {
        return new Option(shortName, longName, hasArgs, help);
    }

    private String formatSize(long size) {
        if (size > 0x40000000L) {
            return String.format("%.2f GB", (double)size / 1.073741824E9);
        }
        if (size > 0x100000L) {
            return String.format("%.2f MB", (double)size / 1048576.0);
        }
        if (size > 1024L) {
            return String.format("%.2f KB", (double)size / 1024.0);
        }
        return String.format("%d B", size);
    }

    private boolean isId(String value) {
        return value.length() == 36 && value.charAt(8) == '-' && value.charAt(13) == '-' && value.charAt(18) == '-' && value.charAt(23) == '-';
    }

    private void addCommand(Command command) {
        String name = command.getName().toLowerCase();
        if (this.mCommandIndex.get(name) != null) {
            throw new RuntimeException("duplicate command: " + name);
        }
        String alias = command.getAlias().toLowerCase();
        if (this.mCommandIndex.get(alias) != null) {
            throw new RuntimeException("duplicate command: " + alias);
        }
        this.mCommandIndex.put(name, command);
        this.mCommandIndex.put(alias, command);
    }

    private void initCommands() {
        this.mCommandIndex = new HashMap<String, Command>();
        for (Command c : Command.values()) {
            this.addCommand(c);
        }
    }

    private Command lookupCommand(String command) {
        return this.mCommandIndex.get(command.toLowerCase());
    }

    public ZMailboxUtil() {
        this.initCommands();
    }

    private ZMailbox.Options getMailboxOptions(SoapProvisioning prov, Provisioning.AccountBy by, String key, int lifetimeSeconds) throws ServiceException {
        SoapAccountInfo sai = prov.getAccountInfo(by, key);
        SoapProvisioning.DelegateAuthResponse dar = prov.delegateAuth(by, key, lifetimeSeconds > 0 ? lifetimeSeconds : 86400);
        return new ZMailbox.Options(dar.getAuthToken(), sai.getAdminSoapURL());
    }

    public void selectMailbox(String targetAccount, SoapProvisioning prov) throws ServiceException {
        if (prov == null) {
            throw ZClientException.CLIENT_ERROR("can only select mailbox after adminAuthenticate", null);
        }
        if (this.mProv == null) {
            this.mProv = prov;
        }
        this.mMbox = null;
        this.mMailboxName = targetAccount;
        ZMailbox.Options options = this.getMailboxOptions(prov, Provisioning.AccountBy.name, this.mMailboxName, 86400);
        options.setRequestProtocol(this.mRequestProto);
        options.setResponseProtocol(this.mResponseProto);
        options.setTimeout(this.mTimeout);
        if (prov.soapGetTransportDebugListener() != null) {
            options.setDebugListener(prov.soapGetTransportDebugListener());
        } else {
            options.setHttpDebugListener(prov.soapGetHttpTransportDebugListener());
        }
        this.mMbox = ZMailbox.getMailbox(options);
        this.dumpMailboxConnect();
        this.mPrompt = String.format("mbox %s> ", this.mMbox.getName());
        this.mSearchParams = null;
        this.mConvSearchParams = null;
        this.mConvSearchResult = null;
        this.mIndexToId.clear();
    }

    public void selectMailbox(String targetAccount) throws ServiceException {
        this.selectMailbox(targetAccount, this.mProv);
    }

    private void adminAuth(String name, String password, String uri) throws ServiceException {
        this.mAdminAccountName = name;
        this.mPassword = password;
        ZMailboxUtil listener = this.mDebug ? this : null;
        this.mProv = new SoapProvisioning();
        this.mProv.soapSetURI(ZMailbox.resolveUrl(uri, true));
        if (listener != null) {
            this.mProv.soapSetTransportDebugListener(listener);
        }
        this.mProv.soapAdminAuthenticate(name, password);
    }

    private void adminAuth(ZAuthToken zat, String uri) throws ServiceException {
        ZMailboxUtil listener = this.mDebug ? this : null;
        this.mProv = new SoapProvisioning();
        this.mProv.soapSetURI(ZMailbox.resolveUrl(uri, true));
        if (listener != null) {
            this.mProv.soapSetTransportDebugListener(listener);
        }
        this.mProv.soapAdminAuthenticate(zat);
    }

    private void auth(String name, String password, String uri) throws ServiceException {
        this.mMailboxName = name;
        this.mPassword = password;
        ZMailbox.Options options = new ZMailbox.Options();
        options.setAccount(this.mMailboxName);
        options.setAccountBy(Provisioning.AccountBy.name);
        options.setPassword(this.mPassword);
        options.setUri(ZMailbox.resolveUrl(uri, false));
        options.setDebugListener(this.mDebug ? this : null);
        options.setRequestProtocol(this.mRequestProto);
        options.setResponseProtocol(this.mResponseProto);
        options.setTimeout(this.mTimeout);
        this.mMbox = ZMailbox.getMailbox(options);
        this.mPrompt = String.format("mbox %s> ", this.mMbox.getName());
        this.dumpMailboxConnect();
    }

    private void computeStats(ZFolder f, Stats s) {
        s.numMessages += f.getMessageCount();
        s.numUnread += f.getUnreadCount();
        for (ZFolder c : f.getSubFolders()) {
            this.computeStats(c, s);
        }
    }

    private void dumpMailboxConnect() throws ServiceException {
        if (!this.mInteractive) {
            return;
        }
        Stats s = new Stats();
        this.computeStats(this.mMbox.getUserRoot(), s);
        stdout.format("mailbox: %s, size: %s, messages: %d, unread: %d%n", this.mMbox.getName(), this.formatSize(this.mMbox.getSize()), s.numMessages, s.numUnread);
    }

    public void initMailbox() throws ServiceException {
        if (this.mPassword == null && this.mAdminAuthToken == null) {
            return;
        }
        if (this.mAdminAccountName != null) {
            this.adminAuth(this.mAdminAccountName, this.mPassword, this.mUrl);
        } else if (this.mAdminAuthToken != null) {
            this.adminAuth(this.mAdminAuthToken, this.mUrl);
        }
        if (this.mMailboxName == null) {
            return;
        }
        if (this.mAdminAccountName != null) {
            this.selectMailbox(this.mMailboxName);
        } else {
            this.auth(this.mMailboxName, this.mPassword, this.mUrl);
        }
    }

    private ZTag lookupTag(String idOrName) throws ServiceException {
        ZTag tag = this.mMbox.getTagByName(idOrName);
        if (tag == null) {
            tag = this.mMbox.getTagById(idOrName);
        }
        if (tag == null) {
            throw ZClientException.CLIENT_ERROR("unknown tag: " + idOrName, null);
        }
        return tag;
    }

    private String lookupTagIds(String idsOrNames) throws ServiceException {
        StringBuilder ids = new StringBuilder();
        for (String t : idsOrNames.split(",")) {
            ZTag tag = this.lookupTag(t);
            if (ids.length() > 0) {
                ids.append(",");
            }
            ids.append(tag.getId());
        }
        return ids.toString();
    }

    private String lookupTagNames(String ids) throws ServiceException {
        StringBuilder names = new StringBuilder();
        for (String tid : ids.split(",")) {
            ZTag tag = this.lookupTag(tid);
            if (names.length() > 0) {
                names.append(", ");
            }
            names.append(tag == null ? tid : tag.getName());
        }
        return names.toString();
    }

    private String lookupFolderId(String pathOrId) throws ServiceException {
        return this.lookupFolderId(pathOrId, false);
    }

    private String getTargetContstraint(String indexOrId) {
        Matcher m = this.sTargetConstraint.matcher(indexOrId);
        return m.find() ? m.group(1) : null;
    }

    private String id(String indexOrId) throws ServiceException {
        Matcher m = this.sTargetConstraint.matcher(indexOrId);
        if (m.find()) {
            indexOrId = m.replaceAll("");
        }
        StringBuilder ids = new StringBuilder();
        for (String t : indexOrId.split(",")) {
            if (t.length() > 1 && t.charAt(0) == '#') {
                int i = (t = t.substring(1)).indexOf(45);
                if (i != -1) {
                    int start = Integer.parseInt(t.substring(0, i));
                    String es = t.substring(i + 1, t.length());
                    int end = Integer.parseInt(t.substring(i + 1, t.length()));
                    for (int j = start; j <= end; ++j) {
                        String id = this.mIndexToId.get(j);
                        if (id == null) {
                            throw ZClientException.CLIENT_ERROR("unknown index: " + t, null);
                        }
                        if (ids.length() > 0) {
                            ids.append(",");
                        }
                        ids.append(id);
                    }
                    continue;
                }
                String id = this.mIndexToId.get(Integer.parseInt(t));
                if (id == null) {
                    throw ZClientException.CLIENT_ERROR("unknown index: " + t, null);
                }
                if (ids.length() > 0) {
                    ids.append(",");
                }
                ids.append(id);
                continue;
            }
            if (ids.length() > 0) {
                ids.append(",");
            }
            ids.append(t);
        }
        return ids.toString();
    }

    private String lookupFolderId(String pathOrId, boolean parent) throws ServiceException {
        if (parent && pathOrId != null) {
            pathOrId = ZMailbox.getParentPath(pathOrId);
        }
        if (pathOrId == null || pathOrId.length() == 0) {
            return null;
        }
        ZFolder folder = this.mMbox.getFolderById(pathOrId);
        if (folder == null) {
            folder = this.mMbox.getFolderByPath(pathOrId);
        }
        if (folder == null) {
            throw ZClientException.CLIENT_ERROR("unknown folder: " + pathOrId, null);
        }
        return folder.getId();
    }

    private ZFolder lookupFolder(String pathOrId) throws ServiceException {
        if (pathOrId == null || pathOrId.length() == 0) {
            return null;
        }
        ZFolder folder = this.mMbox.getFolderById(pathOrId);
        if (folder == null) {
            folder = this.mMbox.getFolderByPath(pathOrId);
        }
        if (folder == null) {
            throw ZClientException.CLIENT_ERROR("unknown folder: " + pathOrId, null);
        }
        return folder;
    }

    private String param(String[] args, int index, String defaultValue) {
        return args.length > index ? args[index] : defaultValue;
    }

    private boolean paramb(String[] args, int index, boolean defaultValue) {
        return args.length > index ? args[index].equals("1") : defaultValue;
    }

    private String param(String[] args, int index) {
        return this.param(args, index, null);
    }

    private ZTag.Color tagColorOpt() throws ServiceException {
        String color = this.mCommandLine.getOptionValue(O_COLOR.getOpt());
        return color == null ? null : ZTag.Color.fromString(color);
    }

    private String tagsOpt() throws ServiceException {
        String tags = this.mCommandLine.getOptionValue(O_TAGS.getOpt());
        return tags == null ? null : this.lookupTagIds(tags);
    }

    private ZFolder.Color folderColorOpt() throws ServiceException {
        String color = this.mCommandLine.getOptionValue(O_COLOR.getOpt());
        return color == null ? null : ZFolder.Color.fromString(color);
    }

    private ZFolder.View folderViewOpt() throws ServiceException {
        String view = this.mCommandLine.getOptionValue(O_VIEW.getOpt());
        return view == null ? null : ZFolder.View.fromString(view);
    }

    private String flagsOpt() {
        return this.mCommandLine.getOptionValue(O_FLAGS.getOpt());
    }

    private String urlOpt(boolean admin) {
        String url = this.mCommandLine.getOptionValue(O_URL.getOpt());
        return url == null && admin ? this.mUrl : url;
    }

    private String outputFileOpt() {
        return this.mCommandLine.getOptionValue(O_OUTPUT_FILE.getOpt());
    }

    private String contentTypeOpt() {
        return this.mCommandLine.getOptionValue(O_CONTENT_TYPE.getOpt());
    }

    private boolean ignoreAndContinueOnErrorOpt() {
        return this.mCommandLine.hasOption(O_IGNORE_ERROR.getOpt());
    }

    private boolean preserveAlarmsOpt() {
        return this.mCommandLine.hasOption(O_PRESERVE_ALARMS.getLongOpt());
    }

    private String startTimeOpt() throws ServiceException {
        return this.mCommandLine.getOptionValue(O_START_TIME.getLongOpt());
    }

    private String endTimeOpt() throws ServiceException {
        return this.mCommandLine.getOptionValue(O_END_TIME.getLongOpt());
    }

    private String typesOpt() throws ServiceException {
        String t = this.mCommandLine.getOptionValue(O_TYPES.getOpt());
        return t == null ? null : ZSearchParams.getCanonicalTypes(t);
    }

    private long dateOpt(long def) {
        String ds = this.mCommandLine.getOptionValue(O_DATE.getOpt());
        return ds == null ? def : Long.parseLong(ds);
    }

    private String folderOpt() {
        return this.mCommandLine.getOptionValue(O_FOLDER.getOpt());
    }

    private boolean replaceOpt() {
        return this.mCommandLine.hasOption(O_REPLACE.getOpt());
    }

    private boolean ignoreOpt() {
        return this.mCommandLine.hasOption(O_IGNORE.getOpt());
    }

    private boolean verboseOpt() {
        return this.mCommandLine.hasOption(O_VERBOSE.getOpt());
    }

    private boolean currrentOpt() {
        return this.mCommandLine.hasOption(O_CURRENT.getOpt());
    }

    private boolean nextOpt() {
        return this.mCommandLine.hasOption(O_NEXT.getOpt());
    }

    private boolean previousOpt() {
        return this.mCommandLine.hasOption(O_PREVIOUS.getOpt());
    }

    private boolean firstOpt() {
        return this.mCommandLine.hasOption(O_FIRST.getOpt());
    }

    private boolean lastOpt() {
        return this.mCommandLine.hasOption(O_LAST.getOpt());
    }

    private String beforeOpt() {
        return this.mCommandLine.getOptionValue(O_BEFORE.getOpt());
    }

    private String afterOpt() {
        return this.mCommandLine.getOptionValue(O_AFTER.getOpt());
    }

    private ZMailbox.SearchSortBy searchSortByOpt() throws ServiceException {
        String sort = this.mCommandLine.getOptionValue(O_SORT.getOpt());
        return sort == null ? null : ZMailbox.SearchSortBy.fromString(sort);
    }

    private boolean validateOpt() {
        return !this.mCommandLine.hasOption(O_NO_VALIDATION.getLongOpt());
    }

    public ExecuteStatus execute(String[] argsIn) throws ServiceException, IOException {
        this.mCommand = this.lookupCommand(argsIn[0]);
        String[] args = new String[argsIn.length - 1];
        System.arraycopy(argsIn, 1, args, 0, args.length);
        if (this.mCommand == null) {
            throw ZClientException.CLIENT_ERROR("Unknown command: (" + argsIn[0] + ") Type: 'help commands' for a list", null);
        }
        try {
            this.mCommandLine = this.mParser.parse(this.mCommand.getOptions(), args, true);
            args = this.mCommandLine.getArgs();
        }
        catch (ParseException e) {
            this.usage();
            return ExecuteStatus.OK;
        }
        if (!this.mCommand.checkArgsLength(args)) {
            this.usage();
            return ExecuteStatus.OK;
        }
        if (this.mCommand != Command.EXIT && this.mCommand != Command.HELP && this.mCommand != Command.AUTHENTICATE && this.mCommand != Command.ADMIN_AUTHENTICATE && this.mCommand != Command.SELECT_MAILBOX && this.mMbox == null) {
            throw ZClientException.CLIENT_ERROR("no mailbox selected. select one with authenticate/adminAuthenticate/selectMailbox", null);
        }
        switch (this.mCommand) {
            case AUTO_COMPLETE: {
                this.doAutoComplete(args);
                break;
            }
            case AUTO_COMPLETE_GAL: {
                this.doAutoCompleteGal(args);
                break;
            }
            case AUTHENTICATE: {
                this.doAuth(args);
                break;
            }
            case ADD_FILTER_RULE: {
                this.doAddFilterRule(args);
                break;
            }
            case ADD_MESSAGE: {
                this.doAddMessage(args);
                break;
            }
            case ADMIN_AUTHENTICATE: {
                this.doAdminAuth(args);
                break;
            }
            case CREATE_CONTACT: {
                String ccId = this.mMbox.createContact(this.lookupFolderId(this.folderOpt()), this.tagsOpt(), this.getContactMap(args, 0, !this.ignoreOpt())).getId();
                stdout.println(ccId);
                break;
            }
            case CREATE_IDENTITY: {
                this.mMbox.createIdentity(new ZIdentity(args[0], this.getMultiMap(args, 1)));
                break;
            }
            case CREATE_FOLDER: {
                this.doCreateFolder(args);
                break;
            }
            case CREATE_MOUNTPOINT: {
                this.doCreateMountpoint(args);
                break;
            }
            case CREATE_SEARCH_FOLDER: {
                this.doCreateSearchFolder(args);
                break;
            }
            case CREATE_SIGNATURE: {
                this.doCreateSignature(args);
                break;
            }
            case CREATE_TAG: {
                ZTag ct = this.mMbox.createTag(args[0], this.tagColorOpt());
                stdout.println(ct.getId());
                break;
            }
            case DELETE_CONTACT: {
                this.mMbox.deleteContact(args[0]);
                break;
            }
            case DELETE_CONVERSATION: {
                this.mMbox.deleteConversation(this.id(args[0]), this.param(args, 1));
                break;
            }
            case DELETE_FILTER_RULE: {
                this.doDeleteFilterRule(args);
                break;
            }
            case DELETE_FOLDER: {
                this.mMbox.deleteFolder(this.lookupFolderId(args[0]));
                break;
            }
            case DELETE_IDENTITY: {
                this.mMbox.deleteIdentity(args[0]);
                break;
            }
            case DELETE_ITEM: {
                this.mMbox.deleteItem(this.id(args[0]), this.param(args, 1));
                break;
            }
            case DELETE_MESSAGE: {
                this.mMbox.deleteMessage(this.id(args[0]));
                break;
            }
            case DELETE_SIGNATURE: {
                this.mMbox.deleteSignature(this.lookupSignatureId(args[0]));
                break;
            }
            case DELETE_TAG: {
                this.mMbox.deleteTag(this.lookupTag(args[0]).getId());
                break;
            }
            case EMPTY_FOLDER: {
                this.mMbox.emptyFolder(this.lookupFolderId(args[0]));
                break;
            }
            case EXIT: {
                return ExecuteStatus.EXIT;
            }
            case FLAG_CONTACT: {
                this.mMbox.flagContact(this.id(args[0]), this.paramb(args, 1, true));
                break;
            }
            case FLAG_CONVERSATION: {
                this.mMbox.flagConversation(this.id(args[0]), this.paramb(args, 1, true), this.param(args, 2));
                break;
            }
            case FLAG_ITEM: {
                this.mMbox.flagItem(this.id(args[0]), this.paramb(args, 1, true), this.param(args, 2));
                break;
            }
            case FLAG_MESSAGE: {
                this.mMbox.flagMessage(this.id(args[0]), this.paramb(args, 1, true));
                break;
            }
            case GET_ALL_CONTACTS: {
                this.doGetAllContacts(args);
                break;
            }
            case GET_CONTACTS: {
                this.doGetContacts(args);
                break;
            }
            case GET_IDENTITIES: {
                this.doGetIdentities(args);
                break;
            }
            case GET_SIGNATURES: {
                this.doGetSignatures(args);
                break;
            }
            case GET_ALL_FOLDERS: {
                this.doGetAllFolders(args);
                break;
            }
            case GET_ALL_TAGS: {
                this.doGetAllTags(args);
                break;
            }
            case GET_APPOINTMENT_SUMMARIES: {
                this.doGetAppointmentSummaries(args);
                break;
            }
            case GET_CONVERSATION: {
                this.doGetConversation(args);
                break;
            }
            case GET_FILTER_RULES: {
                this.doGetFilterRules(args);
                break;
            }
            case GET_FOLDER: {
                this.doGetFolder(args);
                break;
            }
            case GET_FOLDER_REQUEST: {
                this.doGetFolderRequest(args);
                break;
            }
            case GET_FOLDER_GRANT: {
                this.doGetFolderGrant(args);
                break;
            }
            case GET_MAILBOX_SIZE: {
                if (this.verboseOpt()) {
                    stdout.format("%d%n", this.mMbox.getSize());
                    break;
                }
                stdout.format("%s%n", this.formatSize(this.mMbox.getSize()));
                break;
            }
            case GET_MESSAGE: {
                this.doGetMessage(args);
                break;
            }
            case GET_PERMISSION: {
                this.doGetPermission(args);
                break;
            }
            case GET_REST_URL: {
                this.doGetRestURL(args);
                break;
            }
            case GRANT_PERMISSION: {
                this.doGrantPermission(args);
                break;
            }
            case HELP: {
                this.doHelp(args);
                break;
            }
            case IMPORT_URL_INTO_FOLDER: {
                this.mMbox.importURLIntoFolder(this.lookupFolderId(args[0]), args[1]);
                break;
            }
            case LIST_PERMISSION: {
                this.doListPermission();
                break;
            }
            case MARK_CONVERSATION_READ: {
                this.mMbox.markConversationRead(this.id(args[0]), this.paramb(args, 1, true), this.param(args, 2));
                break;
            }
            case MARK_ITEM_READ: {
                this.mMbox.markItemRead(this.id(args[0]), this.paramb(args, 1, true), this.param(args, 2));
                break;
            }
            case MARK_FOLDER_READ: {
                this.mMbox.markFolderRead(this.lookupFolderId(args[0]));
                break;
            }
            case MARK_MESSAGE_READ: {
                this.mMbox.markMessageRead(this.id(args[0]), this.paramb(args, 1, true));
                break;
            }
            case MARK_CONVERSATION_SPAM: {
                this.mMbox.markConversationSpam(this.id(args[0]), this.paramb(args, 1, true), this.lookupFolderId(this.param(args, 2)), this.param(args, 3));
                break;
            }
            case MARK_MESSAGE_SPAM: {
                this.mMbox.markMessageSpam(this.id(args[0]), this.paramb(args, 1, true), this.lookupFolderId(this.param(args, 2)));
                break;
            }
            case MARK_TAG_READ: {
                this.mMbox.markTagRead(this.lookupTag(args[0]).getId());
                break;
            }
            case MODIFY_CONTACT: {
                this.doModifyContact(args);
                break;
            }
            case MODIFY_FILTER_RULE: {
                this.doModifyFilterRule(args);
                break;
            }
            case MODIFY_FOLDER_CHECKED: {
                this.mMbox.modifyFolderChecked(this.lookupFolderId(args[0]), this.paramb(args, 1, true));
                break;
            }
            case MODIFY_FOLDER_COLOR: {
                this.mMbox.modifyFolderColor(this.lookupFolderId(args[0]), ZFolder.Color.fromString(args[1]));
                break;
            }
            case MODIFY_FOLDER_EXCLUDE_FREE_BUSY: {
                this.mMbox.modifyFolderExcludeFreeBusy(this.lookupFolderId(args[0]), this.paramb(args, 1, true));
                break;
            }
            case MODIFY_FOLDER_GRANT: {
                this.doModifyFolderGrant(args);
                break;
            }
            case MODIFY_FOLDER_FLAGS: {
                this.mMbox.updateFolder(this.lookupFolderId(args[0]), null, null, null, args[1], null);
                break;
            }
            case MODIFY_FOLDER_URL: {
                this.mMbox.modifyFolderURL(this.lookupFolderId(args[0]), args[1]);
                break;
            }
            case MODIFY_IDENTITY: {
                this.mMbox.modifyIdentity(new ZIdentity(args[0], this.getMultiMap(args, 1)));
                break;
            }
            case MODIFY_ITEM_FLAGS: {
                this.mMbox.updateItem(this.id(args[0]), null, null, args[1], null);
                break;
            }
            case MODIFY_SIGNATURE: {
                this.doModifySignature(args);
                break;
            }
            case MODIFY_TAG_COLOR: {
                this.mMbox.modifyTagColor(this.lookupTag(args[0]).getId(), ZTag.Color.fromString(args[1]));
                break;
            }
            case MOVE_CONVERSATION: {
                this.mMbox.moveConversation(this.id(args[0]), this.lookupFolderId(this.param(args, 1)), this.param(args, 2));
                break;
            }
            case MOVE_ITEM: {
                this.mMbox.moveItem(this.id(args[0]), this.lookupFolderId(this.param(args, 1)), this.param(args, 2));
                break;
            }
            case MOVE_MESSAGE: {
                this.mMbox.moveMessage(this.id(args[0]), this.lookupFolderId(this.param(args, 1)));
                break;
            }
            case MOVE_CONTACT: {
                this.mMbox.moveContact(this.id(args[0]), this.lookupFolderId(this.param(args, 1)));
                break;
            }
            case NOOP: {
                this.doNoop(args);
                break;
            }
            case POST_REST_URL: {
                this.doPostRestURL(args);
                break;
            }
            case RENAME_FOLDER: {
                this.mMbox.renameFolder(this.lookupFolderId(args[0]), args[1]);
                break;
            }
            case RENAME_SIGNATURE: {
                this.doRenameSignature(args);
                break;
            }
            case RENAME_TAG: {
                this.mMbox.renameTag(this.lookupTag(args[0]).getId(), args[1]);
                break;
            }
            case REVOKE_PERMISSION: {
                this.doRevokePermission(args);
                break;
            }
            case SEARCH: {
                this.doSearch(args);
                break;
            }
            case SEARCH_CONVERSATION: {
                this.doSearchConv(args);
                break;
            }
            case SELECT_MAILBOX: {
                this.selectMailbox(args[0]);
                break;
            }
            case SYNC_FOLDER: {
                this.mMbox.syncFolder(this.lookupFolderId(args[0]));
                break;
            }
            case TAG_CONTACT: {
                this.mMbox.tagContact(this.id(args[0]), this.lookupTag(args[1]).getId(), this.paramb(args, 2, true));
                break;
            }
            case TAG_CONVERSATION: {
                this.mMbox.tagConversation(this.id(args[0]), this.lookupTag(args[1]).getId(), this.paramb(args, 2, true), this.param(args, 3));
                break;
            }
            case TAG_ITEM: {
                this.mMbox.tagItem(this.id(args[0]), this.lookupTag(args[1]).getId(), this.paramb(args, 2, true), this.param(args, 3));
                break;
            }
            case TAG_MESSAGE: {
                this.mMbox.tagMessage(this.id(args[0]), this.lookupTag(args[1]).getId(), this.paramb(args, 2, true));
                break;
            }
            default: {
                throw ZClientException.CLIENT_ERROR("Unhandled command: (" + this.mCommand.name() + ")", null);
            }
        }
        return ExecuteStatus.OK;
    }

    private void doNoop(String[] args) throws ServiceException {
        if (args.length != 0 && args[0].equals("-t")) {
            this.mMbox.addEventHandler(this.mTraceHandler);
            while (true) {
                stdout.println("NoOp: " + DateUtil.toGeneralizedTime(new Date()));
                this.mMbox.noOp();
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        this.mMbox.noOp();
    }

    private void doGetAppointmentSummaries(String[] args) throws ServiceException {
        String folderId;
        long endTime;
        long startTime = DateUtil.parseDateSpecifier(args[0], new Date().getTime());
        List<ZMailbox.ZApptSummaryResult> results = this.mMbox.getApptSummaries(null, startTime, endTime = DateUtil.parseDateSpecifier(args[1], new Date().getTime() + 604800000L), new String[]{folderId = args.length == 3 ? this.lookupFolderId(args[2]) : null}, TimeZone.getDefault(), "appointment");
        if (results.size() != 1) {
            return;
        }
        ZMailbox.ZApptSummaryResult result = results.get(0);
        stdout.print("[");
        boolean first = true;
        for (ZAppointmentHit appt : result.getAppointments()) {
            if (!first) {
                stdout.println(",");
            }
            stdout.print(appt);
            if (!first) continue;
            first = false;
        }
        stdout.println("]");
    }

    private void doAddFilterRule(String[] args) throws ServiceException {
        ZFilterRule newRule = ZFilterRule.parseFilterRule(args);
        ZFilterRules rules = this.mMbox.getFilterRules();
        List<ZFilterRule> list = rules.getRules();
        if (this.firstOpt()) {
            list.add(0, newRule);
        } else if (this.afterOpt() != null) {
            boolean found = false;
            String name = this.afterOpt();
            for (int i = 0; i < list.size(); ++i) {
                found = list.get(i).getName().equalsIgnoreCase(name);
                if (!found) continue;
                if (i + 1 >= list.size()) {
                    list.add(newRule);
                    break;
                }
                list.add(i + 1, newRule);
                break;
            }
            if (!found) {
                throw ZClientException.CLIENT_ERROR("can't find rule: " + name, null);
            }
        } else if (this.beforeOpt() != null) {
            String name = this.beforeOpt();
            boolean found = false;
            for (int i = 0; i < list.size(); ++i) {
                found = list.get(i).getName().equalsIgnoreCase(name);
                if (!found) continue;
                list.add(i, newRule);
                break;
            }
            if (!found) {
                throw ZClientException.CLIENT_ERROR("can't find rule: " + name, null);
            }
        } else {
            list.add(newRule);
        }
        this.mMbox.saveFilterRules(rules);
    }

    private void doModifyFilterRule(String[] args) throws ServiceException {
        ZFilterRule modifiedRule = ZFilterRule.parseFilterRule(args);
        ZFilterRules rules = this.mMbox.getFilterRules(true);
        List<ZFilterRule> list = rules.getRules();
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getName().equalsIgnoreCase(modifiedRule.getName())) continue;
            list.set(i, modifiedRule);
            this.mMbox.saveFilterRules(rules);
            return;
        }
        throw ZClientException.CLIENT_ERROR("can't find rule: " + args[0], null);
    }

    private void doDeleteFilterRule(String[] args) throws ServiceException {
        String name = args[0];
        ZFilterRules rules = this.mMbox.getFilterRules(true);
        List<ZFilterRule> list = rules.getRules();
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getName().equalsIgnoreCase(name)) continue;
            list.remove(i);
            this.mMbox.saveFilterRules(rules);
            return;
        }
        throw ZClientException.CLIENT_ERROR("can't find rule: " + args[0], null);
    }

    private void doGetFilterRules(String[] args) throws ServiceException {
        ZFilterRules rules = this.mMbox.getFilterRules(true);
        for (ZFilterRule r : rules.getRules()) {
            stdout.println(r.generateFilterRule());
        }
    }

    private String getGranteeDisplay(ZGrant.GranteeType type) {
        switch (type) {
            case usr: {
                return "account";
            }
            case grp: {
                return "group";
            }
            case pub: {
                return "public";
            }
            case all: {
                return "all";
            }
            case dom: {
                return "domain";
            }
            case guest: {
                return "guest";
            }
            case key: {
                return "key";
            }
        }
        return "unknown";
    }

    private void doGetFolderGrant(String[] args) throws ServiceException {
        ZFolder f = this.lookupFolder(args[0]);
        if (this.verboseOpt()) {
            StringBuilder sb = new StringBuilder();
            for (ZGrant g : f.getGrants()) {
                if (sb.length() > 0) {
                    sb.append(",\n");
                }
                sb.append(g.dump());
            }
            stdout.format("[%n%s%n]%n", sb.toString());
        } else {
            String format = "%11.11s  %8.8s  %s%n";
            stdout.format(format, "Permissions", "Type", "Display");
            stdout.format(format, "-----------", "--------", "-------");
            for (ZGrant g : f.getGrants()) {
                ZGrant.GranteeType gt = g.getGranteeType();
                String dn = gt == ZGrant.GranteeType.all || gt == ZGrant.GranteeType.pub ? "" : (gt == ZGrant.GranteeType.guest || gt == ZGrant.GranteeType.key ? g.getGranteeId() : (g.getGranteeName() != null ? g.getGranteeName() : g.getGranteeId()));
                stdout.format(format, g.getPermissions(), this.getGranteeDisplay(g.getGranteeType()), dn);
            }
        }
    }

    private ZGrant.GranteeType getGranteeType(String name) throws ServiceException {
        if (name.equalsIgnoreCase("account")) {
            return ZGrant.GranteeType.usr;
        }
        if (name.equalsIgnoreCase("group")) {
            return ZGrant.GranteeType.grp;
        }
        if (name.equalsIgnoreCase("public")) {
            return ZGrant.GranteeType.pub;
        }
        if (name.equalsIgnoreCase("all")) {
            return ZGrant.GranteeType.all;
        }
        if (name.equalsIgnoreCase("domain")) {
            return ZGrant.GranteeType.dom;
        }
        if (name.equalsIgnoreCase("guest")) {
            return ZGrant.GranteeType.guest;
        }
        if (name.equalsIgnoreCase("key")) {
            return ZGrant.GranteeType.key;
        }
        throw ZClientException.CLIENT_ERROR("unknown grantee type: " + name, null);
    }

    private void doModifyFolderGrant(String[] args) throws ServiceException {
        boolean revoke;
        String folderId = this.lookupFolderId(args[0], false);
        ZGrant.GranteeType type = this.getGranteeType(args[1]);
        String grantee = null;
        String perms = null;
        String password = null;
        switch (type) {
            case usr: 
            case grp: 
            case dom: {
                if (args.length != 4) {
                    throw ZClientException.CLIENT_ERROR("not enough args", null);
                }
                grantee = args[2];
                perms = args[3];
                break;
            }
            case pub: {
                grantee = "99999999-9999-9999-9999-999999999999";
                perms = args[2];
                break;
            }
            case all: {
                grantee = "00000000-0000-0000-0000-000000000000";
                perms = args[2];
                break;
            }
            case guest: {
                if (args.length != 4 && args.length != 5) {
                    throw ZClientException.CLIENT_ERROR("not enough args", null);
                }
                grantee = args[2];
                if (args.length == 5) {
                    password = args[3];
                    perms = args[4];
                    break;
                }
                password = null;
                perms = args[3];
                break;
            }
            case key: {
                if (args.length != 4 && args.length != 5) {
                    throw ZClientException.CLIENT_ERROR("not enough args", null);
                }
                grantee = args[2];
                if (args.length == 5) {
                    password = args[3];
                    perms = args[4];
                    break;
                }
                perms = args[3];
            }
        }
        boolean bl = revoke = perms != null && (perms.equalsIgnoreCase("none") || perms.length() == 0);
        if (revoke) {
            ZFolder f = this.lookupFolder(folderId);
            String zid = null;
            for (ZGrant g : f.getGrants()) {
                if (!grantee.equalsIgnoreCase(g.getGranteeName()) && !grantee.equalsIgnoreCase(g.getGranteeId())) continue;
                zid = g.getGranteeId();
                break;
            }
            if (zid == null) {
                if (type != ZGrant.GranteeType.all && type != ZGrant.GranteeType.pub) {
                    throw ZClientException.CLIENT_ERROR("unable to resolve zimbra id for: " + grantee, null);
                }
            } else {
                grantee = zid;
            }
            this.mMbox.modifyFolderRevokeGrant(folderId, grantee);
        } else {
            if (type == ZGrant.GranteeType.guest && password == null) {
                throw ZClientException.CLIENT_ERROR("password is required for guest grantee", null);
            }
            this.mMbox.modifyFolderGrant(folderId, type, grantee, perms, password);
        }
    }

    private void doListPermission() throws ServiceException {
        for (UserRight r : RightManager.getInstance().getAllUserRights().values()) {
            stdout.println("  " + r.getName() + ": " + r.getDesc());
            if (this.verboseOpt() && r.getDoc() != null) {
                stdout.println("      " + r.getDoc());
            }
            stdout.println();
        }
    }

    private void doGetPermission(String[] args) throws ServiceException {
        if (this.verboseOpt()) {
            StringBuilder sb = new StringBuilder();
            for (ZAce g : this.mMbox.getPermission(args)) {
                if (sb.length() > 0) {
                    sb.append(",\n");
                }
                sb.append(g.dump());
            }
            stdout.format("[%n%s%n]%n", sb.toString());
        } else {
            String format = "%16.16s  %8.8s  %s%n";
            stdout.format(format, "Permission", "Type", "Display");
            stdout.format(format, "----------------", "--------", "-------");
            List<ZAce> result = this.mMbox.getPermission(args);
            Comparator<ZAce> comparator = new Comparator<ZAce>(){

                @Override
                public int compare(ZAce a, ZAce b) {
                    String bKey;
                    String aKey = a.getRight() + a.getGranteeTypeSortOrder() + (a.getGranteeName() == null ? "" : a.getGranteeName());
                    int order = aKey.compareTo(bKey = b.getRight() + b.getGranteeTypeSortOrder() + (b.getGranteeName() == null ? "" : b.getGranteeName()));
                    if (order == 0) {
                        order = a.getDeny() ? -1 : 1;
                    }
                    return order;
                }
            };
            Collections.sort(result, comparator);
            for (ZAce ace : result) {
                stdout.format(format, ace.getRightDisplay(), ace.getGranteeTypeDisplay(), ace.getGranteeName());
            }
        }
        stdout.println();
    }

    private ZAce getAceFromArgs(String[] args) throws ServiceException {
        ZAce.GranteeType type = ZAce.getGranteeTypeFromDisplay(args[0]);
        String granteeName = null;
        String granteeId = null;
        String right = null;
        boolean deny = false;
        String secret = null;
        switch (type) {
            case usr: 
            case grp: {
                if (args.length != 3) {
                    throw ZClientException.CLIENT_ERROR("wrong number of args", null);
                }
                granteeName = args[1];
                right = args[2];
                break;
            }
            case all: {
                if (args.length != 2) {
                    throw ZClientException.CLIENT_ERROR("wrong number of args", null);
                }
                granteeId = "00000000-0000-0000-0000-000000000000";
                right = args[1];
                break;
            }
            case pub: {
                if (args.length != 2) {
                    throw ZClientException.CLIENT_ERROR("wrong number of args", null);
                }
                granteeId = "99999999-9999-9999-9999-999999999999";
                right = args[1];
                break;
            }
            case gst: {
                if (args.length != 4) {
                    throw ZClientException.CLIENT_ERROR("wrong number of args", null);
                }
                granteeName = args[1];
                secret = args[2];
                right = args[3];
                break;
            }
            case key: {
                if (args.length != 3 && args.length != 4) {
                    throw ZClientException.CLIENT_ERROR("wrong number of args", null);
                }
                granteeName = args[1];
                if (args.length == 3) {
                    right = args[2];
                    break;
                }
                secret = args[2];
                right = args[3];
            }
        }
        if (right.charAt(0) == '-') {
            deny = true;
            right = right.substring(1);
        }
        return new ZAce(type, granteeId, granteeName, right, deny, secret);
    }

    private void doGrantPermission(String[] args) throws ServiceException {
        ZAce ace = this.getAceFromArgs(args);
        List<ZAce> granted = this.mMbox.grantPermission(ace);
        if (granted.size() == 0) {
            stdout.println("  granted 0 permission");
        } else {
            stdout.println("  granted: ");
            for (ZAce g : granted) {
                stdout.println("    " + g.getGranteeTypeDisplay() + " " + g.getGranteeName() + " " + g.getRightDisplay());
            }
        }
    }

    private void doRevokePermission(String[] args) throws ServiceException {
        List<ZAce> revoked;
        ZAce ace = this.getAceFromArgs(args);
        ZAce.GranteeType granteeType = ace.getGranteeType();
        if (granteeType == ZAce.GranteeType.usr || granteeType == ZAce.GranteeType.grp) {
            String zid = null;
            String granteeName = ace.getGranteeName();
            String[] rights = new String[]{ace.getRight()};
            for (ZAce g : this.mMbox.getPermission(rights)) {
                if (!granteeName.equalsIgnoreCase(g.getGranteeName()) && !granteeName.equalsIgnoreCase(g.getGranteeId())) continue;
                zid = g.getGranteeId();
                break;
            }
            if (zid == null) {
                throw ZClientException.CLIENT_ERROR("unable to resolve zimbra id for: " + granteeName, null);
            }
            ace.setGranteeId(zid);
        }
        if ((revoked = this.mMbox.revokePermission(ace)).size() == 0) {
            stdout.println("  revoked 0 permission");
        } else {
            stdout.println("  revoked: ");
            for (ZAce r : revoked) {
                stdout.println("    " + r.getGranteeTypeDisplay() + " " + r.getGranteeName() + " " + r.getRightDisplay());
            }
        }
    }

    private void doAdminAuth(String[] args) throws ServiceException {
        this.adminAuth(args[0], args[1], this.urlOpt(true));
    }

    private void doAuth(String[] args) throws ServiceException {
        this.auth(args[0], args[1], this.urlOpt(true));
    }

    private void addMessage(String folderId, String flags, String tags, long date, File file, boolean validate) throws ServiceException, IOException {
        FilterInputStream in = new BufferedInputStream(new FileInputStream(file));
        long sizeHint = -1L;
        if (ByteUtil.isGzipped(in)) {
            in = new GZIPInputStream(in);
        } else {
            sizeHint = file.length();
        }
        byte[] data = ByteUtil.getContent(in, (int)sizeHint);
        if (validate && !EmailUtil.isRfc822Message(new ByteArrayInputStream(data))) {
            throw ZClientException.CLIENT_ERROR(file.getPath() + " does not contain a valid RFC 822 message", null);
        }
        try {
            if (date == -1L) {
                MimeMessage mm = new MimeMessage(mSession, (InputStream)new ByteArrayInputStream(data));
                Date d = mm.getSentDate();
                date = d != null ? d.getTime() : 0L;
            }
        }
        catch (MessagingException e) {
            date = 0L;
        }
        String id = this.mMbox.addMessage(folderId, flags, tags, date, data, false);
        stdout.format("%s (%s)%n", id, file.getPath());
    }

    private void doAddMessage(String[] args) throws ServiceException, IOException {
        String folderId = this.lookupFolderId(args[0], false);
        String tags = this.tagsOpt();
        String flags = this.flagsOpt();
        long date = this.dateOpt(-1L);
        boolean validate = this.validateOpt();
        for (int i = 1; i < args.length; ++i) {
            File file = new File(args[i]);
            if (file.isDirectory()) {
                for (File child : file.listFiles()) {
                    if (!child.isFile()) continue;
                    this.addMessage(folderId, flags, tags, date, child, validate);
                }
                continue;
            }
            this.addMessage(folderId, flags, tags, date, file, validate);
        }
    }

    private String emailAddrs(List<ZEmailAddress> addrs) {
        StringBuilder sb = new StringBuilder();
        for (ZEmailAddress e : addrs) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(e.getDisplay());
        }
        return sb.toString();
    }

    private void doCreateFolder(String[] args) throws ServiceException {
        ZFolder cf = this.mMbox.createFolder(this.lookupFolderId(args[0], true), ZMailbox.getBasePath(args[0]), this.folderViewOpt(), this.folderColorOpt(), this.flagsOpt(), this.urlOpt(false));
        stdout.println(cf.getId());
    }

    private void doCreateSignature(String[] args) throws ServiceException {
        ZSignature sig = new ZSignature(args[0], args[1]);
        stdout.println(this.mMbox.createSignature(sig));
    }

    private void doModifySignature(String[] args) throws ServiceException {
        ZSignature sig = this.lookupSignature(args[0]);
        ZSignature modSig = new ZSignature(sig.getId(), sig.getName(), args[1]);
        this.mMbox.modifySignature(modSig);
    }

    private void doRenameSignature(String[] args) throws ServiceException {
        ZSignature sig = this.lookupSignature(args[0]);
        ZSignature modSig = new ZSignature(sig.getId(), args[1], sig.getValue());
        this.mMbox.modifySignature(modSig);
    }

    private ZSignature lookupSignature(String idOrName) throws ServiceException {
        for (ZSignature sig : this.mMbox.getSignatures()) {
            if (!sig.getName().equalsIgnoreCase(idOrName) && !sig.getId().equalsIgnoreCase(idOrName)) continue;
            return sig;
        }
        throw ZClientException.CLIENT_ERROR("unknown signature: " + idOrName, null);
    }

    private String lookupSignatureId(String idOrName) throws ServiceException {
        if (Provisioning.isUUID(idOrName)) {
            return idOrName;
        }
        for (ZSignature sig : this.mMbox.getSignatures()) {
            if (!sig.getName().equalsIgnoreCase(idOrName)) continue;
            return sig.getId();
        }
        throw ZClientException.CLIENT_ERROR("unknown signature: " + idOrName, null);
    }

    private void doCreateSearchFolder(String[] args) throws ServiceException {
        ZSearchFolder csf = this.mMbox.createSearchFolder(this.lookupFolderId(args[0], true), ZMailbox.getBasePath(args[0]), args[1], this.typesOpt(), this.searchSortByOpt(), this.folderColorOpt());
        stdout.println(csf.getId());
    }

    private void doCreateMountpoint(String[] args) throws ServiceException {
        String cmPath = args[0];
        String cmOwner = args[1];
        String cmItem = args[2];
        ZMailbox.OwnerBy ownerBy = ZMailbox.OwnerBy.BY_ID;
        Account ownerAcct = this.mProv.getAccount(cmOwner);
        if (ownerAcct != null) {
            ownerBy = cmOwner.equals(ownerAcct.getId()) ? ZMailbox.OwnerBy.BY_ID : ZMailbox.OwnerBy.BY_NAME;
        }
        ZMountpoint cm = this.mMbox.createMountpoint(this.lookupFolderId(cmPath, true), ZMailbox.getBasePath(cmPath), this.folderViewOpt(), this.folderColorOpt(), this.flagsOpt(), ownerBy, cmOwner, Provisioning.isUUID(cmItem) ? ZMailbox.SharedItemBy.BY_ID : ZMailbox.SharedItemBy.BY_PATH, cmItem);
        stdout.println(cm.getId());
    }

    private void doSearch(String[] args) throws ServiceException {
        if (this.currrentOpt()) {
            this.doSearchRedisplay(args);
            return;
        }
        if (this.previousOpt()) {
            this.doSearchPrevious(args);
            return;
        }
        if (this.nextOpt()) {
            this.doSearchNext(args);
            return;
        }
        if (args.length == 0) {
            this.usage();
            return;
        }
        this.mSearchParams = new ZSearchParams(args[0]);
        String limitStr = this.mCommandLine.getOptionValue(O_LIMIT.getOpt());
        this.mSearchParams.setLimit(limitStr != null ? Integer.parseInt(limitStr) : 25);
        ZMailbox.SearchSortBy sortBy = this.searchSortByOpt();
        this.mSearchParams.setSortBy(sortBy != null ? sortBy : ZMailbox.SearchSortBy.dateDesc);
        String types = this.typesOpt();
        this.mSearchParams.setTypes(types != null ? types : "conversation");
        this.mIndexToId.clear();
        this.mSearchPage = 0;
        ZSearchPagerResult pager = this.mMbox.search(this.mSearchParams, this.mSearchPage, false, false);
        this.dumpSearch(pager.getResult(), this.verboseOpt());
    }

    private void doSearchRedisplay(String[] args) throws ServiceException {
        if (this.mSearchParams == null) {
            return;
        }
        ZSearchPagerResult pager = this.mMbox.search(this.mSearchParams, this.mSearchPage, true, false);
        this.mSearchPage = pager.getActualPage();
        if (pager.getResult().getHits().size() == 0) {
            return;
        }
        this.dumpSearch(pager.getResult(), this.verboseOpt());
    }

    private void doSearchNext(String[] args) throws ServiceException {
        if (this.mSearchParams == null) {
            return;
        }
        ZSearchPagerResult pager = this.mMbox.search(this.mSearchParams, ++this.mSearchPage, true, false);
        this.mSearchPage = pager.getActualPage();
        if (pager.getResult().getHits().size() == 0) {
            return;
        }
        this.dumpSearch(pager.getResult(), this.verboseOpt());
    }

    private void doSearchPrevious(String[] args) throws ServiceException {
        if (this.mSearchParams == null || this.mSearchPage == 0) {
            return;
        }
        ZSearchPagerResult pager = this.mMbox.search(this.mSearchParams, --this.mSearchPage, true, false);
        this.mSearchPage = pager.getActualPage();
        if (pager.getResult().getHits().size() == 0) {
            return;
        }
        this.dumpSearch(pager.getResult(), this.verboseOpt());
    }

    private void doSearchConv(String[] args) throws ServiceException {
        if (this.currrentOpt()) {
            this.doSearchConvRedisplay(args);
            return;
        }
        if (this.previousOpt()) {
            this.doSearchConvPrevious(args);
            return;
        }
        if (this.nextOpt()) {
            this.doSearchConvNext(args);
            return;
        }
        if (args.length != 2) {
            this.usage();
            return;
        }
        this.mConvSearchConvId = this.id(args[0]);
        this.mConvSearchParams = new ZSearchParams(args[1]);
        String limitStr = this.mCommandLine.getOptionValue(O_LIMIT.getOpt());
        this.mConvSearchParams.setLimit(limitStr != null ? Integer.parseInt(limitStr) : 25);
        ZMailbox.SearchSortBy sortBy = this.searchSortByOpt();
        this.mConvSearchParams.setSortBy(sortBy != null ? sortBy : ZMailbox.SearchSortBy.dateDesc);
        String types = this.typesOpt();
        this.mConvSearchParams.setTypes(types != null ? types : "conversation");
        this.mIndexToId.clear();
        this.dumpConvSearch(this.mMbox.searchConversation(this.mConvSearchConvId, this.mConvSearchParams), this.verboseOpt());
    }

    private void doSearchConvRedisplay(String[] args) throws ServiceException {
        ZSearchResult sr = this.mConvSearchResult;
        if (sr == null) {
            return;
        }
        this.dumpConvSearch(this.mConvSearchResult, this.verboseOpt());
    }

    private void doSearchConvNext(String[] args) throws ServiceException {
        ZSearchParams sp = this.mConvSearchParams;
        ZSearchResult sr = this.mConvSearchResult;
        if (sp == null || sr == null || !sr.hasMore()) {
            return;
        }
        List<ZSearchHit> hits = sr.getHits();
        if (hits.size() == 0) {
            return;
        }
        sp.setOffset(sp.getOffset() + hits.size());
        this.dumpConvSearch(this.mMbox.searchConversation(this.mConvSearchConvId, sp), this.verboseOpt());
    }

    private void doSearchConvPrevious(String[] args) throws ServiceException {
        ZSearchParams sp = this.mConvSearchParams;
        ZSearchResult sr = this.mConvSearchResult;
        if (sp == null || sr == null || sp.getOffset() == 0) {
            return;
        }
        sp.setOffset(sp.getOffset() - sr.getHits().size());
        this.dumpConvSearch(this.mMbox.searchConversation(this.mConvSearchConvId, sp), this.verboseOpt());
    }

    private int colWidth(int num) {
        int i = 1;
        while (num >= 10) {
            ++i;
            num /= 10;
        }
        return i;
    }

    private void dumpSearch(ZSearchResult sr, boolean verbose) {
        if (verbose) {
            stdout.println(sr.dump());
            return;
        }
        int offset = this.mSearchPage * this.mSearchParams.getLimit();
        int first = offset + 1;
        int last = offset + sr.getHits().size();
        stdout.printf("num: %d, more: %s%n%n", sr.getHits().size(), sr.hasMore());
        int width = this.colWidth(last);
        if (sr.getHits().size() == 0) {
            return;
        }
        int FROM_LEN = 20;
        int id_len = 4;
        for (ZSearchHit hit : sr.getHits()) {
            id_len = Math.max(id_len, hit.getId().length());
        }
        Calendar c = Calendar.getInstance();
        String headerFormat = String.format("%%%d.%ds  %%%d.%ds  %%4s   %%-20.20s  %%-50.50s  %%s%%n", width, width, id_len, id_len);
        String itemFormat = String.format("%%%d.%ds. %%%d.%ds  %%4s   %%-20.20s  %%-50.50s  %%tD %%<tR%%n", width, width, id_len, id_len);
        stdout.format(headerFormat, "", "Id", "Type", "From", "Subject", "Date");
        stdout.format(headerFormat, "", "----------------------------------------------------------------------------------------------------", "----", "--------------------", "--------------------------------------------------", "--------------");
        int i = first;
        for (ZSearchHit hit : sr.getHits()) {
            String from;
            String sub;
            ZSearchHit ch;
            if (hit instanceof ZConversationHit) {
                ch = (ZConversationHit)hit;
                c.setTimeInMillis(((ZConversationHit)ch).getDate());
                sub = ((ZConversationHit)ch).getSubject();
                from = this.emailAddrs(((ZConversationHit)ch).getRecipients());
                if (((ZConversationHit)ch).getMessageCount() > 1) {
                    String numMsg = " (" + ((ZConversationHit)ch).getMessageCount() + ")";
                    int space = 20 - numMsg.length();
                    from = (from.length() < space ? from : from.substring(0, space)) + numMsg;
                }
                this.mIndexToId.put(i, ((ZConversationHit)ch).getId());
                stdout.format(itemFormat, i++, ((ZConversationHit)ch).getId(), "conv", from, sub, c);
                continue;
            }
            if (hit instanceof ZContactHit) {
                ch = (ZContactHit)hit;
                c.setTimeInMillis(((ZContactHit)ch).getMetaDataChangedDate());
                String from2 = this.getFirstEmail((ZContactHit)ch);
                String sub2 = ((ZContactHit)ch).getFileAsStr();
                this.mIndexToId.put(i, ((ZContactHit)ch).getId());
                stdout.format(itemFormat, i++, ((ZContactHit)ch).getId(), "cont", from2, sub2, c);
                continue;
            }
            if (hit instanceof ZMessageHit) {
                ZMessageHit mh = (ZMessageHit)hit;
                c.setTimeInMillis(mh.getDate());
                sub = mh.getSubject();
                from = mh.getSender() == null ? "<none>" : mh.getSender().getDisplay();
                this.mIndexToId.put(i, mh.getId());
                stdout.format(itemFormat, i++, mh.getId(), "mess", from, sub, c);
                continue;
            }
            if (hit instanceof ZAppointmentHit) {
                ZAppointmentHit ah = (ZAppointmentHit)hit;
                if (ah.getInstanceExpanded()) {
                    c.setTimeInMillis(ah.getStartTime());
                } else {
                    c.setTimeInMillis(ah.getHitDate());
                }
                sub = ah.getName();
                from = "<na>";
                this.mIndexToId.put(i, ah.getId());
                stdout.format(itemFormat, i++, ah.getId(), ah.getIsTask() ? "task" : "appo", from, sub, c);
                continue;
            }
            if (!(hit instanceof ZDocumentHit)) continue;
            ZDocumentHit dh = (ZDocumentHit)hit;
            ZDocument doc = dh.getDocument();
            c.setTimeInMillis(doc.getModifiedDate());
            String name = doc.getName();
            String editor = doc.getEditor();
            this.mIndexToId.put(i, dh.getId());
            stdout.format(itemFormat, i++, dh.getId(), doc.isWiki() ? "wiki" : "doc", editor, name, c);
        }
        stdout.println();
    }

    private String getFirstEmail(ZContactHit ch) {
        if (ch.getEmail() != null) {
            return ch.getEmail();
        }
        if (ch.getEmail2() != null) {
            return ch.getEmail2();
        }
        if (ch.getEmail3() != null) {
            return ch.getEmail3();
        }
        return "<none>";
    }

    private void dumpConvSearch(ZSearchResult sr, boolean verbose) {
        this.mConvSearchResult = sr;
        if (verbose) {
            stdout.println(sr.dump());
            return;
        }
        int offset = sr.getOffset();
        int first = offset + 1;
        int last = offset + sr.getHits().size();
        stdout.printf("num: %d, more: %s%n%n", sr.getHits().size(), sr.hasMore());
        int width = this.colWidth(last);
        if (sr.getHits().size() == 0) {
            return;
        }
        int FROM_LEN = 20;
        int id_len = 4;
        for (ZSearchHit hit : sr.getHits()) {
            id_len = Math.max(id_len, hit.getId().length());
        }
        Calendar c = Calendar.getInstance();
        String headerFormat = String.format("%%%d.%ds  %%%d.%ds  %%-20.20s  %%-50.50s  %%s%%n", width, width, id_len, id_len);
        String itemFormat = String.format("%%%d.%ds. %%%d.%ds  %%-20.20s  %%-50.50s  %%tD %%<tR%%n", width, width, id_len, id_len);
        stdout.format(headerFormat, "", "Id", "From", "Subject", "Date");
        stdout.format(headerFormat, "", "----------------------------------------------------------------------------------------------------", "--------------------", "--------------------------------------------------", "--------------");
        int i = first;
        for (ZSearchHit hit : sr.getHits()) {
            if (!(hit instanceof ZMessageHit)) continue;
            ZMessageHit mh = (ZMessageHit)hit;
            c.setTimeInMillis(mh.getDate());
            String sub = mh.getSubject();
            String from = mh.getSender().getDisplay();
            this.mIndexToId.put(i, mh.getId());
            stdout.format(itemFormat, i++, mh.getId(), from, sub, c);
        }
        stdout.println();
    }

    private void doGetAllTags(String[] args) throws ServiceException {
        if (this.verboseOpt()) {
            StringBuilder sb = new StringBuilder();
            for (String tagName : this.mMbox.getAllTagNames()) {
                ZTag tag = this.mMbox.getTagByName(tagName);
                if (sb.length() > 0) {
                    sb.append(",\n");
                }
                sb.append(tag.dump());
            }
            stdout.format("[%n%s%n]%n", sb.toString());
        } else {
            if (this.mMbox.getAllTagNames().size() == 0) {
                return;
            }
            String hdrFormat = "%10.10s  %10.10s  %10.10s  %s%n";
            stdout.format(hdrFormat, "Id", "Unread", "Color", "Name");
            stdout.format(hdrFormat, "----------", "----------", "----------", "----------");
            for (String tagName : this.mMbox.getAllTagNames()) {
                ZTag tag = this.mMbox.getTagByName(tagName);
                stdout.format("%10.10s  %10d  %10.10s  %s%n", tag.getId(), tag.getUnreadCount(), tag.getColor().name(), tag.getName());
            }
        }
    }

    private void doDumpFolder(ZFolder folder, boolean recurse) {
        String path;
        if (folder instanceof ZSearchFolder) {
            path = String.format("%s (%s)", folder.getPath(), ((ZSearchFolder)folder).getQuery());
        } else if (folder instanceof ZMountpoint) {
            ZMountpoint mp = (ZMountpoint)folder;
            path = String.format("%s (%s:%s)", folder.getPath(), mp.getOwnerDisplayName(), mp.getRemoteId());
        } else {
            path = folder.getRemoteURL() != null ? String.format("%s (%s)", folder.getPath(), folder.getRemoteURL()) : folder.getPath();
        }
        stdout.format("%10.10s  %4.4s  %10d  %10d  %s%n", folder.getId(), folder.getDefaultView().name(), folder.getUnreadCount(), folder.getMessageCount(), path);
        if (recurse) {
            for (ZFolder child : folder.getSubFolders()) {
                this.doDumpFolder(child, recurse);
            }
        }
    }

    private void doGetAllFolders(String[] args) throws ServiceException {
        if (this.verboseOpt()) {
            stdout.println(this.mMbox.getUserRoot().dump());
        } else {
            String hdrFormat = "%10.10s  %4.4s  %10.10s  %10.10s  %s%n";
            stdout.format(hdrFormat, "Id", "View", "Unread", "Msg Count", "Path");
            stdout.format(hdrFormat, "----------", "----", "----------", "----------", "----------");
            this.doDumpFolder(this.mMbox.getUserRoot(), true);
        }
    }

    private void doGetFolder(String[] args) throws ServiceException {
        ZFolder f = this.lookupFolder(args[0]);
        stdout.println(f.dump());
    }

    private void doGetFolderRequest(String[] args) throws ServiceException {
        ZFolder f = this.mMbox.getFolderRequestById(args[0]);
        stdout.println(f);
    }

    private void dumpAllContacts(List<ZContact> contacts) throws ServiceException {
        if (this.verboseOpt()) {
            stdout.println("[");
            boolean first = true;
            for (ZContact cn : contacts) {
                if (first) {
                    first = false;
                } else {
                    stdout.println(",");
                }
                stdout.println(cn.dump());
            }
            stdout.println("]");
        } else {
            if (contacts.size() == 0) {
                return;
            }
            String hdrFormat = "%10.10s  %s%n";
            stdout.format(hdrFormat, "Id", "FileAsStr");
            stdout.format(hdrFormat, "----------", "----------");
            for (ZContact cn : contacts) {
                stdout.format("%10.10s  %s%n", cn.getId(), Contact.getFileAsString(cn.getAttrs()));
            }
        }
    }

    private void dumpIdentities(List<ZIdentity> identities) {
        if (this.verboseOpt()) {
            stdout.println("[");
            boolean first = true;
            for (ZIdentity identity : identities) {
                if (first) {
                    first = false;
                } else {
                    stdout.println(",");
                }
                stdout.println(identity.dump());
            }
            stdout.println("]");
        } else {
            if (identities.size() == 0) {
                return;
            }
            for (ZIdentity identity : identities) {
                stdout.println(identity.getName());
            }
        }
    }

    private void doGetIdentities(String[] args) throws ServiceException {
        this.dumpIdentities(this.mMbox.getIdentities());
    }

    private void dumpSignatures(List<ZSignature> signatures) {
        if (this.verboseOpt()) {
            stdout.println("[");
            boolean first = true;
            for (ZSignature sig : signatures) {
                if (first) {
                    first = false;
                } else {
                    stdout.println(",");
                }
                stdout.println(sig.dump());
            }
            stdout.println("]");
        } else {
            if (signatures.size() == 0) {
                return;
            }
            for (ZSignature sig : signatures) {
                stdout.println(sig.getName());
            }
        }
    }

    private void doGetSignatures(String[] args) throws ServiceException {
        this.dumpSignatures(this.mMbox.getSignatures());
    }

    private void dumpContacts(List<ZContact> contacts) throws ServiceException {
        if (this.verboseOpt()) {
            stdout.println("[");
            boolean first = true;
            for (ZContact cn : contacts) {
                if (first) {
                    first = false;
                } else {
                    stdout.println(",");
                }
                stdout.println(cn.dump());
            }
            stdout.println("]");
        } else {
            if (contacts.size() == 0) {
                return;
            }
            for (ZContact cn : contacts) {
                this.dumpContact(cn);
            }
        }
    }

    private void dumpAutoCompleteMatches(List<ZAutoCompleteMatch> matches) throws ServiceException {
        if (matches.isEmpty()) {
            stdout.println("no matches");
            return;
        }
        int idLen = 2;
        int fidLen = 3;
        int displayLen = 7;
        for (ZAutoCompleteMatch match : matches) {
            String display;
            String fid;
            String id = match.getId();
            if (id != null && id.length() > idLen) {
                idLen = id.length();
            }
            if ((fid = match.getFolderId()) != null && fid.length() > fidLen) {
                fidLen = fid.length();
            }
            if ((display = match.getDisplayName()) == null || display.length() <= displayLen) continue;
            displayLen = display.length();
        }
        String format = "%7s %7s";
        if (this.verboseOpt()) {
            format = format + String.format(" %%%d.%ds", idLen, idLen);
            format = format + String.format(" %%%d.%ds", fidLen, fidLen);
            format = format + String.format(" %%%d.%ds", displayLen, displayLen);
        }
        format = format + " %s %n";
        if (this.verboseOpt()) {
            stdout.format(format, "Ranking", "type", "id", "fid", "display", "email");
            stdout.println("-------------------------------------------------------------------");
        } else {
            stdout.format(format, "Ranking", "type", "email");
            stdout.println("-------------------------------------------------------------------");
        }
        for (ZAutoCompleteMatch match : matches) {
            if (this.verboseOpt()) {
                String folderId = match.getFolderId();
                String id = match.getId();
                String display = match.getDisplayName();
                if (folderId == null) {
                    folderId = "";
                }
                if (id == null) {
                    id = "";
                }
                if (display == null) {
                    display = "";
                }
                stdout.format(format, match.getRanking(), match.getType(), id, folderId, display, match.getEmail());
                continue;
            }
            stdout.format(format, match.getRanking(), match.getType(), match.getEmail());
        }
    }

    private void doGetAllContacts(String[] args) throws ServiceException {
        this.dumpContacts(this.mMbox.getAllContacts(this.lookupFolderId(this.folderOpt()), null, true, this.getList(args, 0)));
    }

    private void doGetContacts(String[] args) throws ServiceException {
        this.dumpContacts(this.mMbox.getContacts(this.id(args[0]), null, true, this.getList(args, 1)));
    }

    private void doAutoComplete(String[] args) throws ServiceException {
        this.dumpAutoCompleteMatches(this.mMbox.autoComplete(args[0], 20));
    }

    private void doAutoCompleteGal(String[] args) throws ServiceException {
        ZMailbox.ZSearchGalResult result = this.mMbox.autoCompleteGal(args[0], ZMailbox.GalEntryType.account, 20);
        this.dumpContacts(result.getContacts());
    }

    private void dumpConversation(ZConversation conv) throws ServiceException {
        int first = 1;
        int last = first + conv.getMessageCount();
        int width = this.colWidth(last);
        this.mIndexToId.clear();
        stdout.format("%nSubject: %s%n", conv.getSubject());
        stdout.format("Id: %s%n", conv.getId());
        if (conv.hasTags()) {
            stdout.format("Tags: %s%n", this.lookupTagNames(conv.getTagIds()));
        }
        if (conv.hasFlags()) {
            stdout.format("Flags: %s%n", ZConversation.Flag.toNameList(conv.getFlags()));
        }
        stdout.format("Num-Messages: %d%n%n", conv.getMessageCount());
        if (conv.getMessageCount() == 0) {
            return;
        }
        int id_len = 4;
        for (ZConversation.ZMessageSummary ms : conv.getMessageSummaries()) {
            id_len = Math.max(id_len, ms.getId().length());
        }
        String headerFormat = String.format("%%%d.%ds  %%%d.%ds  %%-15.15s  %%-50.50s  %%s%%n", width, width, id_len, id_len);
        String itemFormat = String.format("%%%d.%ds. %%%d.%ds  %%-15.15s  %%-50.50s  %%tD %%<tR%%n", width, width, id_len, id_len);
        stdout.format(headerFormat, "", "Id", "Sender", "Fragment", "Date");
        stdout.format(headerFormat, "", "----------------------------------------------------------------------------------------------------", "---------------", "--------------------------------------------------", "--------------");
        int i = first;
        for (ZConversation.ZMessageSummary ms : conv.getMessageSummaries()) {
            stdout.format(itemFormat, i, ms.getId(), ms.getSender().getDisplay(), ms.getFragment(), ms.getDate());
            this.mIndexToId.put(i++, ms.getId());
        }
        stdout.println();
    }

    private void doGetConversation(String[] args) throws ServiceException {
        ZConversation conv = this.mMbox.getConversation(this.id(args[0]), ZMailbox.Fetch.none);
        if (this.verboseOpt()) {
            stdout.println(conv.dump());
        } else {
            this.dumpConversation(conv);
        }
    }

    private static int addEmail(StringBuilder sb, String email, int line) {
        if (sb.length() > 0) {
            sb.append(',');
            ++line;
        }
        if (line > 76) {
            sb.append("\n");
            line = 1;
        }
        if (sb.length() > 0) {
            sb.append(' ');
            ++line;
        }
        if (line > 20 && line + email.length() > 76) {
            sb.append("\n ");
            line = 1;
        }
        sb.append(email);
        return line += email.length();
    }

    public static String formatEmail(ZEmailAddress e) {
        String p = e.getPersonal();
        String a = e.getAddress();
        if (a == null) {
            a = "";
        }
        if (p == null) {
            return String.format("<%s>", a);
        }
        return String.format("%s <%s>", p, a);
    }

    public static String formatEmail(List<ZEmailAddress> list, String type, int used) {
        if (list == null || list.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (ZEmailAddress e : list) {
            if (!e.getType().equalsIgnoreCase(type)) continue;
            String fe = ZMailboxUtil.formatEmail(e);
            used = ZMailboxUtil.addEmail(sb, fe, used);
        }
        return sb.toString();
    }

    private void doHeader(List<ZEmailAddress> list, String hdrName, String addrType) {
        String val = ZMailboxUtil.formatEmail(list, addrType, hdrName.length() + 2);
        if (val == null || val.length() == 0) {
            return;
        }
        stdout.format("%s: %s%n", hdrName, val);
    }

    private void dumpMessage(ZMessage msg) throws ServiceException {
        stdout.format("Id: %s%n", msg.getId());
        stdout.format("Conversation-Id: %s%n", msg.getConversationId());
        ZFolder f = this.mMbox.getFolderById(msg.getFolderId());
        stdout.format("Folder: %s%n", f == null ? msg.getFolderId() : f.getPath());
        stdout.format("Subject: %s%n", msg.getSubject());
        this.doHeader(msg.getEmailAddresses(), "From", "f");
        this.doHeader(msg.getEmailAddresses(), "To", "t");
        this.doHeader(msg.getEmailAddresses(), "Cc", "c");
        stdout.format("Date: %s\n", DateUtil.toRFC822Date(new Date(msg.getReceivedDate())));
        if (msg.hasTags()) {
            stdout.format("Tags: %s%n", this.lookupTagNames(msg.getTagIds()));
        }
        if (msg.hasFlags()) {
            stdout.format("Flags: %s%n", ZMessage.Flag.toNameList(msg.getFlags()));
        }
        stdout.format("Size: %s%n", this.formatSize(msg.getSize()));
        stdout.println();
        if (this.dumpBody(msg.getMimeStructure())) {
            stdout.println();
        }
    }

    private void doGetMessage(String[] args) throws ServiceException {
        ZGetMessageParams params = new ZGetMessageParams();
        params.setMarkRead(true);
        params.setId(this.id(args[0]));
        ZMessage msg = this.mMbox.getMessage(params);
        if (this.verboseOpt()) {
            stdout.println(msg.dump());
        } else {
            this.dumpMessage(msg);
        }
    }

    private boolean dumpBody(ZMessage.ZMimePart mp) {
        if (mp == null) {
            return false;
        }
        if (mp.isBody()) {
            stdout.println(mp.getContent());
            return true;
        }
        for (ZMessage.ZMimePart child : mp.getChildren()) {
            if (!this.dumpBody(child)) continue;
            return true;
        }
        return false;
    }

    private void doModifyContact(String[] args) throws ServiceException {
        String id = this.mMbox.modifyContact(this.id(args[0]), this.mCommandLine.hasOption('r'), this.getContactMap(args, 1, !this.ignoreOpt())).getId();
        stdout.println(id);
    }

    private void dumpContact(ZContact contact) throws ServiceException {
        stdout.format("Id: %s%n", contact.getId());
        ZFolder f = this.mMbox.getFolderById(contact.getFolderId());
        stdout.format("Folder: %s%n", f == null ? contact.getFolderId() : f.getPath());
        stdout.format("Date: %tD %<tR%n", contact.getMetaDataChangedDate());
        if (contact.hasTags()) {
            stdout.format("Tags: %s%n", this.lookupTagNames(contact.getTagIds()));
        }
        if (contact.hasFlags()) {
            stdout.format("Flags: %s%n", ZContact.Flag.toNameList(contact.getFlags()));
        }
        stdout.format("Revision: %s%n", contact.getRevision());
        stdout.format("Attrs:%n", new Object[0]);
        Map<String, String> attrs = contact.getAttrs();
        for (Map.Entry<String, String> entry : attrs.entrySet()) {
            stdout.format("  %s: %s%n", entry.getKey(), entry.getValue());
        }
        stdout.println();
    }

    private void dumpAttrs(Map<String, Object> attrsIn) {
        TreeMap<String, Object> attrs = new TreeMap<String, Object>(attrsIn);
        for (Map.Entry<String, Object> entry : attrs.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String[]) {
                String[] sv = (String[])value;
                for (int i = 0; i < sv.length; ++i) {
                    stdout.println(name + ": " + sv[i]);
                }
                continue;
            }
            if (!(value instanceof String)) continue;
            stdout.println(name + ": " + value);
        }
    }

    private Map<String, String> getContactMap(String[] args, int offset, boolean validate) throws ServiceException {
        Map<String, String> result = this.getMap(args, offset);
        if (validate) {
            for (String name : result.keySet()) {
                ContactConstants.Attr.fromString(name);
            }
        }
        return result;
    }

    private Map<String, Object> getMultiMap(String[] args, int offset) throws ServiceException {
        try {
            return StringUtil.keyValueArrayToMultiMap(args, offset);
        }
        catch (IllegalArgumentException iae) {
            throw ZClientException.CLIENT_ERROR("not enough arguments", null);
        }
    }

    private Map<String, String> getMap(String[] args, int offset) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        for (int i = offset; i < args.length; i += 2) {
            String n = args[i];
            if (i + 1 >= args.length) {
                throw ZClientException.CLIENT_ERROR("not enough arguments", null);
            }
            String v = args[i + 1];
            attrs.put(n, v);
        }
        return attrs;
    }

    private List<String> getList(String[] args, int offset) {
        ArrayList<String> attrs = new ArrayList<String>();
        for (int i = offset; i < args.length; ++i) {
            attrs.add(args[i]);
        }
        return attrs;
    }

    public void interactive(BufferedReader in) throws IOException {
        while (true) {
            String[] args;
            stdout.print(this.mPrompt);
            stdout.flush();
            String line = StringUtil.readLine(in);
            if (line == null || line.length() == -1) break;
            if (this.mGlobalVerbose) {
                stdout.println(line);
            }
            if ((args = StringUtil.parseLine(line)).length == 0) continue;
            try {
                switch (this.execute(args)) {
                    case EXIT: {
                        return;
                    }
                }
            }
            catch (ServiceException e) {
                Throwable cause = e.getCause();
                stderr.println("ERROR: " + e.getCode() + " (" + e.getMessage() + ")" + (cause == null ? "" : " (cause: " + cause.getClass().getName() + " " + cause.getMessage() + ")"));
                if (!this.mGlobalVerbose) continue;
                e.printStackTrace(stderr);
            }
        }
    }

    public static void main(String[] args) throws IOException, ServiceException {
        CliUtil.toolSetup();
        SoapTransport.setDefaultUserAgent("zmmailbox", BuildInfo.VERSION);
        ZMailboxUtil pu = new ZMailboxUtil();
        GnuParser parser = new GnuParser();
        Options options = new Options();
        options.addOption("a", "admin", true, "admin account name to auth as");
        options.addOption("z", "zadmin", false, "use zimbra admin name/password from localconfig for admin/password");
        options.addOption("h", "help", false, "display usage");
        options.addOption("f", "file", true, "use file as input stream");
        options.addOption("u", "url", true, "http[s]://host[:port] of server to connect to");
        options.addOption("r", "protocol", true, "protocol to use for request/response [soap11, soap12, json]");
        options.addOption("m", "mailbox", true, "mailbox to open");
        options.addOption("p", "password", true, "password for admin/mailbox");
        options.addOption("P", "passfile", true, "filename with password in it");
        options.addOption("t", "timeout", true, "timeout (in seconds)");
        options.addOption("v", "verbose", false, "verbose mode");
        options.addOption("d", "debug", false, "debug mode");
        options.addOption(SoapCLI.OPT_AUTHTOKEN);
        options.addOption(SoapCLI.OPT_AUTHTOKENFILE);
        CommandLine cl = null;
        boolean err = false;
        try {
            cl = parser.parse(options, args, true);
        }
        catch (ParseException pe) {
            stderr.println("error: " + pe.getMessage());
            err = true;
        }
        if (err || cl.hasOption('h')) {
            pu.usage();
        }
        boolean isAdmin = false;
        pu.setVerbose(cl.hasOption('v'));
        if (cl.hasOption('a')) {
            pu.setAdminAccountName(cl.getOptionValue('a'));
            pu.setUrl(DEFAULT_ADMIN_URL, true);
            isAdmin = true;
        }
        if (cl.hasOption('z')) {
            pu.setAdminAccountName(LC.zimbra_ldap_user.value());
            pu.setPassword(LC.zimbra_ldap_password.value());
            pu.setUrl(DEFAULT_ADMIN_URL, true);
            isAdmin = true;
        }
        if (cl.hasOption("y") && cl.hasOption("Y")) {
            pu.usage();
        }
        if (cl.hasOption("y")) {
            pu.setAdminAuthToken(ZAuthToken.fromJSONString(cl.getOptionValue("y")));
            pu.setUrl(DEFAULT_ADMIN_URL, true);
            isAdmin = true;
        }
        if (cl.hasOption("Y")) {
            String authToken = StringUtil.readSingleLineFromFile(cl.getOptionValue("Y"));
            pu.setAdminAuthToken(ZAuthToken.fromJSONString(authToken));
            pu.setUrl(DEFAULT_ADMIN_URL, true);
            isAdmin = true;
        }
        if (cl.hasOption('u')) {
            pu.setUrl(cl.getOptionValue('u'), isAdmin);
        }
        if (cl.hasOption('m')) {
            pu.setMailboxName(cl.getOptionValue('m'));
        }
        if (cl.hasOption('p')) {
            pu.setPassword(cl.getOptionValue('p'));
        }
        if (cl.hasOption('r')) {
            pu.setProtocol(cl.getOptionValue('r'));
        }
        if (cl.hasOption('P')) {
            pu.setPassword(StringUtil.readSingleLineFromFile(cl.getOptionValue('P')));
        }
        if (cl.hasOption('d')) {
            pu.setDebug(true);
        }
        if (cl.hasOption('t')) {
            pu.setTimeout(cl.getOptionValue('t'));
        }
        pu.setInteractive((args = cl.getArgs()).length < 1);
        try {
            pu.initMailbox();
            if (args.length < 1) {
                InputStream is = cl.hasOption('f') ? new FileInputStream(cl.getOptionValue('f')) : System.in;
                pu.interactive(new BufferedReader(new InputStreamReader(is, "UTF-8")));
            } else {
                pu.execute(args);
            }
        }
        catch (ServiceException e) {
            Throwable cause = e.getCause();
            stderr.println("ERROR: " + e.getCode() + " (" + e.getMessage() + ")" + (cause == null ? "" : " (cause: " + cause.getClass().getName() + " " + cause.getMessage() + ")"));
            if (pu.mGlobalVerbose) {
                e.printStackTrace(stderr);
            }
            System.exit(2);
        }
    }

    private void doHelp(String[] args) {
        Category cat = null;
        if (args != null && args.length >= 1) {
            String s = args[0].toUpperCase();
            try {
                cat = Category.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                for (Category c : Category.values()) {
                    if (!c.name().startsWith(s)) continue;
                    cat = c;
                    break;
                }
            }
        }
        if (args == null || args.length == 0 || cat == null) {
            stdout.println(" zmmailbox is used for mailbox management. Try:");
            stdout.println("");
            for (Enum enum_ : Category.values()) {
                stdout.printf("     zmmailbox help %-15s %s\n", enum_.name().toLowerCase(), ((Category)enum_).getDescription());
            }
        }
        if (cat != null) {
            stdout.println("");
            for (Enum enum_ : Command.values()) {
                if (!((Command)enum_).hasHelp() || cat != Category.COMMANDS && cat != ((Command)enum_).getCategory()) continue;
                stdout.print(((Command)enum_).getFullUsage());
                stdout.println();
            }
            if (cat.getCategoryHelp() != null) {
                stdout.println(cat.getCategoryHelp());
            }
        }
        stdout.println();
    }

    @Override
    public void receiveSoapMessage(Element envelope) {
        long end = System.currentTimeMillis();
        stdout.printf("======== SOAP RECEIVE =========\n", new Object[0]);
        stdout.println(envelope.prettyPrint());
        stdout.printf("=============================== (%d msecs)\n", end - this.mSendStart);
    }

    @Override
    public void sendSoapMessage(Element envelope) {
        this.mSendStart = System.currentTimeMillis();
        stdout.println("========== SOAP SEND ==========");
        stdout.println(envelope.prettyPrint());
        stdout.println("===============================");
    }

    public static String encodeURL(String unencoded) throws ServiceException {
        String queryString = null;
        int queryStringStart = unencoded.indexOf(63);
        if (queryStringStart != -1) {
            queryString = unencoded.substring(queryStringStart);
            unencoded = unencoded.substring(0, queryStringStart);
        }
        StringBuilder encoded = new StringBuilder();
        Object[] parts = unencoded.split("/");
        if (parts != null) {
            for (int i = 0; i < parts.length; ++i) {
                parts[i] = HttpUtil.encodePath((String)parts[i]);
            }
            encoded.append(StringUtil.join("/", parts));
        } else {
            encoded.append(unencoded);
        }
        if (queryString != null) {
            String encodedQuery;
            try {
                URI uri = new URI(null, null, null, queryString.substring(1), null);
                encodedQuery = uri.toString();
            }
            catch (URISyntaxException e) {
                encodedQuery = queryString;
            }
            encoded.append(encodedQuery);
        }
        return encoded.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doGetRestURL(String[] args) throws ServiceException {
        OutputStream os = null;
        String outputFile = this.outputFileOpt();
        boolean hasOutputFile = outputFile != null;
        try {
            try {
                os = hasOutputFile ? new FileOutputStream(outputFile) : System.out;
                this.mMbox.getRESTResource(ZMailboxUtil.encodeURL(args[0]), os, hasOutputFile, this.startTimeOpt(), this.endTimeOpt(), this.mTimeout, this.urlOpt(false));
            }
            catch (IOException e) {
                throw ZClientException.IO_ERROR(e.getMessage(), e);
            }
            Object var7_5 = null;
            if (!hasOutputFile) return;
            if (os == null) return;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (!hasOutputFile) throw throwable;
            if (os == null) throw throwable;
            try {
                os.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        os.close();
        return;
    }

    private void doPostRestURL(String[] args) throws ServiceException {
        try {
            File file = new File(args[1]);
            this.mMbox.postRESTResource(ZMailboxUtil.encodeURL(args[0]), new FileInputStream(file), true, file.length(), this.contentTypeOpt(), this.ignoreAndContinueOnErrorOpt(), this.preserveAlarmsOpt(), this.mTimeout, this.urlOpt(false));
        }
        catch (FileNotFoundException e) {
            throw ZClientException.CLIENT_ERROR("file not found: " + args[1], e);
        }
    }

    static {
        try {
            stdout = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, "UTF-8"), true);
            stderr = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.err, "UTF-8"), true);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            System.exit(1);
        }
        Properties props = new Properties();
        props.setProperty("mail.mime.address.strict", "false");
        mSession = Session.getInstance((Properties)props);
        System.setProperty("mail.mime.base64.ignoreerrors", "true");
    }

    private static class TraceHandler
    extends ZEventHandler {
        private TraceHandler() {
        }

        public void handleRefresh(ZRefreshEvent refreshEvent, ZMailbox mailbox) {
            stdout.println("ZRefreshEvent: " + refreshEvent);
        }

        public void handleModify(ZModifyEvent event, ZMailbox mailbox) {
            stdout.println(event.getClass().getSimpleName() + ": " + event);
        }

        public void handleCreate(ZCreateEvent event, ZMailbox mailbox) {
            stdout.println(event.getClass().getSimpleName() + ": " + event);
        }

        public void handleDelete(ZDeleteEvent event, ZMailbox mailbox) {
            stdout.println("ZDeleteEvent: " + event);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ExecuteStatus {
        OK,
        EXIT;

    }

    static class Stats {
        int numMessages;
        int numUnread;

        Stats() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Command {
        ADD_FILTER_RULE("addFilterRule", "afrl", "{name}  [*active|inactive] [any|*all] {conditions}+ {actions}+", "add filter rule", Category.FILTER, 2, Integer.MAX_VALUE, O_AFTER, O_BEFORE, O_FIRST, O_LAST),
        ADD_MESSAGE("addMessage", "am", "{dest-folder-path} {filename-or-dir} [{filename-or-dir} ...]", "add a message to a folder", Category.MESSAGE, 2, Integer.MAX_VALUE, O_TAGS, O_DATE, O_FLAGS, O_NO_VALIDATION),
        ADMIN_AUTHENTICATE("adminAuthenticate", "aa", "{admin-name} {admin-password}", "authenticate as an admin. can only be used by an admin", Category.ADMIN, 2, 2, O_URL),
        AUTHENTICATE("authenticate", "a", "{name} {password}", "authenticate as account and open mailbox", Category.MISC, 2, 2, O_URL),
        AUTO_COMPLETE("autoComplete", "ac", "{query}", "contact auto autocomplete", Category.CONTACT, 1, 1, O_VERBOSE),
        AUTO_COMPLETE_GAL("autoCompleteGal", "acg", "{query}", "gal auto autocomplete", Category.CONTACT, 1, 1, O_VERBOSE),
        CREATE_CONTACT("createContact", "cct", "[attr1 value1 [attr2 value2...]]", "create contact", Category.CONTACT, 2, Integer.MAX_VALUE, O_FOLDER, O_IGNORE, O_TAGS),
        CREATE_FOLDER("createFolder", "cf", "{folder-name}", "create folder", Category.FOLDER, 1, 1, O_VIEW, O_COLOR, O_FLAGS, O_URL),
        CREATE_IDENTITY("createIdentity", "cid", "{identity-name} [attr1 value1 [attr2 value2...]]", "create identity", Category.ACCOUNT, 1, Integer.MAX_VALUE, new Option[0]),
        CREATE_MOUNTPOINT("createMountpoint", "cm", "{folder-name} {owner-id-or-name} {remote-item-id-or-path}", "create mountpoint", Category.FOLDER, 3, 3, O_VIEW, O_COLOR, O_FLAGS),
        CREATE_SEARCH_FOLDER("createSearchFolder", "csf", "{folder-name} {query}", "create search folder", Category.FOLDER, 2, 2, O_SORT, O_TYPES, O_COLOR),
        CREATE_SIGNATURE("createSignature", "csig", "{signature-name} [signature-value}", "create signature", Category.ACCOUNT, 2, 2, new Option[0]),
        CREATE_TAG("createTag", "ct", "{tag-name}", "create tag", Category.TAG, 1, 1, O_COLOR),
        DELETE_CONTACT("deleteContact", "dct", "{contact-ids}", "hard delete contact(s)", Category.CONTACT, 1, 1, new Option[0]),
        DELETE_CONVERSATION("deleteConversation", "dc", "{conv-ids}", "hard delete conversastion(s)", Category.CONVERSATION, 1, 1, new Option[0]),
        DELETE_ITEM("deleteItem", "di", "{item-ids}", "hard delete item(s)", Category.ITEM, 1, 1, new Option[0]),
        DELETE_IDENTITY("deleteIdentity", "did", "{identity-name}", "delete an identity", Category.ACCOUNT, 1, 1, new Option[0]),
        DELETE_FILTER_RULE("deleteFilterRule", "dfrl", "{name}", "add filter rule", Category.FILTER, 1, 1, new Option[0]),
        DELETE_FOLDER("deleteFolder", "df", "{folder-path}", "hard delete a folder (and subfolders)", Category.FOLDER, 1, 1, new Option[0]),
        DELETE_MESSAGE("deleteMessage", "dm", "{msg-ids}", "hard delete message(s)", Category.MESSAGE, 1, 1, new Option[0]),
        DELETE_SIGNATURE("deleteSignature", "dsig", "{signature-name|signature-id}", "delete signature", Category.ACCOUNT, 1, 1, new Option[0]),
        DELETE_TAG("deleteTag", "dt", "{tag-name}", "delete a tag", Category.TAG, 1, 1, new Option[0]),
        EMPTY_FOLDER("emptyFolder", "ef", "{folder-path}", "empty all the items in a folder (including subfolders)", Category.FOLDER, 1, 1, new Option[0]),
        EXIT("exit", "quit", "", "exit program", Category.MISC, 0, 0, new Option[0]),
        FLAG_CONTACT("flagContact", "fct", "{contact-ids} [0|1*]", "flag/unflag contact(s)", Category.CONTACT, 1, 2, new Option[0]),
        FLAG_CONVERSATION("flagConversation", "fc", "{conv-ids} [0|1*]", "flag/unflag conversation(s)", Category.CONVERSATION, 1, 2, new Option[0]),
        FLAG_ITEM("flagItem", "fi", "{item-ids} [0|1*]", "flag/unflag item(s)", Category.ITEM, 1, 2, new Option[0]),
        FLAG_MESSAGE("flagMessage", "fm", "{msg-ids} [0|1*]", "flag/unflag message(s)", Category.MESSAGE, 1, 2, new Option[0]),
        GET_ALL_CONTACTS("getAllContacts", "gact", "[attr1 [attr2...]]", "get all contacts", Category.CONTACT, 0, Integer.MAX_VALUE, O_VERBOSE, O_FOLDER),
        GET_ALL_FOLDERS("getAllFolders", "gaf", "", "get all folders", Category.FOLDER, 0, 0, O_VERBOSE),
        GET_ALL_TAGS("getAllTags", "gat", "", "get all tags", Category.TAG, 0, 0, O_VERBOSE),
        GET_APPOINTMENT_SUMMARIES("getAppointmentSummaries", "gaps", "{start-date-spec} {end-date-spec} {folder-path}", "get appointment summaries", Category.APPOINTMENT, 2, 3, O_VERBOSE),
        GET_CONTACTS("getContacts", "gct", "{contact-ids} [attr1 [attr2...]]", "get contact(s)", Category.CONTACT, 1, Integer.MAX_VALUE, O_VERBOSE),
        GET_CONVERSATION("getConversation", "gc", "{conv-id}", "get a converation", Category.CONVERSATION, 1, 1, O_VERBOSE),
        GET_IDENTITIES("getIdentities", "gid", "", "get all identites", Category.ACCOUNT, 0, 0, O_VERBOSE),
        GET_FILTER_RULES("getFilterRules", "gfrl", "", "get filter rules", Category.FILTER, 0, 0, new Option[0]),
        GET_FOLDER("getFolder", "gf", "{folder-path}", "get folder", Category.FOLDER, 1, 1, O_VERBOSE),
        GET_FOLDER_REQUEST("getFolderRequest", "gfr", "{folder-id}", "get folder request (always issues a GetFolderRequest)", Category.FOLDER, 1, 1, O_VERBOSE),
        GET_FOLDER_GRANT("getFolderGrant", "gfg", "{folder-path}", "get folder grants", Category.FOLDER, 1, 1, O_VERBOSE),
        GET_MESSAGE("getMessage", "gm", "{msg-id}", "get a message", Category.MESSAGE, 1, 1, O_VERBOSE),
        GET_MAILBOX_SIZE("getMailboxSize", "gms", "", "get mailbox size", Category.MISC, 0, 0, O_VERBOSE),
        GET_PERMISSION("getPermission", "gp", "[right1 [right2...]]", "get rights currently granted", Category.PERMISSION, 0, Integer.MAX_VALUE, O_VERBOSE),
        GET_REST_URL("getRestURL", "gru", "{relative-path}", "do a GET on a REST URL relative to the mailbox", Category.MISC, 1, 1, O_OUTPUT_FILE, O_START_TIME, O_END_TIME, O_URL),
        GET_SIGNATURES("getSignatures", "gsig", "", "get all signatures", Category.ACCOUNT, 0, 0, O_VERBOSE),
        GRANT_PERMISSION("grantPermission", "grp", "{account {name}|group {name}|key {name} [{access key}]|all|public {[-]right}}", "allow or deny a right to a grantee or a group of grantee. to deny a right, put a '-' in front of the right", Category.PERMISSION, 2, 4, new Option[0]),
        HELP("help", "?", "commands", "return help on a group of commands, or all commands. Use -v for detailed help.", Category.MISC, 0, 1, O_VERBOSE),
        IMPORT_URL_INTO_FOLDER("importURLIntoFolder", "iuif", "{folder-path} {url}", "add the contents to the remote feed at {target-url} to the folder", Category.FOLDER, 2, 2, new Option[0]),
        LIST_PERMISSION("listPermission", "lp", "", "list and describe all rights that can be granted", Category.PERMISSION, 0, 0, O_VERBOSE),
        MARK_CONVERSATION_READ("markConversationRead", "mcr", "{conv-ids} [0|1*]", "mark conversation(s) as read/unread", Category.CONVERSATION, 1, 2, new Option[0]),
        MARK_CONVERSATION_SPAM("markConversationSpam", "mcs", "{conv} [0|1*] [{dest-folder-path}]", "mark conversation as spam/not-spam, and optionally move", Category.CONVERSATION, 1, 3, new Option[0]),
        MARK_ITEM_READ("markItemRead", "mir", "{item-ids} [0|1*]", "mark item(s) as read/unread", Category.ITEM, 1, 2, new Option[0]),
        MARK_FOLDER_READ("markFolderRead", "mfr", "{folder-path}", "mark all items in a folder as read", Category.FOLDER, 1, 1, new Option[0]),
        MARK_MESSAGE_READ("markMessageRead", "mmr", "{msg-ids} [0|1*]", "mark message(s) as read/unread", Category.MESSAGE, 1, 2, new Option[0]),
        MARK_MESSAGE_SPAM("markMessageSpam", "mms", "{msg} [0|1*] [{dest-folder-path}]", "mark a message as spam/not-spam, and optionally move", Category.MESSAGE, 1, 3, new Option[0]),
        MARK_TAG_READ("markTagRead", "mtr", "{tag-name}", "mark all items with this tag as read", Category.TAG, 1, 1, new Option[0]),
        MODIFY_CONTACT("modifyContactAttrs", "mcta", "{contact-id} [attr1 value1 [attr2 value2...]]", "modify a contact", Category.CONTACT, 3, Integer.MAX_VALUE, O_REPLACE, O_IGNORE),
        MODIFY_FILTER_RULE("modifyFilterRule", "mfrl", "{name} [*active|inactive] [any|*all] {conditions}+ {actions}+", "add filter rule", Category.FILTER, 2, Integer.MAX_VALUE, new Option[0]),
        MODIFY_FOLDER_CHECKED("modifyFolderChecked", "mfch", "{folder-path} [0|1*]", "modify whether a folder is checked in the UI", Category.FOLDER, 1, 2, new Option[0]),
        MODIFY_FOLDER_COLOR("modifyFolderColor", "mfc", "{folder-path} {new-color}", "modify a folder's color", Category.FOLDER, 2, 2, new Option[0]),
        MODIFY_FOLDER_EXCLUDE_FREE_BUSY("modifyFolderExcludeFreeBusy", "mfefb", "{folder-path} [0|1*]", "change whether folder is excluded from free-busy", Category.FOLDER, 1, 2, new Option[0]),
        MODIFY_FOLDER_FLAGS("modifyFolderFlags", "mff", "{folder-path} {folder-flags}", "replaces the flags on the folder (subscribed, checked, etc.)", Category.FOLDER, 2, 2, new Option[0]),
        MODIFY_FOLDER_GRANT("modifyFolderGrant", "mfg", "{folder-path} {account {name}|group {name}|domain {name}|all|public|guest {email} [{password}]|key {email} [{accesskey}] {permissions|none}}", "add/remove a grant to a folder", Category.FOLDER, 3, 5, new Option[0]),
        MODIFY_FOLDER_URL("modifyFolderURL", "mfu", "{folder-path} {url}", "modify a folder's URL", Category.FOLDER, 2, 2, new Option[0]),
        MODIFY_IDENTITY("modifyIdentity", "mid", "{identity-name} [attr1 value1 [attr2 value2...]]", "modify an identity", Category.ACCOUNT, 1, Integer.MAX_VALUE, new Option[0]),
        MODIFY_ITEM_FLAGS("modifyItemFlags", "mif", "{item-ids} {item-flags}", "replaces the flags on the items (answered, unread, flagged, etc.)", Category.ITEM, 2, 2, new Option[0]),
        MODIFY_SIGNATURE("modifySignature", "msig", "{signature-name|signature-id} {value}", "modify signature value", Category.ACCOUNT, 2, 2, new Option[0]),
        MODIFY_TAG_COLOR("modifyTagColor", "mtc", "{tag-name} {tag-color}", "modify a tag's color", Category.TAG, 2, 2, new Option[0]),
        MOVE_CONTACT("moveContact", "mct", "{contact-ids} {dest-folder-path}", "move contact(s) to a new folder", Category.CONTACT, 2, 2, new Option[0]),
        MOVE_CONVERSATION("moveConversation", "mc", "{conv-ids} {dest-folder-path}", "move conversation(s) to a new folder", Category.CONVERSATION, 2, 2, new Option[0]),
        MOVE_ITEM("moveItem", "mi", "{item-ids} {dest-folder-path}", "move item(s) to a new folder", Category.ITEM, 2, 2, new Option[0]),
        MOVE_MESSAGE("moveMessage", "mm", "{msg-ids} {dest-folder-path}", "move message(s) to a new folder", Category.MESSAGE, 2, 2, new Option[0]),
        NOOP("noOp", "no", "", "do a NoOp SOAP call to the server", Category.MISC, 0, 1, new Option[0]),
        POST_REST_URL("postRestURL", "pru", "{relative-path} {file-name}", "do a POST on a REST URL relative to the mailbox", Category.MISC, 2, 2, O_CONTENT_TYPE, O_IGNORE_ERROR, O_PRESERVE_ALARMS, O_URL),
        RENAME_FOLDER("renameFolder", "rf", "{folder-path} {new-folder-path}", "rename folder", Category.FOLDER, 2, 2, new Option[0]),
        RENAME_SIGNATURE("renameSignature", "rsig", "{signature-name|signature-id} {new-name}", "rename signature", Category.ACCOUNT, 2, 2, new Option[0]),
        RENAME_TAG("renameTag", "rt", "{tag-name} {new-tag-name}", "rename tag", Category.TAG, 2, 2, new Option[0]),
        REVOKE_PERMISSION("revokePermission", "rvp", "{account {name}|group {name}|key {name}|all|public {[-]right}}", "revoke a right previously granted to a grantee or a group of grantees. to revoke a denied right, put a '-' in front of the right", Category.PERMISSION, 2, 3, new Option[0]),
        SEARCH("search", "s", "{query}", "perform search", Category.SEARCH, 0, 1, O_LIMIT, O_SORT, O_TYPES, O_VERBOSE, O_CURRENT, O_NEXT, O_PREVIOUS),
        SEARCH_CONVERSATION("searchConv", "sc", "{conv-id} {query}", "perform search on conversation", Category.SEARCH, 0, 2, O_LIMIT, O_SORT, O_TYPES, O_VERBOSE, O_CURRENT, O_NEXT, O_PREVIOUS),
        SELECT_MAILBOX("selectMailbox", "sm", "{account-name}", "select a different mailbox. can only be used by an admin", Category.ADMIN, 1, 1, new Option[0]),
        SYNC_FOLDER("syncFolder", "sf", "{folder-path}", "synchronize folder's contents to the remote feed specified by folder's {url}", Category.FOLDER, 1, 1, new Option[0]),
        TAG_CONTACT("tagContact", "tct", "{contact-ids} {tag-name} [0|1*]", "tag/untag contact(s)", Category.CONTACT, 2, 3, new Option[0]),
        TAG_CONVERSATION("tagConversation", "tc", "{conv-ids} {tag-name} [0|1*]", "tag/untag conversation(s)", Category.CONVERSATION, 2, 3, new Option[0]),
        TAG_ITEM("tagItem", "ti", "{item-ids} {tag-name} [0|1*]", "tag/untag item(s)", Category.ITEM, 2, 3, new Option[0]),
        TAG_MESSAGE("tagMessage", "tm", "{msg-ids} {tag-name} [0|1*]", "tag/untag message(s)", Category.MESSAGE, 2, 3, new Option[0]);

        private String mName;
        private String mAlias;
        private String mSyntax;
        private String mHelp;
        private Option[] mOpt;
        private Category mCat;
        private int mMinArgLength = 0;
        private int mMaxArgLength = Integer.MAX_VALUE;

        public String getName() {
            return this.mName;
        }

        public String getAlias() {
            return this.mAlias;
        }

        public String getSyntax() {
            return this.mSyntax;
        }

        public String getHelp() {
            return this.mHelp;
        }

        public Category getCategory() {
            return this.mCat;
        }

        public boolean hasHelp() {
            return this.mSyntax != null;
        }

        public boolean checkArgsLength(String[] args) {
            int len = args == null ? 0 : args.length;
            return len >= this.mMinArgLength && len <= this.mMaxArgLength;
        }

        public Options getOptions() {
            Options opts = new Options();
            for (Option o : this.mOpt) {
                opts.addOption(o.getOpt(), o.getLongOpt(), o.hasArg(), o.getDescription());
            }
            return opts;
        }

        public String getCommandHelp() {
            String commandName = String.format("%s(%s)", this.getName(), this.getAlias());
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("  %-38s %s%n", commandName, this.getHelp()));
            return sb.toString();
        }

        public String getFullUsage() {
            String commandName = String.format("%s(%s)", this.getName(), this.getAlias());
            Collection opts = this.getOptions().getOptions();
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("  %-28s %s%n", commandName, (opts.size() > 0 ? "[opts] " : "") + this.getSyntax()));
            for (Object o : opts) {
                Option opt = (Option)o;
                String arg = opt.hasArg() ? " <arg>" : "";
                String shortOpt = opt.getOpt();
                String longOpt = opt.getLongOpt();
                String optStr = shortOpt != null ? String.format("  -%s/--%s%s", shortOpt, longOpt, arg) : String.format("  --%s%s", longOpt, arg);
                sb.append(String.format("  %-30s %s%n", optStr, opt.getDescription()));
            }
            return sb.toString();
        }

        private Command(String name, String alias, String syntax, String help, Category cat, int minArgLength, int maxArgLength, Option ... opts) {
            this.mName = name;
            this.mAlias = alias;
            this.mSyntax = syntax;
            this.mHelp = help;
            this.mCat = cat;
            this.mMinArgLength = minArgLength;
            this.mMaxArgLength = maxArgLength;
            this.mOpt = opts;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Category {
        ADMIN("help on admin-related commands"),
        ACCOUNT("help on account-related commands"),
        APPOINTMENT("help on appoint-related commands", " absolute date-specs:\n\n  mm/dd/yyyy (i.e., 12/25/1998)\n  yyyy/dd/mm (i.e., 1989/12/25)\n  \\d+       (num milliseconds, i.e., 1132276598000)\n\n  relative date-specs:\n\n  [mp+-]?([0-9]+)([mhdwy][a-z]*)?g\n \n   +/{not-specified}   current time plus an offset\n   -                   current time minus an offset\n  \n   (0-9)+    value\n\n   ([mhdwy][a-z]*)  units, everything after the first character is ignored (except for \"mi\" case):\n   m(onths)\n   mi(nutes)\n   d(ays)\n   w(eeks)\n   h(ours)\n   y(ears)\n   \n  examples:\n     1day     1 day from now\n    +1day     1 day from now \n    p1day     1 day from now\n    +60mi     60 minutes from now\n    +1week    1 week from now\n    +6mon     6 months from now \n    1year     1 year from now\n\n"),
        COMMANDS("help on all commands"),
        CONTACT("help on contact-related commands"),
        CONVERSATION("help on conversation-related commands"),
        FILTER("help on filter-realted commnds", "  {conditions}:\n    header \"name\" is|not_is|contains|not_contains|matches|not_matches \"value\"\n    header \"name\" exists|not_exists\n    date before|not_before|after|not_after \"YYYYMMDD\"\n    size under|not_under|over|not_over \"1|1K|1M\"\n    body contains|not_contains \"text\"\n    addressbook in|not_in \"header-name\"\n    attachment exists|not_exists\n\n  {actions}:\n    keep\n    discard\n    fileinto \"/path\"\n    tag \"/tag\"\n    mark read|flagged\n    redirect \"address\"\n    stop\n"),
        FOLDER("help on folder-related commands"),
        ITEM("help on item-related commands"),
        MESSAGE("help on message-related commands"),
        MISC("help on misc commands"),
        PERMISSION("help on permission commands"),
        SEARCH("help on search-related commands"),
        TAG("help on tag-related commands");

        String mDesc;
        String mCategoryHelp;

        public String getDescription() {
            return this.mDesc;
        }

        public String getCategoryHelp() {
            return this.mCategoryHelp;
        }

        private Category(String desc) {
            this.mDesc = desc;
        }

        private Category(String desc, String help) {
            this.mDesc = desc;
            this.mCategoryHelp = help;
        }
    }
}

