/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient;

import com.zimbra.common.auth.ZAuthToken;
import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.RemoteServiceException;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AccountConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.soap.SoapFaultException;
import com.zimbra.common.soap.SoapHttpTransport;
import com.zimbra.common.soap.SoapProtocol;
import com.zimbra.common.soap.SoapTransport;
import com.zimbra.common.soap.VoiceConstants;
import com.zimbra.common.soap.ZimbraNamespace;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.EasySSLProtocolSocketFactory;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.SystemUtil;
import com.zimbra.common.util.ZimbraHttpConnectionManager;
import com.zimbra.common.zclient.ZClientException;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.util.BuildInfo;
import com.zimbra.cs.zclient.GetMethodInputStream;
import com.zimbra.cs.zclient.ToZJSONObject;
import com.zimbra.cs.zclient.ZAce;
import com.zimbra.cs.zclient.ZAppointment;
import com.zimbra.cs.zclient.ZAppointmentHit;
import com.zimbra.cs.zclient.ZApptSummaryCache;
import com.zimbra.cs.zclient.ZAuthResult;
import com.zimbra.cs.zclient.ZAutoCompleteMatch;
import com.zimbra.cs.zclient.ZCalDataSource;
import com.zimbra.cs.zclient.ZCallFeature;
import com.zimbra.cs.zclient.ZCallFeatures;
import com.zimbra.cs.zclient.ZChangePasswordResult;
import com.zimbra.cs.zclient.ZContact;
import com.zimbra.cs.zclient.ZContactByPhoneCache;
import com.zimbra.cs.zclient.ZConversation;
import com.zimbra.cs.zclient.ZDataSource;
import com.zimbra.cs.zclient.ZDateTime;
import com.zimbra.cs.zclient.ZDocument;
import com.zimbra.cs.zclient.ZEmailAddress;
import com.zimbra.cs.zclient.ZFeatures;
import com.zimbra.cs.zclient.ZFilterRules;
import com.zimbra.cs.zclient.ZFolder;
import com.zimbra.cs.zclient.ZGetInfoResult;
import com.zimbra.cs.zclient.ZGetMessageParams;
import com.zimbra.cs.zclient.ZGrant;
import com.zimbra.cs.zclient.ZIdentity;
import com.zimbra.cs.zclient.ZImapDataSource;
import com.zimbra.cs.zclient.ZInvite;
import com.zimbra.cs.zclient.ZItem;
import com.zimbra.cs.zclient.ZJSONObject;
import com.zimbra.cs.zclient.ZMessage;
import com.zimbra.cs.zclient.ZMountpoint;
import com.zimbra.cs.zclient.ZPhoneAccount;
import com.zimbra.cs.zclient.ZPop3DataSource;
import com.zimbra.cs.zclient.ZPrefs;
import com.zimbra.cs.zclient.ZRssDataSource;
import com.zimbra.cs.zclient.ZSearchContext;
import com.zimbra.cs.zclient.ZSearchFolder;
import com.zimbra.cs.zclient.ZSearchHit;
import com.zimbra.cs.zclient.ZSearchPagerCache;
import com.zimbra.cs.zclient.ZSearchPagerResult;
import com.zimbra.cs.zclient.ZSearchParams;
import com.zimbra.cs.zclient.ZSearchResult;
import com.zimbra.cs.zclient.ZSignature;
import com.zimbra.cs.zclient.ZTag;
import com.zimbra.cs.zclient.event.ZCreateAppointmentEvent;
import com.zimbra.cs.zclient.event.ZCreateContactEvent;
import com.zimbra.cs.zclient.event.ZCreateConversationEvent;
import com.zimbra.cs.zclient.event.ZCreateEvent;
import com.zimbra.cs.zclient.event.ZCreateFolderEvent;
import com.zimbra.cs.zclient.event.ZCreateItemEvent;
import com.zimbra.cs.zclient.event.ZCreateMessageEvent;
import com.zimbra.cs.zclient.event.ZCreateMountpointEvent;
import com.zimbra.cs.zclient.event.ZCreateSearchFolderEvent;
import com.zimbra.cs.zclient.event.ZCreateTagEvent;
import com.zimbra.cs.zclient.event.ZCreateTaskEvent;
import com.zimbra.cs.zclient.event.ZDeleteEvent;
import com.zimbra.cs.zclient.event.ZEventHandler;
import com.zimbra.cs.zclient.event.ZModifyAppointmentEvent;
import com.zimbra.cs.zclient.event.ZModifyContactEvent;
import com.zimbra.cs.zclient.event.ZModifyConversationEvent;
import com.zimbra.cs.zclient.event.ZModifyEvent;
import com.zimbra.cs.zclient.event.ZModifyFolderEvent;
import com.zimbra.cs.zclient.event.ZModifyMailboxEvent;
import com.zimbra.cs.zclient.event.ZModifyMessageEvent;
import com.zimbra.cs.zclient.event.ZModifyMountpointEvent;
import com.zimbra.cs.zclient.event.ZModifySearchFolderEvent;
import com.zimbra.cs.zclient.event.ZModifyTagEvent;
import com.zimbra.cs.zclient.event.ZModifyTaskEvent;
import com.zimbra.cs.zclient.event.ZModifyVoiceMailItemEvent;
import com.zimbra.cs.zclient.event.ZModifyVoiceMailItemFolderEvent;
import com.zimbra.cs.zclient.event.ZRefreshEvent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.multipart.ByteArrayPartSource;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.dom4j.QName;
import org.json.JSONException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZMailbox
implements ToZJSONObject {
    public static final int MAX_NUM_CACHED_SEARCH_PAGERS = 5;
    public static final int MAX_NUM_CACHED_SEARCH_CONV_PAGERS = 5;
    public static final int MAX_NUM_CACHED_MESSAGES;
    public static final int MAX_NUM_CACHED_CONTACTS = 25;
    public static final String PATH_SEPARATOR = "/";
    public static final char PATH_SEPARATOR_CHAR = '/';
    private ZAuthToken mAuthToken;
    private SoapHttpTransport mTransport;
    private NotifyPreference mNotifyPreference;
    private Map<String, ZTag> mNameToTag;
    private Map<String, ZItem> mIdToItem;
    private ZGetInfoResult mGetInfoResult;
    private ZFolder mUserRoot;
    private ZSearchPagerCache mSearchPagerCache;
    private ZSearchPagerCache mSearchConvPagerCache;
    private ZApptSummaryCache mApptSummaryCache;
    private LRUMap mMessageCache;
    private LRUMap mContactCache;
    private ZFilterRules mRules;
    private ZAuthResult mAuthResult;
    private String mClientIp;
    private List<ZPhoneAccount> mPhoneAccounts;
    private Map<String, ZPhoneAccount> mPhoneAccountMap;
    private Element mVoiceStorePrincipal;
    private long mSize;
    private boolean mHasMyCard;
    private ZContact mMyCard;
    private boolean mNoTagCache;
    private ZContactByPhoneCache mContactByPhoneCache;
    private List<ZEventHandler> mHandlers = new ArrayList<ZEventHandler>();
    private static final Pattern sCOMMA;
    public static final String CONTACT_IMPORT_TYPE_CSV = "csv";
    public static final String TC_INCLUDE_TRASH = "t";
    public static final String TC_INCLUDE_JUNK = "j";
    public static final String TC_INCLUDE_SENT = "s";
    public static final String TC_INCLUDE_OTHER = "o";
    private static Pattern sAttachmentId;
    public static final String APPOINTMENT_IMPORT_TYPE_ICS = "ics";
    private static final int ADMIN_PORT;

    public static ZMailbox getMailbox(Options options) throws ServiceException {
        return new ZMailbox(options);
    }

    private ZMailbox() {
    }

    public static ZChangePasswordResult changePassword(Options options) throws ServiceException {
        ZMailbox mailbox = new ZMailbox();
        mailbox.mClientIp = options.getClientIp();
        mailbox.mNotifyPreference = NotifyPreference.fromOptions(options);
        mailbox.initPreAuth(options);
        return mailbox.changePassword(options.getAccount(), options.getAccountBy(), options.getPassword(), options.getNewPassword(), options.getVirtualHost());
    }

    public static ZMailbox getByName(String name, String password, String uri) throws ServiceException {
        return new ZMailbox(new Options(name, Provisioning.AccountBy.name, password, uri));
    }

    public static ZMailbox getByAuthToken(String authToken, String uri) throws ServiceException {
        return new ZMailbox(new Options(authToken, uri));
    }

    public static ZMailbox getByAuthToken(ZAuthToken authToken, String uri) throws ServiceException {
        return new ZMailbox(new Options(authToken, uri));
    }

    public ZMailbox(Options options) throws ServiceException {
        this.mHandlers.add(new InternalEventHandler());
        this.mSearchPagerCache = new ZSearchPagerCache(5, true);
        this.mHandlers.add(this.mSearchPagerCache);
        this.mSearchConvPagerCache = new ZSearchPagerCache(5, false);
        this.mHandlers.add(this.mSearchConvPagerCache);
        this.mMessageCache = new LRUMap(MAX_NUM_CACHED_MESSAGES);
        this.mContactCache = new LRUMap(25);
        this.mApptSummaryCache = new ZApptSummaryCache();
        this.mHandlers.add(this.mApptSummaryCache);
        if (options.getEventHandler() != null) {
            this.mHandlers.add(options.getEventHandler());
        }
        this.mNotifyPreference = NotifyPreference.fromOptions(options);
        this.mClientIp = options.getClientIp();
        this.initPreAuth(options);
        if (options.getAuthToken() != null) {
            if (options.getAuthAuthToken()) {
                this.mAuthResult = this.authByAuthToken(options);
            }
            this.initAuthToken(options.getAuthToken());
        } else {
            String password;
            if (options.getNewPassword() != null) {
                this.changePassword(options.getAccount(), options.getAccountBy(), options.getPassword(), options.getNewPassword(), options.getVirtualHost());
                password = options.getNewPassword();
            } else {
                password = options.getPassword();
            }
            this.mAuthResult = this.authByPassword(options, password);
            this.initAuthToken(this.mAuthResult.getAuthToken());
        }
        if (options.getTargetAccount() != null) {
            this.initTargetAccount(options.getTargetAccount(), options.getTargetAccountBy());
        }
    }

    public boolean addEventHandler(ZEventHandler handler) {
        if (!this.mHandlers.contains(handler)) {
            this.mHandlers.add(handler);
            return true;
        }
        return false;
    }

    public boolean removeEventHandler(ZEventHandler handler) {
        return this.mHandlers.remove(handler);
    }

    private void initAuthToken(ZAuthToken authToken) {
        this.mAuthToken = authToken;
        this.mTransport.setAuthToken(this.mAuthToken);
    }

    private void initPreAuth(Options options) {
        this.mIdToItem = new HashMap<String, ZItem>();
        this.setSoapURI(options);
        if (options.getDebugListener() != null) {
            this.mTransport.setDebugListener(options.getDebugListener());
        } else if (options.getHttpDebugListener() != null) {
            this.mTransport.setHttpDebugListener(options.getHttpDebugListener());
        }
    }

    private void initTargetAccount(String key, Provisioning.AccountBy by) {
        if (Provisioning.AccountBy.id.equals((Object)by)) {
            this.mTransport.setTargetAcctId(key);
        } else if (Provisioning.AccountBy.name.equals((Object)by)) {
            this.mTransport.setTargetAcctName(key);
        }
    }

    public Element newRequestElement(QName name) {
        if (this.mTransport.getRequestProtocol() == SoapProtocol.SoapJS) {
            return new Element.JSONElement(name);
        }
        return new Element.XMLElement(name);
    }

    private ZChangePasswordResult changePassword(String key, Provisioning.AccountBy by, String oldPassword, String newPassword, String virtualHost) throws ServiceException {
        if (this.mTransport == null) {
            throw ZClientException.CLIENT_ERROR("must call setURI before calling changePassword", null);
        }
        Element req = this.newRequestElement(AccountConstants.CHANGE_PASSWORD_REQUEST);
        Element account = req.addUniqueElement("account");
        account.addAttribute("by", by.name());
        account.setText(key);
        req.addElement("oldPassword").setText(oldPassword);
        req.addElement("password").setText(newPassword);
        if (virtualHost != null) {
            req.addElement("virtualHost").setText(virtualHost);
        }
        return new ZChangePasswordResult(this.invoke(req));
    }

    private void addAttrsAndPrefs(Element req, Options options) {
        List<String> attrs;
        List<String> prefs = options.getPrefs();
        if (prefs != null && !prefs.isEmpty()) {
            Element prefsEl = req.addElement("prefs");
            for (String p : prefs) {
                prefsEl.addElement("pref").addAttribute("name", p);
            }
        }
        if ((attrs = options.getAttrs()) != null && !attrs.isEmpty()) {
            Element attrsEl = req.addElement("attrs");
            for (String a : attrs) {
                attrsEl.addElement("attr").addAttribute("name", a);
            }
        }
    }

    private ZAuthResult authByPassword(Options options, String password) throws ServiceException {
        if (this.mTransport == null) {
            throw ZClientException.CLIENT_ERROR("must call setURI before calling authenticate", null);
        }
        Element req = this.newRequestElement(AccountConstants.AUTH_REQUEST);
        Element account = req.addElement("account");
        account.addAttribute("by", options.getAccountBy().name());
        account.setText(options.getAccount());
        req.addElement("password").setText(password);
        if (options.getVirtualHost() != null) {
            req.addElement("virtualHost").setText(options.getVirtualHost());
        }
        if (options.getRequestedSkin() != null) {
            req.addElement("requestedSkin").setText(options.getRequestedSkin());
        }
        this.addAttrsAndPrefs(req, options);
        ZAuthResult r = new ZAuthResult(this.invoke(req));
        r.setSessionId(this.mTransport.getSessionId());
        return r;
    }

    private ZAuthResult authByAuthToken(Options options) throws ServiceException {
        if (this.mTransport == null) {
            throw ZClientException.CLIENT_ERROR("must call setURI before calling authenticate", null);
        }
        Element req = this.newRequestElement(AccountConstants.AUTH_REQUEST);
        ZAuthToken zat = options.getAuthToken();
        zat.encodeAuthReq(req, false);
        if (options.getRequestedSkin() != null) {
            req.addElement("requestedSkin").setText(options.getRequestedSkin());
        }
        this.addAttrsAndPrefs(req, options);
        ZAuthResult r = new ZAuthResult(this.invoke(req));
        r.setSessionId(this.mTransport.getSessionId());
        return r;
    }

    public ZAuthResult getAuthResult() {
        return this.mAuthResult;
    }

    public ZAuthToken getAuthToken() {
        return this.mAuthToken;
    }

    private void setSoapURI(Options options) {
        if (this.mTransport != null) {
            this.mTransport.shutdown();
        }
        this.mTransport = new SoapHttpTransport(options.getUri(), options.getProxyHost(), options.getProxyPort(), options.getProxyUser(), options.getProxyPass());
        if (options.getUserAgentName() == null) {
            this.mTransport.setUserAgent("zclient", BuildInfo.VERSION);
        } else {
            this.mTransport.setUserAgent(options.getUserAgentName(), options.getUserAgentVersion());
        }
        this.mTransport.setMaxNotifySeq(0L);
        this.mTransport.setClientIp(this.mClientIp);
        if (options.getTimeout() > -1) {
            this.mTransport.setTimeout(options.getTimeout());
        }
        if (options.getRetryCount() != -1) {
            this.mTransport.setRetryCount(options.getRetryCount());
        }
        if (this.mAuthToken != null) {
            this.mTransport.setAuthToken(this.mAuthToken);
        }
        if (options.getResponseProtocol() != null) {
            this.mTransport.setResponseProtocol(options.getResponseProtocol());
        }
        if (options.getRequestProtocol() != null) {
            this.mTransport.setRequestProtocol(options.getRequestProtocol());
        }
    }

    public Element invoke(Element request) throws ServiceException {
        return this.invoke(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Element invoke(Element request, String requestedAccountId) throws ServiceException {
        Element element;
        try {
            try {
                boolean nosession = this.mNotifyPreference == NotifyPreference.nosession;
                element = this.mTransport.invoke(request, false, nosession, requestedAccountId);
                Object var6_8 = null;
            }
            catch (SoapFaultException e) {
                throw e;
            }
            catch (Exception e) {
                Throwable t = SystemUtil.getInnermostException(e);
                RemoteServiceException.doConnectionFailures(this.mTransport.getURI(), t);
                RemoteServiceException.doSSLFailures(t.getMessage(), t);
                if (!(e instanceof IOException)) throw ServiceException.FAILURE(e.getMessage(), e);
                throw ZClientException.IO_ERROR(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            Element context = this.mTransport.getZimbraContext();
            this.mTransport.clearZimbraContext();
            this.handleResponseContext(context);
            throw throwable;
        }
        Element context = this.mTransport.getZimbraContext();
        this.mTransport.clearZimbraContext();
        this.handleResponseContext(context);
        return element;
    }

    private void handleResponseContext(Element context) throws ServiceException {
        if (context == null) {
            return;
        }
        Element refresh = context.getOptionalElement("refresh");
        if (refresh != null) {
            this.handleRefresh(refresh);
        }
        for (Element notify : context.listElements("notify")) {
            this.mTransport.setMaxNotifySeq(Math.max(this.mTransport.getMaxNotifySeq(), notify.getAttributeLong("seq", 0L)));
            this.handleDeleted(notify.getOptionalElement("deleted"));
            this.handleCreated(notify.getOptionalElement("created"));
            this.handleModified(notify.getOptionalElement("modified"));
        }
    }

    private void handleRefresh(Element refresh) throws ServiceException {
        for (Element mbx : refresh.listElements("mbx")) {
            if (mbx.getAttribute("acct", null) != null) continue;
            this.mSize = mbx.getAttributeLong(TC_INCLUDE_SENT);
        }
        Element tags = refresh.getOptionalElement("tags");
        ArrayList<ZTag> tagList = new ArrayList<ZTag>();
        if (tags != null) {
            for (Element t : tags.listElements("tag")) {
                ZTag tag = new ZTag(t, this);
                tagList.add(tag);
            }
        }
        Element folderEl = refresh.getOptionalElement("folder");
        ZFolder userRoot = new ZFolder(folderEl, null, this);
        ZRefreshEvent event = new ZRefreshEvent(this.mSize, userRoot, tagList);
        for (ZEventHandler handler : this.mHandlers) {
            handler.handleRefresh(event, this);
        }
        this.mRules = null;
    }

    private void handleModified(Element modified) throws ServiceException {
        if (modified == null) {
            return;
        }
        for (Element e : modified.listElements()) {
            ToZJSONObject event = null;
            if (e.getName().equals("c")) {
                event = new ZModifyConversationEvent(e);
            } else if (e.getName().equals("m")) {
                event = new ZModifyMessageEvent(e);
            } else if (e.getName().equals("tag")) {
                event = new ZModifyTagEvent(e);
            } else if (e.getName().equals("cn")) {
                event = new ZModifyContactEvent(e);
            } else if (e.getName().equals("search")) {
                event = new ZModifySearchFolderEvent(e);
            } else if (e.getName().equals("folder")) {
                event = new ZModifyFolderEvent(e);
            } else if (e.getName().equals("link")) {
                event = new ZModifyMountpointEvent(e);
            } else if (e.getName().equals("mbx")) {
                event = new ZModifyMailboxEvent(e);
            } else if (e.getName().equals("appt")) {
                event = new ZModifyAppointmentEvent(e);
            } else if (e.getName().equals("task")) {
                event = new ZModifyTaskEvent(e);
            }
            if (event == null) continue;
            this.handleEvent((ZModifyEvent)((Object)event));
        }
    }

    private void handleEvent(ZModifyEvent event) throws ServiceException {
        for (ZEventHandler handler : this.mHandlers) {
            handler.handleModify(event, this);
        }
    }

    private List<ZFolder> parentCheck(List<ZFolder> list, ZFolder f, ZFolder parent) {
        if (parent != null) {
            parent.addChild(f);
        } else {
            if (list == null) {
                list = new ArrayList<ZFolder>();
            }
            list.add(f);
        }
        return list;
    }

    private void handleCreated(Element created) throws ServiceException {
        if (created == null) {
            return;
        }
        ArrayList<ZCreateConversationEvent> events = null;
        List<ZFolder> parentFixup = null;
        for (Element element : created.listElements()) {
            ZFolder child;
            ZFolder parent;
            String parentId;
            ZCreateItemEvent event = null;
            if (element.getName().equals("c")) {
                event = new ZCreateConversationEvent(element);
            } else if (element.getName().equals("m")) {
                event = new ZCreateMessageEvent(element);
            } else if (element.getName().equals("cn")) {
                event = new ZCreateContactEvent(element);
            } else if (element.getName().equals("appt")) {
                event = new ZCreateAppointmentEvent(element);
            } else if (element.getName().equals("task")) {
                event = new ZCreateTaskEvent(element);
            } else if (element.getName().equals("folder")) {
                parentId = element.getAttribute("l");
                parent = this.getFolderById(parentId);
                child = new ZFolder(element, parent, this);
                this.addItemIdMapping(child);
                event = new ZCreateFolderEvent(child);
                parentFixup = this.parentCheck(parentFixup, child, parent);
            } else if (element.getName().equals("link")) {
                parentId = element.getAttribute("l");
                parent = this.getFolderById(parentId);
                child = new ZMountpoint(element, parent, this);
                this.addItemIdMapping(child);
                this.addRemoteItemIdMapping(((ZMountpoint)child).getCanonicalRemoteId(), child);
                parentFixup = this.parentCheck(parentFixup, child, parent);
                event = new ZCreateMountpointEvent((ZMountpoint)child);
            } else if (element.getName().equals("search")) {
                parentId = element.getAttribute("l");
                parent = this.getFolderById(parentId);
                child = new ZSearchFolder(element, parent, this);
                this.addItemIdMapping(child);
                event = new ZCreateSearchFolderEvent((ZSearchFolder)child);
                parentFixup = this.parentCheck(parentFixup, child, parent);
            } else if (element.getName().equals("tag")) {
                event = new ZCreateTagEvent(new ZTag(element, this));
                this.addTag(((ZCreateTagEvent)event).getTag());
            }
            if (event == null) continue;
            if (events == null) {
                events = new ArrayList<ZCreateConversationEvent>();
            }
            events.add((ZCreateConversationEvent)event);
        }
        if (parentFixup != null) {
            for (ZFolder zFolder : parentFixup) {
                ZFolder parent = this.getFolderById(zFolder.getParentId());
                if (parent == null) continue;
                parent.addChild(zFolder);
                zFolder.setParent(parent);
            }
        }
        if (events != null) {
            for (ZCreateEvent zCreateEvent : events) {
                for (ZEventHandler handler : this.mHandlers) {
                    handler.handleCreate(zCreateEvent, this);
                }
            }
        }
    }

    private void handleDeleted(Element deleted) throws ServiceException {
        if (deleted == null) {
            return;
        }
        String ids = deleted.getAttribute("id", null);
        if (ids == null) {
            return;
        }
        ZDeleteEvent de = new ZDeleteEvent(ids);
        for (ZEventHandler handler : this.mHandlers) {
            handler.handleDelete(de, this);
        }
    }

    private void addIdMappings(ZFolder folder) {
        if (folder == null) {
            return;
        }
        this.addItemIdMapping(folder);
        if (folder instanceof ZMountpoint) {
            ZMountpoint mp = (ZMountpoint)folder;
            this.addRemoteItemIdMapping(mp.getCanonicalRemoteId(), mp);
        }
        for (ZFolder child : folder.getSubFolders()) {
            this.addIdMappings(child);
        }
    }

    private void addTag(ZTag tag) {
        if (this.mNameToTag != null) {
            this.mNameToTag.put(tag.getName(), tag);
        }
        this.addItemIdMapping(tag);
    }

    void addItemIdMapping(ZItem item) {
        this.mIdToItem.put(item.getId(), item);
    }

    void addRemoteItemIdMapping(String remoteId, ZItem item) {
        this.mIdToItem.put(remoteId, item);
    }

    private void reparent(ZFolder f, String newParentId) throws ServiceException {
        ZFolder newParent;
        ZFolder parent = f.getParent();
        if (parent != null) {
            parent.removeChild(f);
        }
        if ((newParent = this.getFolderById(newParentId)) != null) {
            newParent.addChild(f);
            f.setParent(newParent);
        }
    }

    public static String getParentPath(String path) throws ServiceException {
        int index;
        if (path.equals(PATH_SEPARATOR)) {
            return PATH_SEPARATOR;
        }
        if (path.charAt(0) != '/') {
            throw ServiceException.INVALID_REQUEST("path must be absolute: " + path, null);
        }
        if (path.charAt(path.length() - 1) == '/') {
            path = path.substring(0, path.length() - 1);
        }
        if ((path = path.substring(0, index = path.lastIndexOf(47))).length() == 0) {
            return PATH_SEPARATOR;
        }
        return path;
    }

    public static String getBasePath(String path) throws ServiceException {
        if (path.equals(PATH_SEPARATOR)) {
            return PATH_SEPARATOR;
        }
        if (path.charAt(0) != '/') {
            throw ServiceException.INVALID_REQUEST("path must be absolute: " + path, null);
        }
        if (path.charAt(path.length() - 1) == '/') {
            path = path.substring(0, path.length() - 1);
        }
        int index = path.lastIndexOf(47);
        return path.substring(index + 1);
    }

    public long getSize() throws ServiceException {
        this.populateFolderCache();
        return this.mSize;
    }

    public String getName() throws ServiceException {
        return this.getAccountInfo(false).getName();
    }

    public ZPrefs getPrefs() throws ServiceException {
        return this.getPrefs(false);
    }

    public ZPrefs getPrefs(boolean refresh) throws ServiceException {
        return this.getAccountInfo(refresh).getPrefs();
    }

    public ZFeatures getFeatures() throws ServiceException {
        return this.getFeatures(false);
    }

    public ZFeatures getFeatures(boolean refresh) throws ServiceException {
        return this.getAccountInfo(refresh).getFeatures();
    }

    public ZGetInfoResult getAccountInfo(boolean refresh) throws ServiceException {
        if (this.mGetInfoResult == null || refresh) {
            Element req = this.newRequestElement(AccountConstants.GET_INFO_REQUEST);
            this.mGetInfoResult = new ZGetInfoResult(this.invoke(req));
        }
        return this.mGetInfoResult;
    }

    public int getTimeout() {
        return this.mTransport.getTimeout();
    }

    public Element getItemInfoJSON(String id) throws ServiceException {
        try {
            Element req = this.newRequestElement(MailConstants.GET_ITEM_REQUEST);
            Element item = req.addElement("item");
            item.addAttribute("id", id);
            return this.mTransport.invoke(req);
        }
        catch (IOException e) {
            throw ZClientException.IO_ERROR("invoke " + e.getMessage(), e);
        }
    }

    public static Element getBootstrapJSON(String url, String remoteAddr, ZAuthToken authToken, boolean doSearch, String itemsPerPage, String searchTypes) throws ServiceException {
        Options options = new Options(authToken, url);
        JsonDebugListener debug = new JsonDebugListener();
        options.setNoSession(false);
        options.setAuthAuthToken(false);
        options.setDebugListener(debug);
        options.setClientIp(remoteAddr);
        options.setResponseProtocol(SoapProtocol.SoapJS);
        ZMailbox mbox = ZMailbox.getMailbox(options);
        try {
            Element batch = mbox.newRequestElement(ZimbraNamespace.E_BATCH_REQUEST);
            batch.addElement(AccountConstants.GET_INFO_REQUEST);
            if (doSearch) {
                Element search = batch.addElement(MailConstants.SEARCH_REQUEST);
                if (itemsPerPage != null && itemsPerPage.length() > 0) {
                    search.addAttribute("limit", itemsPerPage);
                }
                if (searchTypes != null && searchTypes.length() > 0) {
                    search.addAttribute("types", searchTypes);
                }
            }
            mbox.mTransport.invoke(batch);
            return debug.getEnvelope();
        }
        catch (IOException e) {
            throw ZClientException.IO_ERROR("invoke " + e.getMessage(), e);
        }
    }

    public static Element getBootstrapCalSearchJSON(String url, String remoteAddr, ZAuthToken authToken, String itemsPerPage, String searchTypes) throws ServiceException {
        Options options = new Options(authToken, url);
        JsonDebugListener debug = new JsonDebugListener();
        options.setNoSession(false);
        options.setAuthAuthToken(false);
        options.setDebugListener(debug);
        options.setClientIp(remoteAddr);
        options.setResponseProtocol(SoapProtocol.SoapJS);
        ZMailbox mbox = ZMailbox.getMailbox(options);
        try {
            TimeZone tz = mbox.getPrefs().getTimeZone();
            Calendar currentDay = tz == null ? Calendar.getInstance() : Calendar.getInstance(tz);
            currentDay.setTimeInMillis(System.currentTimeMillis());
            currentDay.set(11, 0);
            currentDay.set(12, 0);
            currentDay.set(13, 0);
            currentDay.set(14, 0);
            currentDay.set(5, 1);
            StringBuilder sb = new StringBuilder();
            ZMailbox.getCheckedCalendarFoldersRecursive(mbox.getUserRoot(), sb);
            String checkedCalendars = sb.toString();
            Calendar other = Calendar.getInstance(currentDay.getTimeZone());
            other.setTimeInMillis(currentDay.getTimeInMillis());
            other.add(5, -8);
            long calStart = other.getTimeInMillis();
            other.setTimeInMillis(currentDay.getTimeInMillis());
            other.add(5, 42);
            long calEnd = other.getTimeInMillis();
            Element.JSONElement batch = new Element.JSONElement(ZimbraNamespace.E_BATCH_REQUEST);
            Element miniCalRequest = ((Element)batch).addElement(MailConstants.GET_MINI_CAL_REQUEST);
            miniCalRequest.addAttribute(TC_INCLUDE_SENT, calStart);
            miniCalRequest.addAttribute("e", calEnd);
            String[] sArray = null;
            StringBuilder searchQuery = new StringBuilder();
            if (checkedCalendars != null) {
                sArray = checkedCalendars.indexOf(",") == -1 ? new String[]{checkedCalendars} : checkedCalendars.split(",");
                for (int i = 0; i < sArray.length; ++i) {
                    Element folder = miniCalRequest.addElement("folder");
                    folder.addAttribute("id", sArray[i]);
                    if (searchQuery.length() > 1) {
                        searchQuery.append(" or ");
                    }
                    searchQuery.append("inid:").append(sArray[i]);
                }
            }
            Element search = ((Element)batch).addElement(MailConstants.SEARCH_REQUEST);
            if (itemsPerPage != null && itemsPerPage.length() > 0) {
                search.addAttribute("limit", itemsPerPage);
            }
            if (searchTypes != null && searchTypes.length() > 0) {
                search.addAttribute("types", searchTypes);
            }
            search.addAttribute("calExpandInstStart", calStart);
            search.addAttribute("calExpandInstEnd", calEnd);
            search.addAttribute("offset", 0L);
            Element queryEl = search.addElement("query");
            queryEl.setText(searchQuery.toString());
            mbox.mTransport.invoke(batch);
            Element e = debug.getEnvelope();
            Element responseParams = e.addElement("search");
            responseParams.addAttribute(TC_INCLUDE_SENT, calStart);
            responseParams.addAttribute("e", calEnd);
            Element queryElement = responseParams.addElement("query");
            queryElement.setText(searchQuery.toString());
            responseParams.addAttribute("l", checkedCalendars);
            return e;
        }
        catch (IOException e) {
            throw ZClientException.IO_ERROR("invoke " + e.getMessage(), e);
        }
    }

    private static void getCheckedCalendarFoldersRecursive(ZFolder f, StringBuilder sb) {
        if (f.getDefaultView() == ZFolder.View.appointment && f.isCheckedInUI()) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(f.getId());
        }
        for (ZFolder child : f.getSubFolders()) {
            ZMailbox.getCheckedCalendarFoldersRecursive(child, sb);
        }
    }

    public String maskRemoteItemId(String folderId, String id) throws ServiceException {
        String idPrefix;
        String folderPrefix;
        ZFolder f;
        int folderIndex = folderId.indexOf(58);
        int idIndex = id.indexOf(58);
        if (folderIndex != -1 && idIndex != -1 && (f = this.getFolderById(folderId)) != null && (folderPrefix = folderId.substring(0, folderIndex)).equalsIgnoreCase(idPrefix = id.substring(0, idIndex))) {
            return f.getId() + ":" + id.substring(idIndex + 1);
        }
        return id;
    }

    public String unmaskRemoteItemId(String id) throws ServiceException {
        String idPrefix;
        ZMountpoint mp;
        int idIndex = id.indexOf(58);
        if (idIndex != -1 && (mp = this.getMountpointById(idPrefix = id.substring(0, idIndex))) != null) {
            return mp.getOwnerId() + ":" + id.substring(idIndex + 1);
        }
        return id;
    }

    public List<ZTag> getAllTags() throws ServiceException {
        this.populateTagCache();
        ArrayList<ZTag> result = new ArrayList<ZTag>(this.mNameToTag.values());
        Collections.sort(result);
        return result;
    }

    public boolean hasTags() throws ServiceException {
        this.populateTagCache();
        return !this.mNameToTag.isEmpty();
    }

    public List<String> getAllTagNames() throws ServiceException {
        this.populateTagCache();
        ArrayList<String> names = new ArrayList<String>(this.mNameToTag.keySet());
        Collections.sort(names);
        return names;
    }

    public ZTag getTag(String nameOrId) throws ServiceException {
        ZTag result = this.getTagByName(nameOrId);
        return result != null ? result : this.getTagById(nameOrId);
    }

    public ZTag getTagByName(String name) throws ServiceException {
        this.populateTagCache();
        return this.mNameToTag.get(name);
    }

    public ZTag getTagById(String id) throws ServiceException {
        this.populateTagCache();
        ZItem item = this.mIdToItem.get(id);
        if (item instanceof ZTag) {
            return (ZTag)item;
        }
        return null;
    }

    public List<ZTag> getTags(String ids) throws ServiceException {
        ArrayList<ZTag> tags = new ArrayList<ZTag>();
        if (!StringUtil.isNullOrEmpty(ids)) {
            for (String id : sCOMMA.split(ids)) {
                ZTag tag = this.getTagById(id);
                if (tag == null) continue;
                tags.add(tag);
            }
        }
        return tags;
    }

    public ZTag createTag(String name, ZTag.Color color) throws ServiceException {
        Element createdTagEl;
        ZTag tag;
        Element req = this.newRequestElement(MailConstants.CREATE_TAG_REQUEST);
        Element tagEl = req.addUniqueElement("tag");
        tagEl.addAttribute("name", name);
        if (color != null) {
            tagEl.addAttribute("color", color.getValue());
        }
        return (tag = this.getTagById((createdTagEl = this.invoke(req).getElement("tag")).getAttribute("id"))) != null ? tag : new ZTag(createdTagEl, this);
    }

    public ZActionResult updateTag(String id, String name, ZTag.Color color) throws ServiceException {
        Element action = this.tagAction("update", id);
        if (color != null) {
            action.addAttribute("color", color.getValue());
        }
        if (name != null && name.length() > 0) {
            action.addAttribute("name", name);
        }
        return this.doAction(action);
    }

    public ZActionResult modifyTagColor(String id, ZTag.Color color) throws ServiceException {
        return this.doAction(this.tagAction("color", id).addAttribute("color", color.getValue()));
    }

    public ZActionResult markTagRead(String id) throws ServiceException {
        return this.doAction(this.tagAction("read", id));
    }

    public ZActionResult deleteTag(String id) throws ServiceException {
        return this.doAction(this.tagAction("delete", id));
    }

    public ZActionResult renameTag(String id, String name) throws ServiceException {
        return this.doAction(this.tagAction("rename", id).addAttribute("name", name));
    }

    private Element tagAction(String op, String id) {
        Element req = this.newRequestElement(MailConstants.TAG_ACTION_REQUEST);
        Element actionEl = req.addUniqueElement("action");
        actionEl.addAttribute("id", id);
        actionEl.addAttribute("op", op);
        return actionEl;
    }

    private ZActionResult doAction(Element actionEl) throws ServiceException {
        Element response = this.invoke(actionEl.getParent());
        return new ZActionResult(response);
    }

    public List<ZContact> getAllContacts(String optFolderId, ContactSortBy sortBy, boolean sync, List<String> attrs) throws ServiceException {
        Element req = this.newRequestElement(MailConstants.GET_CONTACTS_REQUEST);
        if (optFolderId != null) {
            req.addAttribute("l", optFolderId);
        }
        if (sortBy != null) {
            req.addAttribute("sortBy", sortBy.name());
        }
        if (sync) {
            req.addAttribute("sync", sync);
        }
        if (attrs != null) {
            for (String name : attrs) {
                req.addElement("a").addAttribute("n", name);
            }
        }
        Element response = this.invoke(req);
        ArrayList<ZContact> result = new ArrayList<ZContact>();
        for (Element cn : response.listElements("cn")) {
            result.add(new ZContact(cn, this));
        }
        return result;
    }

    public ZContact createContact(String folderId, String tags, Map<String, String> attrs) throws ServiceException {
        return this.createContact(folderId, tags, attrs, null);
    }

    public ZContact createContact(String folderId, String tags, Map<String, String> attrs, Map<String, ZAttachmentInfo> attachments) throws ServiceException {
        Element req = this.newRequestElement(MailConstants.CREATE_CONTACT_REQUEST);
        Element cn = req.addUniqueElement("cn");
        if (folderId != null) {
            cn.addAttribute("l", folderId);
        }
        if (tags != null) {
            cn.addAttribute(TC_INCLUDE_TRASH, tags);
        }
        this.addAttrsAndAttachments(cn, attrs, attachments);
        return new ZContact(this.invoke(req).getElement("cn"), this);
    }

    private void addAttrsAndAttachments(Element cn, Map<String, String> attrs, Map<String, ZAttachmentInfo> attachments) throws ServiceException {
        if (attrs != null) {
            for (Map.Entry entry : attrs.entrySet()) {
                cn.addKeyValuePair((String)entry.getKey(), ((String)entry.getValue()).trim(), "a", "n");
            }
        }
        if (attachments != null) {
            for (String string : attachments.keySet()) {
                ZAttachmentInfo info = attachments.get(string);
                Element attachEl = cn.addElement("a");
                attachEl.addAttribute("n", string);
                if (info.getAttachmentId() != null) {
                    attachEl.addAttribute("aid", info.getAttachmentId());
                    continue;
                }
                if (info.getItemId() != null) {
                    attachEl.addAttribute("id", info.getItemId());
                    attachEl.addAttribute("part", info.getPartName());
                    continue;
                }
                if (info.getPartName() == null) continue;
                attachEl.addAttribute("part", info.getPartName());
            }
        }
    }

    public ZContact modifyContact(String id, boolean replace, Map<String, String> attrs) throws ServiceException {
        return this.modifyContact(id, replace, attrs, null);
    }

    public ZContact modifyContact(String id, boolean replace, Map<String, String> attrs, Map<String, ZAttachmentInfo> attachments) throws ServiceException {
        Element req = this.newRequestElement(MailConstants.MODIFY_CONTACT_REQUEST);
        if (replace) {
            req.addAttribute("replace", replace);
        }
        Element cn = req.addUniqueElement("cn");
        cn.addAttribute("id", id);
        this.addAttrsAndAttachments(cn, attrs, attachments);
        return new ZContact(this.invoke(req).getElement("cn"), this);
    }

    public List<ZContact> getContacts(String ids, ContactSortBy sortBy, boolean sync, List<String> attrs) throws ServiceException {
        Element req = this.newRequestElement(MailConstants.GET_CONTACTS_REQUEST);
        if (sortBy != null) {
            req.addAttribute("sortBy", sortBy.name());
        }
        if (sync) {
            req.addAttribute("sync", sync);
        }
        if (ids != null) {
            req.addElement("cn").addAttribute("id", ids);
        }
        if (attrs != null) {
            for (String name : attrs) {
                req.addElement("a").addAttribute("n", name);
            }
        }
        ArrayList<ZContact> result = new ArrayList<ZContact>();
        for (Element cn : this.invoke(req).listElements("cn")) {
            result.add(new ZContact(cn, this));
        }
        return result;
    }

    public synchronized ZContact getContact(String id) throws ServiceException {
        ZContact result = (ZContact)this.mContactCache.get((Object)id);
        if (result == null) {
            Element req = this.newRequestElement(MailConstants.GET_CONTACTS_REQUEST);
            req.addAttribute("sync", true);
            req.addElement("cn").addAttribute("id", id);
            result = new ZContact(this.invoke(req).getElement("cn"), this);
            this.mContactCache.put((Object)id, (Object)result);
        }
        return result;
    }

    public synchronized List<ZAutoCompleteMatch> autoComplete(String query, int limit) throws ServiceException {
        Element req = this.newRequestElement(MailConstants.AUTO_COMPLETE_REQUEST);
        req.addAttribute("limit", limit);
        req.addAttribute("includeGal", this.getFeatures().getGalAutoComplete());
        req.addUniqueElement("name").setText(query);
        Element response = this.invoke(req);
        ArrayList<ZAutoCompleteMatch> matches = new ArrayList<ZAutoCompleteMatch>();
        for (Element match : response.listElements("match")) {
            matches.add(new ZAutoCompleteMatch(match, this));
        }
        return matches;
    }

    private Element contactAction(String op, String id) {
        Element req = this.newRequestElement(MailConstants.CONTACT_ACTION_REQUEST);
        Element actionEl = req.addUniqueElement("action");
        actionEl.addAttribute("id", id);
        actionEl.addAttribute("op", op);
        return actionEl;
    }

    public ZActionResult moveContact(String ids, String destFolderId) throws ServiceException {
        return this.doAction(this.contactAction("move", ids).addAttribute("l", destFolderId));
    }

    public ZActionResult deleteContact(String ids) throws ServiceException {
        return this.doAction(this.contactAction("delete", ids));
    }

    public ZActionResult trashContact(String ids) throws ServiceException {
        return this.doAction(this.contactAction("trash", ids));
    }

    public ZActionResult flagContact(String ids, boolean flag) throws ServiceException {
        return this.doAction(this.contactAction(flag ? "flag" : "!flag", ids));
    }

    public ZActionResult tagContact(String ids, String tagId, boolean tag) throws ServiceException {
        return this.doAction(this.contactAction(tag ? "tag" : "!tag", ids).addAttribute("tag", tagId));
    }

    public synchronized ZContact getMyCard() throws ServiceException {
        if (!this.mHasMyCard) {
            ZSearchParams searchParams = new ZSearchParams("#cardOwner:isMyCard");
            searchParams.setTypes("contact");
            List<ZSearchHit> hits = this.search(searchParams).getHits();
            if (hits.size() > 0) {
                ZSearchHit myCardHit = null;
                int lowestId = 0;
                for (ZSearchHit hit : hits) {
                    String idStr = hit.getId();
                    try {
                        int id = Integer.parseInt(idStr);
                        if (myCardHit != null && id > lowestId) continue;
                        lowestId = id;
                        myCardHit = hit;
                    }
                    catch (NumberFormatException ignored) {}
                }
                if (myCardHit != null) {
                    this.mMyCard = this.getContact(myCardHit.getId());
                }
            }
            this.mHasMyCard = true;
        }
        return this.mMyCard;
    }

    public boolean getIsMyCard(String ids) throws ServiceException {
        ZContact myCard = this.getMyCard();
        if (myCard != null) {
            for (String id : sCOMMA.split(ids)) {
                if (!id.equals(myCard.getId())) continue;
                return true;
            }
        }
        return false;
    }

    public ZActionResult updateContact(String ids, String destFolderId, String tagList, String flags) throws ServiceException {
        Element actionEl = this.contactAction("update", ids);
        if (destFolderId != null && destFolderId.length() > 0) {
            actionEl.addAttribute("l", destFolderId);
        }
        if (tagList != null) {
            actionEl.addAttribute(TC_INCLUDE_TRASH, tagList);
        }
        if (flags != null) {
            actionEl.addAttribute("f", flags);
        }
        return this.doAction(actionEl);
    }

    public ZImportContactsResult importContacts(String folderId, String type, String attachmentId) throws ServiceException {
        Element req = this.newRequestElement(MailConstants.IMPORT_CONTACTS_REQUEST);
        req.addAttribute("ct", type);
        req.addAttribute("l", folderId);
        Element content = req.addUniqueElement("content");
        content.addAttribute("aid", attachmentId);
        return new ZImportContactsResult(this.invoke(req).getElement("cn"));
    }

    public ZConversation getConversation(String id, Fetch fetch) throws ServiceException {
        Element req = this.newRequestElement(MailConstants.GET_CONV_REQUEST);
        Element convEl = req.addUniqueElement("c");
        convEl.addAttribute("id", id);
        if (fetch != null && fetch != Fetch.none && fetch != Fetch.hits) {
            convEl.addAttribute("fetch", fetch == Fetch.first ? "1" : fetch.name());
        }
        return new ZConversation(this.invoke(req).getElement("c"), this);
    }

    private Element convAction(String op, String id, String constraints) {
        Element req = this.newRequestElement(MailConstants.CONV_ACTION_REQUEST);
        Element actionEl = req.addUniqueElement("action");
        actionEl.addAttribute("id", id);
        actionEl.addAttribute("op", op);
        if (constraints != null) {
            actionEl.addAttribute("tcon", constraints);
        }
        return actionEl;
    }

    public ZActionResult deleteConversation(String ids, String targetConstraints) throws ServiceException {
        return this.doAction(this.convAction("delete", ids, targetConstraints));
    }

    public ZActionResult trashConversation(String ids, String targetConstraints) throws ServiceException {
        return this.doAction(this.convAction("trash", ids, targetConstraints));
    }

    public ZActionResult markConversationRead(String ids, boolean read, String targetConstraints) throws ServiceException {
        return this.doAction(this.convAction(read ? "read" : "!read", ids, targetConstraints));
    }

    public ZActionResult flagConversation(String ids, boolean flag, String targetConstraints) throws ServiceException {
        return this.doAction(this.convAction(flag ? "flag" : "!flag", ids, targetConstraints));
    }

    public ZActionResult tagConversation(String ids, String tagId, boolean tag, String targetConstraints) throws ServiceException {
        return this.doAction(this.convAction(tag ? "tag" : "!tag", ids, targetConstraints).addAttribute("tag", tagId));
    }

    public ZActionResult moveConversation(String ids, String destFolderId, String targetConstraints) throws ServiceException {
        return this.doAction(this.convAction("move", ids, targetConstraints).addAttribute("l", destFolderId));
    }

    public ZActionResult markConversationSpam(String id, boolean spam, String destFolderId, String targetConstraints) throws ServiceException {
        Element actionEl = this.convAction(spam ? "spam" : "!spam", id, targetConstraints);
        if (destFolderId != null && destFolderId.length() > 0) {
            actionEl.addAttribute("l", destFolderId);
        }
        return this.doAction(actionEl);
    }

    private Element messageAction(String op, String id) {
        Element req = this.newRequestElement(MailConstants.MSG_ACTION_REQUEST);
        Element actionEl = req.addUniqueElement("action");
        actionEl.addAttribute("id", id);
        actionEl.addAttribute("op", op);
        return actionEl;
    }

    private Element itemAction(String op, String id, String constraints) {
        Element req = this.newRequestElement(MailConstants.ITEM_ACTION_REQUEST);
        Element actionEl = req.addUniqueElement("action");
        actionEl.addAttribute("id", id);
        actionEl.addAttribute("op", op);
        if (constraints != null) {
            actionEl.addAttribute("tcon", constraints);
        }
        return actionEl;
    }

    public ZActionResult deleteItem(String ids, String targetConstraints) throws ServiceException {
        return this.doAction(this.itemAction("delete", ids, targetConstraints));
    }

    public ZActionResult trashItem(String ids, String targetConstraints) throws ServiceException {
        return this.doAction(this.itemAction("trash", ids, targetConstraints));
    }

    public ZActionResult markItemRead(String ids, boolean read, String targetConstraints) throws ServiceException {
        return this.doAction(this.itemAction(read ? "read" : "!read", ids, targetConstraints));
    }

    public ZActionResult flagItem(String ids, boolean flag, String targetConstraints) throws ServiceException {
        return this.doAction(this.itemAction(flag ? "flag" : "!flag", ids, targetConstraints));
    }

    public ZActionResult tagItem(String ids, String tagId, boolean tag, String targetConstraints) throws ServiceException {
        return this.doAction(this.itemAction(tag ? "tag" : "!tag", ids, targetConstraints).addAttribute("tag", tagId));
    }

    public ZActionResult moveItem(String ids, String destFolderId, String targetConstraints) throws ServiceException {
        return this.doAction(this.itemAction("move", ids, targetConstraints).addAttribute("l", destFolderId));
    }

    public ZActionResult updateItem(String ids, String destFolderId, String tagList, String flags, String targetConstraints) throws ServiceException {
        Element actionEl = this.itemAction("update", ids, targetConstraints);
        if (destFolderId != null && destFolderId.length() > 0) {
            actionEl.addAttribute("l", destFolderId);
        }
        if (tagList != null) {
            actionEl.addAttribute(TC_INCLUDE_TRASH, tagList);
        }
        if (flags != null) {
            actionEl.addAttribute("f", flags);
        }
        return this.doAction(actionEl);
    }

    public String uploadAttachments(File[] files, int msTimeout) throws ServiceException {
        Part[] parts = new Part[files.length];
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            String contentType = URLConnection.getFileNameMap().getContentTypeFor(file.getName());
            try {
                parts[i] = new FilePart(file.getName(), file, contentType, "UTF-8");
                continue;
            }
            catch (IOException e) {
                throw ZClientException.IO_ERROR(e.getMessage(), e);
            }
        }
        return this.uploadAttachments(parts, msTimeout);
    }

    public String uploadAttachment(String name, byte[] content, String contentType, int msTimeout) throws ServiceException {
        FilePart part = new FilePart(name, new ByteArrayPartSource(name, content));
        part.setContentType(contentType);
        return this.uploadAttachments(new Part[]{part}, msTimeout);
    }

    public String uploadAttachments(Map<String, byte[]> attachments, int msTimeout) throws ServiceException {
        if (attachments == null || attachments.size() == 0) {
            return null;
        }
        Part[] parts = new Part[attachments.size()];
        int i = 0;
        for (String name : attachments.keySet()) {
            byte[] content = attachments.get(name);
            parts[i++] = this.createAttachmentPart(name, content);
        }
        return this.uploadAttachments(parts, msTimeout);
    }

    public FilePart createAttachmentPart(String filename, byte[] content) {
        FilePart part = new FilePart(filename, new ByteArrayPartSource(filename, content));
        String contentType = URLConnection.getFileNameMap().getContentTypeFor(filename);
        part.setContentType(contentType);
        return part;
    }

    public String uploadAttachments(Part[] parts, int msTimeout) throws ServiceException {
        String aid = null;
        URI uri = this.getUploadURI();
        HttpClient client = this.getHttpClient(uri);
        PostMethod post = new PostMethod(uri.toString());
        post.getParams().setSoTimeout(msTimeout);
        try {
            try {
                post.setRequestEntity(new MultipartRequestEntity(parts, post.getParams()));
                int statusCode = client.executeMethod(post);
                if (statusCode != 200) {
                    throw ZClientException.UPLOAD_FAILED("Attachment post failed, status=" + statusCode, null);
                }
                String response = post.getResponseBodyAsString();
                aid = this.getAttachmentId(response);
                Object var10_10 = null;
            }
            catch (IOException e) {
                throw ZClientException.IO_ERROR(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            post.releaseConnection();
            throw throwable;
        }
        post.releaseConnection();
        return aid;
    }

    public String uploadContentAsStream(String name, InputStream in, String contentType, long contentLength, int msTimeout) throws ServiceException {
        String aid = null;
        if (name != null) {
            contentType = contentType + "; name=" + name;
        }
        URI uri = this.getUploadURI();
        HttpClient client = this.getHttpClient(uri);
        PostMethod post = new PostMethod(uri.toString());
        post.getParams().setSoTimeout(msTimeout);
        try {
            try {
                post.setRequestEntity(new InputStreamRequestEntity(in, contentLength, contentType));
                int statusCode = client.executeMethod(post);
                if (statusCode != 200) {
                    throw ZClientException.UPLOAD_FAILED("Attachment post failed, status=" + statusCode, null);
                }
                String response = post.getResponseBodyAsString();
                aid = this.getAttachmentId(response);
                Object var14_13 = null;
            }
            catch (IOException e) {
                throw ZClientException.IO_ERROR(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            post.releaseConnection();
            throw throwable;
        }
        post.releaseConnection();
        return aid;
    }

    public URI getUploadURI() throws ServiceException {
        try {
            URI uri = new URI(this.mTransport.getURI());
            return uri.resolve("/service/upload?fmt=raw");
        }
        catch (URISyntaxException e) {
            throw ZClientException.CLIENT_ERROR("unable to parse URI: " + this.mTransport.getURI(), e);
        }
    }

    private String getAttachmentId(String result) throws ZClientException {
        if (result.startsWith("200")) {
            Matcher m = sAttachmentId.matcher(result);
            return m.find() ? m.group(1) : null;
        }
        if (result.startsWith("413")) {
            throw ZClientException.UPLOAD_SIZE_LIMIT_EXCEEDED("upload size limit exceeded", null);
        }
        throw ZClientException.UPLOAD_FAILED("upload failed, response: " + result, null);
    }

    private void addAuthCookie(Map<String, String> cookieMap, URI uri, HttpState state) {
        if (cookieMap == null) {
            return;
        }
        for (Map.Entry<String, String> ck : cookieMap.entrySet()) {
            Cookie cookie = new Cookie(uri.getHost(), ck.getKey(), ck.getValue(), PATH_SEPARATOR, -1, false);
            state.addCookie(cookie);
        }
    }

    public HttpClient getHttpClient(URI uri) {
        Map<String, String> cookieMap;
        boolean isAdmin = uri.getPort() == LC.zimbra_admin_service_port.intValue();
        HttpState initialState = new HttpState();
        if (isAdmin) {
            cookieMap = this.getAuthToken().cookieMap(isAdmin);
            this.addAuthCookie(cookieMap, uri, initialState);
        }
        cookieMap = this.getAuthToken().cookieMap(false);
        this.addAuthCookie(cookieMap, uri, initialState);
        HttpClient client = ZimbraHttpConnectionManager.getInternalHttpConnMgr().newHttpClient();
        client.setState(initialState);
        client.getParams().setCookiePolicy("compatibility");
        return client;
    }

    public String addMessage(String folderId, String flags, String tags, long receivedDate, String content, boolean noICal) throws ServiceException {
        Element req = this.newRequestElement(MailConstants.ADD_MSG_REQUEST);
        Element m = req.addUniqueElement("m");
        m.addAttribute("l", folderId);
        if (flags != null && flags.length() > 0) {
            m.addAttribute("f", flags);
        }
        if (tags != null && tags.length() > 0) {
            m.addAttribute(TC_INCLUDE_TRASH, tags);
        }
        if (receivedDate != 0L) {
            m.addAttribute("d", receivedDate);
        }
        m.addAttribute("noICal", noICal);
        m.addElement("content").setText(content);
        return this.invoke(req).getElement("m").getAttribute("id");
    }

    public String addMessage(String folderId, String flags, String tags, long receivedDate, byte[] content, boolean noICal) throws ServiceException {
        return this.addMessage(folderId, flags, tags, receivedDate, new ByteArrayInputStream(content), content.length, noICal);
    }

    public String addMessage(String folderId, String flags, String tags, long receivedDate, InputStream in, long contentLength, boolean noICal) throws ServiceException {
        String aid = this.uploadContentAsStream("message", in, "message/rfc822", contentLength, 5000);
        Element req = this.newRequestElement(MailConstants.ADD_MSG_REQUEST);
        Element m = req.addUniqueElement("m");
        m.addAttribute("l", folderId);
        if (flags != null && flags.length() > 0) {
            m.addAttribute("f", flags);
        }
        if (tags != null && tags.length() > 0) {
            m.addAttribute(TC_INCLUDE_TRASH, tags);
        }
        if (receivedDate > 0L) {
            m.addAttribute("d", receivedDate);
        }
        m.addAttribute("aid", aid);
        m.addAttribute("noICal", noICal);
        return this.invoke(req).getElement("m").getAttribute("id");
    }

    public synchronized ZMessage getMessage(ZGetMessageParams params) throws ServiceException {
        CachedMessage cm = (CachedMessage)this.mMessageCache.get((Object)params.getId());
        if (cm == null || !cm.params.equals(params)) {
            String reqHdrs;
            Element req = this.newRequestElement(MailConstants.GET_MSG_REQUEST);
            Element msgEl = req.addUniqueElement("m");
            msgEl.addAttribute("id", params.getId());
            if (params.getPart() != null) {
                msgEl.addAttribute("part", params.getPart());
            }
            msgEl.addAttribute("read", params.isMarkRead());
            msgEl.addAttribute("html", params.isWantHtml());
            msgEl.addAttribute("neuter", params.isNeuterImages());
            msgEl.addAttribute("raw", params.isRawContent());
            if (params.getMax() != null) {
                msgEl.addAttribute("max", params.getMax().intValue());
            }
            if ((reqHdrs = params.getReqHeaders()) != null && reqHdrs.length() > 0) {
                for (String hdrName : reqHdrs.split(",")) {
                    Element headerEl = msgEl.addElement("header");
                    headerEl.addAttribute("n", hdrName);
                }
            }
            ZMessage zm = new ZMessage(this.invoke(req).getElement("m"), this);
            cm = new CachedMessage();
            cm.zm = zm;
            cm.params = params;
            this.mMessageCache.put((Object)params.getId(), (Object)cm);
        } else if (params.isMarkRead() && cm.zm.isUnread()) {
            this.markMessageRead(cm.zm.getId(), true);
        }
        return cm.zm;
    }

    public synchronized ZMessage getMessageById(String id) throws ServiceException {
        ZGetMessageParams params = new ZGetMessageParams();
        params.setId(id);
        return this.getMessage(params);
    }

    public ZActionResult deleteMessage(String ids) throws ServiceException {
        return this.doAction(this.messageAction("delete", ids));
    }

    public ZActionResult trashMessage(String ids) throws ServiceException {
        return this.doAction(this.messageAction("trash", ids));
    }

    public ZActionResult markMessageRead(String ids, boolean read) throws ServiceException {
        return this.doAction(this.messageAction(read ? "read" : "!read", ids));
    }

    public ZActionResult markMessageSpam(String id, boolean spam, String destFolderId) throws ServiceException {
        Element actionEl = this.messageAction(spam ? "spam" : "!spam", id);
        if (destFolderId != null && destFolderId.length() > 0) {
            actionEl.addAttribute("l", destFolderId);
        }
        return this.doAction(actionEl);
    }

    public ZActionResult flagMessage(String ids, boolean flag) throws ServiceException {
        return this.doAction(this.messageAction(flag ? "flag" : "!flag", ids));
    }

    public ZActionResult tagMessage(String ids, String tagId, boolean tag) throws ServiceException {
        return this.doAction(this.messageAction(tag ? "tag" : "!tag", ids).addAttribute("tag", tagId));
    }

    public ZActionResult moveMessage(String ids, String destFolderId) throws ServiceException {
        return this.doAction(this.messageAction("move", ids).addAttribute("l", destFolderId));
    }

    public ZActionResult updateMessage(String ids, String destFolderId, String tagList, String flags) throws ServiceException {
        Element actionEl = this.messageAction("update", ids);
        if (destFolderId != null && destFolderId.length() > 0) {
            actionEl.addAttribute("l", destFolderId);
        }
        if (tagList != null) {
            actionEl.addAttribute(TC_INCLUDE_TRASH, tagList);
        }
        if (flags != null) {
            actionEl.addAttribute("f", flags);
        }
        return this.doAction(actionEl);
    }

    public ZFolder getUserRoot() throws ServiceException {
        this.populateFolderCache();
        return this.mUserRoot;
    }

    public ZFolder getFolderByPath(String path) throws ServiceException {
        this.populateFolderCache();
        if (!path.startsWith(PATH_SEPARATOR)) {
            path = PATH_SEPARATOR + path;
        }
        if (this.mUserRoot == null) {
            return null;
        }
        return this.mUserRoot.getSubFolderByPath(path.substring(1));
    }

    public ZFolder getInbox() throws ServiceException {
        return this.getFolderById("2");
    }

    public ZFolder getTrash() throws ServiceException {
        return this.getFolderById("3");
    }

    public ZFolder getSpam() throws ServiceException {
        return this.getFolderById("4");
    }

    public ZFolder getJunk() throws ServiceException {
        return this.getFolderById("4");
    }

    public ZFolder getSent() throws ServiceException {
        return this.getFolderById("5");
    }

    public ZFolder getDrafts() throws ServiceException {
        return this.getFolderById("6");
    }

    public ZFolder getContacts() throws ServiceException {
        return this.getFolderById("7");
    }

    public ZFolder getCalendar() throws ServiceException {
        return this.getFolderById("10");
    }

    public ZFolder getNotebok() throws ServiceException {
        return this.getFolderById("12");
    }

    public ZFolder getAutoContacts() throws ServiceException {
        return this.getFolderById("13");
    }

    public ZFolder getChats() throws ServiceException {
        return this.getFolderById("14");
    }

    public ZFolder getTasks() throws ServiceException {
        return this.getFolderById("15");
    }

    public ZFolder getBriefcase() throws ServiceException {
        return this.getFolderById("16");
    }

    public ZFolder getFolderById(String id) throws ServiceException {
        this.populateFolderCache();
        ZItem item = this.mIdToItem.get(id);
        if (!(item instanceof ZFolder)) {
            return null;
        }
        ZFolder folder = (ZFolder)item;
        return folder.isHierarchyPlaceholder() ? null : folder;
    }

    public ZFolder getFolder(String pathOrId) throws ServiceException {
        ZFolder result = this.getFolderByPath(pathOrId);
        return result != null ? result : this.getFolderById(pathOrId);
    }

    public ZFolder getFolderRequestById(String id) throws ServiceException {
        Element req = this.newRequestElement(MailConstants.GET_FOLDER_REQUEST).addAttribute("visible", true);
        req.addElement("folder").addAttribute("l", id);
        Element response = this.invoke(req);
        Element eFolder = response.getOptionalElement("folder");
        if (eFolder == null) {
            eFolder = response.getOptionalElement("link");
        }
        if (eFolder == null) {
            return null;
        }
        ZFolder folder = new ZFolder(eFolder, null, this);
        return folder.isHierarchyPlaceholder() ? null : folder;
    }

    public ZFolder getFolderRequest(String id) throws ServiceException {
        return this.getFolderRequestById(id);
    }

    public List<ZFolder> getAllFolders() throws ServiceException {
        this.populateFolderCache();
        ArrayList<ZFolder> allFolders = new ArrayList<ZFolder>();
        if (this.getUserRoot() != null) {
            this.addSubFolders(this.getUserRoot(), allFolders);
        }
        return allFolders;
    }

    private void addSubFolders(ZFolder folder, List<ZFolder> folderList) throws ServiceException {
        if (!folder.isHierarchyPlaceholder()) {
            folderList.add(folder);
        }
        for (ZFolder subFolder : folder.getSubFolders()) {
            this.addSubFolders(subFolder, folderList);
        }
    }

    public URI getRestURI(String relativePath) throws ServiceException {
        return this.getRestURI(relativePath, null);
    }

    private URI getRestURI(String relativePath, String alternateUrl) throws ServiceException {
        String pathPrefix = PATH_SEPARATOR;
        if (relativePath.startsWith(PATH_SEPARATOR)) {
            pathPrefix = "";
        }
        try {
            URI uri;
            String restURI = this.getAccountInfo(false).getRestURLBase();
            if (alternateUrl != null) {
                uri = new URI(restURI);
                restURI = alternateUrl + uri.getPath();
            }
            if (restURI == null) {
                uri = new URI(this.mTransport.getURI());
                return uri.resolve("/home/" + this.getName() + pathPrefix + relativePath);
            }
            return new URI(restURI + pathPrefix + relativePath);
        }
        catch (URISyntaxException e) {
            throw ZClientException.CLIENT_ERROR("unable to parse URI: " + this.mTransport.getURI(), e);
        }
    }

    public void getRESTResource(String relativePath, OutputStream os, boolean closeOs, String startTimeArg, String endTimeArg, int msecTimeout, String alternateUrl) throws ServiceException {
        InputStream in = null;
        try {
            try {
                in = this.getRESTResource(relativePath, startTimeArg, endTimeArg, msecTimeout, alternateUrl);
                ByteUtil.copy(in, false, os, closeOs);
            }
            catch (IOException e) {
                throw ZClientException.IO_ERROR("Unable to get " + relativePath, e);
            }
            Object var11_9 = null;
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            ByteUtil.closeStream(in);
            throw throwable;
        }
        ByteUtil.closeStream(in);
    }

    private InputStream getRESTResource(String relativePath, String startTimeArg, String endTimeArg, int msecTimeout, String alternateUrl) throws ServiceException {
        GetMethod get = null;
        URI uri = null;
        try {
            int statusCode;
            String encodedArg;
            if (startTimeArg != null) {
                encodedArg = URLEncoder.encode(startTimeArg, "UTF-8");
                relativePath = !relativePath.contains("?") ? relativePath + "?start=" + encodedArg : relativePath + "&start=" + encodedArg;
            }
            if (endTimeArg != null) {
                encodedArg = URLEncoder.encode(endTimeArg, "UTF-8");
                relativePath = !relativePath.contains("?") ? relativePath + "?end=" + encodedArg : relativePath + "&end=" + encodedArg;
            }
            uri = this.getRestURI(relativePath, alternateUrl);
            HttpClient client = this.getHttpClient(uri);
            get = new GetMethod(uri.toString());
            if (msecTimeout > -1) {
                get.getParams().setSoTimeout(msecTimeout);
            }
            if ((statusCode = client.executeMethod(get)) == 200) {
                return new GetMethodInputStream(get);
            }
            String msg = String.format("GET from %s failed, status=%d.  %s", uri.toString(), statusCode, get.getStatusText());
            throw ServiceException.FAILURE(msg, null);
        }
        catch (IOException e) {
            String fromUri = "";
            if (uri != null) {
                fromUri = " from " + uri.toString();
            }
            String msg = String.format("Unable to get REST resource%s: %s", fromUri, e.getMessage());
            throw ZClientException.IO_ERROR(msg, e);
        }
    }

    public InputStream getRESTResource(String relativePath) throws ServiceException {
        return this.getRESTResource(relativePath, null, null, this.getTimeout(), null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void postRESTResource(String relativePath, InputStream is, boolean closeIs, long length, String contentType, boolean ignoreAndContinueOnError, boolean preserveAlarms, int msecTimeout, String alternateUrl) throws ServiceException {
        HttpMethodBase post;
        block9: {
            post = null;
            try {
                try {
                    if (ignoreAndContinueOnError) {
                        relativePath = !relativePath.contains("?") ? relativePath + "?ignore=1" : relativePath + "&ignore=1";
                    }
                    if (preserveAlarms) {
                        relativePath = !relativePath.contains("?") ? relativePath + "?preserveAlarms=1" : relativePath + "&preserveAlarms=1";
                    }
                    URI uri = this.getRestURI(relativePath, alternateUrl);
                    HttpClient client = this.getHttpClient(uri);
                    post = new PostMethod(uri.toString());
                    if (msecTimeout > -1) {
                        post.getParams().setSoTimeout(msecTimeout);
                    }
                    InputStreamRequestEntity entity = length > 0L ? new InputStreamRequestEntity(is, length, contentType != null ? contentType : "application/octet-stream") : new InputStreamRequestEntity(is, contentType);
                    ((EntityEnclosingMethod)post).setRequestEntity(entity);
                    int statusCode = client.executeMethod(post);
                    if (statusCode != 200) throw ServiceException.FAILURE("POST failed, status=" + statusCode + " " + post.getStatusText(), null);
                    Object var17_16 = null;
                    if (!closeIs) break block9;
                }
                catch (IOException e) {
                    throw ZClientException.IO_ERROR(e.getMessage(), e);
                }
            }
            catch (Throwable throwable) {
                Object var17_17 = null;
                if (closeIs) {
                    ByteUtil.closeStream(is);
                }
                if (post == null) throw throwable;
                post.releaseConnection();
                throw throwable;
            }
            ByteUtil.closeStream(is);
        }
        if (post == null) return;
        post.releaseConnection();
    }

    public void postRESTResource(String relativePath, InputStream is, boolean closeIs, long length, String contentType, int msecTimeout) throws ServiceException {
        this.postRESTResource(relativePath, is, closeIs, length, contentType, false, false, msecTimeout, null);
    }

    public ZSearchFolder getSearchFolderById(String id) throws ServiceException {
        this.populateFolderCache();
        ZItem item = this.mIdToItem.get(id);
        if (item instanceof ZSearchFolder) {
            return (ZSearchFolder)item;
        }
        return null;
    }

    public ZMountpoint getMountpointById(String id) throws ServiceException {
        this.populateFolderCache();
        ZItem item = this.mIdToItem.get(id);
        if (item instanceof ZMountpoint) {
            return (ZMountpoint)item;
        }
        return null;
    }

    public ZFolder createFolder(String parentId, String name, ZFolder.View defaultView, ZFolder.Color color, String flags, String url) throws ServiceException {
        Element newFolderEl;
        ZFolder newFolder;
        Element req = this.newRequestElement(MailConstants.CREATE_FOLDER_REQUEST);
        Element folderEl = req.addUniqueElement("folder");
        folderEl.addAttribute("name", name);
        folderEl.addAttribute("l", parentId);
        if (defaultView != null) {
            folderEl.addAttribute("view", defaultView.name());
        }
        if (color != null) {
            folderEl.addAttribute("color", color.getValue());
        }
        if (flags != null) {
            folderEl.addAttribute("f", flags);
        }
        if (url != null && url.length() > 0) {
            folderEl.addAttribute("url", url);
        }
        return (newFolder = this.getFolderById((newFolderEl = this.invoke(req).getElement("folder")).getAttribute("id"))) != null ? newFolder : new ZFolder(newFolderEl, null, this);
    }

    public ZSearchFolder createSearchFolder(String parentId, String name, String query, String types, SearchSortBy sortBy, ZFolder.Color color) throws ServiceException {
        Element newSearchEl;
        ZSearchFolder newSearch;
        Element req = this.newRequestElement(MailConstants.CREATE_SEARCH_FOLDER_REQUEST);
        Element folderEl = req.addUniqueElement("search");
        folderEl.addAttribute("name", name);
        folderEl.addAttribute("l", parentId);
        folderEl.addAttribute("query", query);
        if (color != null) {
            folderEl.addAttribute("color", color.getValue());
        }
        if (types != null) {
            folderEl.addAttribute("types", types);
        }
        if (sortBy != null) {
            folderEl.addAttribute("sortBy", sortBy.name());
        }
        return (newSearch = this.getSearchFolderById((newSearchEl = this.invoke(req).getElement("search")).getAttribute("id"))) != null ? newSearch : new ZSearchFolder(newSearchEl, null, this);
    }

    public ZSearchFolder modifySearchFolder(String id, String query, String types, SearchSortBy sortBy) throws ServiceException {
        Element req = this.newRequestElement(MailConstants.MODIFY_SEARCH_FOLDER_REQUEST);
        Element folderEl = req.addUniqueElement("search");
        folderEl.addAttribute("id", id);
        if (query != null) {
            folderEl.addAttribute("query", query);
        }
        if (types != null) {
            folderEl.addAttribute("types", types);
        }
        if (sortBy != null) {
            folderEl.addAttribute("sortBy", sortBy.name());
        }
        this.invoke(req);
        return this.getSearchFolderById(id);
    }

    private Element folderAction(String op, String ids) {
        Element req = this.newRequestElement(MailConstants.FOLDER_ACTION_REQUEST);
        Element actionEl = req.addUniqueElement("action");
        actionEl.addAttribute("id", ids);
        actionEl.addAttribute("op", op);
        return actionEl;
    }

    public ZActionResult modifyFolderChecked(String ids, boolean checked) throws ServiceException {
        return this.doAction(this.folderAction(checked ? "check" : "!check", ids));
    }

    public ZActionResult modifyFolderColor(String ids, ZFolder.Color color) throws ServiceException {
        return this.doAction(this.folderAction("color", ids).addAttribute("color", color.getValue()));
    }

    public ZActionResult deleteFolder(String ids) throws ServiceException {
        return this.doAction(this.folderAction("delete", ids));
    }

    public ZActionResult trashFolder(String ids) throws ServiceException {
        return this.doAction(this.folderAction("trash", ids));
    }

    public ZActionResult emptyFolder(String ids) throws ServiceException {
        return this.emptyFolder(ids, true);
    }

    public ZActionResult emptyFolder(String ids, boolean subfolders) throws ServiceException {
        return this.doAction(this.folderAction("empty", ids).addAttribute("recursive", true));
    }

    public ZActionResult markFolderRead(String ids) throws ServiceException {
        return this.doAction(this.folderAction("read", ids));
    }

    public ZActionResult importURLIntoFolder(String id, String url) throws ServiceException {
        return this.doAction(this.folderAction("import", id).addAttribute("url", url));
    }

    public ZActionResult moveFolder(String id, String targetFolderId) throws ServiceException {
        return this.doAction(this.folderAction("move", id).addAttribute("l", targetFolderId));
    }

    public ZActionResult renameFolder(String id, String name) throws ServiceException {
        return this.renameFolder(id, name, null);
    }

    public ZActionResult renameFolder(String id, String name, String targetFolderId) throws ServiceException {
        Element folderAction = this.folderAction("rename", id);
        folderAction.addAttribute("name", name);
        if (targetFolderId != null) {
            folderAction.addAttribute("l", targetFolderId);
        }
        return this.doAction(folderAction);
    }

    public ZActionResult modifyFolderExcludeFreeBusy(String ids, boolean state) throws ServiceException {
        return this.doAction(this.folderAction("fb", ids).addAttribute("excludeFreeBusy", state));
    }

    public ZActionResult modifyFolderGrant(String folderId, ZGrant.GranteeType granteeType, String grantreeId, String perms, String args) throws ServiceException {
        Element action = this.folderAction("grant", folderId);
        Element grant = action.addUniqueElement("grant");
        grant.addAttribute("perm", perms);
        grant.addAttribute("d", grantreeId);
        grant.addAttribute("gt", granteeType.name());
        if (args != null) {
            if (granteeType == ZGrant.GranteeType.key) {
                grant.addAttribute("key", args);
            } else {
                grant.addAttribute("args", args);
            }
        }
        ZActionResult r = this.doAction(action);
        if (granteeType == ZGrant.GranteeType.key) {
            ZFolder folder = this.getFolderById(folderId);
            for (ZGrant g : folder.getGrants()) {
                if (g.getGranteeType() != ZGrant.GranteeType.key || !g.getGranteeId().equals(grantreeId)) continue;
                String key = null;
                Element eAction = r.getResponse().getOptionalElement("action");
                if (eAction != null) {
                    key = eAction.getAttribute("key", null);
                }
                if (key == null) break;
                g.setAccessKey(key);
                break;
            }
        }
        return r;
    }

    public ZActionResult modifyFolderRevokeGrant(String folderId, String grantreeId) throws ServiceException {
        Element action = this.folderAction("!grant", folderId);
        action.addAttribute("zid", grantreeId);
        return this.doAction(action);
    }

    public ZActionResult modifyFolderURL(String id, String url) throws ServiceException {
        return this.doAction(this.folderAction("url", id).addAttribute("url", url));
    }

    public ZActionResult updateFolder(String id, String name, String parentId, ZFolder.Color newColor, String flags, List<ZGrant> acl) throws ServiceException {
        Element action = this.folderAction("update", id);
        if (name != null && name.length() > 0) {
            action.addAttribute("name", name);
        }
        if (parentId != null && parentId.length() > 0) {
            action.addAttribute("l", parentId);
        }
        if (newColor != null) {
            action.addAttribute("color", newColor.getValue());
        }
        if (flags != null) {
            action.addAttribute("f", flags);
        }
        if (acl != null) {
            Element aclEl = action.addElement("acl");
            for (ZGrant grant : acl) {
                grant.toElement(aclEl);
            }
        }
        return this.doAction(action);
    }

    public ZActionResult syncFolder(String ids) throws ServiceException {
        return this.doAction(this.folderAction("sync", ids));
    }

    public ZActionResult modifyFolderSyncFlag(String id, boolean syncon) throws ServiceException {
        return this.doAction(this.folderAction(syncon ? "syncon" : "!syncon", id));
    }

    private synchronized ZSearchResult internalSearch(String convId, ZSearchParams params, boolean nest) throws ServiceException {
        QName name = convId != null ? MailConstants.SEARCH_CONV_REQUEST : (params.getTypes().equals("voicemail") || params.getTypes().equals("calllog") ? VoiceConstants.SEARCH_VOICE_REQUEST : (params.getTypes().equals("gal") ? AccountConstants.SEARCH_GAL_REQUEST : MailConstants.SEARCH_REQUEST));
        Element req = this.newRequestElement(name);
        if (params.getTypes().equals("gal")) {
            req.addAttribute("type", GalEntryType.account.name());
            req.addElement("name").setText(params.getQuery());
        }
        req.addAttribute("cid", convId);
        if (nest) {
            req.addAttribute("nest", true);
        }
        if (params.getLimit() != 0) {
            req.addAttribute("limit", params.getLimit());
        }
        if (params.getOffset() != 0) {
            req.addAttribute("offset", params.getOffset());
        }
        if (params.getSortBy() != null) {
            req.addAttribute("sortBy", params.getSortBy().name());
        }
        if (params.getTypes() != null) {
            req.addAttribute("types", params.getTypes());
        }
        if (params.getFetch() != null && params.getFetch() != Fetch.none) {
            req.addAttribute("fetch", params.getFetch() == Fetch.first ? "1" : params.getFetch().name());
        }
        if (params.getCalExpandInstStart() != 0L) {
            req.addAttribute("calExpandInstStart", params.getCalExpandInstStart());
        }
        if (params.getCalExpandInstEnd() != 0L) {
            req.addAttribute("calExpandInstEnd", params.getCalExpandInstEnd());
        }
        if (params.isPreferHtml()) {
            req.addAttribute("html", params.isPreferHtml());
        }
        if (params.isMarkAsRead()) {
            req.addAttribute("read", params.isMarkAsRead());
        }
        if (params.isRecipientMode()) {
            req.addAttribute("recip", params.isRecipientMode());
        }
        if (params.getField() != null) {
            req.addAttribute("field", params.getField());
        }
        req.addAttribute("query", params.getQuery(), Element.Disposition.CONTENT);
        if (params.getCursor() != null) {
            ZSearchParams.Cursor cursor = params.getCursor();
            Element cursorEl = req.addElement("cursor");
            if (cursor.getPreviousId() != null) {
                cursorEl.addAttribute("id", cursor.getPreviousId());
            }
            if (cursor.getPreviousSortValue() != null) {
                cursorEl.addAttribute("sortVal", cursor.getPreviousSortValue());
            }
        }
        if (params.getTypes().equals("voicemail") || params.getTypes().equals("calllog")) {
            this.setVoiceStorePrincipal(req);
        }
        Element resp = this.invoke(req);
        if (params.getTypes().equals("gal")) {
            try {
                resp.getAttribute("sortBy");
            }
            catch (Exception e) {
                resp.addAttribute("sortBy", params.getSortBy().name());
            }
            try {
                resp.getAttribute("offset");
            }
            catch (Exception e) {
                resp.addAttribute("offset", params.getOffset());
            }
        }
        return new ZSearchResult(resp, nest, params.getTimeZone() != null ? params.getTimeZone() : this.getPrefs().getTimeZone());
    }

    public synchronized ZSearchResult search(ZSearchParams params) throws ServiceException {
        return this.internalSearch(null, params, false);
    }

    public synchronized ZSearchPagerResult search(ZSearchParams params, int page, boolean useCache, boolean useCursor) throws ServiceException {
        return this.mSearchPagerCache.search(this, params, page, useCache, useCursor);
    }

    public synchronized void clearSearchCache(String type) {
        this.mSearchPagerCache.clear(type);
    }

    public synchronized ZSearchResult searchConversation(String convId, ZSearchParams params) throws ServiceException {
        if (convId == null) {
            throw ZClientException.CLIENT_ERROR("conversation id must not be null", null);
        }
        return this.internalSearch(convId, params, true);
    }

    public synchronized ZSearchPagerResult searchConversation(String convId, ZSearchParams params, int page, boolean useCache, boolean useCursor) throws ServiceException {
        if (params.getConvId() == null) {
            params.setConvId(convId);
        }
        return this.mSearchConvPagerCache.search(this, params, page, useCache, useCursor);
    }

    private void populateFolderCache() throws ServiceException {
        Element response;
        Element eFolder;
        if (this.mUserRoot != null) {
            return;
        }
        if (this.mNotifyPreference == null || this.mNotifyPreference == NotifyPreference.full) {
            this.noOp();
            if (this.mUserRoot != null) {
                return;
            }
        }
        ZFolder userRoot = (eFolder = (response = this.invoke(this.newRequestElement(MailConstants.GET_FOLDER_REQUEST).addAttribute("visible", true))).getOptionalElement("folder")) != null ? new ZFolder(eFolder, null, this) : null;
        ZRefreshEvent event = new ZRefreshEvent(this.mSize, userRoot, null);
        for (ZEventHandler handler : this.mHandlers) {
            handler.handleRefresh(event, this);
        }
    }

    private void populateTagCache() throws ServiceException {
        ArrayList<ZTag> tagList;
        block8: {
            if (this.mNameToTag != null) {
                return;
            }
            if (this.mNotifyPreference == null || this.mNotifyPreference == NotifyPreference.full) {
                this.noOp();
                if (this.mNameToTag != null) {
                    return;
                }
            }
            tagList = new ArrayList<ZTag>();
            if (!this.mNoTagCache) {
                try {
                    Element response = this.invoke(this.newRequestElement(MailConstants.GET_TAG_REQUEST));
                    for (Element t : response.listElements("tag")) {
                        tagList.add(new ZTag(t, this));
                    }
                }
                catch (SoapFaultException sfe) {
                    if (sfe.getCode().equals("service.PERM_DENIED")) break block8;
                    throw sfe;
                }
            }
        }
        ZRefreshEvent event = new ZRefreshEvent(this.mSize, null, tagList);
        for (ZEventHandler handler : this.mHandlers) {
            handler.handleRefresh(event, this);
        }
    }

    public void noOp() throws ServiceException {
        this.invoke(this.newRequestElement(MailConstants.NO_OP_REQUEST));
    }

    public ZMountpoint createMountpoint(String parentId, String name, ZFolder.View defaultView, ZFolder.Color color, String flags, OwnerBy ownerBy, String owner, SharedItemBy itemBy, String sharedItem) throws ServiceException {
        Element req = this.newRequestElement(MailConstants.CREATE_MOUNTPOINT_REQUEST);
        Element linkEl = req.addUniqueElement("link");
        linkEl.addAttribute("name", name);
        linkEl.addAttribute("l", parentId);
        if (defaultView != null) {
            linkEl.addAttribute("view", defaultView.name());
        }
        if (color != null) {
            linkEl.addAttribute("color", color.getValue());
        }
        if (flags != null) {
            linkEl.addAttribute("f", flags);
        }
        linkEl.addAttribute(ownerBy == OwnerBy.BY_ID ? "zid" : "owner", owner);
        linkEl.addAttribute(itemBy == SharedItemBy.BY_ID ? "rid" : "path", sharedItem);
        Element newMountEl = this.invoke(req).getElement("link");
        ZMountpoint newMount = this.getMountpointById(newMountEl.getAttribute("id"));
        return newMount != null ? newMount : new ZMountpoint(newMountEl, null, this);
    }

    public void iCalReply(String ical) throws ServiceException {
        Element req = this.newRequestElement(MailConstants.ICAL_REPLY_REQUEST);
        Element icalElem = req.addUniqueElement("ical");
        icalElem.setText(ical);
        this.invoke(req);
    }

    public Element getMessageElement(Element req, ZOutgoingMessage message, ZMountpoint mountpoint) throws ServiceException {
        int idx;
        Element m = req.addElement("m");
        String id = message.getOriginalMessageId();
        if (mountpoint != null && (idx = id.indexOf(":")) != -1) {
            id = id.substring(idx + 1);
        }
        if (id != null) {
            m.addAttribute("origid", id);
        }
        if (message.getReplyType() != null) {
            m.addAttribute("rt", message.getReplyType());
        }
        if (message.getAddresses() != null) {
            for (ZEmailAddress addr : message.getAddresses()) {
                Element e;
                if (mountpoint != null && addr.getType().equals("f")) {
                    e = m.addElement("e");
                    e.addAttribute(TC_INCLUDE_TRASH, TC_INCLUDE_SENT);
                    e.addAttribute("a", addr.getAddress());
                    e = m.addElement("e");
                    e.addAttribute(TC_INCLUDE_TRASH, "f");
                    e.addAttribute("a", mountpoint.getOwnerDisplayName());
                    continue;
                }
                e = m.addElement("e");
                e.addAttribute(TC_INCLUDE_TRASH, addr.getType());
                e.addAttribute("a", addr.getAddress());
                e.addAttribute("p", addr.getPersonal());
            }
        }
        if (message.getSubject() != null) {
            m.addElement("su").setText(message.getSubject());
        }
        if (message.getPriority() != null && message.getPriority().length() != 0) {
            m.addAttribute("f", message.getPriority());
        }
        if (message.getInReplyTo() != null) {
            m.addElement("irt").setText(message.getInReplyTo());
        }
        if (message.getMessagePart() != null) {
            message.getMessagePart().toElement(m);
        }
        Element attach = null;
        if (message.getAttachmentUploadId() != null) {
            attach = m.addElement("attach");
            attach.addAttribute("aid", message.getAttachmentUploadId());
        }
        if (message.getMessageIdsToAttach() != null) {
            if (attach == null) {
                attach = m.addElement("attach");
            }
            for (String mid : message.getMessageIdsToAttach()) {
                attach.addElement("m").addAttribute("id", mid);
            }
        }
        if (message.getDocIdsToAttach() != null) {
            if (attach == null) {
                attach = m.addElement("attach");
            }
            for (String did : message.getDocIdsToAttach()) {
                attach.addElement("doc").addAttribute("id", did);
            }
        }
        if (message.getMessagePartsToAttach() != null) {
            if (attach == null) {
                attach = m.addElement("attach");
            }
            for (ZOutgoingMessage.AttachedMessagePart part : message.getMessagePartsToAttach()) {
                if (part.getContentId() != null && !part.getContentId().equals("")) continue;
                attach.addElement("mp").addAttribute("mid", part.getMessageId()).addAttribute("part", part.getPartName());
            }
        }
        return m;
    }

    private ZMountpoint getMountpoint(ZOutgoingMessage message) throws ServiceException {
        ZMountpoint mountpoint = null;
        String oringinalId = message.getOriginalMessageId();
        if (oringinalId != null) {
            ZGetMessageParams params = new ZGetMessageParams();
            params.setId(oringinalId);
            params.setPart("");
            ZMessage original = this.getMessage(params);
            ZFolder folder = this.getFolderById(original.getFolderId());
            if (folder instanceof ZMountpoint) {
                mountpoint = (ZMountpoint)folder;
            }
        }
        return mountpoint;
    }

    public ZSendMessageResponse sendMessage(ZOutgoingMessage message, String sendUid, boolean needCalendarSentByFixup) throws ServiceException {
        Element req = this.newRequestElement(MailConstants.SEND_MSG_REQUEST);
        if (sendUid != null && sendUid.length() > 0) {
            req.addAttribute("suid", sendUid);
        }
        if (needCalendarSentByFixup) {
            req.addAttribute("needCalendarSentByFixup", needCalendarSentByFixup);
        }
        ZMountpoint mountpoint = this.getMountpoint(message);
        this.getMessageElement(req, message, mountpoint);
        String requestedAccountId = mountpoint == null ? null : mountpoint.getOwnerId();
        Element resp = this.invoke(req, requestedAccountId);
        Element msg = resp.getOptionalElement("m");
        String id = msg == null ? null : msg.getAttribute("id", null);
        return new ZSendMessageResponse(id);
    }

    public synchronized ZMessage saveDraft(ZOutgoingMessage message, String existingDraftId, String folderId) throws ServiceException {
        Element req = this.newRequestElement(MailConstants.SAVE_DRAFT_REQUEST);
        ZMountpoint mountpoint = this.getMountpoint(message);
        Element m = this.getMessageElement(req, message, mountpoint);
        if (existingDraftId != null && existingDraftId.length() > 0) {
            this.mMessageCache.remove((Object)existingDraftId);
            m.addAttribute("id", existingDraftId);
        }
        if (folderId != null) {
            m.addAttribute("l", folderId);
        }
        String requestedAccountId = mountpoint == null ? null : this.mGetInfoResult.getId();
        return new ZMessage(this.invoke(req, requestedAccountId).getElement("m"), this);
    }

    public synchronized CheckSpellingResult checkSpelling(String text) throws ServiceException {
        return this.checkSpelling(text, null);
    }

    public synchronized CheckSpellingResult checkSpelling(String text, String dictionary) throws ServiceException {
        Element req = this.newRequestElement(MailConstants.CHECK_SPELLING_REQUEST);
        if (dictionary != null) {
            req.addAttribute("dictionary", dictionary);
        }
        req.setText(text);
        Element response = this.invoke(req);
        return new CheckSpellingResult(response);
    }

    public void createIdentity(ZIdentity identity) throws ServiceException {
        Element req = this.newRequestElement(AccountConstants.CREATE_IDENTITY_REQUEST);
        identity.toElement(req);
        this.invoke(req);
    }

    public List<ZIdentity> getIdentities() throws ServiceException {
        Element req = this.newRequestElement(AccountConstants.GET_IDENTITIES_REQUEST);
        Element resp = this.invoke(req);
        ArrayList<ZIdentity> result = new ArrayList<ZIdentity>();
        for (Element identity : resp.listElements("identity")) {
            result.add(new ZIdentity(identity));
        }
        return result;
    }

    public void deleteIdentity(String name) throws ServiceException {
        this.deleteIdentity(Provisioning.IdentityBy.name, name);
    }

    public void deleteIdentity(Provisioning.IdentityBy by, String key) throws ServiceException {
        Element req = this.newRequestElement(AccountConstants.DELETE_IDENTITY_REQUEST);
        if (by == Provisioning.IdentityBy.name) {
            req.addUniqueElement("identity").addAttribute("name", key);
        } else if (by == Provisioning.IdentityBy.id) {
            req.addUniqueElement("identity").addAttribute("id", key);
        }
        this.invoke(req);
    }

    public void modifyIdentity(ZIdentity identity) throws ServiceException {
        Element req = this.newRequestElement(AccountConstants.MODIFY_IDENTITY_REQUEST);
        identity.toElement(req);
        this.invoke(req);
    }

    public String createDataSource(ZDataSource source) throws ServiceException {
        Element req = this.newRequestElement(MailConstants.CREATE_DATA_SOURCE_REQUEST);
        source.toElement(req);
        return this.invoke(req).listElements().get(0).getAttribute("id");
    }

    public String testDataSource(ZDataSource source) throws ServiceException {
        Element req = this.newRequestElement(MailConstants.TEST_DATA_SOURCE_REQUEST);
        source.toElement(req);
        Element resp = this.invoke(req);
        List<Element> children = resp.listElements();
        if (children.size() == 0) {
            return MailConstants.TEST_DATA_SOURCE_RESPONSE + " has no child elements";
        }
        Element dsEl = children.get(0);
        boolean success = dsEl.getAttributeBool("success", false);
        if (!success) {
            return resp.getAttribute("error", "error");
        }
        return null;
    }

    public List<ZDataSource> getAllDataSources() throws ServiceException {
        Element req = this.newRequestElement(MailConstants.GET_DATA_SOURCES_REQUEST);
        Element response = this.invoke(req);
        ArrayList<ZDataSource> result = new ArrayList<ZDataSource>();
        for (Element ds : response.listElements()) {
            if (ds.getName().equals("pop3")) {
                result.add(new ZPop3DataSource(ds));
                continue;
            }
            if (ds.getName().equals("imap")) {
                result.add(new ZImapDataSource(ds));
                continue;
            }
            if (ds.getName().equals("rss")) {
                result.add(new ZRssDataSource(ds));
                continue;
            }
            if (!ds.getName().equals("cal")) continue;
            result.add(new ZCalDataSource(ds));
        }
        return result;
    }

    public ZDataSource getDataSourceById(String id) throws ServiceException {
        for (ZDataSource ds : this.getAllDataSources()) {
            if (!ds.getId().equals(id)) continue;
            return ds;
        }
        return null;
    }

    public void modifyDataSource(ZDataSource source) throws ServiceException {
        Element req = this.newRequestElement(MailConstants.MODIFY_DATA_SOURCE_REQUEST);
        source.toElement(req);
        this.invoke(req);
    }

    public void deleteDataSource(ZDataSource source) throws ServiceException {
        Element req = this.newRequestElement(MailConstants.DELETE_DATA_SOURCE_REQUEST);
        source.toIdElement(req);
        this.invoke(req);
    }

    public ZFilterRules getFilterRules() throws ServiceException {
        return this.getFilterRules(false);
    }

    public synchronized ZFilterRules getFilterRules(boolean refresh) throws ServiceException {
        if (this.mRules == null || refresh) {
            Element req = this.newRequestElement(MailConstants.GET_FILTER_RULES_REQUEST);
            this.mRules = new ZFilterRules(this.invoke(req).getElement("filterRules"));
        }
        return new ZFilterRules(this.mRules);
    }

    public synchronized void saveFilterRules(ZFilterRules rules) throws ServiceException {
        Element req = this.newRequestElement(MailConstants.MODIFY_FILTER_RULES_REQUEST);
        rules.toElement(req);
        this.invoke(req);
        this.mRules = new ZFilterRules(rules);
    }

    public void deleteDataSource(Provisioning.DataSourceBy by, String key) throws ServiceException {
        Element req = this.newRequestElement(MailConstants.DELETE_DATA_SOURCE_REQUEST);
        if (by == Provisioning.DataSourceBy.name) {
            req.addUniqueElement("dsrc").addAttribute("name", key);
        } else if (by == Provisioning.DataSourceBy.id) {
            req.addUniqueElement("dsrc").addAttribute("id", key);
        } else {
            throw ServiceException.INVALID_REQUEST("must specify data source by id or name", null);
        }
        this.invoke(req);
    }

    public void importData(List<ZDataSource> sources) throws ServiceException {
        Element req = this.newRequestElement(MailConstants.IMPORT_DATA_REQUEST);
        for (ZDataSource src : sources) {
            src.toIdElement(req);
        }
        this.invoke(req);
    }

    public List<ZImportStatus> getImportStatus() throws ServiceException {
        Element req = this.newRequestElement(MailConstants.GET_IMPORT_STATUS_REQUEST);
        Element response = this.invoke(req);
        ArrayList<ZImportStatus> result = new ArrayList<ZImportStatus>();
        for (Element status : response.listElements()) {
            result.add(new ZImportStatus(status));
        }
        return result;
    }

    public String createDocument(String folderId, String name, String attachmentId) throws ServiceException {
        Element req = this.newRequestElement(MailConstants.SAVE_DOCUMENT_REQUEST);
        Element doc = req.addUniqueElement("doc");
        doc.addAttribute("name", name);
        doc.addAttribute("l", folderId);
        Element upload = doc.addElement("upload");
        upload.addAttribute("id", attachmentId);
        return this.invoke(req).getElement("doc").getAttribute("id");
    }

    public ZDocument getDocument(String id) throws ServiceException {
        Element req = this.newRequestElement(MailConstants.GET_ITEM_REQUEST);
        Element item = req.addUniqueElement("item");
        item.addAttribute("id", id);
        Element e = this.invoke(req).getElement("doc");
        return new ZDocument(e);
    }

    public String createWiki(String folderId, String name, String contents) throws ServiceException {
        Element req = this.newRequestElement(MailConstants.SAVE_WIKI_REQUEST);
        Element doc = req.addUniqueElement("w");
        doc.addAttribute("name", name);
        doc.addAttribute("l", folderId);
        doc.setText(contents);
        return this.invoke(req).getElement("w").getAttribute("id");
    }

    public void modifyPrefs(Map<String, ? extends Object> prefs) throws ServiceException {
        Element req = this.newRequestElement(AccountConstants.MODIFY_PREFS_REQUEST);
        for (Map.Entry<String, ? extends Object> entry : prefs.entrySet()) {
            Object values;
            Object vo = entry.getValue();
            if (vo instanceof String[]) {
                values = (String[])vo;
                for (String v : values) {
                    req.addKeyValuePair(entry.getKey(), v, "pref", "name");
                }
                continue;
            }
            if (vo instanceof Collection) {
                values = (Collection)vo;
                Iterator i$ = values.iterator();
                while (i$.hasNext()) {
                    Object v = i$.next();
                    req.addKeyValuePair(entry.getKey(), v.toString(), "pref", "name");
                }
                continue;
            }
            req.addKeyValuePair(entry.getKey(), vo.toString(), "pref", "name");
        }
        this.invoke(req);
    }

    public List<String> getAvailableSkins() throws ServiceException {
        Element req = this.newRequestElement(AccountConstants.GET_AVAILABLE_SKINS_REQUEST);
        Element resp = this.invoke(req);
        ArrayList<String> result = new ArrayList<String>();
        for (Element skin : resp.listElements("skin")) {
            String name = skin.getAttribute("name", null);
            if (name == null) continue;
            result.add(name);
        }
        Collections.sort(result);
        return result;
    }

    public ZSearchGalResult searchGal(String query, GalEntryType type) throws ServiceException {
        Element req = this.newRequestElement(AccountConstants.SEARCH_GAL_REQUEST);
        if (type != null) {
            req.addAttribute("type", type.name());
        }
        req.addElement("name").setText(query);
        Element resp = this.invoke(req);
        ArrayList<ZContact> contacts = new ArrayList<ZContact>();
        for (Element contact : resp.listElements("cn")) {
            contacts.add(new ZContact(contact, true, this));
        }
        return new ZSearchGalResult(contacts, resp.getAttributeBool("more", false), query, type);
    }

    public ZSearchGalResult autoCompleteGal(String query, GalEntryType type, int limit) throws ServiceException {
        Element req = this.newRequestElement(AccountConstants.AUTO_COMPLETE_GAL_REQUEST);
        if (type != null) {
            req.addAttribute("type", type.name());
        }
        req.addAttribute("limit", limit);
        req.addElement("name").setText(query);
        Element resp = this.invoke(req);
        ArrayList<ZContact> contacts = new ArrayList<ZContact>();
        for (Element contact : resp.listElements("cn")) {
            contacts.add(new ZContact(contact, true, this));
        }
        return new ZSearchGalResult(contacts, resp.getAttributeBool("more", false), query, type);
    }

    public synchronized void clearApptSummaryCache() {
        this.mApptSummaryCache.clear();
    }

    public synchronized Set<String> getMiniCal(long startMsec, long endMsec, String[] folderIds) throws ServiceException {
        Set<String> result = this.mApptSummaryCache.getMiniCal(startMsec, endMsec, folderIds);
        if (result == null) {
            Element req = this.newRequestElement(MailConstants.GET_MINI_CAL_REQUEST);
            req.addAttribute(TC_INCLUDE_SENT, startMsec);
            req.addAttribute("e", endMsec);
            for (String folderId : folderIds) {
                Element folderElem = req.addElement("folder");
                folderElem.addAttribute("id", folderId);
            }
            Element resp = this.invoke(req);
            result = new HashSet<String>();
            for (Element date : resp.listElements("date")) {
                result.add(date.getTextTrim());
            }
            this.mApptSummaryCache.putMiniCal(result, startMsec, endMsec, folderIds);
        }
        return result;
    }

    public synchronized List<ZApptSummaryResult> getApptSummaries(String query, long startMsec, long endMsec, String[] folderIds, TimeZone timeZone, String types) throws ServiceException {
        if (types == null) {
            types = "appointment";
        }
        if (query == null) {
            query = "";
        }
        if (folderIds == null || folderIds.length == 0) {
            folderIds = new String[]{"10"};
        }
        ArrayList<ZApptSummaryResult> summaries = new ArrayList<ZApptSummaryResult>();
        ArrayList<String> idsToFetch = new ArrayList<String>(folderIds.length);
        for (String folderId : folderIds) {
            ZApptSummaryResult cached;
            if (folderId == null) {
                folderId = "10";
            }
            if ((cached = this.mApptSummaryCache.get(startMsec, endMsec, folderId, timeZone, query)) == null) {
                idsToFetch.add(folderId);
                continue;
            }
            summaries.add(cached);
        }
        HashMap<String, ZApptSummaryResult> folder2List = new HashMap<String, ZApptSummaryResult>();
        HashMap<String, String> folderIdMapper = new HashMap<String, String>();
        String targetId = this.mTransport.getTargetAcctId();
        if (!idsToFetch.isEmpty()) {
            Object result;
            StringBuilder searchQuery = new StringBuilder();
            searchQuery.append("(");
            for (String folderId : idsToFetch) {
                ZFolder folder;
                if (searchQuery.length() > 1) {
                    searchQuery.append(" or ");
                }
                searchQuery.append("inid:").append("\"" + folderId + "\"");
                ArrayList<ZAppointmentHit> appts = new ArrayList<ZAppointmentHit>();
                result = new ZApptSummaryResult(startMsec, endMsec, folderId, timeZone, appts, query);
                summaries.add((ZApptSummaryResult)result);
                folder2List.put(folderId, (ZApptSummaryResult)result);
                ZFolder zFolder = folder = targetId != null ? null : this.getFolderById(folderId);
                if (folder != null && folder instanceof ZMountpoint) {
                    folderIdMapper.put(((ZMountpoint)folder).getCanonicalRemoteId(), folderId);
                    continue;
                }
                if (targetId != null) {
                    folderIdMapper.put(this.mTransport.getTargetAcctId() + ":" + folderId, folderId);
                    folderIdMapper.put(folderId, folderId);
                    continue;
                }
                folderIdMapper.put(folderId, folderId);
            }
            searchQuery.append(")");
            if (query.length() > 0) {
                searchQuery.append("AND (").append(query).append(")");
            }
            ZSearchParams params = new ZSearchParams(searchQuery.toString());
            params.setCalExpandInstStart(startMsec);
            params.setCalExpandInstEnd(endMsec);
            params.setTypes(types);
            params.setLimit(2000);
            params.setSortBy(SearchSortBy.none);
            params.setTimeZone(timeZone);
            int offset = 0;
            int n = 0;
            while (n++ < 100) {
                params.setOffset(offset);
                result = this.search(params);
                for (ZSearchHit hit : ((ZSearchResult)result).getHits()) {
                    ZApptSummaryResult r;
                    ++offset;
                    if (!(hit instanceof ZAppointmentHit)) continue;
                    ZAppointmentHit as = (ZAppointmentHit)hit;
                    String fid = (String)folderIdMapper.get(as.getFolderId());
                    if (fid == null) {
                        fid = as.getFolderId();
                    }
                    if ((r = (ZApptSummaryResult)folder2List.get(fid)) == null) {
                        ArrayList<ZAppointmentHit> appts = new ArrayList<ZAppointmentHit>();
                        r = new ZApptSummaryResult(startMsec, endMsec, fid, timeZone, appts, query);
                        summaries.add(r);
                        folder2List.put(fid, r);
                    }
                    r.getAppointments().add(as);
                }
                List<ZSearchHit> hits = ((ZSearchResult)result).getHits();
                if (!((ZSearchResult)result).hasMore() || hits.isEmpty()) break;
                params.setOffset(offset);
            }
            for (ZApptSummaryResult r : folder2List.values()) {
                this.mApptSummaryCache.add(r, timeZone);
            }
        }
        return summaries;
    }

    public ZAppointmentResult createAppointment(String folderId, String flags, ZOutgoingMessage message, ZInvite invite, String optionalUid) throws ServiceException {
        Element req = this.newRequestElement(MailConstants.CREATE_APPOINTMENT_REQUEST);
        Element mEl = this.getMessageElement(req, message, null);
        if (flags != null) {
            mEl.addAttribute("f", flags);
        }
        if (folderId != null) {
            mEl.addAttribute("l", folderId);
        }
        Element invEl = invite.toElement(mEl);
        if (optionalUid != null) {
            invEl.addAttribute("uid", optionalUid);
        }
        return new ZAppointmentResult(this.invoke(req));
    }

    public ZAppointmentResult createAppointmentException(String id, String component, ZDateTime exceptionId, ZOutgoingMessage message, ZInvite invite, String optionalUid) throws ServiceException {
        Element req = this.newRequestElement(MailConstants.CREATE_APPOINTMENT_EXCEPTION_REQUEST);
        req.addAttribute("id", id);
        req.addAttribute("comp", component);
        Element mEl = this.getMessageElement(req, message, null);
        Element invEl = invite.toElement(mEl);
        Element compEl = invEl.getElement("comp");
        exceptionId.toElement("exceptId", compEl);
        if (optionalUid != null) {
            invEl.addAttribute("uid", optionalUid);
        }
        return new ZAppointmentResult(this.invoke(req));
    }

    public ZAppointmentResult modifyAppointment(String id, String component, ZDateTime exceptionId, ZOutgoingMessage message, ZInvite invite) throws ServiceException {
        Element req = this.newRequestElement(MailConstants.MODIFY_APPOINTMENT_REQUEST);
        req.addAttribute("id", id);
        req.addAttribute("comp", component);
        Element mEl = this.getMessageElement(req, message, null);
        Element invEl = invite.toElement(mEl);
        if (exceptionId != null) {
            Element compEl = invEl.getElement("comp");
            exceptionId.toElement("exceptId", compEl);
        }
        return new ZAppointmentResult(this.invoke(req));
    }

    public void cancelAppointment(String id, String component, ZInvite.ZTimeZone tz, ZDateTime instance, CancelRange range, ZOutgoingMessage message) throws ServiceException {
        Element req = this.newRequestElement(MailConstants.CANCEL_APPOINTMENT_REQUEST);
        req.addAttribute("id", id);
        req.addAttribute("comp", component);
        if (tz != null) {
            tz.toElement(req);
        }
        if (instance != null) {
            Element instEl = instance.toElement("inst", req);
            if (range != null) {
                instEl.addAttribute("range", range.name());
            }
        }
        if (message != null) {
            this.getMessageElement(req, message, null);
        }
        this.mMessageCache.remove((Object)id);
        this.invoke(req);
    }

    public ZSendInviteReplyResult sendInviteReply(String id, String component, ReplyVerb verb, boolean updateOrganizer, ZInvite.ZTimeZone tz, ZDateTime instance, ZOutgoingMessage message) throws ServiceException {
        Element req = this.newRequestElement(MailConstants.SEND_INVITE_REPLY_REQUEST);
        req.addAttribute("id", id);
        req.addAttribute("compNum", component);
        req.addAttribute("verb", verb.name());
        req.addAttribute("updateOrganizer", updateOrganizer);
        if (tz != null) {
            tz.toElement(req);
        }
        if (instance != null) {
            instance.toElement("exceptId", req);
        }
        if (message != null) {
            this.getMessageElement(req, message, null);
        }
        this.mMessageCache.remove((Object)id);
        return new ZSendInviteReplyResult(this.invoke(req));
    }

    public ZAppointment getAppointment(String id) throws ServiceException {
        Element req = this.newRequestElement(MailConstants.GET_APPOINTMENT_REQUEST);
        req.addAttribute("id", id);
        req.addAttribute("sync", true);
        return new ZAppointment(this.invoke(req));
    }

    public void clearMessageCache() {
        this.mMessageCache.clear();
    }

    public ZImportAppointmentsResult importAppointments(String folderId, String type, String attachmentId) throws ServiceException {
        Element req = this.newRequestElement(MailConstants.IMPORT_APPOINTMENTS_REQUEST);
        req.addAttribute("ct", type);
        req.addAttribute("l", folderId);
        Element content = req.addElement("content");
        content.addAttribute("aid", attachmentId);
        return new ZImportAppointmentsResult(this.invoke(req).getElement("appt"));
    }

    public List<ZGetFreeBusyResult> getFreeBusy(String email, long startTime, long endTime, int folder) throws ServiceException {
        Element req = this.newRequestElement(MailConstants.GET_FREE_BUSY_REQUEST);
        req.addAttribute(TC_INCLUDE_SENT, startTime);
        req.addAttribute("e", endTime);
        Element userElem = req.addElement("usr");
        userElem.addAttribute("name", email);
        if (folder != -1) {
            userElem.addAttribute("l", folder);
        }
        Element resp = this.invoke(req);
        ArrayList<ZGetFreeBusyResult> result = new ArrayList<ZGetFreeBusyResult>();
        for (Element user : resp.listElements("usr")) {
            String userId = user.getAttribute("id");
            ArrayList<ZFreeBusyTimeSlot> slots = new ArrayList<ZFreeBusyTimeSlot>();
            for (Element slot : user.listElements()) {
                ZFreeBusySlotType type = slot.getName().equals("f") ? ZFreeBusySlotType.FREE : (slot.getName().equals("b") ? ZFreeBusySlotType.BUSY : (slot.getName().equals(TC_INCLUDE_TRASH) ? ZFreeBusySlotType.TENTATIVE : (slot.getName().equals("u") ? ZFreeBusySlotType.UNAVAILABLE : (slot.getName().equals(TC_INCLUDE_OTHER) ? ZFreeBusySlotType.OUT_OF_OFFICE : ZFreeBusySlotType.NO_DATA))));
                slots.add(new ZFreeBusyTimeSlot(type, slot.getAttributeLong(TC_INCLUDE_SENT), slot.getAttributeLong("e")));
            }
            result.add(new ZGetFreeBusyResult(userId, slots));
        }
        return result;
    }

    public List<ZAppointmentHit> createAppointmentHits(List<ZFreeBusyTimeSlot> slots) {
        ArrayList<ZAppointmentHit> result = new ArrayList<ZAppointmentHit>();
        for (ZFreeBusyTimeSlot slot : slots) {
            switch (slot.getType()) {
                case BUSY: 
                case TENTATIVE: 
                case UNAVAILABLE: 
                case OUT_OF_OFFICE: {
                    result.add(new ZAppointmentHit(slot));
                }
            }
        }
        return result;
    }

    public ZAppointmentResult createTask(String folderId, String flags, ZOutgoingMessage message, ZInvite invite, String optionalUid) throws ServiceException {
        Element req = this.newRequestElement(MailConstants.CREATE_TASK_REQUEST);
        Element mEl = this.getMessageElement(req, message, null);
        if (flags != null) {
            mEl.addAttribute("f", flags);
        }
        if (folderId != null) {
            mEl.addAttribute("l", folderId);
        }
        Element invEl = invite.toElement(mEl);
        if (optionalUid != null) {
            invEl.addAttribute("uid", optionalUid);
        }
        return new ZAppointmentResult(this.invoke(req));
    }

    public ZAppointmentResult createTaskException(String id, String component, ZDateTime exceptionId, ZOutgoingMessage message, ZInvite invite, String optionalUid) throws ServiceException {
        Element req = this.newRequestElement(MailConstants.CREATE_TASK_EXCEPTION_REQUEST);
        req.addAttribute("id", id);
        req.addAttribute("comp", component);
        Element mEl = this.getMessageElement(req, message, null);
        Element invEl = invite.toElement(mEl);
        Element compEl = invEl.getElement("comp");
        exceptionId.toElement("exceptId", compEl);
        if (optionalUid != null) {
            invEl.addAttribute("uid", optionalUid);
        }
        return new ZAppointmentResult(this.invoke(req));
    }

    public ZAppointmentResult modifyTask(String id, String component, ZDateTime exceptionId, ZOutgoingMessage message, ZInvite invite) throws ServiceException {
        Element req = this.newRequestElement(MailConstants.MODIFY_TASK_REQUEST);
        req.addAttribute("id", id);
        req.addAttribute("comp", component);
        Element mEl = this.getMessageElement(req, message, null);
        Element invEl = invite.toElement(mEl);
        if (exceptionId != null) {
            Element compEl = invEl.getElement("comp");
            exceptionId.toElement("exceptId", compEl);
        }
        return new ZAppointmentResult(this.invoke(req));
    }

    public void cancelTask(String id, String component, ZInvite.ZTimeZone tz, ZDateTime instance, CancelRange range, ZOutgoingMessage message) throws ServiceException {
        Element req = this.newRequestElement(MailConstants.CANCEL_TASK_REQUEST);
        req.addAttribute("id", id);
        req.addAttribute("comp", component);
        if (tz != null) {
            tz.toElement(req);
        }
        if (instance != null) {
            Element instEl = instance.toElement("inst", req);
            if (range != null) {
                instEl.addAttribute("range", range.name());
            }
        }
        if (message != null) {
            this.getMessageElement(req, message, null);
        }
        this.mMessageCache.remove((Object)id);
        this.invoke(req);
    }

    public synchronized List<ZPhoneAccount> getAllPhoneAccounts() throws ServiceException {
        if (this.mPhoneAccounts == null) {
            ArrayList<ZPhoneAccount> accounts = new ArrayList<ZPhoneAccount>();
            this.mPhoneAccountMap = new HashMap<String, ZPhoneAccount>();
            Element req = this.newRequestElement(VoiceConstants.GET_VOICE_INFO_REQUEST);
            Element response = this.invoke(req);
            Element storePrincipalEl = response.getElement("storeprincipal");
            this.mVoiceStorePrincipal = storePrincipalEl.clone();
            List<Element> phoneElements = response.listElements("phone");
            for (Element element : phoneElements) {
                ZPhoneAccount account = new ZPhoneAccount(element, this);
                accounts.add(account);
                this.mPhoneAccountMap.put(account.getPhone().getName(), account);
            }
            this.mPhoneAccounts = Collections.unmodifiableList(accounts);
        }
        return this.mPhoneAccounts;
    }

    private void setVoiceStorePrincipal(Element req) {
        req.addElement(this.mVoiceStorePrincipal.clone());
    }

    public ZPhoneAccount getPhoneAccount(String name) throws ServiceException {
        this.getAllPhoneAccounts();
        return this.mPhoneAccountMap.get(name);
    }

    public String uploadVoiceMail(String phone, String id) throws ServiceException {
        Element req = this.newRequestElement(VoiceConstants.UPLOAD_VOICE_MAIL_REQUEST);
        this.setVoiceStorePrincipal(req);
        Element actionEl = req.addElement("vm");
        actionEl.addAttribute("id", id);
        actionEl.addAttribute("phone", phone);
        Element response = this.invoke(req);
        return response.getElement("upload").getAttribute("id");
    }

    public void loadCallFeatures(ZCallFeatures features) throws ServiceException {
        Element req = this.newRequestElement(VoiceConstants.GET_VOICE_FEATURES_REQUEST);
        this.setVoiceStorePrincipal(req);
        Element phoneEl = req.addElement("phone");
        phoneEl.addAttribute("name", features.getPhone().getName());
        List<ZCallFeature> featureList = features.getSubscribedFeatures();
        for (ZCallFeature feature : featureList) {
            phoneEl.addElement(feature.getName());
        }
        Element response = this.invoke(req);
        phoneEl = response.getElement("phone");
        for (ZCallFeature feature : featureList) {
            String name = feature.getName();
            Element element = phoneEl.getOptionalElement(name);
            if (element == null) continue;
            feature.fromElement(element);
        }
    }

    public void saveCallFeatures(ZCallFeatures newFeatures) throws ServiceException {
        Element req = this.newRequestElement(VoiceConstants.MODIFY_VOICE_FEATURES_REQUEST);
        this.setVoiceStorePrincipal(req);
        Element phoneEl = req.addElement("phone");
        phoneEl.addAttribute("name", newFeatures.getPhone().getName());
        Collection<ZCallFeature> list = newFeatures.getAllFeatures();
        for (ZCallFeature newFeature : list) {
            Element element = phoneEl.addElement(newFeature.getName());
            newFeature.toElement(element);
        }
        this.invoke(req);
        ZPhoneAccount account = this.getPhoneAccount(newFeatures.getPhone().getName());
        ZCallFeatures oldFeatures = account.getCallFeatures();
        for (ZCallFeature newFeature : list) {
            ZCallFeature oldFeature = oldFeatures.getFeature(newFeature.getName());
            oldFeature.assignFrom(newFeature);
        }
    }

    public ZActionResult trashVoiceMail(String phone, String id) throws ServiceException {
        return this.moveVoiceMail(phone, id, 1028);
    }

    public ZActionResult moveVoiceMail(String phone, String id, int folderId) throws ServiceException {
        ZActionResult result = this.doAction(this.voiceAction("move", phone, id, folderId));
        ZModifyVoiceMailItemFolderEvent event = new ZModifyVoiceMailItemFolderEvent(Integer.toString(folderId));
        this.handleEvent(event);
        this.refreshVoiceMailInbox(phone);
        return result;
    }

    public ZActionResult emptyVoiceMailTrash(String phone, String folderId) throws ServiceException {
        ZActionResult result = this.doAction(this.voiceAction("empty", phone, folderId, 0));
        this.mSearchPagerCache.clear(null);
        return result;
    }

    private void refreshVoiceMailInbox(String phone) throws ServiceException {
        ZPhoneAccount account = this.getPhoneAccount(phone);
        if (account == null) {
            return;
        }
        Element req = this.newRequestElement(VoiceConstants.GET_VOICE_FOLDER_REQUEST);
        this.setVoiceStorePrincipal(req);
        Element phoneEl = req.addElement("phone");
        phoneEl.addAttribute("name", phone);
        Element response = this.invoke(req);
        Element phoneResponse = response.getElement("phone");
        if (phoneResponse != null) {
            ZFolder rootFolder = account.getRootFolder();
            Element rootEl = phoneResponse.getElement("folder");
            for (Element childEl : rootEl.listElements("folder")) {
                String name = childEl.getAttribute("name");
                ZFolder childFolder = rootFolder.getSubFolderByPath(name);
                if (childFolder == null) continue;
                childFolder.setUnreadCount((int)childEl.getAttributeLong("u", 0L));
                childFolder.setMessageCount((int)childEl.getAttributeLong("n", 0L));
            }
        }
    }

    public ZActionResult markVoiceMailHeard(String phone, String idList, boolean heard) throws ServiceException {
        String op = heard ? "read" : "!read";
        ZActionResult result = this.doAction(this.voiceAction(op, phone, idList, 0));
        int changeCount = 0;
        boolean needRefresh = false;
        for (String id : sCOMMA.split(idList)) {
            ZModifyVoiceMailItemEvent event = new ZModifyVoiceMailItemEvent(id, heard);
            this.handleEvent(event);
            if (event.getMadeChange()) {
                ++changeCount;
                continue;
            }
            needRefresh = true;
        }
        if (needRefresh) {
            this.refreshVoiceMailInbox(phone);
        } else if (changeCount > 0) {
            ZPhoneAccount account = this.getPhoneAccount(phone);
            ZFolder inbox = account.getRootFolder().getSubFolderByPath("Voicemail Inbox");
            int diff = heard ? -changeCount : changeCount;
            inbox.setUnreadCount(inbox.getUnreadCount() + diff);
        }
        return result;
    }

    private Element voiceAction(String op, String phone, String id, int folderId) {
        Element req = this.newRequestElement(VoiceConstants.VOICE_MSG_ACTION_REQUEST);
        this.setVoiceStorePrincipal(req);
        Element actionEl = req.addElement("action");
        actionEl.addAttribute("id", id);
        actionEl.addAttribute("op", op);
        actionEl.addAttribute("phone", phone);
        if (folderId != 0) {
            actionEl.addAttribute("l", Integer.toString(folderId) + '-' + phone);
        }
        return actionEl;
    }

    public synchronized ZContactByPhoneCache.ContactPhone getContactByPhone(String phone) throws ServiceException {
        if (this.mContactByPhoneCache == null) {
            this.mContactByPhoneCache = new ZContactByPhoneCache();
            this.mHandlers.add(this.mContactByPhoneCache);
        }
        return this.mContactByPhoneCache.getByPhone(phone, this);
    }

    private void updateSigs() {
        try {
            if (this.mGetInfoResult != null) {
                this.mGetInfoResult.setSignatures(this.getSignatures());
            }
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
    }

    public synchronized List<String> saveAttachmentsToBriefcase(String mid, String[] partIds, String folderId) throws ServiceException {
        if (partIds == null || partIds.length <= 0) {
            return null;
        }
        ArrayList<String> docIds = new ArrayList<String>();
        for (String pid : partIds) {
            Element req = this.newRequestElement(MailConstants.SAVE_DOCUMENT_REQUEST);
            Element doc = req.addElement("doc").addAttribute("l", folderId);
            Element m = doc.addElement("m").addAttribute("id", mid);
            m.addAttribute("part", pid);
            Element rDoc = this.invoke(req).getElement("doc");
            if (rDoc == null) continue;
            docIds.add(rDoc.getAttribute("id"));
        }
        return docIds;
    }

    public synchronized String createSignature(ZSignature signature) throws ServiceException {
        Element req = this.newRequestElement(AccountConstants.CREATE_SIGNATURE_REQUEST);
        signature.toElement(req);
        String id = this.invoke(req).getElement("signature").getAttribute("id");
        this.updateSigs();
        return id;
    }

    public List<ZSignature> getSignatures() throws ServiceException {
        Element req = this.newRequestElement(AccountConstants.GET_SIGNATURES_REQUEST);
        Element resp = this.invoke(req);
        ArrayList<ZSignature> result = new ArrayList<ZSignature>();
        for (Element signature : resp.listElements("signature")) {
            result.add(new ZSignature(signature));
        }
        return result;
    }

    public synchronized void deleteSignature(String id) throws ServiceException {
        Element req = this.newRequestElement(AccountConstants.DELETE_SIGNATURE_REQUEST);
        req.addElement("signature").addAttribute("id", id);
        this.invoke(req);
        this.updateSigs();
    }

    public synchronized void modifySignature(ZSignature signature) throws ServiceException {
        Element req = this.newRequestElement(AccountConstants.MODIFY_SIGNATURE_REQUEST);
        signature.toElement(req);
        this.invoke(req);
        this.updateSigs();
    }

    public List<ZAce> getPermission(String[] rights) throws ServiceException {
        Element req = this.newRequestElement(MailConstants.GET_PERMISSION_REQUEST);
        if (rights != null && rights.length > 0) {
            for (String right : rights) {
                req.addElement("ace").addAttribute("right", right);
            }
        }
        Element resp = this.invoke(req);
        ArrayList<ZAce> result = new ArrayList<ZAce>();
        for (Element ace : resp.listElements("ace")) {
            result.add(new ZAce(ace));
        }
        return result;
    }

    public List<ZAce> grantPermission(ZAce ace) throws ServiceException {
        Element req = this.newRequestElement(MailConstants.GRANT_PERMISSION_REQUEST);
        ace.toElement(req);
        Element resp = this.invoke(req);
        ArrayList<ZAce> result = new ArrayList<ZAce>();
        for (Element a : resp.listElements("ace")) {
            result.add(new ZAce(a));
        }
        return result;
    }

    public List<ZAce> revokePermission(ZAce ace) throws ServiceException {
        Element req = this.newRequestElement(MailConstants.REVOKE_PERMISSION_REQUEST);
        ace.toElement(req);
        Element resp = this.invoke(req);
        ArrayList<ZAce> result = new ArrayList<ZAce>();
        for (Element a : resp.listElements("ace")) {
            result.add(new ZAce(a));
        }
        return result;
    }

    public String toString() {
        try {
            return String.format("[ZMailbox %s]", this.getName());
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ZJSONObject toZJSONObject() throws JSONException {
        try {
            ZJSONObject jo = new ZJSONObject();
            jo.put("name", this.getName());
            jo.put("size", this.mSize);
            jo.put("hasTags", this.hasTags());
            jo.put("userRoot", this.getUserRoot());
            jo.put("tags", this.getAllTags());
            return jo;
        }
        catch (ServiceException se) {
            throw new JSONException(se);
        }
    }

    public String dump() {
        return ZJSONObject.toString(this);
    }

    public ZSearchContext searchContext(ZSearchParams params) {
        return new ZSearchContext(params, this);
    }

    public ZSearchContext searchContext(String query) {
        return new ZSearchContext(new ZSearchParams(query), this);
    }

    public static String resolveUrl(String url, boolean isAdmin) throws ZClientException {
        try {
            String service;
            URI uri = new URI(url);
            if (isAdmin && uri.getPort() == -1) {
                uri = new URI("https", uri.getUserInfo(), uri.getHost(), ADMIN_PORT, uri.getPath(), uri.getQuery(), uri.getFragment());
                url = uri.toString();
            }
            String string = service = uri.getPort() == ADMIN_PORT ? "/service/admin/soap/" : "/service/soap/";
            if (uri.getPath() == null || uri.getPath().length() <= 1) {
                url = url.charAt(url.length() - 1) == '/' ? url.substring(0, url.length() - 1) + service : url + service;
            }
            return url;
        }
        catch (URISyntaxException e) {
            throw ZClientException.CLIENT_ERROR("invalid URL: " + url, e);
        }
    }

    static {
        if (LC.ssl_allow_untrusted_certs.booleanValue()) {
            EasySSLProtocolSocketFactory.init();
        }
        MAX_NUM_CACHED_MESSAGES = LC.zmailbox_message_cachesize.intValue();
        sCOMMA = Pattern.compile(",");
        sAttachmentId = Pattern.compile("\\d+,'.*','(.*)'");
        ADMIN_PORT = LC.zimbra_admin_service_port.intValue();
    }

    public static class ZFreeBusyTimeSlot {
        private ZFreeBusySlotType mType;
        private long mStart;
        private long mEnd;

        public ZFreeBusyTimeSlot(ZFreeBusySlotType type, long start, long end) {
            this.mType = type;
            this.mStart = start;
            this.mEnd = end;
        }

        public ZFreeBusySlotType getType() {
            return this.mType;
        }

        public long getStartTime() {
            return this.mStart;
        }

        public long getEndTime() {
            return this.mEnd;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ZFreeBusySlotType {
        FREE,
        BUSY,
        TENTATIVE,
        UNAVAILABLE,
        NO_DATA,
        OUT_OF_OFFICE;


        public static ZFreeBusySlotType fromString(String s) throws ServiceException {
            try {
                return ZFreeBusySlotType.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                throw ZClientException.CLIENT_ERROR("invalid free busy slot type: " + s + ", valid values: " + Arrays.asList(ZFreeBusySlotType.values()), e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ZGetFreeBusyResult {
        private String mId;
        private List<ZFreeBusyTimeSlot> mTimeSlots;

        public ZGetFreeBusyResult(String id, List<ZFreeBusyTimeSlot> timeSlots) {
            this.mId = id;
            this.mTimeSlots = timeSlots;
        }

        public String getId() {
            return this.mId;
        }

        public List<ZFreeBusyTimeSlot> getTimeSlots() {
            return this.mTimeSlots;
        }
    }

    public static class ZImportAppointmentsResult {
        private String mIds;
        private long mCount;

        public ZImportAppointmentsResult(Element response) throws ServiceException {
            this.mIds = response.getAttribute("id", null);
            this.mCount = response.getAttributeLong("n");
        }

        public String getIds() {
            return this.mIds;
        }

        public long getCount() {
            return this.mCount;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReplyVerb {
        ACCEPT,
        COMPLETED,
        DECLINE,
        DELEGATED,
        TENTATIVE;


        public static ReplyVerb fromString(String s) throws ServiceException {
            try {
                return ReplyVerb.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                throw ZClientException.CLIENT_ERROR("invalid reply verb: " + s + ", valid values: " + Arrays.asList(ReplyVerb.values()), e);
            }
        }
    }

    public static class ZSendInviteReplyResult {
        public static final String STATUS_OK = "OK";
        public static final String STATUS_OLD = "OLD";
        public static final String STATUS_ALREADY_REPLIED = "ALREADY-REPLIED";
        public static final String STATUS_FAIL = "FAIL";
        private String mStatus;

        public ZSendInviteReplyResult(Element response) {
            this.mStatus = response.getAttribute("status", STATUS_OK);
        }

        public String getStatus() {
            return this.mStatus;
        }

        public boolean isOk() {
            return this.mStatus.equals(STATUS_OK);
        }

        public boolean isOld() {
            return this.mStatus.equals(STATUS_OLD);
        }

        public boolean isAlreadyReplied() {
            return this.mStatus.equals(STATUS_ALREADY_REPLIED);
        }

        public boolean isFail() {
            return this.mStatus.equals(STATUS_FAIL);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CancelRange {
        THISANDFUTURE,
        THISANDPRIOR;

    }

    public static class ZAppointmentResult {
        private String mCalItemId;
        private String mInviteId;

        public ZAppointmentResult(Element response) {
            this.mCalItemId = response.getAttribute("calItemId", null);
            this.mInviteId = response.getAttribute("invId", null);
        }

        public String getCalItemId() {
            return this.mCalItemId;
        }

        public String getInviteId() {
            return this.mInviteId;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ZApptSummaryResult {
        private String mFolderId;
        private List<ZAppointmentHit> mAppointments;
        private long mStart;
        private long mEnd;
        private TimeZone mTimeZone;
        private String mQuery;

        ZApptSummaryResult(long start, long end, String folderId, TimeZone timeZone, List<ZAppointmentHit> appointments, String query) {
            this.mFolderId = folderId;
            this.mAppointments = appointments;
            this.mStart = start;
            this.mEnd = end;
            this.mTimeZone = timeZone;
            this.mQuery = query;
        }

        public String getFolderId() {
            return this.mFolderId;
        }

        public TimeZone getTimeZone() {
            return this.mTimeZone;
        }

        public long getStart() {
            return this.mStart;
        }

        public long getEnd() {
            return this.mEnd;
        }

        public List<ZAppointmentHit> getAppointments() {
            return this.mAppointments;
        }

        public String getQuery() {
            return this.mQuery;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ZSearchGalResult {
        private boolean mMore;
        private List<ZContact> mContacts;
        private String mQuery;
        private GalEntryType mType;

        public ZSearchGalResult(List<ZContact> contacts, boolean more, String query, GalEntryType type) {
            this.mMore = more;
            this.mContacts = contacts;
            this.mQuery = query;
            this.mType = type;
        }

        public boolean getHasMore() {
            return this.mMore;
        }

        public List<ZContact> getContacts() {
            return this.mContacts;
        }

        public String getQuery() {
            return this.mQuery;
        }

        public GalEntryType getGalEntryType() {
            return this.mType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GalEntryType {
        account,
        resource,
        all;


        public static GalEntryType fromString(String s) throws ServiceException {
            try {
                return GalEntryType.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                throw ZClientException.CLIENT_ERROR("invalid GalType: " + s + ", valid values: " + Arrays.asList(GalEntryType.values()), e);
            }
        }
    }

    public static class ZImportStatus {
        private String mType;
        private boolean mIsRunning;
        private boolean mSuccess;
        private String mError;
        private String mId;

        ZImportStatus(Element e) throws ServiceException {
            this.mType = e.getName();
            this.mId = e.getAttribute("id");
            this.mIsRunning = e.getAttributeBool("isRunning", false);
            this.mSuccess = e.getAttributeBool("success", true);
            this.mError = e.getAttribute("error", null);
        }

        public String getType() {
            return this.mType;
        }

        public String getId() {
            return this.mId;
        }

        public boolean isRunning() {
            return this.mIsRunning;
        }

        public boolean getSuccess() {
            return this.mSuccess;
        }

        public String getError() {
            return this.mError;
        }
    }

    public static class Misspelling {
        private String mWord;
        private String[] mSuggestions;

        public Misspelling(Element element) throws ServiceException {
            this.mWord = element.getAttribute("word");
            String suggestions = element.getAttribute("suggestions");
            this.mSuggestions = suggestions.length() > 0 ? sCOMMA.split(suggestions) : new String[]{};
        }

        public String getWord() {
            return this.mWord;
        }

        public String[] getSuggestions() {
            return this.mSuggestions;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CheckSpellingResult {
        private boolean mAvailable;
        private List<Misspelling> mMisspellings;

        public CheckSpellingResult(Element response) throws ServiceException {
            this.mAvailable = response.getAttributeBool("available");
            List<Element> list = response.listElements("misspelled");
            this.mMisspellings = new ArrayList<Misspelling>(list.size());
            for (Element misspelled : list) {
                this.mMisspellings.add(new Misspelling(misspelled));
            }
        }

        public boolean getIsAvailable() {
            return this.mAvailable;
        }

        public List<Misspelling> getMisspellings() {
            return this.mMisspellings;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ZOutgoingMessage {
        private List<ZEmailAddress> mAddresses;
        private String mSubject;
        private String mPriority;
        private String mInReplyTo;
        private MessagePart mMessagePart;
        private String mAttachmentUploadId;
        private List<AttachedMessagePart> mMessagePartsToAttach;
        private List<String> mContactIdsToAttach;
        private List<String> mMessageIdsToAttach;
        private List<String> mDocIdsToAttach;
        private String mOriginalMessageId;
        private String mReplyType;

        public List<ZEmailAddress> getAddresses() {
            return this.mAddresses;
        }

        public void setAddresses(List<ZEmailAddress> addresses) {
            this.mAddresses = addresses;
        }

        public String getAttachmentUploadId() {
            return this.mAttachmentUploadId;
        }

        public void setAttachmentUploadId(String attachmentUploadId) {
            this.mAttachmentUploadId = attachmentUploadId;
        }

        public List<String> getContactIdsToAttach() {
            return this.mContactIdsToAttach;
        }

        public void setContactIdsToAttach(List<String> contactIdsToAttach) {
            this.mContactIdsToAttach = contactIdsToAttach;
        }

        public MessagePart getMessagePart() {
            return this.mMessagePart;
        }

        public void setMessagePart(MessagePart messagePart) {
            this.mMessagePart = messagePart;
        }

        public List<AttachedMessagePart> getMessagePartsToAttach() {
            return this.mMessagePartsToAttach;
        }

        public void setMessagePartsToAttach(List<AttachedMessagePart> messagePartsToAttach) {
            this.mMessagePartsToAttach = messagePartsToAttach;
        }

        public String getOriginalMessageId() {
            return this.mOriginalMessageId;
        }

        public void setOriginalMessageId(String originalMessageId) {
            this.mOriginalMessageId = originalMessageId;
        }

        public String getInReplyTo() {
            return this.mInReplyTo;
        }

        public void setInReplyTo(String inReplyTo) {
            this.mInReplyTo = inReplyTo;
        }

        public String getReplyType() {
            return this.mReplyType;
        }

        public void setReplyType(String replyType) {
            this.mReplyType = replyType;
        }

        public String getSubject() {
            return this.mSubject;
        }

        public void setSubject(String subject) {
            this.mSubject = subject;
        }

        public String getPriority() {
            return this.mPriority;
        }

        public void setPriority(String priority) {
            this.mPriority = priority;
        }

        public List<String> getMessageIdsToAttach() {
            return this.mMessageIdsToAttach;
        }

        public void setMessageIdsToAttach(List<String> messageIdsToAttach) {
            this.mMessageIdsToAttach = messageIdsToAttach;
        }

        public List<String> getDocIdsToAttach() {
            return this.mDocIdsToAttach;
        }

        public void setDocIdsToAttach(List<String> docIdsToAttach) {
            this.mDocIdsToAttach = docIdsToAttach;
        }

        public List<AttachedMessagePart> getInlineMessagePartsToAttach() {
            ArrayList<AttachedMessagePart> attachments = new ArrayList<AttachedMessagePart>();
            if (this.mMessagePartsToAttach == null || this.mMessagePartsToAttach.size() <= 0) {
                return attachments;
            }
            for (AttachedMessagePart part : this.mMessagePartsToAttach) {
                if (part.getContentId() == null || part.getContentId().equals("")) continue;
                attachments.add(part);
            }
            return attachments;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class MessagePart {
            private String mContentType;
            private String mContent;
            private List<MessagePart> mSubParts;
            private List<AttachedMessagePart> mAttachSubParts;

            public MessagePart(String contentType, String content) {
                this.mContent = content;
                this.mContentType = contentType;
            }

            public MessagePart(String contentType, String content, List<AttachedMessagePart> attachSubParts) {
                this.mContent = content;
                this.mContentType = contentType;
                this.mAttachSubParts = attachSubParts;
            }

            public MessagePart(String contentType, MessagePart ... parts) {
                this.mContent = null;
                this.mContentType = contentType;
                this.mSubParts = new ArrayList<MessagePart>();
                for (MessagePart sub : parts) {
                    this.mSubParts.add(sub);
                }
            }

            public String getContentType() {
                return this.mContentType;
            }

            public void setContentType(String contentType) {
                this.mContentType = contentType;
            }

            public String getContent() {
                return this.mContent;
            }

            public void setContent(String content) {
                this.mContentType = content;
            }

            public List<MessagePart> getSubParts() {
                return this.mSubParts;
            }

            public void setSubParts(List<MessagePart> subParts) {
                this.mSubParts = subParts;
            }

            public List<AttachedMessagePart> getAttachSubParts() {
                return this.mAttachSubParts;
            }

            public void setAttachSubParts(List<AttachedMessagePart> attachSubParts) {
                this.mAttachSubParts = attachSubParts;
            }

            public Element toElement(Element parent) {
                Element mpEl = parent.addElement("mp");
                mpEl.addAttribute("ct", this.mContentType);
                if (this.mContent != null) {
                    mpEl.addElement("content").setText(this.mContent);
                }
                if (this.mSubParts != null) {
                    for (MessagePart messagePart : this.mSubParts) {
                        messagePart.toElement(mpEl);
                    }
                }
                if (this.mAttachSubParts != null) {
                    for (AttachedMessagePart attachedMessagePart : this.mAttachSubParts) {
                        Element e = parent.addElement("mp");
                        e.addAttribute("ci", attachedMessagePart.getContentId());
                        Element attach = e.addElement("attach");
                        Element el = attach.addElement("mp");
                        el.addAttribute("mid", attachedMessagePart.getMessageId());
                        el.addAttribute("part", attachedMessagePart.getPartName());
                    }
                }
                return mpEl;
            }
        }

        public static class AttachedMessagePart {
            private String mMessageId;
            private String mPartName;
            private String mContentId;

            public AttachedMessagePart(String messageId, String partName, String contentId) {
                this.mMessageId = messageId;
                this.mPartName = partName;
                this.mContentId = contentId;
            }

            public String getMessageId() {
                return this.mMessageId;
            }

            public void setMessageId(String messageId) {
                this.mMessageId = messageId;
            }

            public String getContentId() {
                return this.mContentId;
            }

            public void setContentId(String contentId) {
                this.mContentId = contentId;
            }

            public String getPartName() {
                return this.mPartName;
            }

            public void setPartName(String partName) {
                this.mPartName = partName;
            }
        }
    }

    public static class ZSendMessageResponse {
        private String mId;

        public ZSendMessageResponse(String id) {
            this.mId = id;
        }

        public String getId() {
            return this.mId;
        }

        public void setId(String id) {
            this.mId = id;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SharedItemBy {
        BY_ID,
        BY_PATH;


        public static SharedItemBy fromString(String s) throws ServiceException {
            try {
                return SharedItemBy.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                throw ZClientException.CLIENT_ERROR("invalid sharedItemBy: " + s + ", valid values: " + Arrays.asList(SharedItemBy.values()), e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OwnerBy {
        BY_ID,
        BY_NAME;


        public static OwnerBy fromString(String s) throws ServiceException {
            try {
                return OwnerBy.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                throw ZClientException.CLIENT_ERROR("invalid ownerBy: " + s + ", valid values: " + Arrays.asList(OwnerBy.values()), e);
            }
        }
    }

    public static class ZActionResult {
        private String mIds;
        private Element mResponse;

        public ZActionResult(Element response) throws ServiceException {
            String ids = response.getElement("action").getAttribute("id");
            if (ids == null) {
                ids = "";
            }
            this.mIds = ids;
            this.mResponse = response;
        }

        public String getIds() {
            return this.mIds;
        }

        public String[] getIdsAsArray() {
            return this.mIds.split(",");
        }

        public String toString() {
            return String.format("[ZActionResult %s]", this.mIds);
        }

        Element getResponse() {
            return this.mResponse;
        }
    }

    static class CachedMessage {
        ZGetMessageParams params;
        ZMessage zm;

        CachedMessage() {
        }
    }

    public static class ZImportContactsResult {
        private String mIds;
        private long mCount;

        public ZImportContactsResult(Element response) throws ServiceException {
            this.mIds = response.getAttribute("id", null);
            this.mCount = response.getAttributeLong("n");
        }

        public String getIds() {
            return this.mIds;
        }

        public long getCount() {
            return this.mCount;
        }
    }

    public static class ZAttachmentInfo {
        private String mAttachmentId;
        private String mPartName;
        private String mItemId;

        public ZAttachmentInfo setAttachmentId(String attachmentId) {
            this.mAttachmentId = attachmentId;
            return this;
        }

        public ZAttachmentInfo setPartName(String partName) {
            this.mPartName = partName;
            return this;
        }

        public ZAttachmentInfo setItemId(String itemId) {
            this.mItemId = itemId;
            return this;
        }

        public String getAttachmentId() {
            return this.mAttachmentId;
        }

        public String getPartName() {
            return this.mPartName;
        }

        public String getItemId() {
            return this.mItemId;
        }

        public String toString() {
            return String.format("%s: {attachmentId=%s, partName=%s, itemId=%s}", ZAttachmentInfo.class.getSimpleName(), this.mAttachmentId, this.mPartName, this.mItemId);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ContactSortBy {
        nameDesc,
        nameAsc;


        public static ContactSortBy fromString(String s) throws ServiceException {
            try {
                return ContactSortBy.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                throw ZClientException.CLIENT_ERROR("invalid sortBy: " + s + ", valid values: " + Arrays.asList(ContactSortBy.values()), e);
            }
        }
    }

    public static class JsonDebugListener
    implements SoapTransport.DebugListener {
        Element env;

        public void sendSoapMessage(Element envelope) {
        }

        public void receiveSoapMessage(Element envelope) {
            this.env = envelope;
        }

        public Element getEnvelope() {
            return this.env;
        }
    }

    class InternalEventHandler
    extends ZEventHandler {
        InternalEventHandler() {
        }

        public synchronized void handleRefresh(ZRefreshEvent event, ZMailbox mailbox) {
            ZFolder root = event.getUserRoot();
            List<ZTag> tags = event.getTags();
            ZMailbox.this.mIdToItem.clear();
            ZMailbox.this.mMessageCache.clear();
            ZMailbox.this.mContactCache.clear();
            ZMailbox.this.mTransport.setMaxNotifySeq(0L);
            ZMailbox.this.mSize = event.getSize();
            if (root != null) {
                ZMailbox.this.mUserRoot = root;
                ZMailbox.this.addIdMappings(ZMailbox.this.mUserRoot);
            }
            if (tags != null) {
                if (ZMailbox.this.mNameToTag == null) {
                    ZMailbox.this.mNameToTag = new HashMap();
                } else {
                    ZMailbox.this.mNameToTag.clear();
                }
                for (ZTag tag : tags) {
                    ZMailbox.this.addTag(tag);
                }
            }
        }

        public synchronized void handleCreate(ZCreateEvent event, ZMailbox mailbox) {
        }

        public synchronized void handleModify(ZModifyEvent event, ZMailbox mailbox) throws ServiceException {
            if (event instanceof ZModifyTagEvent) {
                ZModifyTagEvent tagEvent = (ZModifyTagEvent)event;
                ZTag tag = ZMailbox.this.getTagById(tagEvent.getId());
                if (tag != null) {
                    String oldName = tag.getName();
                    tag.modifyNotification(tagEvent);
                    if (ZMailbox.this.mNameToTag != null && !tag.getName().equalsIgnoreCase(oldName)) {
                        ZMailbox.this.mNameToTag.remove(oldName);
                        ZMailbox.this.mNameToTag.put(tag.getName(), tag);
                    }
                }
            } else if (event instanceof ZModifyFolderEvent) {
                ZModifyFolderEvent mfe = (ZModifyFolderEvent)event;
                ZFolder f = ZMailbox.this.getFolderById(mfe.getId());
                if (f != null) {
                    String newParentId = mfe.getParentId(null);
                    if (newParentId != null && !newParentId.equals(f.getParentId())) {
                        ZMailbox.this.reparent(f, newParentId);
                    }
                    f.modifyNotification(event);
                }
            } else if (event instanceof ZModifyMailboxEvent) {
                ZModifyMailboxEvent mme = (ZModifyMailboxEvent)event;
                if (mme.getOwner(null) == null) {
                    ZMailbox.this.mSize = mme.getSize(ZMailbox.this.mSize);
                }
            } else if (event instanceof ZModifyMessageEvent) {
                ZModifyMessageEvent mme = (ZModifyMessageEvent)event;
                CachedMessage cm = (CachedMessage)ZMailbox.this.mMessageCache.get((Object)mme.getId());
                if (cm != null) {
                    cm.zm.modifyNotification(event);
                }
            } else if (event instanceof ZModifyContactEvent) {
                ZModifyContactEvent mce = (ZModifyContactEvent)event;
                ZContact contact = (ZContact)ZMailbox.this.mContactCache.get((Object)mce.getId());
                if (contact != null) {
                    contact.modifyNotification(mce);
                }
            }
        }

        public synchronized void handleDelete(ZDeleteEvent event, ZMailbox mailbox) {
            for (String id : event.toList()) {
                ZMailbox.this.mMessageCache.remove((Object)id);
                ZMailbox.this.mContactCache.remove((Object)id);
                ZItem item = (ZItem)ZMailbox.this.mIdToItem.get(id);
                if (item instanceof ZMountpoint) {
                    ZMountpoint sl = (ZMountpoint)item;
                    if (sl.getParent() != null) {
                        sl.getParent().removeChild(sl);
                    }
                    ZMailbox.this.mIdToItem.remove(sl.getCanonicalRemoteId());
                } else if (item instanceof ZFolder) {
                    ZFolder sf = (ZFolder)item;
                    if (sf.getParent() != null) {
                        sf.getParent().removeChild(sf);
                    }
                } else if (item instanceof ZTag && ZMailbox.this.mNameToTag != null) {
                    ZMailbox.this.mNameToTag.remove(((ZTag)item).getName());
                }
                if (item == null) continue;
                ZMailbox.this.mIdToItem.remove(item.getId());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Options {
        private String mAccount;
        private Provisioning.AccountBy mAccountBy = Provisioning.AccountBy.name;
        private String mPassword;
        private String mNewPassword;
        private ZAuthToken mAuthToken;
        private String mVirtualHost;
        private String mUri;
        private String mClientIp;
        private String mProxyHost;
        private int mProxyPort;
        private String mProxyUser;
        private String mProxyPass;
        private String mUserAgentName;
        private String mUserAgentVersion;
        private int mTimeout = -1;
        private int mRetryCount = -1;
        private SoapProtocol mResponseProtocol = SoapProtocol.SoapJS;
        private SoapProtocol mRequestProtocol = SoapProtocol.SoapJS;
        private SoapTransport.DebugListener mDebugListener;
        private SoapHttpTransport.HttpDebugListener mHttpDebugListener;
        private String mTargetAccount;
        private Provisioning.AccountBy mTargetAccountBy = Provisioning.AccountBy.name;
        private boolean mNoSession;
        private boolean mAuthAuthToken;
        private ZEventHandler mHandler;
        private List<String> mAttrs;
        private List<String> mPrefs;
        private String mRequestedSkin;

        public Options() {
        }

        public Options(String account, Provisioning.AccountBy accountBy, String password, String uri) {
            this.mAccount = account;
            this.mAccountBy = accountBy;
            this.mPassword = password;
            this.setUri(uri);
        }

        public Options(String authToken, String uri) {
            this.mAuthToken = new ZAuthToken(null, authToken, null);
            this.setUri(uri);
        }

        public Options(ZAuthToken authToken, String uri) {
            this.mAuthToken = authToken;
            this.setUri(uri);
        }

        public void setProxy(String proxyHost, int proxyPort) {
            this.mProxyHost = proxyHost;
            this.mProxyPort = proxyPort;
        }

        public void setProxy(String proxyHost, int proxyPort, String proxyUser, String proxyPass) {
            this.mProxyHost = proxyHost;
            this.mProxyPort = proxyPort;
            this.mProxyUser = proxyUser;
            this.mProxyPass = proxyPass;
        }

        public String getProxyHost() {
            return this.mProxyHost;
        }

        public int getProxyPort() {
            return this.mProxyPort;
        }

        public String getProxyUser() {
            return this.mProxyUser;
        }

        public String getProxyPass() {
            return this.mProxyPass;
        }

        public String getClientIp() {
            return this.mClientIp;
        }

        public void setClientIp(String clientIp) {
            this.mClientIp = clientIp;
        }

        public String getAccount() {
            return this.mAccount;
        }

        public void setAccount(String account) {
            this.mAccount = account;
        }

        public Provisioning.AccountBy getAccountBy() {
            return this.mAccountBy;
        }

        public void setAccountBy(Provisioning.AccountBy accountBy) {
            this.mAccountBy = accountBy;
        }

        public String getTargetAccount() {
            return this.mTargetAccount;
        }

        public void setTargetAccount(String targetAccount) {
            this.mTargetAccount = targetAccount;
        }

        public Provisioning.AccountBy getTargetAccountBy() {
            return this.mTargetAccountBy;
        }

        public void setTargetAccountBy(Provisioning.AccountBy targetAccountBy) {
            this.mTargetAccountBy = targetAccountBy;
        }

        public String getPassword() {
            return this.mPassword;
        }

        public void setPassword(String password) {
            this.mPassword = password;
        }

        public String getNewPassword() {
            return this.mNewPassword;
        }

        public void setNewPassword(String newPassword) {
            this.mNewPassword = newPassword;
        }

        public String getVirtualHost() {
            return this.mVirtualHost;
        }

        public void setVirtualHost(String virtualHost) {
            this.mVirtualHost = virtualHost;
        }

        public ZAuthToken getAuthToken() {
            return this.mAuthToken;
        }

        public void setAuthToken(ZAuthToken authToken) {
            this.mAuthToken = authToken;
        }

        public void setAuthToken(String authToken) {
            this.mAuthToken = new ZAuthToken(null, authToken, null);
        }

        public String getUri() {
            return this.mUri;
        }

        public void setUri(String uri) {
            this.setUri(uri, false);
        }

        public void setUri(String uri, boolean isAdmin) {
            try {
                this.mUri = ZMailbox.resolveUrl(uri, isAdmin);
            }
            catch (ZClientException e) {
                this.mUri = uri;
            }
        }

        public String getUserAgentName() {
            return this.mUserAgentName;
        }

        public String getUserAgentVersion() {
            return this.mUserAgentVersion;
        }

        public void setUserAgent(String name, String version) {
            this.mUserAgentName = name;
            this.mUserAgentVersion = version;
        }

        public int getTimeout() {
            return this.mTimeout;
        }

        public void setTimeout(int timeout) {
            this.mTimeout = timeout;
        }

        public int getRetryCount() {
            return this.mRetryCount;
        }

        public void setRetryCount(int retryCount) {
            this.mRetryCount = retryCount;
        }

        public SoapProtocol getResponseProtocol() {
            return this.mResponseProtocol;
        }

        public void setResponseProtocol(SoapProtocol proto) {
            this.mResponseProtocol = proto;
        }

        public SoapProtocol getRequestProtocol() {
            return this.mRequestProtocol;
        }

        public void setRequestProtocol(SoapProtocol proto) {
            this.mRequestProtocol = proto;
        }

        public SoapTransport.DebugListener getDebugListener() {
            return this.mDebugListener;
        }

        public void setDebugListener(SoapTransport.DebugListener listener) {
            this.mDebugListener = listener;
        }

        public SoapHttpTransport.HttpDebugListener getHttpDebugListener() {
            return this.mHttpDebugListener;
        }

        public void setHttpDebugListener(SoapHttpTransport.HttpDebugListener listener) {
            this.mHttpDebugListener = listener;
        }

        public boolean getNoSession() {
            return this.mNoSession;
        }

        public void setNoSession(boolean noSession) {
            this.mNoSession = noSession;
        }

        public boolean getAuthAuthToken() {
            return this.mAuthAuthToken;
        }

        public void setAuthAuthToken(boolean authAuthToken) {
            this.mAuthAuthToken = authAuthToken;
        }

        public ZEventHandler getEventHandler() {
            return this.mHandler;
        }

        public void setEventHandler(ZEventHandler handler) {
            this.mHandler = handler;
        }

        public List<String> getPrefs() {
            return this.mPrefs;
        }

        public void setPrefs(List<String> prefs) {
            this.mPrefs = prefs;
        }

        public List<String> getAttrs() {
            return this.mAttrs;
        }

        public void setAttrs(List<String> attrs) {
            this.mAttrs = attrs;
        }

        public String getRequestedSkin() {
            return this.mRequestedSkin;
        }

        public void setRequestedSkin(String skin) {
            this.mRequestedSkin = skin;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum NotifyPreference {
        nosession,
        full;


        static NotifyPreference fromOptions(Options options) {
            if (options == null) {
                return full;
            }
            if (options.getNoSession()) {
                return nosession;
            }
            return full;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Fetch {
        none,
        first,
        hits,
        all;


        public static Fetch fromString(String s) throws ServiceException {
            try {
                return Fetch.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                throw ZClientException.CLIENT_ERROR("invalid fetch: " + s + ", valid values: " + Arrays.asList(Fetch.values()), e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SearchSortBy {
        dateDesc,
        dateAsc,
        subjDesc,
        subjAsc,
        nameDesc,
        nameAsc,
        durDesc,
        durAsc,
        none,
        taskDueAsc,
        taskDueDesc,
        taskStatusAsc,
        taskStatusDesc,
        taskPercCompletedAsc,
        taskPercCompletedDesc;


        public static SearchSortBy fromString(String s) throws ServiceException {
            try {
                return SearchSortBy.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                throw ZClientException.CLIENT_ERROR("invalid sortBy: " + s + ", valid values: " + Arrays.asList(SearchSortBy.values()), e);
            }
        }
    }
}

