/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient;

import com.zimbra.common.util.ExceptionToString;
import com.zimbra.cs.zclient.ToZJSONObject;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZJSONObject {
    JSONObject mJO = new JSONObject();

    public JSONObject getJSONObject() {
        return this.mJO;
    }

    public ZJSONObject put(String key, ToZJSONObject value) throws JSONException {
        if (value != null) {
            this.mJO.put(key, value.toZJSONObject().getJSONObject());
        }
        return this;
    }

    public ZJSONObject put(String key, JSONObject value) throws JSONException {
        if (value != null) {
            this.mJO.put(key, value);
        }
        return this;
    }

    public ZJSONObject put(String key, ZJSONObject value) throws JSONException {
        if (value != null) {
            this.mJO.put(key, value.getJSONObject());
        }
        return this;
    }

    public ZJSONObject put(String key, String value) throws JSONException {
        this.mJO.put(key, value);
        return this;
    }

    public ZJSONObject put(String key, long value) throws JSONException {
        this.mJO.put(key, value);
        return this;
    }

    public ZJSONObject put(String key, boolean value) throws JSONException {
        this.mJO.put(key, value);
        return this;
    }

    public ZJSONObject put(String key, float value) throws JSONException {
        this.mJO.put(key, value);
        return this;
    }

    public ZJSONObject put(String key, double value) throws JSONException {
        this.mJO.put(key, value);
        return this;
    }

    public ZJSONObject putMap(String key, Map<String, String> attrs) throws JSONException {
        JSONObject ja = new JSONObject();
        this.mJO.put(key, ja);
        if (attrs != null) {
            for (Map.Entry<String, String> entry : attrs.entrySet()) {
                ja.put(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    public ZJSONObject put(String key, List<? extends ToZJSONObject> items) throws JSONException {
        JSONArray ja = new JSONArray();
        this.mJO.put(key, ja);
        if (items != null) {
            for (ToZJSONObject toZJSONObject : items) {
                ja.put(toZJSONObject.toZJSONObject().getJSONObject());
            }
        }
        return this;
    }

    public ZJSONObject put(String key, String[] items) throws JSONException {
        JSONArray ja = new JSONArray();
        this.mJO.put(key, ja);
        if (items != null) {
            for (String item : items) {
                ja.put(item);
            }
        }
        return this;
    }

    public ZJSONObject putMapList(String key, Map<String, List<String>> attrs) throws JSONException {
        JSONObject obj = new JSONObject();
        this.mJO.put(key, obj);
        if (attrs != null) {
            for (Map.Entry<String, List<String>> entry : attrs.entrySet()) {
                JSONArray ja = new JSONArray();
                obj.put(key, ja);
                if (entry.getValue() == null) continue;
                for (String item : entry.getValue()) {
                    ja.put(item);
                }
            }
        }
        return this;
    }

    public ZJSONObject putList(String key, List<String> items) throws JSONException {
        JSONArray ja = new JSONArray();
        this.mJO.put(key, ja);
        if (items != null) {
            for (String item : items) {
                ja.put(item);
            }
        }
        return this;
    }

    public String toString() {
        try {
            return this.mJO.toString(5);
        }
        catch (JSONException e) {
            return ExceptionToString.ToString(e);
        }
    }

    public static String toString(ToZJSONObject zjo) {
        try {
            return zjo.toZJSONObject().toString();
        }
        catch (JSONException e) {
            return ExceptionToString.ToString(e);
        }
    }
}

