/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.zclient.ZClientException;
import com.zimbra.cs.mailbox.calendar.Geo;
import com.zimbra.cs.mailbox.calendar.ZCalendar;
import com.zimbra.cs.service.mail.CalendarUtils;
import com.zimbra.cs.service.mail.ToXML;
import com.zimbra.cs.zclient.ToZJSONObject;
import com.zimbra.cs.zclient.ZAlarm;
import com.zimbra.cs.zclient.ZDateTime;
import com.zimbra.cs.zclient.ZEmailAddress;
import com.zimbra.cs.zclient.ZJSONObject;
import com.zimbra.cs.zclient.ZSimpleRecurrence;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.json.JSONException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZInvite
implements ToZJSONObject {
    private List<ZTimeZone> mTimeZones = new ArrayList<ZTimeZone>();
    private List<ZComponent> mComponents;
    private ZInviteType mType;

    public ZInvite() {
        this.mComponents = new ArrayList<ZComponent>();
    }

    public ZInvite(Element e) throws ServiceException {
        this.mType = ZInviteType.fromString(e.getAttribute("t", ZInviteType.appt.name()));
        for (Element tzEl : e.listElements("tz")) {
            this.mTimeZones.add(new ZTimeZone(tzEl));
        }
        this.mComponents = new ArrayList<ZComponent>();
        for (Element compEl : e.listElements("comp")) {
            this.mComponents.add(new ZComponent(compEl));
        }
    }

    public void setTimeZones(List<ZTimeZone> timeZones) {
        this.mTimeZones = timeZones;
    }

    public List<ZTimeZone> getTimeZones() {
        return this.mTimeZones;
    }

    public void setType(ZInviteType type) {
        this.mType = type;
    }

    public ZInviteType getType() {
        return this.mType;
    }

    public void setComponents(List<ZComponent> components) {
        this.mComponents = components;
    }

    public List<ZComponent> getComponents() {
        return this.mComponents;
    }

    public ZComponent getComponent() {
        return this.mComponents == null || this.mComponents.isEmpty() ? null : this.mComponents.get(0);
    }

    public Element toElement(Element parent) {
        Element invEl = parent.addElement("inv");
        for (ZTimeZone tz : this.mTimeZones) {
            tz.toElement(invEl);
        }
        for (ZComponent comp : this.mComponents) {
            comp.toElement(invEl);
        }
        return invEl;
    }

    @Override
    public ZJSONObject toZJSONObject() throws JSONException {
        ZJSONObject zjo = new ZJSONObject();
        zjo.put("type", this.mType.name());
        zjo.put("timezones", this.mTimeZones);
        zjo.put("components", this.mComponents);
        return zjo;
    }

    public String toString() {
        return String.format("[ZInvite %s]", this.getComponent().getName());
    }

    public String dump() {
        return ZJSONObject.toString(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ZRecurrence
    implements ToZJSONObject {
        private List<ZRecurrenceRule> mRules;
        private List<ZRecurrenceDates> mDates;
        private List<ZRecurrenceRule> mExRules;
        private List<ZRecurrenceDates> mExDates;

        public ZRecurrence() {
        }

        public ZRecurrence(Element e) throws ServiceException {
            this.mRules = new ArrayList<ZRecurrenceRule>();
            this.mExRules = new ArrayList<ZRecurrenceRule>();
            this.mDates = new ArrayList<ZRecurrenceDates>();
            this.mExDates = new ArrayList<ZRecurrenceDates>();
            for (Element addEl : e.listElements("add")) {
                for (Element ruleEl : addEl.listElements("rule")) {
                    this.mRules.add(new ZRecurrenceRule(ruleEl));
                }
                for (Element datesEl : addEl.listElements("dates")) {
                    this.mDates.add(new ZRecurrenceDates(datesEl));
                }
            }
            for (Element excludeEl : e.listElements("exclude")) {
                for (Element ruleEl : excludeEl.listElements("rule")) {
                    this.mExRules.add(new ZRecurrenceRule(ruleEl));
                }
                for (Element datesEl : excludeEl.listElements("dates")) {
                    this.mExDates.add(new ZRecurrenceDates(datesEl));
                }
            }
        }

        public Element toElement(Element parent) {
            Element recurEl = parent.addElement("recur");
            if (this.mRules != null && !this.mRules.isEmpty() || this.mDates != null && !this.mDates.isEmpty()) {
                Element addEl = recurEl.addElement("add");
                if (this.mRules != null) {
                    for (ZRecurrenceRule rule : this.mRules) {
                        rule.toElement(addEl);
                    }
                }
                if (this.mDates != null) {
                    for (ZRecurrenceDates dates : this.mDates) {
                        dates.toElement(addEl);
                    }
                }
            }
            if (this.mExRules != null && !this.mExRules.isEmpty() || this.mExDates != null && !this.mExDates.isEmpty()) {
                Element exEl = recurEl.addElement("exclude");
                if (this.mExRules != null) {
                    for (ZRecurrenceRule rule : this.mExRules) {
                        rule.toElement(exEl);
                    }
                }
                if (this.mExDates != null) {
                    for (ZRecurrenceDates dates : this.mExDates) {
                        dates.toElement(exEl);
                    }
                }
            }
            return recurEl;
        }

        public List<ZRecurrenceRule> getRules() {
            return this.mRules;
        }

        public void setRules(List<ZRecurrenceRule> rules) {
            this.mRules = rules;
        }

        public List<ZRecurrenceDates> getDates() {
            return this.mDates;
        }

        public void setDates(List<ZRecurrenceDates> dates) {
            this.mDates = dates;
        }

        public List<ZRecurrenceRule> getExRules() {
            return this.mExRules;
        }

        public void setExRules(List<ZRecurrenceRule> exRules) {
            this.mExRules = exRules;
        }

        public List<ZRecurrenceDates> getExDates() {
            return this.mExDates;
        }

        public void setExDates(List<ZRecurrenceDates> exDates) {
            this.mExDates = exDates;
        }

        @Override
        public ZJSONObject toZJSONObject() throws JSONException {
            ZJSONObject jso = new ZJSONObject();
            jso.put("rules", this.mRules);
            jso.put("dates", this.mDates);
            jso.put("exRules", this.mExRules);
            jso.put("exDates", this.mExDates);
            return jso;
        }

        public String toString() {
            return String.format("[ZRecurrence]", new Object[0]);
        }

        public String dump() {
            return ZJSONObject.toString(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ZRecurrenceRule
    implements ToZJSONObject {
        private ZFrequency mFrequency;
        private ZDateTime mUntilDate;
        private int mCount;
        private int mInterval = 1;
        private List<ZByRule> mByRules;
        private ZWeekDay mWeekStart;

        public ZRecurrenceRule() {
        }

        public ZRecurrenceRule(Element e) throws ServiceException {
            this.mFrequency = ZFrequency.fromString(e.getAttribute("freq"));
            this.mByRules = new ArrayList<ZByRule>();
            for (Element childEl : e.listElements()) {
                if (childEl.getName().equals("until")) {
                    this.mUntilDate = new ZDateTime(childEl);
                    continue;
                }
                if (childEl.getName().equals("count")) {
                    this.mCount = (int)childEl.getAttributeLong("num", 1L);
                    continue;
                }
                if (childEl.getName().equals("interval")) {
                    this.mInterval = (int)childEl.getAttributeLong("ival", 1L);
                    continue;
                }
                if (childEl.getName().equals("wkst")) {
                    this.mWeekStart = ZWeekDay.fromString(childEl.getAttribute("day"));
                    continue;
                }
                if (!childEl.getName().startsWith("by")) continue;
                this.mByRules.add(new ZByRule(childEl));
            }
        }

        @Override
        public ZJSONObject toZJSONObject() throws JSONException {
            ZJSONObject zjo = new ZJSONObject();
            zjo.put("frequency", this.mFrequency.name());
            zjo.put("until", this.mUntilDate);
            zjo.put("count", this.mCount);
            zjo.put("interval", this.mInterval);
            zjo.put("byRules", this.mByRules);
            if (this.mWeekStart != null) {
                zjo.put("weekStart", this.mWeekStart.name());
            }
            return zjo;
        }

        public String toString() {
            return String.format("[ZRecurrenceRule]", new Object[0]);
        }

        public String dump() {
            return ZJSONObject.toString(this);
        }

        public Element toElement(Element parent) {
            Element ruleEl = parent.addElement("rule");
            if (this.mFrequency != null) {
                ruleEl.addAttribute("freq", this.mFrequency.name());
            }
            if (this.mUntilDate != null) {
                this.mUntilDate.toElement("until", ruleEl);
            } else if (this.mCount != 0) {
                ruleEl.addElement("count").addAttribute("num", this.mCount);
            }
            if (this.mInterval != 0) {
                ruleEl.addElement("interval").addAttribute("ival", this.mInterval);
            }
            if (this.mWeekStart != null) {
                ruleEl.addElement("wkst").addAttribute("day", this.mWeekStart.name());
            }
            if (this.mByRules != null && !this.mByRules.isEmpty()) {
                for (ZByRule rule : this.mByRules) {
                    rule.toElement(ruleEl);
                }
            }
            return ruleEl;
        }

        public ZFrequency getFrequency() {
            return this.mFrequency;
        }

        public void setFrequency(ZFrequency frequency) {
            this.mFrequency = frequency;
        }

        public ZDateTime getUntilDate() {
            return this.mUntilDate;
        }

        public void setUntilDate(ZDateTime untilDate) {
            this.mUntilDate = untilDate;
        }

        public int getCount() {
            return this.mCount;
        }

        public void setCount(int count) {
            this.mCount = count;
        }

        public int getInterval() {
            return this.mInterval;
        }

        public void setInterval(int interval) {
            this.mInterval = interval;
        }

        public List<ZByRule> getByRules() {
            return this.mByRules;
        }

        public void setByRules(List<ZByRule> byRules) {
            this.mByRules = byRules;
        }

        public ZWeekDay getWeekStart() {
            return this.mWeekStart;
        }

        public void setWeekStart(ZWeekDay weekStart) {
            this.mWeekStart = weekStart;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ZByRule
    implements ToZJSONObject {
        private ZByType mType;
        private String mList;
        private List<ZByDayWeekDay> mWeekDays;

        public ZByRule(ZByType type, String list, List<ZByDayWeekDay> weekDays) {
            this.mType = type;
            this.mList = list;
            this.mWeekDays = weekDays;
        }

        public ZByRule(Element e) throws ServiceException {
            String ename = e.getName();
            if (ename.equals("bysecond")) {
                this.mType = ZByType.BY_SECOND;
                this.mList = e.getAttribute("seclist", null);
            } else if (ename.equals("byminute")) {
                this.mType = ZByType.BY_MINUTE;
                this.mList = e.getAttribute("minlist", null);
            } else if (ename.equals("byhour")) {
                this.mType = ZByType.BY_HOUR;
                this.mList = e.getAttribute("hrlist", null);
            } else if (ename.equals("byday")) {
                this.mType = ZByType.BY_DAY;
                this.mWeekDays = new ArrayList<ZByDayWeekDay>();
                for (Element wkdayEl : e.listElements("wkday")) {
                    this.mWeekDays.add(new ZByDayWeekDay(wkdayEl));
                }
            } else if (ename.equals("bymonthday")) {
                this.mType = ZByType.BY_MONTHDAY;
                this.mList = e.getAttribute("modaylist", null);
            } else if (ename.equals("byyearday")) {
                this.mType = ZByType.BY_YEARDAY;
                this.mList = e.getAttribute("yrdaylist", null);
            } else if (ename.equals("byweekno")) {
                this.mType = ZByType.BY_WEEKNO;
                this.mList = e.getAttribute("wklist", null);
            } else if (ename.equals("bymonth")) {
                this.mType = ZByType.BY_MONTH;
                this.mList = e.getAttribute("molist", null);
            } else if (ename.equals("bysetpos")) {
                this.mType = ZByType.BY_SETPOS;
                this.mList = e.getAttribute("poslist", null);
            }
        }

        public Element toElement(Element parent) {
            String elName = null;
            String listName = null;
            switch (this.mType) {
                case BY_SECOND: {
                    elName = "bysecond";
                    listName = "seclist";
                    break;
                }
                case BY_MINUTE: {
                    elName = "byminute";
                    listName = "minlist";
                    break;
                }
                case BY_HOUR: {
                    elName = "byhour";
                    listName = "hrlist";
                    break;
                }
                case BY_DAY: {
                    elName = "byday";
                    break;
                }
                case BY_MONTHDAY: {
                    elName = "bymonthday";
                    listName = "modaylist";
                    break;
                }
                case BY_YEARDAY: {
                    elName = "byyearday";
                    listName = "yrdaylist";
                    break;
                }
                case BY_WEEKNO: {
                    elName = "byweekno";
                    listName = "wklist";
                    break;
                }
                case BY_MONTH: {
                    elName = "bymonth";
                    listName = "molist";
                    break;
                }
                case BY_SETPOS: {
                    elName = "bysetpos";
                    listName = "poslist";
                }
            }
            Element byEl = parent.addElement(elName);
            if (this.mList != null && listName != null) {
                byEl.addAttribute(listName, this.mList);
            }
            if (this.mType == ZByType.BY_DAY && this.mWeekDays != null) {
                for (ZByDayWeekDay wd : this.mWeekDays) {
                    wd.toElement(byEl);
                }
            }
            return byEl;
        }

        public ZByType getType() {
            return this.mType;
        }

        public String getListValue() {
            return this.mList;
        }

        public String[] getList() {
            if (this.mList == null || this.mList.length() == 0) {
                return new String[0];
            }
            return this.mList.split(",");
        }

        public List<ZByDayWeekDay> getByDayWeekDays() {
            return this.mWeekDays;
        }

        @Override
        public ZJSONObject toZJSONObject() throws JSONException {
            ZJSONObject zjo = new ZJSONObject();
            zjo.put("type", this.mType.name());
            zjo.put("list", this.mList);
            zjo.put("weekdays", this.mWeekDays);
            return zjo;
        }

        public String toString() {
            return String.format("[ZByRule]", new Object[0]);
        }

        public String dump() {
            return ZJSONObject.toString(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ZByDayWeekDay
    implements ToZJSONObject {
        private int mWeekOrd;
        private ZWeekDay mDay;

        public static List<ZByDayWeekDay> getList(ZWeekDay ... days) {
            ArrayList<ZByDayWeekDay> result = new ArrayList<ZByDayWeekDay>(days.length);
            for (ZWeekDay day : days) {
                result.add(new ZByDayWeekDay(day, 0));
            }
            return result;
        }

        public static List<ZByDayWeekDay> getList(List<ZWeekDay> days) {
            ArrayList<ZByDayWeekDay> result = new ArrayList<ZByDayWeekDay>(days.size());
            for (ZWeekDay day : days) {
                result.add(new ZByDayWeekDay(day, 0));
            }
            return result;
        }

        public ZByDayWeekDay() {
        }

        public ZByDayWeekDay(ZWeekDay day, int weekOrd) {
            this.mDay = day;
            this.mWeekOrd = weekOrd;
        }

        public ZByDayWeekDay(Element e) throws ServiceException {
            this.mWeekOrd = (int)e.getAttributeLong("ordwk", 0L);
            this.mDay = ZWeekDay.fromString(e.getAttribute("day"));
        }

        public Element toElement(Element parent) {
            Element wkdayEl = parent.addElement("wkday");
            if (this.mWeekOrd != 0) {
                wkdayEl.addAttribute("ordwk", this.mWeekOrd);
            }
            wkdayEl.addAttribute("day", this.mDay.name());
            return wkdayEl;
        }

        public int getWeekOrd() {
            return this.mWeekOrd;
        }

        public void setWeekOrd(int weekOrd) {
            this.mWeekOrd = weekOrd;
        }

        public ZWeekDay getDay() {
            return this.mDay;
        }

        public void setDay(ZWeekDay day) {
            this.mDay = day;
        }

        @Override
        public ZJSONObject toZJSONObject() throws JSONException {
            ZJSONObject zjo = new ZJSONObject();
            zjo.put("weekOrd", this.mWeekOrd);
            zjo.put("day", this.mDay.name());
            return zjo;
        }

        public String toString() {
            return String.format("[ZByDayWeekDay weekOrd=%d day=%s]", new Object[]{this.mWeekOrd, this.mDay});
        }

        public String dump() {
            return ZJSONObject.toString(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ZByType {
        BY_SECOND,
        BY_MINUTE,
        BY_HOUR,
        BY_DAY,
        BY_MONTHDAY,
        BY_YEARDAY,
        BY_WEEKNO,
        BY_MONTH,
        BY_SETPOS;


        public static ZByType fromString(String s) throws ServiceException {
            try {
                return ZByType.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                throw ZClientException.CLIENT_ERROR("invalid by type " + s + ", valid values: " + Arrays.asList(ZByType.values()), e);
            }
        }

        public boolean isBySecond() {
            return this.equals((Object)BY_SECOND);
        }

        public boolean isByMinute() {
            return this.equals((Object)BY_MINUTE);
        }

        public boolean isByHour() {
            return this.equals((Object)BY_HOUR);
        }

        public boolean isByDay() {
            return this.equals((Object)BY_DAY);
        }

        public boolean isByMonthDay() {
            return this.equals((Object)BY_MONTHDAY);
        }

        public boolean isByYearDay() {
            return this.equals((Object)BY_YEARDAY);
        }

        public boolean isByWeekNo() {
            return this.equals((Object)BY_WEEKNO);
        }

        public boolean isByMonth() {
            return this.equals((Object)BY_MONTH);
        }

        public boolean isBySetPos() {
            return this.equals((Object)BY_SETPOS);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ZWeekDay {
        SU,
        MO,
        TU,
        WE,
        TH,
        FR,
        SA;


        public static ZWeekDay fromString(String s) throws ServiceException {
            try {
                return ZWeekDay.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                throw ZClientException.CLIENT_ERROR("invalid weekday " + s + ", valid values: " + Arrays.asList(ZWeekDay.values()), e);
            }
        }

        public int getOrdinal() {
            return this.ordinal();
        }

        public static ZWeekDay fromOrdinal(int ord) throws ServiceException {
            if (ord < 0 || ord >= ZWeekDay.values().length) {
                throw ZClientException.CLIENT_ERROR("invalid weekday ordinal: " + ord, null);
            }
            return ZWeekDay.values()[ord];
        }

        public boolean isSunday() {
            return this.equals((Object)SU);
        }

        public boolean isMonday() {
            return this.equals((Object)MO);
        }

        public boolean isTuesday() {
            return this.equals((Object)TU);
        }

        public boolean isWednesday() {
            return this.equals((Object)WE);
        }

        public boolean isThursday() {
            return this.equals((Object)TH);
        }

        public boolean isFriday() {
            return this.equals((Object)FR);
        }

        public boolean isSaturday() {
            return this.equals((Object)SA);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ZFrequency {
        SEC,
        MIN,
        HOU,
        DAI,
        WEE,
        MON,
        YEA;


        public static ZFrequency fromString(String s) throws ServiceException {
            try {
                return ZFrequency.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                throw ZClientException.CLIENT_ERROR("invalid frequency " + s + ", valid values: " + Arrays.asList(ZFrequency.values()), e);
            }
        }

        public boolean isSecond() {
            return this.equals((Object)SEC);
        }

        public boolean isMinute() {
            return this.equals((Object)MIN);
        }

        public boolean isHour() {
            return this.equals((Object)HOU);
        }

        public boolean isDaily() {
            return this.equals((Object)DAI);
        }

        public boolean isWeek() {
            return this.equals((Object)WEE);
        }

        public boolean isMonth() {
            return this.equals((Object)MON);
        }

        public boolean isYear() {
            return this.equals((Object)YEA);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ZRecurrenceDates
    implements ToZJSONObject {
        private String mTimeZoneId;
        private List<ZRecurrenceDate> mDates;

        public ZRecurrenceDates() {
        }

        public ZRecurrenceDates(Element e) throws ServiceException {
            this.mDates = new ArrayList<ZRecurrenceDate>();
            this.mTimeZoneId = e.getAttribute("tz", null);
            for (Element dtvalEl : e.listElements("dtval")) {
                this.mDates.add(new ZRecurrenceDate(dtvalEl));
            }
        }

        public Element toElement(Element parent) {
            Element datesEl = parent.addElement("dates");
            if (this.mTimeZoneId != null) {
                datesEl.addAttribute("tz", this.mTimeZoneId);
            }
            for (ZRecurrenceDate rdate : this.mDates) {
                rdate.toElement(datesEl);
            }
            return datesEl;
        }

        public String getTimeZoneId() {
            return this.mTimeZoneId;
        }

        public void setTimeZoneId(String timeZoneId) {
            this.mTimeZoneId = timeZoneId;
        }

        public List<ZRecurrenceDate> getDates() {
            return this.mDates;
        }

        public void setDates(List<ZRecurrenceDate> dates) {
            this.mDates = dates;
        }

        @Override
        public ZJSONObject toZJSONObject() throws JSONException {
            ZJSONObject zjo = new ZJSONObject();
            zjo.put("timeZoneId", this.mTimeZoneId);
            zjo.put("dates", this.mDates);
            return zjo;
        }

        public String toString() {
            return String.format("[ZRecurrenceDates]", new Object[0]);
        }

        public String dump() {
            return ZJSONObject.toString(this);
        }
    }

    public static class ZRecurrenceDate
    implements ToZJSONObject {
        private ZDateTime mStart;
        private ZDateTime mEnd;
        private ZDuration mDuration;

        public ZRecurrenceDate() {
        }

        public ZRecurrenceDate(Element e) throws ServiceException {
            Element durEl;
            this.mStart = new ZDateTime(e.getElement("s"));
            Element endEl = e.getOptionalElement("e");
            if (endEl != null) {
                this.mEnd = new ZDateTime(endEl);
            }
            if ((durEl = e.getOptionalElement("dur")) != null) {
                this.mDuration = new ZDuration(durEl);
            }
        }

        public Element toElement(Element parent) {
            Element dtvalEl = parent.addElement("dtval");
            this.mStart.toElement("s", dtvalEl);
            if (this.mEnd != null) {
                this.mEnd.toElement("e", dtvalEl);
            } else if (this.mDuration != null) {
                this.mDuration.toElement(dtvalEl);
            }
            return dtvalEl;
        }

        public ZDateTime getStart() {
            return this.mStart;
        }

        public void setStart(ZDateTime start) {
            this.mStart = start;
        }

        public ZDateTime getEnd() {
            return this.mEnd;
        }

        public void setEnd(ZDateTime end) {
            this.mEnd = end;
        }

        public ZDuration getDuration() {
            return this.mDuration;
        }

        public void setDuration(ZDuration duration) {
            this.mDuration = duration;
        }

        public ZJSONObject toZJSONObject() throws JSONException {
            ZJSONObject zjo = new ZJSONObject();
            zjo.put("start", this.mStart);
            zjo.put("end", this.mEnd);
            zjo.put("duration", this.mDuration);
            return zjo;
        }

        public String toString() {
            return String.format("[ZRecurrenceDate]", new Object[0]);
        }

        public String dump() {
            return ZJSONObject.toString(this);
        }
    }

    public static class ZAttendee
    extends ZCalendarUser
    implements ToZJSONObject {
        private ZRole mRole;
        private ZParticipantStatus mParticipantStatus;
        private boolean mRSVP;
        private ZCalendarUserType mCalendarUserType;
        private String mMember;
        private String mDelegatedTo;
        private String mDelegatedFrom;

        public ZAttendee() {
        }

        public ZAttendee(Element e) throws ServiceException {
            super(e);
            this.mRole = ZRole.fromString(e.getAttribute("role", ZRole.OPT.name()));
            this.mParticipantStatus = ZParticipantStatus.fromString(e.getAttribute("ptst", ZParticipantStatus.AC.name()));
            this.mRSVP = e.getAttributeBool("rsvp", false);
            this.mCalendarUserType = ZCalendarUserType.fromString(e.getAttribute("cutype", ZCalendarUserType.IND.name()));
            this.mMember = e.getAttribute("member", null);
            this.mDelegatedTo = e.getAttribute("delTo", null);
            this.mDelegatedFrom = e.getAttribute("delFrom", null);
        }

        public Element toElement(Element parent) {
            Element attEl = parent.addElement("at");
            if (this.getAddress() != null) {
                attEl.addAttribute("a", this.getAddress());
            }
            if (this.getUrl() != null) {
                attEl.addAttribute("url", this.getUrl());
            }
            if (this.getPersonalName() != null) {
                attEl.addAttribute("d", this.getPersonalName());
            }
            if (this.getSentBy() != null) {
                attEl.addAttribute("sentBy", this.getSentBy());
            }
            if (this.getDirectoryUrl() != null) {
                attEl.addAttribute("dir", this.getDirectoryUrl());
            }
            if (this.getLanguage() != null) {
                attEl.addAttribute("lang", this.getLanguage());
            }
            if (this.mRole != null) {
                attEl.addAttribute("role", this.mRole.name());
            }
            if (this.mParticipantStatus != null) {
                attEl.addAttribute("ptst", this.mParticipantStatus.name());
            }
            if (this.mRSVP) {
                attEl.addAttribute("rsvp", this.mRSVP);
            }
            if (this.mCalendarUserType != null && this.mCalendarUserType != ZCalendarUserType.IND) {
                attEl.addAttribute("cutype", this.mCalendarUserType.name());
            }
            if (this.mMember != null) {
                attEl.addAttribute("member", this.mMember);
            }
            if (this.mDelegatedTo != null) {
                attEl.addAttribute("delTo", this.mDelegatedTo);
            }
            if (this.mDelegatedFrom != null) {
                attEl.addAttribute("delFrom", this.mDelegatedFrom);
            }
            ToXML.encodeXParams(attEl, this.xparamsIterator());
            return attEl;
        }

        public ZRole getRole() {
            return this.mRole;
        }

        public void setRole(ZRole role) {
            this.mRole = role;
        }

        public ZParticipantStatus getParticipantStatus() {
            return this.mParticipantStatus;
        }

        public void setParticipantStatus(ZParticipantStatus participantStatus) {
            this.mParticipantStatus = participantStatus;
        }

        public boolean isRSVP() {
            return this.mRSVP;
        }

        public void setRSVP(boolean RSVP) {
            this.mRSVP = RSVP;
        }

        public ZCalendarUserType getCalendarUserType() {
            return this.mCalendarUserType;
        }

        public void setCalendarUserType(ZCalendarUserType calendarUserType) {
            this.mCalendarUserType = calendarUserType;
        }

        public String getMember() {
            return this.mMember;
        }

        public void setMember(String member) {
            this.mMember = member;
        }

        public String getDelegatedTo() {
            return this.mDelegatedTo;
        }

        public void setDelegatedTo(String delegatedTo) {
            this.mDelegatedTo = delegatedTo;
        }

        public String getDelegatedFrom() {
            return this.mDelegatedFrom;
        }

        public void setDelegatedFrom(String delegatedFrom) {
            this.mDelegatedFrom = delegatedFrom;
        }

        public ZJSONObject toZJSONObject() throws JSONException {
            ZJSONObject zjo = super.toZJSONObject();
            zjo.put("role", this.mRole.name());
            zjo.put("participantStatus", this.mParticipantStatus.name());
            zjo.put("rsvp", this.mRSVP);
            zjo.put("calendarUserType", this.mCalendarUserType.name());
            zjo.put("member", this.mMember);
            zjo.put("delegatedFrom", this.mDelegatedFrom);
            zjo.put("delegatedTo", this.mDelegatedTo);
            return zjo;
        }

        public String toString() {
            return String.format("[ZAttendee %s]", this.getAddress());
        }

        public String dump() {
            return ZJSONObject.toString(this);
        }
    }

    public static class ZOrganizer
    extends ZCalendarUser {
        public ZOrganizer() {
        }

        public ZOrganizer(String address) {
            this.setAddress(address);
        }

        public ZOrganizer(Element e) throws ServiceException {
            super(e);
        }

        public Element toElement(Element parent) {
            Element orEl = parent.addElement("or");
            if (this.getAddress() != null) {
                orEl.addAttribute("a", this.getAddress());
            }
            if (this.getUrl() != null) {
                orEl.addAttribute("url", this.getUrl());
            }
            if (this.getPersonalName() != null) {
                orEl.addAttribute("d", this.getPersonalName());
            }
            if (this.getSentBy() != null) {
                orEl.addAttribute("sentBy", this.getSentBy());
            }
            if (this.getDirectoryUrl() != null) {
                orEl.addAttribute("dir", this.getDirectoryUrl());
            }
            if (this.getLanguage() != null) {
                orEl.addAttribute("lang", this.getLanguage());
            }
            ToXML.encodeXParams(orEl, this.xparamsIterator());
            return orEl;
        }

        public String toString() {
            return String.format("[ZOrganizer %s]", this.getAddress());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ZCalendarUser
    implements ToZJSONObject {
        private String mAddress;
        private String mUrl;
        private String mPersonalName;
        private String mSentBy;
        private String mDirectoryUrl;
        private String mLanguage;
        private List<ZCalendar.ZParameter> mXParams;

        public ZCalendarUser() {
            this.mXParams = new ArrayList<ZCalendar.ZParameter>();
        }

        public ZCalendarUser(Element e) throws ServiceException {
            this.mAddress = e.getAttribute("a", null);
            this.mUrl = e.getAttribute("url", null);
            this.mPersonalName = e.getAttribute("d", null);
            this.mSentBy = e.getAttribute("sentBy", null);
            this.mDirectoryUrl = e.getAttribute("dir", null);
            this.mLanguage = e.getAttribute("lang", null);
            this.mXParams = CalendarUtils.parseXParams(e);
        }

        public String getAddress() {
            return this.mAddress;
        }

        public ZEmailAddress getEmailAddress() {
            return new ZEmailAddress(this.mAddress, null, this.mPersonalName, "t");
        }

        public void setAddress(String address) {
            this.mAddress = address;
        }

        public String getUrl() {
            return this.mUrl;
        }

        public void setUrl(String url) {
            this.mUrl = url;
        }

        public String getPersonalName() {
            return this.mPersonalName;
        }

        public void setPersonalName(String personalName) {
            this.mPersonalName = personalName;
        }

        public String getSentBy() {
            return this.mSentBy;
        }

        public void setSentBy(String sentBy) {
            this.mSentBy = sentBy;
        }

        public String getDirectoryUrl() {
            return this.mDirectoryUrl;
        }

        public void setDirectoryUrl(String dir) {
            this.mDirectoryUrl = dir;
        }

        public String getLanguage() {
            return this.mLanguage;
        }

        public void setLanguage(String language) {
            this.mLanguage = language;
        }

        public Iterator<ZCalendar.ZParameter> xparamsIterator() {
            return this.mXParams.iterator();
        }

        @Override
        public ZJSONObject toZJSONObject() throws JSONException {
            ZJSONObject zjo = new ZJSONObject();
            zjo.put("address", this.mAddress);
            zjo.put("url", this.mUrl);
            zjo.put("personalName", this.mPersonalName);
            zjo.put("sentBy", this.mSentBy);
            zjo.put("dir", this.mDirectoryUrl);
            zjo.put("language", this.mLanguage);
            return zjo;
        }

        public String toString() {
            return String.format("[ZCalendarUser %s]", this.mAddress);
        }

        public String dump() {
            return ZJSONObject.toString(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ZCalendarUserType {
        IND,
        GRO,
        RES,
        ROO,
        UNK;


        public static ZCalendarUserType fromString(String s) throws ServiceException {
            try {
                return ZCalendarUserType.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                throw ZClientException.CLIENT_ERROR("invalid role " + s + ", valid values: " + Arrays.asList(ZCalendarUserType.values()), e);
            }
        }

        public boolean isIndividual() {
            return this.equals((Object)IND);
        }

        public boolean isGroup() {
            return this.equals((Object)GRO);
        }

        public boolean isResource() {
            return this.equals((Object)RES);
        }

        public boolean isRoom() {
            return this.equals((Object)ROO);
        }

        public boolean isUnknown() {
            return this.equals((Object)UNK);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ZRole {
        CHA,
        REQ,
        OPT,
        NON;


        public static ZRole fromString(String s) throws ServiceException {
            try {
                return ZRole.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                throw ZClientException.CLIENT_ERROR("invalid role " + s + ", valid values: " + Arrays.asList(ZRole.values()), e);
            }
        }

        public boolean isChair() {
            return this.equals((Object)CHA);
        }

        public boolean isRequired() {
            return this.equals((Object)REQ);
        }

        public boolean isOptional() {
            return this.equals((Object)OPT);
        }

        public boolean isNonParticipant() {
            return this.equals((Object)NON);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ZTransparency {
        O,
        T;


        public static ZTransparency fromString(String s) throws ServiceException {
            try {
                return ZTransparency.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                throw ZClientException.CLIENT_ERROR("invalid transparency " + s + ", valid values: " + Arrays.asList(ZTransparency.values()), e);
            }
        }

        public boolean isTransparent() {
            return this.equals((Object)T);
        }

        public boolean isOpaque() {
            return this.equals((Object)O);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ZParticipantStatus {
        AC,
        DE,
        TE,
        NE,
        DG;


        public static ZParticipantStatus fromString(String s) throws ServiceException {
            try {
                return ZParticipantStatus.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                throw ZClientException.CLIENT_ERROR("invalid participant status " + s + ", valid values: " + Arrays.asList(ZParticipantStatus.values()), e);
            }
        }

        public boolean isAccepted() {
            return this.equals((Object)AC);
        }

        public boolean isDeclined() {
            return this.equals((Object)DE);
        }

        public boolean isTentative() {
            return this.equals((Object)TE);
        }

        public boolean isNew() {
            return this.equals((Object)NE);
        }

        public boolean isDelegated() {
            return this.equals((Object)DG);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ZFreeBusyStatus {
        F,
        B,
        T,
        O;


        public static ZFreeBusyStatus fromString(String s) throws ServiceException {
            try {
                return ZFreeBusyStatus.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                throw ZClientException.CLIENT_ERROR("invalid free busy status " + s + ", valid values: " + Arrays.asList(ZFreeBusyStatus.values()), e);
            }
        }

        public boolean isFree() {
            return this.equals((Object)F);
        }

        public boolean isBusy() {
            return this.equals((Object)B);
        }

        public boolean isTentative() {
            return this.equals((Object)T);
        }

        public boolean isOutOfOffice() {
            return this.equals((Object)O);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ZClass {
        PUB,
        PRI,
        CON;


        public static ZClass fromString(String s) throws ServiceException {
            try {
                return ZClass.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                throw ZClientException.CLIENT_ERROR("invalid class " + s + ", valid values: " + Arrays.asList(ZClass.values()), e);
            }
        }

        public boolean isPublic() {
            return this.equals((Object)PUB);
        }

        public boolean isPrivate() {
            return this.equals((Object)PRI);
        }

        public boolean isConfidential() {
            return this.equals((Object)CON);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ZStatus {
        TENT,
        CONF,
        CANC,
        NEED,
        COMP,
        INPR,
        WAITING,
        DEFERRED;


        public static ZStatus fromString(String s) throws ServiceException {
            try {
                return ZStatus.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                throw ZClientException.CLIENT_ERROR("invalid status " + s + ", valid values: " + Arrays.asList(ZStatus.values()), e);
            }
        }

        public boolean isTentative() {
            return this.equals((Object)TENT);
        }

        public boolean isConfirmed() {
            return this.equals((Object)CONF);
        }

        public boolean isCancelled() {
            return this.equals((Object)CANC);
        }

        public boolean isNeedsAction() {
            return this.equals((Object)NEED);
        }

        public boolean isCompleted() {
            return this.equals((Object)COMP);
        }

        public boolean isInProgress() {
            return this.equals((Object)INPR);
        }

        public boolean isWaiting() {
            return this.equals((Object)WAITING);
        }

        public boolean isDeferred() {
            return this.equals((Object)DEFERRED);
        }
    }

    public static class ZDuration
    implements ToZJSONObject {
        private boolean mNegative;
        private int mWeeks;
        private int mDays;
        private int mHours;
        private int mMinutes;
        private int mSeconds;

        public ZDuration() {
        }

        public ZDuration(Element e) throws ServiceException {
            this.mNegative = e.getAttributeBool("neg", false);
            this.mWeeks = (int)e.getAttributeLong("w", 0L);
            this.mDays = (int)e.getAttributeLong("d", 0L);
            this.mHours = (int)e.getAttributeLong("h", 0L);
            this.mMinutes = (int)e.getAttributeLong("m", 0L);
            this.mSeconds = (int)e.getAttributeLong("s", 0L);
        }

        Date addToDate(Date date) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            int mult = this.mNegative ? -1 : 1;
            cal.add(3, mult * this.mWeeks);
            cal.add(6, mult * this.mDays);
            cal.add(11, mult * this.mHours);
            cal.add(12, mult * this.mMinutes);
            cal.add(13, mult * this.mSeconds);
            return cal.getTime();
        }

        public long addToTime(long utcTime) {
            return this.addToDate(new Date(utcTime)).getTime();
        }

        public Element toElement(Element parent) {
            Element durEl = parent.addElement("dur");
            durEl.addAttribute("neg", this.mNegative);
            if (this.mWeeks != 0) {
                durEl.addAttribute("w", this.mWeeks);
            } else {
                if (this.mDays != 0) {
                    durEl.addAttribute("d", this.mDays);
                }
                if (this.mHours != 0) {
                    durEl.addAttribute("h", this.mHours);
                }
                if (this.mMinutes != 0) {
                    durEl.addAttribute("m", this.mMinutes);
                }
                if (this.mSeconds != 0) {
                    durEl.addAttribute("s", this.mSeconds);
                }
            }
            return durEl;
        }

        public boolean isNegative() {
            return this.mNegative;
        }

        public void setNegative(boolean negative) {
            this.mNegative = negative;
        }

        public int getWeeks() {
            return this.mWeeks;
        }

        public void setWeeks(int weeks) {
            this.mWeeks = weeks;
        }

        public int getDays() {
            return this.mDays;
        }

        public void setDays(int days) {
            this.mDays = days;
        }

        public int getHours() {
            return this.mHours;
        }

        public void setHours(int hours) {
            this.mHours = hours;
        }

        public int getMinutes() {
            return this.mMinutes;
        }

        public void setMinutes(int minutes) {
            this.mMinutes = minutes;
        }

        public int getSeconds() {
            return this.mSeconds;
        }

        public void setSeconds(int seconds) {
            this.mSeconds = seconds;
        }

        public ZJSONObject toZJSONObject() throws JSONException {
            ZJSONObject zjo = new ZJSONObject();
            zjo.put("negative", this.mNegative);
            zjo.put("weeks", this.mWeeks);
            zjo.put("days", this.mDays);
            zjo.put("hours", this.mHours);
            zjo.put("minutes", this.mMinutes);
            zjo.put("seconds", this.mSeconds);
            return zjo;
        }

        public String toString() {
            return "[ZDuration]";
        }

        public String dump() {
            return ZJSONObject.toString(this);
        }
    }

    public static class ZTimeZone
    implements ToZJSONObject {
        private String mId;
        private long mStandardOffset;
        private long mDaylightSavingsOffset;
        private ZTransitionRule mStandard;
        private ZTransitionRule mDaylight;
        private String mStandardTzname;
        private String mDaylightTzname;

        public ZTimeZone() {
        }

        public ZTimeZone(Element e) throws ServiceException {
            Element daylightEl;
            this.mId = e.getAttribute("id");
            this.mStandardTzname = e.getAttribute("stdname", null);
            this.mDaylightTzname = e.getAttribute("dayname", null);
            this.mStandardOffset = e.getAttributeLong("stdoff", 0L);
            this.mDaylightSavingsOffset = e.getAttributeLong("dayoff", -1L);
            Element standardEl = e.getOptionalElement("standard");
            if (standardEl != null) {
                this.mStandard = new ZTransitionRule(standardEl);
            }
            if ((daylightEl = e.getOptionalElement("daylight")) != null) {
                this.mDaylight = new ZTransitionRule(daylightEl);
            }
        }

        public Element toElement(Element parent) {
            Element tzEl = parent.addElement("tz");
            tzEl.addAttribute("id", this.mId);
            tzEl.addAttribute("stdname", this.mStandardTzname);
            tzEl.addAttribute("dayname", this.mDaylightTzname);
            tzEl.addAttribute("stdoff", this.mStandardOffset);
            if (this.mDaylightSavingsOffset != -1L) {
                tzEl.addAttribute("dayoff", this.mDaylightSavingsOffset);
            }
            if (this.mStandard != null) {
                this.mStandard.toElement("standard", tzEl);
            }
            if (this.mDaylight != null) {
                this.mDaylight.toElement("daylight", tzEl);
            }
            return tzEl;
        }

        public long getDaylightSavingsOffset() {
            return this.mDaylightSavingsOffset;
        }

        public long getStandardOffset() {
            return this.mStandardOffset;
        }

        public String getId() {
            return this.mId;
        }

        public String getStandardTzname() {
            return this.mStandardTzname;
        }

        public String getDaylightTzname() {
            return this.mDaylightTzname;
        }

        public ZTransitionRule getStandardRule() {
            return this.mStandard;
        }

        public ZTransitionRule getDaylightRule() {
            return this.mDaylight;
        }

        public void setId(String id) {
            this.mId = id;
        }

        public void setStandardTzname(String name) {
            this.mStandardTzname = name;
        }

        public void setDaylightTzname(String name) {
            this.mDaylightTzname = name;
        }

        public void setStandardOffset(long standardOffset) {
            this.mStandardOffset = standardOffset;
        }

        public void setDaylightSavingsOffset(long daylightSavingsOffset) {
            this.mDaylightSavingsOffset = daylightSavingsOffset;
        }

        public void setStandard(ZTransitionRule standard) {
            this.mStandard = standard;
        }

        public void setDaylight(ZTransitionRule daylight) {
            this.mDaylight = daylight;
        }

        public ZJSONObject toZJSONObject() throws JSONException {
            ZJSONObject zjo = new ZJSONObject();
            zjo.put("id", this.mId);
            zjo.put("standardOffset", this.mStandardOffset);
            zjo.put("daylightOffset", this.mDaylightSavingsOffset);
            zjo.put("standardRule", this.mStandard);
            zjo.put("daylightRule", this.mDaylight);
            zjo.put("standardTzname", this.mStandardTzname);
            zjo.put("daylightTzname", this.mDaylightTzname);
            return zjo;
        }

        public String toString() {
            return String.format("[ZTimeZone %s]", this.mId);
        }

        public String dump() {
            return ZJSONObject.toString(this);
        }

        public static class ZTransitionRule
        implements ToZJSONObject {
            private int mWeek;
            private int mDayOfWeek;
            private int mMonth;
            private int mDayOfMonth;
            private int mHour;
            private int mMinute;
            private int mSecond;

            public ZTransitionRule() {
            }

            public ZTransitionRule(Element e) throws ServiceException {
                this.mWeek = (int)e.getAttributeLong("week", 0L);
                this.mDayOfWeek = (int)e.getAttributeLong("wkday", 0L);
                this.mDayOfMonth = (int)e.getAttributeLong("mday", 0L);
                this.mMonth = (int)e.getAttributeLong("mon", 0L);
                this.mHour = (int)e.getAttributeLong("hour", 0L);
                this.mMinute = (int)e.getAttributeLong("min", 0L);
                this.mSecond = (int)e.getAttributeLong("sec", 0L);
            }

            public Element toElement(String name, Element parent) {
                Element trEl = parent.addElement(name);
                if (this.mWeek != 0) {
                    trEl.addAttribute("week", this.mWeek);
                }
                if (this.mDayOfWeek != 0) {
                    trEl.addAttribute("wkday", this.mDayOfWeek);
                }
                if (this.mDayOfMonth != 0) {
                    trEl.addAttribute("mday", this.mMonth);
                }
                trEl.addAttribute("mon", this.mMonth);
                trEl.addAttribute("hour", this.mHour);
                trEl.addAttribute("min", this.mMinute);
                trEl.addAttribute("sec", this.mSecond);
                return trEl;
            }

            public int getWeek() {
                return this.mWeek;
            }

            public void setWeek(int week) {
                this.mWeek = week;
            }

            public int getDayOfWeek() {
                return this.mDayOfWeek;
            }

            public void setDayOfWeek(int dayOfWeek) {
                this.mDayOfWeek = dayOfWeek;
            }

            public int getMonth() {
                return this.mMonth;
            }

            public void setMonth(int month) {
                this.mMonth = month;
            }

            public int getDayOfMonth() {
                return this.mDayOfMonth;
            }

            public void setDayOfMonth(int dayOfMonth) {
                this.mDayOfMonth = dayOfMonth;
            }

            public int getHour() {
                return this.mHour;
            }

            public void setHour(int hour) {
                this.mHour = hour;
            }

            public int getMinute() {
                return this.mMinute;
            }

            public void setMinute(int minute) {
                this.mMinute = minute;
            }

            public int getSecond() {
                return this.mSecond;
            }

            public void setSecond(int second) {
                this.mSecond = second;
            }

            public ZJSONObject toZJSONObject() throws JSONException {
                ZJSONObject zjo = new ZJSONObject();
                zjo.put("week", this.mWeek);
                zjo.put("dayOfWeek", this.mDayOfWeek);
                zjo.put("dayOfMonth", this.mDayOfMonth);
                zjo.put("month", this.mMonth);
                zjo.put("hour", this.mHour);
                zjo.put("minute", this.mMinute);
                zjo.put("second", this.mSecond);
                return zjo;
            }

            public String toString() {
                return "[ZTransitionRule]";
            }

            public String dump() {
                return ZJSONObject.toString(this);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ZComponent
    implements ToZJSONObject {
        private ZStatus mStatus;
        private ZClass mClass;
        private ZFreeBusyStatus mFreeBusyStatus;
        private ZFreeBusyStatus mActualFreeBusyStatus;
        private ZTransparency mTransparency;
        private boolean mIsAllDay;
        private String mName;
        private String mLocation;
        private List<String> mCategories;
        private List<String> mComments;
        private List<String> mContacts;
        private Geo mGeo;
        private String mUrl;
        private boolean mIsException;
        private boolean mIsOrganizer;
        private long mSequenceNumber;
        private String mPriority;
        private String mPercentCompleted;
        private String mCompleted;
        private List<ZReply> mReplies;
        private ZDateTime mStart;
        private ZDateTime mEnd;
        private ZDuration mDuration;
        private ZOrganizer mOrganizer;
        private List<ZAttendee> mAttendees;
        private ZRecurrence mRecurrence;
        private String mComponentNum;
        private List<ZAlarm> mAlarms;
        private String mRecurrenceIdZ;
        private String mDescription;
        private String mDescriptionHtml;
        private boolean mIsNoBlob;

        public ZComponent() {
            this.mStatus = ZStatus.CONF;
            this.mClass = ZClass.PUB;
            this.mFreeBusyStatus = ZFreeBusyStatus.B;
            this.mTransparency = ZTransparency.O;
            this.mReplies = new ArrayList<ZReply>();
            this.mAttendees = new ArrayList<ZAttendee>();
            this.mAlarms = new ArrayList<ZAlarm>();
        }

        public ZComponent(Element e) throws ServiceException {
            Element alarmEl;
            Element orEl;
            Element durEl;
            Element endEl;
            Element startEl;
            Element geoElem;
            Iterator<Element> cnIter;
            Iterator<Element> cmtIter;
            this.mStatus = ZStatus.fromString(e.getAttribute("status", ZStatus.CONF.name()));
            this.mClass = ZClass.fromString(e.getAttribute("class", ZClass.PUB.name()));
            this.mFreeBusyStatus = ZFreeBusyStatus.fromString(e.getAttribute("fb", ZFreeBusyStatus.B.name()));
            this.mActualFreeBusyStatus = ZFreeBusyStatus.fromString(e.getAttribute("fba", ZFreeBusyStatus.B.name()));
            this.mTransparency = ZTransparency.fromString(e.getAttribute("transp", "O"));
            this.mIsAllDay = e.getAttributeBool("allDay", false);
            this.mName = e.getAttribute("name", null);
            this.mLocation = e.getAttribute("loc", null);
            Iterator<Element> catIter = e.elementIterator("category");
            if (catIter.hasNext()) {
                ArrayList<String> categories = new ArrayList<String>();
                while (catIter.hasNext()) {
                    String cat = catIter.next().getTextTrim();
                    categories.add(cat);
                }
                this.mCategories = categories;
            }
            if ((cmtIter = e.elementIterator("comment")).hasNext()) {
                ArrayList<String> comments = new ArrayList<String>();
                while (cmtIter.hasNext()) {
                    String cmt = cmtIter.next().getTextTrim();
                    comments.add(cmt);
                }
                this.mComments = comments;
            }
            if ((cnIter = e.elementIterator("contact")).hasNext()) {
                ArrayList<String> contacts = new ArrayList<String>();
                while (cnIter.hasNext()) {
                    String cn = cnIter.next().getTextTrim();
                    contacts.add(cn);
                }
                this.mContacts = contacts;
            }
            if ((geoElem = e.getOptionalElement("geo")) != null) {
                this.mGeo = Geo.parse(geoElem);
            }
            this.mUrl = e.getAttribute("url", null);
            this.mIsException = e.getAttributeBool("ex", false);
            this.mIsOrganizer = e.getAttributeBool("isOrg", false);
            this.mSequenceNumber = e.getAttributeLong("seq", 0L);
            this.mPriority = e.getAttribute("priority", "0");
            this.mPercentCompleted = e.getAttribute("percentComplete", "0");
            this.mCompleted = e.getAttribute("completed", null);
            this.mComponentNum = e.getAttribute("compNum", "0");
            this.mReplies = new ArrayList<ZReply>();
            this.mAlarms = new ArrayList<ZAlarm>();
            Element repliesEl = e.getOptionalElement("replies");
            if (repliesEl != null) {
                for (Element replyEl : repliesEl.listElements("reply")) {
                    this.mReplies.add(new ZReply(replyEl));
                }
            }
            if ((startEl = e.getOptionalElement("s")) != null) {
                this.mStart = new ZDateTime(startEl);
            }
            if ((endEl = e.getOptionalElement("e")) != null) {
                this.mEnd = new ZDateTime(endEl);
            }
            if ((durEl = e.getOptionalElement("dur")) != null) {
                this.mDuration = new ZDuration(durEl);
            }
            if ((orEl = e.getOptionalElement("or")) != null) {
                this.mOrganizer = new ZOrganizer(orEl);
            }
            this.mAttendees = new ArrayList<ZAttendee>();
            for (Element attendeeEl : e.listElements("at")) {
                this.mAttendees.add(new ZAttendee(attendeeEl));
            }
            this.mRecurrenceIdZ = e.getAttribute("ridZ", null);
            Element recurEl = e.getOptionalElement("recur");
            if (recurEl != null) {
                this.mRecurrence = new ZRecurrence(recurEl);
            }
            if ((alarmEl = e.getOptionalElement("alarm")) != null) {
                for (Element alarm : e.listElements("alarm")) {
                    this.mAlarms.add(new ZAlarm(alarm));
                }
            }
            this.mIsNoBlob = e.getAttributeBool("noBlob", false);
            Element descEl = e.getOptionalElement("desc");
            this.mDescription = descEl != null ? descEl.getText() : null;
            Element descHtmlElem = e.getOptionalElement("descHtml");
            this.mDescriptionHtml = descHtmlElem != null ? descHtmlElem.getText() : null;
        }

        public Element toElement(Element parent) {
            Element compEl = parent.addElement("comp");
            if (this.mStatus != null) {
                compEl.addAttribute("status", this.mStatus.name());
            }
            if (this.mClass != null) {
                compEl.addAttribute("class", this.mClass.name());
            }
            if (this.mFreeBusyStatus != null) {
                compEl.addAttribute("fb", this.mFreeBusyStatus.name());
            }
            if (this.mActualFreeBusyStatus != null) {
                compEl.addAttribute("fba", this.mActualFreeBusyStatus.name());
            }
            if (this.mTransparency != null) {
                compEl.addAttribute("transp", this.mTransparency.name());
            }
            if (this.mIsAllDay) {
                compEl.addAttribute("allDay", this.mIsAllDay);
            }
            if (this.mName != null) {
                compEl.addAttribute("name", this.mName);
            }
            if (this.mLocation != null) {
                compEl.addAttribute("loc", this.mLocation);
            }
            if (this.mCategories != null) {
                for (String cat : this.mCategories) {
                    compEl.addElement("category").setText(cat);
                }
            }
            if (this.mComments != null) {
                for (String cmt : this.mComments) {
                    compEl.addElement("comment").setText(cmt);
                }
            }
            if (this.mContacts != null) {
                for (String cn : this.mContacts) {
                    compEl.addElement("contact").setText(cn);
                }
            }
            if (this.mGeo != null) {
                this.mGeo.toXml(compEl);
            }
            if (this.mUrl != null) {
                compEl.addAttribute("url", this.mUrl);
            }
            if (this.mIsOrganizer) {
                compEl.addAttribute("isOrg", this.mIsOrganizer);
            }
            if (this.mSequenceNumber > 0L) {
                compEl.addAttribute("seq", this.mSequenceNumber);
            }
            if (this.mPriority != null) {
                compEl.addAttribute("priority", this.mPriority);
            }
            if (this.mPercentCompleted != null) {
                compEl.addAttribute("percentComplete", this.mPercentCompleted);
            }
            if (this.mCompleted != null) {
                compEl.addAttribute("completed", this.mCompleted);
            }
            if (this.mReplies != null && !this.mReplies.isEmpty()) {
                Element repliesEl = compEl.addElement("replies");
                for (ZReply reply : this.mReplies) {
                    reply.toElement(repliesEl);
                }
            }
            if (this.mStart != null) {
                this.mStart.toElement("s", compEl);
            }
            if (this.mEnd != null) {
                this.mEnd.toElement("e", compEl);
            } else if (this.mDuration != null) {
                this.mDuration.toElement(compEl);
            }
            if (this.mOrganizer != null) {
                this.mOrganizer.toElement(compEl);
            }
            if (this.mAttendees != null && !this.mAttendees.isEmpty()) {
                for (ZAttendee attendee : this.mAttendees) {
                    attendee.toElement(compEl);
                }
            }
            if (this.mRecurrence != null) {
                this.mRecurrence.toElement(compEl);
            }
            for (ZAlarm alarm : this.mAlarms) {
                alarm.toElement(compEl);
            }
            return compEl;
        }

        public ZRecurrence getRecurrence() {
            return this.mRecurrence;
        }

        public ZSimpleRecurrence getSimpleRecurrence() {
            return new ZSimpleRecurrence(this.mRecurrence);
        }

        public void setRecurrence(ZRecurrence recurrence) {
            this.mRecurrence = recurrence;
        }

        public ZStatus getStatus() {
            return this.mStatus;
        }

        public void setStatus(ZStatus status) {
            this.mStatus = status;
        }

        public ZClass getClassProp() {
            return this.mClass;
        }

        public void setClassProp(ZClass cl) {
            this.mClass = cl;
        }

        public ZFreeBusyStatus getFreeBusyStatus() {
            return this.mFreeBusyStatus;
        }

        public void setFreeBusyStatus(ZFreeBusyStatus freeBusyStatus) {
            this.mFreeBusyStatus = freeBusyStatus;
        }

        public ZFreeBusyStatus getActualFreeBusyStatus() {
            return this.mActualFreeBusyStatus;
        }

        public void setActualFreeBusyStatus(ZFreeBusyStatus actualFreeBusyStatus) {
            this.mActualFreeBusyStatus = actualFreeBusyStatus;
        }

        public ZTransparency getTransparency() {
            return this.mTransparency;
        }

        public void setTransparency(ZTransparency transparency) {
            this.mTransparency = transparency;
        }

        public boolean isAllDay() {
            return this.mIsAllDay;
        }

        public void setIsAllDay(boolean isAllDay) {
            this.mIsAllDay = isAllDay;
        }

        public String getName() {
            return this.mName;
        }

        public void setName(String name) {
            this.mName = name;
        }

        public String getLocation() {
            return this.mLocation;
        }

        public void setLocation(String location) {
            this.mLocation = location;
        }

        public List<String> getCategories() {
            return this.mCategories;
        }

        public void setCategories(List<String> categories) {
            this.mCategories = categories;
        }

        public List<String> getComments() {
            return this.mComments;
        }

        public void setComments(List<String> comments) {
            this.mComments = comments;
        }

        public List<String> getContacts() {
            return this.mContacts;
        }

        public void setContacts(List<String> contacts) {
            this.mContacts = contacts;
        }

        public Geo getGeo() {
            return this.mGeo;
        }

        public void setGeo(Geo geo) {
            this.mGeo = geo;
        }

        public String getUrl() {
            return this.mUrl;
        }

        public void setUrl(String url) {
            this.mUrl = url;
        }

        public boolean isException() {
            return this.mIsException;
        }

        public boolean getIsOrganizer() {
            return this.mIsOrganizer;
        }

        public void setIsOrganizer(boolean isOrganizer) {
            this.mIsOrganizer = isOrganizer;
        }

        public long getSequenceNumber() {
            return this.mSequenceNumber;
        }

        public void setSequenceNumber(long sequenceNumber) {
            this.mSequenceNumber = sequenceNumber;
        }

        public String getPriority() {
            return this.mPriority;
        }

        public void setPriority(String priority) {
            this.mPriority = priority;
        }

        public String getPercentCompleted() {
            return this.mPercentCompleted;
        }

        public void setPercentCompleted(String percentCompleted) {
            this.mPercentCompleted = percentCompleted;
        }

        public String getCompleted() {
            return this.mCompleted;
        }

        public void setCompleted(String completed) {
            this.mCompleted = completed;
        }

        public List<ZReply> getReplies() {
            return this.mReplies;
        }

        public void setReplies(List<ZReply> replies) {
            this.mReplies = replies;
        }

        public ZDateTime getStart() {
            return this.mStart;
        }

        public void setStart(ZDateTime start) {
            this.mStart = start;
        }

        public Date getComputedEndDate() {
            if (this.getEnd() != null) {
                return this.getEnd().getDate();
            }
            if (this.getDuration() != null) {
                return this.getDuration().addToDate(this.getStart().getDate());
            }
            return this.getStart().getDate();
        }

        public ZDateTime getEnd() {
            return this.mEnd;
        }

        public void setEnd(ZDateTime end) {
            this.mEnd = end;
        }

        public ZDuration getDuration() {
            return this.mDuration;
        }

        public void setDuration(ZDuration duration) {
            this.mDuration = duration;
        }

        public ZOrganizer getOrganizer() {
            return this.mOrganizer;
        }

        public void setOrganizer(ZOrganizer organizer) {
            this.mOrganizer = organizer;
        }

        public List<ZAttendee> getAttendees() {
            return this.mAttendees;
        }

        public void setAttendees(List<ZAttendee> attendees) {
            this.mAttendees = attendees;
        }

        public void setComponentNumber(String compNum) {
            this.mComponentNum = compNum;
        }

        public String getComponentNumber() {
            return this.mComponentNum;
        }

        public List<ZAlarm> getAlarms() {
            return this.mAlarms;
        }

        public void setAlarms(List<ZAlarm> alarms) {
            this.mAlarms = alarms;
        }

        public void addAlarm(ZAlarm alarm) {
            this.mAlarms.add(alarm);
        }

        public String getRecurrenceIdZ() {
            return this.mRecurrenceIdZ;
        }

        public String getDescription() {
            return this.mDescription;
        }

        public void setDescription(String desc) {
            this.mDescription = desc;
        }

        public String getDescriptionHtml() {
            return this.mDescriptionHtml;
        }

        public void setDescriptionHtml(String descHtml) {
            this.mDescriptionHtml = descHtml;
        }

        public boolean getIsNoBlob() {
            return this.mIsNoBlob;
        }

        public void setIsNoBlob(boolean noBlob) {
            this.mIsNoBlob = noBlob;
        }

        @Override
        public ZJSONObject toZJSONObject() throws JSONException {
            ZJSONObject zjo = new ZJSONObject();
            zjo.put("status", this.mStatus.name());
            zjo.put("class", this.mClass.name());
            zjo.put("freeBusyStatus", this.mFreeBusyStatus.name());
            zjo.put("actualFreeBusyStatus", this.mActualFreeBusyStatus.name());
            zjo.put("transparency", this.mTransparency.name());
            zjo.put("isAllDay", this.mIsAllDay);
            zjo.put("name", this.mName);
            zjo.put("compNum", this.mComponentNum);
            zjo.put("locaiton", this.mLocation);
            zjo.putList("categories", this.mCategories);
            zjo.putList("comments", this.mComments);
            zjo.putList("contacts", this.mContacts);
            if (this.mGeo != null) {
                zjo.put("geo", this.mGeo.toString());
            }
            if (this.mUrl != null) {
                zjo.put("url", this.mUrl);
            }
            zjo.put("isOrganizer", this.mIsOrganizer);
            zjo.put("sequenceNumber", this.mSequenceNumber);
            zjo.put("priority", this.mPriority);
            zjo.put("percentCompleted", this.mPercentCompleted);
            zjo.put("completed", this.mCompleted);
            zjo.put("replies", this.mReplies);
            zjo.put("start", this.mStart);
            zjo.put("end", this.mEnd);
            zjo.put("duration", this.mDuration);
            zjo.put("organizer", this.mOrganizer);
            zjo.put("attendees", this.mAttendees);
            zjo.put("recurrence", this.mRecurrence);
            zjo.put("recurrenceId", this.mRecurrenceIdZ);
            zjo.put("desc", this.mDescription);
            zjo.put("deschtml", this.mDescriptionHtml);
            zjo.put("noblob", this.mIsNoBlob);
            return zjo;
        }

        public String toString() {
            return String.format("[ZComponent %s]", this.getName());
        }

        public String dump() {
            return ZJSONObject.toString(this);
        }

        public static class ZReply
        implements ToZJSONObject {
            private long mDate;
            private String mAttendee;
            private ZParticipantStatus mParticipantStatus;
            private int mRangeType;
            private String mRecurrenceId;
            private String mTimeZone;

            public ZReply() {
            }

            public ZJSONObject toZJSONObject() throws JSONException {
                ZJSONObject zjo = new ZJSONObject();
                zjo.put("date", this.mDate);
                zjo.put("attendee", this.mAttendee);
                zjo.put("participantStatus", this.mParticipantStatus.name());
                return zjo;
            }

            public String toString() {
                return String.format("[ZReply %s]", this.mAttendee);
            }

            public String dump() {
                return ZJSONObject.toString(this);
            }

            public ZReply(Element e) throws ServiceException {
                this.mDate = e.getAttributeLong("d", 0L);
                this.mAttendee = e.getAttribute("at", null);
                this.mParticipantStatus = ZParticipantStatus.fromString(e.getAttribute("ptst", ZParticipantStatus.AC.name()));
                this.mRangeType = (int)e.getAttributeLong("rangeType", 0L);
                this.mRecurrenceId = e.getAttribute("recurId", null);
                this.mTimeZone = e.getAttribute("tz", null);
            }

            public Element toElement(Element parent) {
                Element replyEl = parent.addElement("reply");
                replyEl.addAttribute("d", this.mDate);
                if (this.mAttendee != null) {
                    replyEl.addAttribute("at", this.mAttendee);
                }
                if (this.mParticipantStatus != null) {
                    replyEl.addAttribute("ptst", this.mParticipantStatus.name());
                }
                replyEl.addAttribute("rangeType", this.mRangeType);
                if (this.mRecurrenceId != null) {
                    replyEl.addAttribute("recurId", this.mRecurrenceId);
                }
                if (this.mTimeZone != null) {
                    replyEl.addAttribute("tz", this.mTimeZone);
                }
                return replyEl;
            }

            public long getDate() {
                return this.mDate;
            }

            public void setDate(long date) {
                this.mDate = date;
            }

            public String getAttendee() {
                return this.mAttendee;
            }

            public void setAttendee(String attendee) {
                this.mAttendee = attendee;
            }

            public ZParticipantStatus getParticipantStatus() {
                return this.mParticipantStatus;
            }

            public void setParticipantStatus(ZParticipantStatus participantStatus) {
                this.mParticipantStatus = participantStatus;
            }

            public int getRangeType() {
                return this.mRangeType;
            }

            public void setRangeType(int rangeType) {
                this.mRangeType = rangeType;
            }

            public String getRecurrenceId() {
                return this.mRecurrenceId;
            }

            public void setRecurrenceId(String recurrenceId) {
                this.mRecurrenceId = recurrenceId;
            }

            public String getTimeZone() {
                return this.mTimeZone;
            }

            public void setTimeZone(String timeZone) {
                this.mTimeZone = timeZone;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ZInviteType {
        appt,
        task;


        public static ZInviteType fromString(String s) throws ServiceException {
            try {
                return ZInviteType.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                throw ZClientException.CLIENT_ERROR("invalid type " + s + ", valid values: " + Arrays.asList(ZInviteType.values()), e);
            }
        }

        public boolean isTask() {
            return this.equals((Object)task);
        }

        public boolean isAppointment() {
            return this.equals((Object)appt);
        }
    }
}

