/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.DataSource;
import com.zimbra.cs.zclient.ToZJSONObject;
import com.zimbra.cs.zclient.ZDataSource;
import com.zimbra.cs.zclient.ZJSONObject;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZImapDataSource
implements ZDataSource,
ToZJSONObject {
    private String mId;
    private String mName;
    private boolean mEnabled;
    private String mHost;
    private int mPort;
    private String mUsername;
    private String mPassword;
    private String mFolderId;
    private DataSource.ConnectionType mConnectionType;

    public ZImapDataSource(Element e) throws ServiceException {
        this.mId = e.getAttribute("id");
        this.mName = e.getAttribute("name");
        this.mEnabled = e.getAttributeBool("isEnabled");
        this.mHost = e.getAttribute("host");
        this.mPort = (int)e.getAttributeLong("port", 110L);
        this.mUsername = e.getAttribute("username");
        this.mFolderId = e.getAttribute("l");
        this.mConnectionType = DataSource.ConnectionType.fromString(e.getAttribute("connectionType"));
    }

    public ZImapDataSource(String name, boolean enabled, String host, int port, String username, String password, String folderid, DataSource.ConnectionType connectionType) {
        this.mName = name;
        this.mEnabled = enabled;
        this.mHost = host;
        this.mPort = port;
        this.mUsername = username;
        this.mPassword = password;
        this.mFolderId = folderid;
        this.mConnectionType = connectionType;
    }

    public ZImapDataSource(DataSource dsrc) throws ServiceException {
        if (dsrc.getType() != DataSource.Type.imap) {
            throw ServiceException.INVALID_REQUEST("can't instantiate ZImapDataSource for " + (Object)((Object)dsrc.getType()), null);
        }
        this.mName = dsrc.getName();
        this.mEnabled = dsrc.isEnabled();
        this.mHost = dsrc.getHost();
        this.mPort = dsrc.getPort();
        this.mUsername = dsrc.getUsername();
        this.mPassword = dsrc.getDecryptedPassword();
        this.mFolderId = "" + dsrc.getFolderId();
        this.mConnectionType = dsrc.getConnectionType();
    }

    @Override
    public Element toElement(Element parent) {
        Element src = parent.addElement("imap");
        if (this.mId != null) {
            src.addAttribute("id", this.mId);
        }
        src.addAttribute("name", this.mName);
        src.addAttribute("isEnabled", this.mEnabled);
        src.addAttribute("host", this.mHost);
        src.addAttribute("port", this.mPort);
        src.addAttribute("username", this.mUsername);
        if (this.mPassword != null) {
            src.addAttribute("password", this.mPassword);
        }
        src.addAttribute("l", this.mFolderId);
        src.addAttribute("connectionType", this.mConnectionType.name());
        return src;
    }

    @Override
    public Element toIdElement(Element parent) {
        Element src = parent.addElement("imap");
        src.addAttribute("id", this.mId);
        return src;
    }

    @Override
    public DataSource.Type getType() {
        return DataSource.Type.imap;
    }

    @Override
    public String getId() {
        return this.mId;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.mEnabled = enabled;
    }

    public String getHost() {
        return this.mHost;
    }

    public void setHost(String host) {
        this.mHost = host;
    }

    public int getPort() {
        return this.mPort;
    }

    public void setPort(int port) {
        this.mPort = port;
    }

    public String getUsername() {
        return this.mUsername;
    }

    public void setUsername(String username) {
        this.mUsername = username;
    }

    public String getFolderId() {
        return this.mFolderId;
    }

    public void setFolderId(String folderid) {
        this.mFolderId = folderid;
    }

    public DataSource.ConnectionType getConnectionType() {
        return this.mConnectionType;
    }

    public void setConnectionType(DataSource.ConnectionType connectionType) {
        this.mConnectionType = connectionType;
    }

    @Override
    public Map<String, Object> getAttrs() {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("zimbraDataSourceId", this.mId);
        attrs.put("zimbraDataSourceName", this.mName);
        attrs.put("zimbraDataSourceEnabled", this.mEnabled ? "TRUE" : "FALSE");
        attrs.put("zimbraDataSourceUsername", this.mUsername);
        attrs.put("zimbraDataSourceHost", this.mHost);
        attrs.put("zimbraDataSourceConnectionType", (Object)this.mConnectionType);
        if (this.mPort > 0) {
            attrs.put("zimbraDataSourcePort", "" + this.mPort);
        }
        if (this.mFolderId != null) {
            attrs.put("zimbraDataSourceFolderId", this.mFolderId);
        }
        return attrs;
    }

    @Override
    public ZJSONObject toZJSONObject() throws JSONException {
        ZJSONObject zjo = new ZJSONObject();
        zjo.put("id", this.mId);
        zjo.put("name", this.mName);
        zjo.put("enabled", this.mEnabled);
        zjo.put("host", this.mHost);
        zjo.put("port", this.mPort);
        zjo.put("username", this.mUsername);
        zjo.put("folderId", this.mFolderId);
        zjo.put("connectionType", this.mConnectionType.name());
        return zjo;
    }

    public String toString() {
        return String.format("[ZImapDataSource %s]", this.mName);
    }

    public String dump() {
        return ZJSONObject.toString(this);
    }
}

