/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.StringUtil;
import com.zimbra.cs.zclient.ToZJSONObject;
import com.zimbra.cs.zclient.ZEmailAddress;
import com.zimbra.cs.zclient.ZJSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZIdentity
implements ToZJSONObject {
    private String mName;
    private String mId;
    private Map<String, Object> mAttrs;

    public ZIdentity(Element e) throws ServiceException {
        this.mName = e.getAttribute("name");
        this.mId = e.getAttribute("id", null);
        this.mAttrs = new HashMap<String, Object>();
        for (Element.KeyValuePair pair : e.listKeyValuePairs("a", "name")) {
            StringUtil.addToMultiMap(this.mAttrs, pair.getKey(), pair.getValue());
        }
    }

    public ZIdentity(String name, Map<String, Object> attrs) {
        this.mName = name;
        this.mAttrs = attrs;
        this.mId = this.get("zimbraPrefIdentityId");
    }

    public String getRawName() {
        return this.mName;
    }

    public String getName() {
        return this.get("zimbraPrefIdentityName");
    }

    public String getId() {
        return this.mId;
    }

    public String get(String name) {
        Object value = this.mAttrs.get(name);
        if (value == null) {
            return null;
        }
        if (value instanceof String[]) {
            return ((String[])value)[0];
        }
        if (value instanceof List) {
            return (String)((List)value).get(0);
        }
        return value.toString();
    }

    public Map<String, Object> getAttrs() {
        return new HashMap<String, Object>(this.mAttrs);
    }

    public boolean getBool(String name) {
        return "TRUE".equals(this.get(name));
    }

    public boolean isDefault() {
        return this.mName.equals("DEFAULT");
    }

    public String getFromAddress() {
        return this.get("zimbraPrefFromAddress");
    }

    public String getFromDisplay() {
        return this.get("zimbraPrefFromDisplay");
    }

    public ZEmailAddress getFromEmailAddress() {
        return new ZEmailAddress(this.getFromAddress(), null, this.getFromDisplay(), "f");
    }

    public String getSignatureId() {
        return this.get("zimbraPrefDefaultSignatureId");
    }

    public String getReplyToAddress() {
        return this.get("zimbraPrefReplyToAddress");
    }

    public String getReplyToDisplay() {
        return this.get("zimbraPrefReplyToDisplay");
    }

    public ZEmailAddress getReplyToEmailAddress() {
        return new ZEmailAddress(this.getReplyToAddress(), null, this.getReplyToDisplay(), "r");
    }

    public boolean getReplyToEnabled() {
        return this.getBool("zimbraPrefReplyToEnabled");
    }

    public String[] getMulti(String name) {
        Object o = this.mAttrs.get(name);
        if (o instanceof String[]) {
            return (String[])o;
        }
        if (o instanceof String) {
            return new String[]{o.toString()};
        }
        return new String[0];
    }

    public String[] getWhenInFolderIds() {
        return this.getMulti("zimbraPrefWhenInFolderIds");
    }

    public boolean getWhenInFoldersEnabled() {
        return this.getBool("zimbraPrefWhenInFoldersEnabled");
    }

    public boolean containsFolderId(String folderId) {
        for (String id : this.getWhenInFolderIds()) {
            if (!id.equals(folderId)) continue;
            return true;
        }
        return false;
    }

    public Element toElement(Element parent) {
        Element identity = parent.addElement("identity");
        identity.addAttribute("name", this.mName).addAttribute("id", this.mId);
        for (Map.Entry<String, Object> entry : this.mAttrs.entrySet()) {
            if (entry.getValue() instanceof String[]) {
                String[] values;
                for (String value : values = (String[])entry.getValue()) {
                    identity.addKeyValuePair(entry.getKey(), value, "a", "name");
                }
                continue;
            }
            identity.addKeyValuePair(entry.getKey(), entry.getValue().toString(), "a", "name");
        }
        return identity;
    }

    @Override
    public ZJSONObject toZJSONObject() throws JSONException {
        ZJSONObject zjo = new ZJSONObject();
        zjo.put("name", this.mName);
        zjo.put("id", this.mId);
        JSONObject jo = new JSONObject();
        zjo.put("attrs", jo);
        for (Map.Entry<String, Object> entry : this.mAttrs.entrySet()) {
            if (entry.getValue() instanceof String[]) {
                String[] values = (String[])entry.getValue();
                JSONArray ja = new JSONArray();
                jo.put(entry.getKey(), ja);
                for (String v : values) {
                    ja.put(v);
                }
                continue;
            }
            jo.put(entry.getKey(), entry.getValue().toString());
        }
        return zjo;
    }

    public String toString() {
        return String.format("[ZIdentity %s]", this.mName);
    }

    public String dump() {
        return ZJSONObject.toString(this);
    }
}

