/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.zclient.ZClientException;
import com.zimbra.cs.zclient.ToZJSONObject;
import com.zimbra.cs.zclient.ZJSONObject;
import java.util.Arrays;
import org.json.JSONException;

public class ZGrant
implements ToZJSONObject {
    private String mArgs;
    private String mGranteeName;
    private String mGranteeId;
    private GranteeType mGranteeType;
    private String mPermissions;
    public static final String GUID_AUTHUSER = "00000000-0000-0000-0000-000000000000";
    public static final String GUID_PUBLIC = "99999999-9999-9999-9999-999999999999";

    public ZGrant(Element e) throws ServiceException {
        this.mPermissions = e.getAttribute("perm");
        this.mGranteeName = e.getAttribute("d", null);
        this.mGranteeId = e.getAttribute("zid", null);
        this.mGranteeType = GranteeType.fromString(e.getAttribute("gt"));
        this.mArgs = this.mGranteeType == GranteeType.key ? e.getAttribute("key", null) : e.getAttribute("pw", null);
    }

    public void toElement(Element parent) {
        Element grant = parent.addElement("grant");
        if (this.mPermissions != null) {
            grant.addAttribute("perm", this.mPermissions);
        }
        grant.addAttribute("gt", this.mGranteeType.name());
        if (this.mGranteeId != null) {
            grant.addAttribute("zid", this.mGranteeId);
        }
        if (this.mGranteeName != null) {
            grant.addAttribute("d", this.mGranteeName);
        }
        if (this.mArgs != null && this.mArgs.length() > 0) {
            if (this.mGranteeType == GranteeType.key) {
                grant.addAttribute("key", this.mArgs);
            } else {
                grant.addAttribute("args", this.mArgs);
            }
        }
    }

    public String getPermissions() {
        return this.mPermissions;
    }

    private boolean hasPerm(Permission p) {
        return this.mPermissions != null && this.mPermissions.indexOf(p.getPermissionChar()) != -1;
    }

    public boolean canAdminister() {
        return this.hasPerm(Permission.administer);
    }

    public boolean canDelete() {
        return this.hasPerm(Permission.delete);
    }

    public boolean canInsert() {
        return this.hasPerm(Permission.insert);
    }

    public boolean canRead() {
        return this.hasPerm(Permission.read);
    }

    public boolean canWorkflow() {
        return this.hasPerm(Permission.workflow);
    }

    public boolean canWrite() {
        return this.hasPerm(Permission.write);
    }

    public boolean canViewFreeBusy() {
        return this.hasPerm(Permission.freebusy);
    }

    public GranteeType getGranteeType() {
        return this.mGranteeType;
    }

    public String getGranteeName() {
        return this.mGranteeName;
    }

    public String getGranteeId() {
        return this.mGranteeId;
    }

    public String getArgs() {
        return this.mArgs;
    }

    void setAccessKey(String accesskey) {
        this.mArgs = accesskey;
    }

    public boolean isPublic() {
        return this.getGranteeType().equals((Object)GranteeType.pub);
    }

    public ZJSONObject toZJSONObject() throws JSONException {
        ZJSONObject jo = new ZJSONObject();
        jo.put("type", this.mGranteeType.name());
        jo.put("name", this.mGranteeName);
        jo.put("id", this.mGranteeId);
        jo.put("permissions", this.mPermissions);
        jo.put("args", this.mArgs);
        return jo;
    }

    public String toString() {
        return String.format("[ZGrant %s %s %s]", this.mGranteeType.name(), this.mGranteeName, this.mPermissions);
    }

    public String dump() {
        return ZJSONObject.toString(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GranteeType {
        usr,
        grp,
        pub,
        all,
        dom,
        guest,
        key;


        public static GranteeType fromString(String s) throws ServiceException {
            try {
                return GranteeType.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                throw ZClientException.CLIENT_ERROR("invalid grantee: " + s + ", valid values: " + Arrays.asList(GranteeType.values()), e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Permission {
        read('r'),
        write('w'),
        insert('i'),
        delete('d'),
        administer('a'),
        workflow('x'),
        freebusy('f');

        private char mPermChar;

        public char getPermissionChar() {
            return this.mPermChar;
        }

        public static String toNameList(String perms) {
            if (perms == null || perms.length() == 0) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < perms.length(); ++i) {
                String v = null;
                for (Permission f : Permission.values()) {
                    if (f.getPermissionChar() != perms.charAt(i)) continue;
                    v = f.name();
                    break;
                }
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(v == null ? perms.substring(i, i + 1) : v);
            }
            return sb.toString();
        }

        private Permission(char permChar) {
            this.mPermChar = permChar;
        }
    }
}

