/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.zclient.ToZJSONObject;
import com.zimbra.cs.zclient.ZDataSource;
import com.zimbra.cs.zclient.ZFeatures;
import com.zimbra.cs.zclient.ZIdentity;
import com.zimbra.cs.zclient.ZJSONObject;
import com.zimbra.cs.zclient.ZPop3DataSource;
import com.zimbra.cs.zclient.ZPrefs;
import com.zimbra.cs.zclient.ZSignature;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZGetInfoResult
implements ToZJSONObject {
    private String mVersion;
    private String mId;
    private String mName;
    private String mRestURLBase;
    private String mPublicURLBase;
    private String mCrumb;
    private long mLifetime;
    private long mExpiration;
    private long mMailboxQuotaUsed;
    private String mRecent;
    private Map<String, List<String>> mAttrs;
    private Map<String, List<String>> mPrefAttrs;
    private ZPrefs mPrefs;
    private ZFeatures mFeatures;
    private List<ZIdentity> mIdentities;
    private List<ZDataSource> mDataSources;
    private List<ZSignature> mSignatures;
    private List<String> mMailURLs;
    private Set<String> mEmailAddresses;
    private Date mPrevSession;
    private String mChangePasswordURL;
    private String mPublicURL;

    static Map<String, List<String>> getMap(Element e, String root, String elName) throws ServiceException {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        Element attrsEl = e.getOptionalElement(root);
        if (attrsEl != null) {
            for (Element.KeyValuePair pair : attrsEl.listKeyValuePairs(elName, "name")) {
                String name = pair.getKey();
                ArrayList<String> list = (ArrayList<String>)result.get(name);
                if (list == null) {
                    list = new ArrayList<String>();
                    result.put(name, list);
                }
                list.add(pair.getValue());
            }
        }
        return result;
    }

    public ZGetInfoResult(Element e) throws ServiceException {
        this.mVersion = e.getAttribute("version", "unknown");
        this.mId = e.getAttribute("id", null);
        this.mName = e.getAttribute("name");
        this.mCrumb = e.getAttribute("crumb", null);
        this.mLifetime = e.getAttributeLong("lifetime");
        this.mMailboxQuotaUsed = e.getAttributeLong("used", -1L);
        this.mExpiration = this.mLifetime + System.currentTimeMillis();
        this.mAttrs = ZGetInfoResult.getMap(e, "attrs", "attr");
        this.mPrefAttrs = ZGetInfoResult.getMap(e, "prefs", "pref");
        this.mPrefs = new ZPrefs(this.mPrefAttrs);
        this.mFeatures = new ZFeatures(this.mAttrs);
        this.mRecent = e.getAttribute("recent", "0");
        this.mRestURLBase = e.getAttribute("rest", null);
        this.mPublicURLBase = e.getAttribute("publicURL", null);
        long prevSession = e.getAttributeLong("prevSession", 0L);
        this.mPrevSession = prevSession != 0L ? new Date(prevSession) : new Date();
        this.mChangePasswordURL = e.getAttribute("changePasswordURL", null);
        this.mPublicURL = e.getAttribute("publicURL", null);
        this.mMailURLs = new ArrayList<String>();
        String mailUrl = e.getAttribute("soapURL", null);
        if (mailUrl != null) {
            this.mMailURLs.add(mailUrl);
        }
        this.mIdentities = new ArrayList<ZIdentity>();
        Element identities = e.getOptionalElement("identities");
        if (identities != null) {
            for (Element identity : identities.listElements("identity")) {
                this.mIdentities.add(new ZIdentity(identity));
            }
        }
        this.mDataSources = new ArrayList<ZDataSource>();
        Element sources = e.getOptionalElement("dataSources");
        if (sources != null) {
            for (Element source : sources.listElements()) {
                if (!source.getName().equals("pop3")) continue;
                this.mDataSources.add(new ZPop3DataSource(source));
            }
        }
        this.mSignatures = new ArrayList<ZSignature>();
        Element sigs = e.getOptionalElement("signatures");
        if (sigs != null) {
            for (Element sig : sigs.listElements()) {
                if (!sig.getName().equals("signature")) continue;
                this.mSignatures.add(new ZSignature(sig));
            }
        }
    }

    void setSignatures(List<ZSignature> sigs) {
        this.mSignatures = sigs;
    }

    public List<ZSignature> getSignatures() {
        return this.mSignatures;
    }

    public ZSignature getSignature(String id) {
        for (ZSignature sig : this.getSignatures()) {
            if (!sig.getId().equals(id)) continue;
            return sig;
        }
        return null;
    }

    public List<ZIdentity> getIdentities() {
        return this.mIdentities;
    }

    public List<ZDataSource> getDataSources() {
        return this.mDataSources;
    }

    public Map<String, List<String>> getAttrs() {
        return this.mAttrs;
    }

    public synchronized Set<String> getEmailAddresses() {
        if (this.mEmailAddresses == null) {
            List<String> allowFromList;
            this.mEmailAddresses = new HashSet<String>();
            this.mEmailAddresses.add(this.getName().toLowerCase());
            List<String> aliasList = this.getAttrs().get("zimbraMailAlias");
            if (aliasList != null) {
                for (String alias : aliasList) {
                    this.mEmailAddresses.add(alias.toLowerCase());
                }
            }
            if ((allowFromList = this.getAttrs().get("zimbraAllowFromAddress")) != null) {
                for (String allowFrom : allowFromList) {
                    this.mEmailAddresses.add(allowFrom.toLowerCase());
                }
            }
        }
        return this.mEmailAddresses;
    }

    public long getExpiration() {
        return this.mExpiration;
    }

    public long getLifetime() {
        return this.mLifetime;
    }

    public String getRecent() {
        return this.mRecent;
    }

    public String getChangePasswordURL() {
        return this.mChangePasswordURL;
    }

    public String getPublicURL() {
        return this.mPublicURL;
    }

    public List<String> getMailURL() {
        return this.mMailURLs;
    }

    public String getCrumb() {
        return this.mCrumb;
    }

    public String getName() {
        return this.mName;
    }

    public Map<String, List<String>> getPrefAttrs() {
        return this.mPrefAttrs;
    }

    public ZPrefs getPrefs() {
        return this.mPrefs;
    }

    public ZFeatures getFeatures() {
        return this.mFeatures;
    }

    public String getRestURLBase() {
        return this.mRestURLBase;
    }

    public String getPublicURLBase() {
        return this.mPublicURLBase;
    }

    @Override
    public ZJSONObject toZJSONObject() throws JSONException {
        ZJSONObject jo = new ZJSONObject();
        jo.put("id", this.mId);
        jo.put("name", this.mName);
        jo.put("rest", this.mRestURLBase);
        jo.put("expiration", this.mExpiration);
        jo.put("lifetime", this.mLifetime);
        jo.put("mailboxQuotaUsed", this.mMailboxQuotaUsed);
        jo.put("recent", this.mRecent);
        jo.putMapList("attrs", this.mAttrs);
        jo.putMapList("prefs", this.mPrefAttrs);
        jo.putList("mailURLs", this.mMailURLs);
        jo.put("publicURL", this.mPublicURLBase);
        return jo;
    }

    public String toString() {
        return String.format("[ZGetInfoResult %s]", this.mName);
    }

    public String dump() {
        return ZJSONObject.toString(this);
    }

    public long getMailboxQuotaUsed() {
        return this.mMailboxQuotaUsed;
    }

    public String getId() {
        return this.mId;
    }

    public String getVersion() {
        return this.mVersion;
    }

    public Date getPrevSession() {
        return this.mPrevSession;
    }
}

