/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.zclient.ZClientException;
import com.zimbra.cs.zclient.ToZJSONObject;
import com.zimbra.cs.zclient.ZGrant;
import com.zimbra.cs.zclient.ZItem;
import com.zimbra.cs.zclient.ZJSONObject;
import com.zimbra.cs.zclient.ZMailbox;
import com.zimbra.cs.zclient.ZMountpoint;
import com.zimbra.cs.zclient.ZSearchContext;
import com.zimbra.cs.zclient.ZSearchFolder;
import com.zimbra.cs.zclient.ZSearchParams;
import com.zimbra.cs.zclient.event.ZModifyEvent;
import com.zimbra.cs.zclient.event.ZModifyFolderEvent;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.json.JSONException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZFolder
implements ZItem,
Comparable<Object>,
ToZJSONObject {
    public static final String ID_USER_ROOT = "1";
    public static final String ID_INBOX = "2";
    public static final String ID_TRASH = "3";
    public static final String ID_SPAM = "4";
    public static final String ID_SENT = "5";
    public static final String ID_DRAFTS = "6";
    public static final String ID_CONTACTS = "7";
    public static final String ID_TAGS = "8";
    public static final String ID_CONVERSATIONS = "9";
    public static final String ID_CALENDAR = "10";
    public static final String ID_ROOT = "11";
    public static final String ID_NOTEBOOK = "12";
    public static final String ID_AUTO_CONTACTS = "13";
    public static final String ID_CHATS = "14";
    public static final String ID_TASKS = "15";
    public static final String ID_BRIEFCASE = "16";
    public static final String ID_FIRST_USER_ID = "256";
    private Color mColor;
    private String mId;
    private String mName;
    private int mUnreadCount;
    private long mSize;
    private View mDefaultView;
    private String mFlags;
    private int mMessageCount;
    private String mParentId;
    private int mModifiedSequence;
    private int mContentSequence;
    private int mImapUIDNEXT;
    private int mImapMODSEQ;
    private String mRemoteURL;
    private String mEffectivePerms;
    private List<ZGrant> mGrants;
    private List<ZFolder> mSubFolders;
    private ZFolder mParent;
    private boolean mIsPlaceholder;
    private ZMailbox mMailbox;

    @Override
    public int compareTo(Object obj) {
        if (!(obj instanceof ZFolder)) {
            return 0;
        }
        ZFolder other = (ZFolder)obj;
        return this.getName().compareToIgnoreCase(other.getName());
    }

    public ZFolder(Element e, ZFolder parent, ZMailbox mailbox) throws ServiceException {
        this.mMailbox = mailbox;
        this.mParent = parent;
        this.mId = e.getAttribute("id");
        this.mName = e.getAttribute("name");
        this.mParentId = e.getAttribute("l", null);
        this.mIsPlaceholder = this.mParentId == null;
        this.mFlags = e.getAttribute("f", null);
        try {
            this.mColor = Color.fromString(e.getAttribute("color", "0"));
        }
        catch (ServiceException se) {
            this.mColor = Color.orange;
        }
        this.mUnreadCount = (int)e.getAttributeLong("u", 0L);
        this.mMessageCount = (int)e.getAttributeLong("n", 0L);
        this.mDefaultView = View.fromString(e.getAttribute("view", View.conversation.name()));
        this.mModifiedSequence = (int)e.getAttributeLong("ms", -1L);
        this.mContentSequence = (int)e.getAttributeLong("rev", -1L);
        this.mImapUIDNEXT = (int)e.getAttributeLong("i4next", -1L);
        this.mImapMODSEQ = (int)e.getAttributeLong("i4ms", -1L);
        this.mRemoteURL = e.getAttribute("url", null);
        this.mEffectivePerms = e.getAttribute("perm", null);
        this.mSize = e.getAttributeLong("s", 0L);
        this.mGrants = new ArrayList<ZGrant>();
        this.mSubFolders = new ArrayList<ZFolder>();
        Element aclEl = e.getOptionalElement("acl");
        if (aclEl != null) {
            for (Element grant : aclEl.listElements("grant")) {
                this.mGrants.add(new ZGrant(grant));
            }
        }
        for (Element child : e.listElements("folder")) {
            this.mSubFolders.add(this.createSubFolder(child));
        }
        for (Element s : e.listElements("search")) {
            this.mSubFolders.add(new ZSearchFolder(s, this, this.mMailbox));
        }
        for (Element l : e.listElements("link")) {
            this.mSubFolders.add(new ZMountpoint(l, this, this.mMailbox));
        }
    }

    protected ZFolder createSubFolder(Element element) throws ServiceException {
        return new ZFolder(element, this, this.getMailbox());
    }

    synchronized void addChild(ZFolder folder) {
        ArrayList<ZFolder> newSubs = new ArrayList<ZFolder>(this.mSubFolders);
        newSubs.add(folder);
        this.mSubFolders = newSubs;
    }

    synchronized void removeChild(ZFolder folder) {
        ArrayList<ZFolder> newSubs = new ArrayList<ZFolder>(this.mSubFolders);
        newSubs.remove(folder);
        this.mSubFolders = newSubs;
    }

    @Override
    public void modifyNotification(ZModifyEvent event) throws ServiceException {
        if (event instanceof ZModifyFolderEvent) {
            ZModifyFolderEvent fevent = (ZModifyFolderEvent)event;
            this.mName = fevent.getName(this.mName);
            this.mParentId = fevent.getParentId(this.mParentId);
            this.mFlags = fevent.getFlags(this.mFlags);
            this.mColor = fevent.getColor(this.mColor);
            this.mUnreadCount = fevent.getUnreadCount(this.mUnreadCount);
            this.mMessageCount = fevent.getMessageCount(this.mMessageCount);
            this.mDefaultView = fevent.getDefaultView(this.mDefaultView);
            this.mModifiedSequence = fevent.getModifiedSequence(this.mModifiedSequence);
            this.mContentSequence = fevent.getContentSequence(this.mContentSequence);
            this.mImapUIDNEXT = fevent.getImapUIDNEXT(this.mImapUIDNEXT);
            this.mImapMODSEQ = fevent.getImapMODSEQ(this.mImapMODSEQ);
            this.mRemoteURL = fevent.getRemoteURL(this.mRemoteURL);
            this.mEffectivePerms = fevent.getEffectivePerm(this.mEffectivePerms);
            this.mGrants = fevent.getGrants(this.mGrants);
            this.mSize = fevent.getSize(this.mSize);
        }
    }

    public ZSearchContext getSearchContext() {
        ZSearchParams params = new ZSearchParams("inid:" + this.getId());
        if (this.getDefaultView() != null) {
            params.setTypes(this.getDefaultView().name());
        }
        return new ZSearchContext(params, this.getMailbox());
    }

    public ZMailbox getMailbox() {
        return this.mMailbox;
    }

    public ZFolder getParent() {
        return this.mParent;
    }

    void setParent(ZFolder parent) {
        this.mParent = parent;
    }

    @Override
    public String getId() {
        return this.mId;
    }

    public String getName() {
        return this.mName;
    }

    public String getPath() {
        if (this.mParent == null) {
            return "/";
        }
        String pp = this.mParent.getPath();
        return pp.length() == 1 ? pp + this.mName : pp + "/" + this.mName;
    }

    public String getPathURLEncoded() {
        if (this.mParent == null) {
            return "/";
        }
        String pp = this.mParent.getPath();
        String n = null;
        try {
            n = URLEncoder.encode(this.mName, "utf-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            n = this.mName;
        }
        return pp.length() == 1 ? pp + n : pp + "/" + n;
    }

    public String getRootRelativePath() {
        String path = this.getPath();
        if (path.startsWith("/")) {
            return path.substring("/".length());
        }
        return path;
    }

    public String getRootRelativePathURLEncoded() {
        String path = this.getPathURLEncoded();
        if (path.startsWith("/")) {
            return path.substring("/".length());
        }
        return path;
    }

    public String getParentId() {
        return this.mParentId;
    }

    boolean isHierarchyPlaceholder() {
        return this.mIsPlaceholder;
    }

    public int getUnreadCount() {
        return this.mUnreadCount;
    }

    void setUnreadCount(int count) {
        this.mUnreadCount = count;
    }

    public long getSize() {
        return this.mSize;
    }

    public int getMessageCount() {
        return this.mMessageCount;
    }

    void setMessageCount(int count) {
        this.mMessageCount = count;
    }

    public View getDefaultView() {
        return this.mDefaultView;
    }

    public int getModifiedSequence() {
        return this.mModifiedSequence;
    }

    public int getContentSequence() {
        return this.mContentSequence;
    }

    public int getImapUIDNEXT() {
        return this.mImapUIDNEXT;
    }

    public int getImapMODSEQ() {
        return this.mImapMODSEQ;
    }

    public String getFlags() {
        return this.mFlags;
    }

    public boolean hasFlags() {
        return this.mFlags != null && this.mFlags.length() > 0;
    }

    public boolean isCheckedInUI() {
        return this.hasFlags() && this.mFlags.indexOf(Flag.checkedInUI.getFlagChar()) != -1;
    }

    public boolean isExcludedFromFreeBusy() {
        return this.hasFlags() && this.mFlags.indexOf(Flag.excludeFreeBusyInfo.getFlagChar()) != -1;
    }

    public boolean isIMAPSubscribed() {
        return this.hasFlags() && this.mFlags.indexOf(Flag.imapSubscribed.getFlagChar()) != -1;
    }

    public boolean isIMAPDeleted() {
        return this.hasFlags() && this.mFlags.indexOf(Flag.imapDeleted.getFlagChar()) != -1;
    }

    public boolean isSyncFolder() {
        return this.hasFlags() && this.mFlags.indexOf(Flag.syncFolder.getFlagChar()) != -1;
    }

    public boolean isSyncEnabled() {
        return this.hasFlags() && this.mFlags.indexOf(Flag.syncEnabled.getFlagChar()) != -1;
    }

    public boolean isNoInferiors() {
        return this.hasFlags() && this.mFlags.indexOf(Flag.noInferiors.getFlagChar()) != -1;
    }

    public Color getColor() {
        return this.mColor;
    }

    public String getRemoteURL() {
        return this.mRemoteURL;
    }

    public String getEffectivePerms() {
        return this.mEffectivePerms;
    }

    public List<ZGrant> getGrants() {
        return this.mGrants;
    }

    public List<ZFolder> getSubFolders() {
        return this.mSubFolders;
    }

    public ZFolder getSubFolderByPath(String path) {
        if (path.length() == 0) {
            return this;
        }
        int index = path.indexOf("/");
        String name = index == -1 ? path : path.substring(0, index);
        String subpath = index == -1 ? null : path.substring(index + 1);
        for (ZFolder f : this.getSubFolders()) {
            if (!f.getName().equalsIgnoreCase(name)) continue;
            if (subpath != null) {
                return f.getSubFolderByPath(subpath);
            }
            return f.isHierarchyPlaceholder() ? null : f;
        }
        return null;
    }

    public boolean isSystemFolder() {
        try {
            return Integer.parseInt(this.mId) < Integer.parseInt(ID_FIRST_USER_ID);
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public ZJSONObject toZJSONObject() throws JSONException {
        ZJSONObject jo = new ZJSONObject();
        jo.put("id", this.mId);
        jo.put("name", this.mName);
        jo.put("path", this.getPath());
        jo.put("pathURLEncoded", this.getPathURLEncoded());
        jo.put("parentId", this.mParentId);
        jo.put("flags", this.mFlags);
        jo.put("color", this.mColor.name());
        jo.put("unreadCount", this.mUnreadCount);
        jo.put("itemCount", this.mMessageCount);
        jo.put("defaultView", this.mDefaultView.name());
        jo.put("remoteUrl", this.mRemoteURL);
        jo.put("effectivePermissions", this.mEffectivePerms);
        jo.put("grants", this.mGrants);
        jo.put("size", this.mSize);
        jo.put("subFolders", this.mSubFolders);
        jo.put("isCheckedInUI", this.isCheckedInUI());
        jo.put("isExcludedFromFreeBusy", this.isExcludedFromFreeBusy());
        jo.put("isSyncEnabled", this.isSyncEnabled());
        jo.put("isSyncFolder", this.isSyncFolder());
        jo.put("isSystemFolder", this.isSystemFolder());
        jo.put("contentSequence", this.getContentSequence());
        return jo;
    }

    public String toString() {
        return String.format("[ZFolder %s]", this.getPath());
    }

    public String dump() {
        return ZJSONObject.toString(this);
    }

    public void delete() throws ServiceException {
        this.mMailbox.deleteFolder(this.mId);
    }

    public void deleteItem() throws ServiceException {
        this.delete();
    }

    public void moveToTrash() throws ServiceException {
        this.mMailbox.trashFolder(this.mId);
    }

    public void sync() throws ServiceException {
        this.mMailbox.syncFolder(this.mId);
    }

    public void clearGrants() throws ServiceException {
        this.mMailbox.updateFolder(this.mId, null, null, null, null, new ArrayList<ZGrant>());
    }

    public void empty(boolean recursive) throws ServiceException {
        this.mMailbox.emptyFolder(this.mId, recursive);
    }

    public void importURL(String url) throws ServiceException {
        this.mMailbox.importURLIntoFolder(this.mId, url);
    }

    public void markRead() throws ServiceException {
        this.mMailbox.markFolderRead(this.mId);
    }

    public void checked(boolean checked) throws ServiceException {
        this.mMailbox.modifyFolderChecked(this.mId, checked);
    }

    public void modifySyncFlag(boolean checked) throws ServiceException {
        this.mMailbox.modifyFolderSyncFlag(this.mId, checked);
    }

    public void modifyExcludeFreeBusy(boolean exclude) throws ServiceException {
        this.mMailbox.modifyFolderExcludeFreeBusy(this.mId, exclude);
    }

    public void modifyColor(Color color) throws ServiceException {
        this.mMailbox.modifyFolderColor(this.mId, color);
    }

    public void modifyFlags(String flags) throws ServiceException {
        this.mMailbox.updateFolder(this.mId, null, null, null, flags, null);
    }

    public void modifyURL(String url) throws ServiceException {
        this.mMailbox.modifyFolderURL(this.mId, url);
    }

    public void rename(String newPath) throws ServiceException {
        this.mMailbox.renameFolder(this.mId, newPath);
    }

    public void updateFolder(String name, String parentId, Color newColor, String flags, List<ZGrant> acl) throws ServiceException {
        this.mMailbox.updateFolder(this.mId, name, parentId, newColor, flags, acl);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum View {
        appointment,
        chat,
        contact,
        conversation,
        document,
        message,
        remote,
        search,
        task,
        voice,
        wiki;


        public static View fromString(String s) throws ServiceException {
            try {
                return s.equals("search folder") ? search : View.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                if (s.equals("remote folder")) {
                    return remote;
                }
                if (s.equals("search folder")) {
                    return search;
                }
                throw ZClientException.CLIENT_ERROR("invalid view: " + s + ", valid values: " + Arrays.asList(View.values()), e);
            }
        }

        public boolean isAppointment() {
            return this.equals((Object)appointment);
        }

        public boolean isChat() {
            return this.equals((Object)chat);
        }

        public boolean isContact() {
            return this.equals((Object)contact);
        }

        public boolean isConversation() {
            return this.equals((Object)conversation);
        }

        public boolean isDocument() {
            return this.equals((Object)document);
        }

        public boolean isMessage() {
            return this.equals((Object)message);
        }

        public boolean isRemote() {
            return this.equals((Object)remote);
        }

        public boolean isSearch() {
            return this.equals((Object)search);
        }

        public boolean isTask() {
            return this.equals((Object)task);
        }

        public boolean isVoice() {
            return this.equals((Object)voice);
        }

        public boolean isWiki() {
            return this.equals((Object)wiki);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Color {
        defaultColor(0),
        blue(1),
        cyan(2),
        green(3),
        purple(4),
        red(5),
        yellow(6),
        pink(7),
        gray(8),
        orange(9);

        private int mValue;

        public int getValue() {
            return this.mValue;
        }

        public static Color fromString(String s) throws ServiceException {
            try {
                return Color.values()[Integer.parseInt(s)];
            }
            catch (NumberFormatException e) {
            }
            catch (IndexOutOfBoundsException e) {
                // empty catch block
            }
            try {
                return Color.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                throw ZClientException.CLIENT_ERROR("invalid color: " + s + ", valid values: " + Arrays.asList(Color.values()), e);
            }
        }

        private Color(int value) {
            this.mValue = value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Flag {
        checkedInUI('#'),
        doesNotInheritPermissions('i'),
        excludeFreeBusyInfo('b'),
        imapDeleted('x'),
        imapSubscribed('*'),
        syncFolder('y'),
        syncEnabled('~'),
        noInferiors('o');

        private char mFlagChar;

        public char getFlagChar() {
            return this.mFlagChar;
        }

        public static String toNameList(String flags) {
            if (flags == null || flags.length() == 0) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < flags.length(); ++i) {
                String v = null;
                for (Flag f : Flag.values()) {
                    if (f.getFlagChar() != flags.charAt(i)) continue;
                    v = f.name();
                    break;
                }
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(v == null ? flags.substring(i, i + 1) : v);
            }
            return sb.toString();
        }

        private Flag(char flagChar) {
            this.mFlagChar = flagChar;
        }
    }
}

