/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.zclient.ZClientException;
import com.zimbra.cs.filter.FilterUtil;
import com.zimbra.cs.zclient.ToZJSONObject;
import com.zimbra.cs.zclient.ZFilterAction;
import com.zimbra.cs.zclient.ZFilterCondition;
import com.zimbra.cs.zclient.ZJSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.json.JSONException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZFilterRule
implements ToZJSONObject {
    private String mName;
    private boolean mActive;
    private boolean mAllConditions;
    private List<ZFilterCondition> mConditions;
    private List<ZFilterAction> mActions;

    public String getName() {
        return this.mName;
    }

    public boolean isActive() {
        return this.mActive;
    }

    public boolean isAllConditions() {
        return this.mAllConditions;
    }

    public List<ZFilterCondition> getConditions() {
        return this.mConditions;
    }

    public List<ZFilterAction> getActions() {
        return this.mActions;
    }

    public ZFilterRule(String name, boolean active, boolean allConditions, List<ZFilterCondition> conditions, List<ZFilterAction> actions) {
        this.mName = name;
        this.mActive = active;
        this.mAllConditions = allConditions;
        this.mConditions = conditions;
        this.mActions = actions;
    }

    public ZFilterRule(Element e) throws ServiceException {
        this.mName = e.getAttribute("name");
        this.mActive = e.getAttributeBool("active", false);
        Element testsEl = e.getElement("filterTests");
        TreeMap conditions = new TreeMap();
        this.mAllConditions = testsEl.getAttribute("condition", "allof").equalsIgnoreCase("allof");
        for (Element condEl : testsEl.listElements()) {
            ZFilterCondition condition = ZFilterCondition.getCondition(condEl);
            int index = FilterUtil.getIndex(condEl);
            FilterUtil.addToMap(conditions, index, condition);
        }
        this.mConditions = new ArrayList<ZFilterCondition>();
        this.mConditions.addAll(conditions.values());
        Element actionsEl = e.getElement("filterActions");
        TreeMap actions = new TreeMap();
        for (Element actionEl : actionsEl.listElements()) {
            ZFilterAction action = ZFilterAction.getAction(actionEl);
            int index = FilterUtil.getIndex(actionEl);
            FilterUtil.addToMap(actions, index, action);
        }
        this.mActions = new ArrayList<ZFilterAction>();
        this.mActions.addAll(actions.values());
    }

    Element toElement(Element parent) {
        Element r = parent.addElement("filterRule");
        r.addAttribute("name", this.mName);
        r.addAttribute("active", this.mActive);
        Element tests = r.addElement("filterTests");
        tests.addAttribute("condition", this.mAllConditions ? "allof" : "anyof");
        for (ZFilterCondition condition : this.mConditions) {
            int index = tests.listElements().size();
            Element conditionEl = condition.toElement(tests);
            conditionEl.addAttribute("index", index);
        }
        Element actions = r.addElement("filterActions");
        for (ZFilterAction action : this.mActions) {
            int index = actions.listElements().size();
            Element actionElement = action.toElement(actions);
            actionElement.addAttribute("index", index);
        }
        return r;
    }

    @Override
    public ZJSONObject toZJSONObject() throws JSONException {
        ZJSONObject jo = new ZJSONObject();
        jo.put("name", this.mName);
        jo.put("active", this.mActive);
        jo.put("allConditions", this.mAllConditions);
        jo.put("conditions", this.mConditions);
        jo.put("actions", this.mActions);
        return jo;
    }

    public String toString() {
        return String.format("[ZFilterRule %s]", this.mName);
    }

    public String dump() {
        return ZJSONObject.toString(this);
    }

    static String quotedString(String s) {
        return "\"" + s.replaceAll("\"", "\\\"") + "\"";
    }

    public String generateFilterRule() {
        StringBuilder sb = new StringBuilder();
        sb.append(ZFilterRule.quotedString(this.mName)).append(' ');
        sb.append(this.mActive ? "active" : "inactive").append(' ');
        sb.append(this.mAllConditions ? "all" : "any").append(' ');
        boolean needSpace = false;
        for (ZFilterCondition cond : this.mConditions) {
            if (needSpace) {
                sb.append(' ');
            }
            sb.append(cond.toConditionString());
            needSpace = true;
        }
        for (ZFilterAction action : this.mActions) {
            if (needSpace) {
                sb.append(' ');
            }
            sb.append(action.toActionString());
            needSpace = true;
        }
        return sb.toString();
    }

    public static ZFilterRule parseFilterRule(String[] args) throws ServiceException {
        String name = args[0];
        boolean all = true;
        boolean active = true;
        ArrayList<ZFilterCondition> conditions = new ArrayList<ZFilterCondition>();
        ArrayList<ZFilterAction> actions = new ArrayList<ZFilterAction>();
        int i = 1;
        while (i < args.length) {
            String a;
            if ((a = args[i++]).equals("active")) {
                active = true;
                continue;
            }
            if (a.equals("inactive")) {
                active = false;
                continue;
            }
            if (a.equals("any")) {
                all = false;
                continue;
            }
            if (a.equals("all")) {
                all = true;
                continue;
            }
            if (a.equals("addressbook")) {
                if (i + 2 > args.length) {
                    throw ZClientException.CLIENT_ERROR("missing args", null);
                }
                conditions.add(new ZFilterCondition.ZAddressBookCondition(args[i++].equals("in") ? ZFilterCondition.AddressBookOp.IN : ZFilterCondition.AddressBookOp.NOT_IN, args[i++]));
                continue;
            }
            if (a.equals("attachment")) {
                if (i + 1 > args.length) {
                    throw ZClientException.CLIENT_ERROR("missing exists arg", null);
                }
                conditions.add(new ZFilterCondition.ZAttachmentExistsCondition(args[i++].equals("exists")));
                continue;
            }
            if (a.equals("body")) {
                if (i + 2 > args.length) {
                    throw ZClientException.CLIENT_ERROR("missing args", null);
                }
                conditions.add(new ZFilterCondition.ZBodyCondition(ZFilterCondition.BodyOp.fromString(args[i++]), args[i++]));
                continue;
            }
            if (a.equals("size")) {
                if (i + 2 > args.length) {
                    throw ZClientException.CLIENT_ERROR("missing args", null);
                }
                conditions.add(new ZFilterCondition.ZSizeCondition(ZFilterCondition.SizeOp.fromString(args[i++]), args[i++]));
                continue;
            }
            if (a.equals("date")) {
                if (i + 2 > args.length) {
                    throw ZClientException.CLIENT_ERROR("missing args", null);
                }
                conditions.add(new ZFilterCondition.ZDateCondition(ZFilterCondition.DateOp.fromString(args[i++]), args[i++]));
                continue;
            }
            if (a.equals("header")) {
                String op;
                if (i + 2 > args.length) {
                    throw ZClientException.CLIENT_ERROR("missing args", null);
                }
                String headerName = args[i++];
                if ((op = args[i++]).equals("exists")) {
                    conditions.add(new ZFilterCondition.ZHeaderExistsCondition(headerName, true));
                    continue;
                }
                if (op.equals("not_exists")) {
                    conditions.add(new ZFilterCondition.ZHeaderExistsCondition(headerName, false));
                    continue;
                }
                if (i + 1 > args.length) {
                    throw ZClientException.CLIENT_ERROR("missing args", null);
                }
                String value = args[i++];
                conditions.add(new ZFilterCondition.ZHeaderCondition(headerName, ZFilterCondition.HeaderOp.fromString(op), value));
                continue;
            }
            if (a.equals("invite")) {
                if (i + 1 > args.length) {
                    throw ZClientException.CLIENT_ERROR("missing exists arg", null);
                }
                conditions.add(new ZFilterCondition.ZInviteCondition(args[i++].equals("exists")));
                continue;
            }
            if (a.equals("keep")) {
                actions.add(new ZFilterAction.ZKeepAction());
                continue;
            }
            if (a.equals("discard")) {
                actions.add(new ZFilterAction.ZDiscardAction());
                continue;
            }
            if (a.equals("fileinto")) {
                if (i + 1 > args.length) {
                    throw ZClientException.CLIENT_ERROR("missing args", null);
                }
                actions.add(new ZFilterAction.ZFileIntoAction(args[i++]));
                continue;
            }
            if (a.equals("tag")) {
                if (i + 1 > args.length) {
                    throw ZClientException.CLIENT_ERROR("missing args", null);
                }
                actions.add(new ZFilterAction.ZTagAction(args[i++]));
                continue;
            }
            if (a.equals("mark")) {
                if (i + 1 > args.length) {
                    throw ZClientException.CLIENT_ERROR("missing args", null);
                }
                actions.add(new ZFilterAction.ZMarkAction(ZFilterAction.MarkOp.fromString(args[i++])));
                continue;
            }
            if (a.equals("redirect")) {
                if (i + 1 > args.length) {
                    throw ZClientException.CLIENT_ERROR("missing args", null);
                }
                actions.add(new ZFilterAction.ZRedirectAction(args[i++]));
                continue;
            }
            if (a.equals("stop")) {
                actions.add(new ZFilterAction.ZStopAction());
                continue;
            }
            throw ZClientException.CLIENT_ERROR("unknown keyword: " + a, null);
        }
        if (name == null || name.length() == 0) {
            throw ZClientException.CLIENT_ERROR("missing filter name", null);
        }
        if (actions.isEmpty()) {
            throw ZClientException.CLIENT_ERROR("must have at least one action", null);
        }
        if (conditions.isEmpty()) {
            throw ZClientException.CLIENT_ERROR("must have at least one condition", null);
        }
        return new ZFilterRule(name, active, all, conditions, actions);
    }
}

