/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.zclient.ZClientException;
import com.zimbra.cs.filter.FilterUtil;
import com.zimbra.cs.zclient.ToZJSONObject;
import com.zimbra.cs.zclient.ZFilterRule;
import com.zimbra.cs.zclient.ZJSONObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import org.json.JSONException;

public abstract class ZFilterCondition
implements ToZJSONObject {
    public static final String C_ADDRESSBOOK = "addressbook";
    public static final String C_ATTACHMENT = "attachment";
    public static final String C_BODY = "body";
    public static final String C_DATE = "date";
    public static final String C_EXISTS = "exists";
    public static final String C_NOT_EXISTS = "not exists";
    public static final String C_HEADER = "header";
    public static final String C_NOT_ATTACHMENT = "not attachment";
    public static final String C_SIZE = "size";
    public static final String C_INVITE = "invite";

    public static ZFilterCondition getCondition(Element condEl) throws ServiceException {
        String name = condEl.getName();
        boolean isNegative = condEl.getAttributeBool("negative", false);
        if (name.equals("headerTest")) {
            String header = condEl.getAttribute(C_HEADER);
            String s = condEl.getAttribute("stringComparison");
            s = s.toLowerCase();
            FilterUtil.StringComparison comparison = FilterUtil.StringComparison.fromString(s);
            String value = condEl.getAttribute("value");
            return new ZHeaderCondition(header, HeaderOp.fromStringComparison(comparison, isNegative), value);
        }
        if (name.equals("headerExistsTest")) {
            String header = condEl.getAttribute(C_HEADER);
            return new ZHeaderExistsCondition(header, !isNegative);
        }
        if (name.equals("sizeTest")) {
            String s = condEl.getAttribute("numberComparison");
            s = s.toLowerCase();
            FilterUtil.NumberComparison comparison = FilterUtil.NumberComparison.fromString(s);
            String size = condEl.getAttribute("s");
            return new ZSizeCondition(SizeOp.fromNumberComparison(comparison, isNegative), size);
        }
        if (name.equals("dateTest")) {
            String s = condEl.getAttribute("dateComparison");
            s = s.toLowerCase();
            FilterUtil.DateComparison comparison = FilterUtil.DateComparison.fromString(s);
            Date date = new Date(condEl.getAttributeLong("d") * 1000L);
            return new ZDateCondition(DateOp.fromDateComparison(comparison, isNegative), date);
        }
        if (name.equals("bodyTest")) {
            String value = condEl.getAttribute("value");
            BodyOp op = isNegative ? BodyOp.NOT_CONTAINS : BodyOp.CONTAINS;
            return new ZBodyCondition(op, value);
        }
        if (name.equals("addressBookTest")) {
            String header = condEl.getAttribute(C_HEADER);
            AddressBookOp op = isNegative ? AddressBookOp.NOT_IN : AddressBookOp.IN;
            return new ZAddressBookCondition(op, header);
        }
        if (name.equals("attachmentTest")) {
            return new ZAttachmentExistsCondition(!isNegative);
        }
        if (name.equals("inviteTest")) {
            return new ZInviteCondition(!isNegative);
        }
        throw ZClientException.CLIENT_ERROR("unknown filter condition: " + name, null);
    }

    abstract Element toElement(Element var1);

    public abstract String getName();

    public ZJSONObject toZJSONObject() throws JSONException {
        ZJSONObject jo = new ZJSONObject();
        jo.put("name", this.getName());
        return jo;
    }

    public String toString() {
        return String.format("[ZFilterCondition %s]", this.getName());
    }

    public String dump() {
        return ZJSONObject.toString(this);
    }

    public abstract String toConditionString();

    public static class ZInviteCondition
    extends ZFilterCondition {
        private boolean mIsInvite;

        public ZInviteCondition(boolean isInvite) {
            this.mIsInvite = isInvite;
        }

        public boolean isInvite() {
            return this.mIsInvite;
        }

        public String toConditionString() {
            return this.mIsInvite ? "invite exists" : "invite not_exists";
        }

        public String getName() {
            return ZFilterCondition.C_INVITE;
        }

        Element toElement(Element parent) {
            Element test = parent.addElement("inviteTest");
            if (!this.mIsInvite) {
                test.addAttribute("negative", true);
            }
            return test;
        }
    }

    public static class ZAttachmentExistsCondition
    extends ZFilterCondition {
        private boolean mExists;

        public ZAttachmentExistsCondition(boolean exists) {
            this.mExists = exists;
        }

        public boolean getExists() {
            return this.mExists;
        }

        public String toConditionString() {
            return this.mExists ? "attachment exists" : "attachment not_exists";
        }

        public String getName() {
            return ZFilterCondition.C_ATTACHMENT;
        }

        Element toElement(Element parent) {
            Element test = parent.addElement("attachmentTest");
            if (!this.mExists) {
                test.addAttribute("negative", true);
            }
            return test;
        }
    }

    public static class ZHeaderExistsCondition
    extends ZFilterCondition {
        private boolean mExists;
        private String mHeaderName;

        public ZHeaderExistsCondition(String headerName, boolean exists) {
            this.mExists = exists;
            this.mHeaderName = headerName;
        }

        public boolean getExists() {
            return this.mExists;
        }

        public String getHeaderName() {
            return this.mHeaderName;
        }

        public String toConditionString() {
            return "header " + ZFilterRule.quotedString(this.getHeaderName()) + (this.mExists ? " exists" : " not_exists");
        }

        public String getName() {
            return ZFilterCondition.C_EXISTS;
        }

        Element toElement(Element parent) {
            Element test = parent.addElement("headerExistsTest");
            test.addAttribute(ZFilterCondition.C_HEADER, this.mHeaderName);
            if (!this.mExists) {
                test.addAttribute("negative", true);
            }
            return test;
        }
    }

    public static class ZHeaderCondition
    extends ZFilterCondition {
        private HeaderOp mHeaderOp;
        private String mHeaderName;
        private String mValue;

        public ZHeaderCondition(String headerName, HeaderOp op, String value) {
            this.mHeaderName = headerName;
            this.mHeaderOp = op;
            this.mValue = value;
        }

        public HeaderOp getHeaderOp() {
            return this.mHeaderOp;
        }

        public String getHeaderName() {
            return this.mHeaderName;
        }

        public String getHeaderValue() {
            return this.mValue;
        }

        public String toConditionString() {
            return "header " + ZFilterRule.quotedString(this.getHeaderName()) + " " + this.mHeaderOp.name().toLowerCase() + " " + ZFilterRule.quotedString(this.getHeaderValue());
        }

        public String getName() {
            return ZFilterCondition.C_HEADER;
        }

        Element toElement(Element parent) {
            Element test = parent.addElement("headerTest");
            test.addAttribute(ZFilterCondition.C_HEADER, this.mHeaderName);
            test.addAttribute("stringComparison", this.mHeaderOp.toStringComparison().toString());
            if (this.mHeaderOp.isNegative()) {
                test.addAttribute("negative", true);
            }
            test.addAttribute("value", this.mValue);
            return test;
        }
    }

    public static class ZDateCondition
    extends ZFilterCondition {
        private DateOp mDateOp;
        private Date mDate;

        public ZDateCondition(DateOp op, Date date) {
            this.mDateOp = op;
            this.mDate = date;
        }

        public ZDateCondition(DateOp op, String dateStr) throws ServiceException {
            this.mDateOp = op;
            try {
                this.mDate = new SimpleDateFormat("yyyyMMdd").parse(dateStr);
            }
            catch (ParseException e) {
                throw ZClientException.CLIENT_ERROR("invalid date: " + dateStr + ", should be: YYYYMMDD", e);
            }
        }

        public DateOp getDateOp() {
            return this.mDateOp;
        }

        public Date getDate() {
            return this.mDate;
        }

        public String getDateString() {
            return FilterUtil.SIEVE_DATE_PARSER.format(this.mDate);
        }

        public String toConditionString() {
            return "date " + this.mDateOp.name().toLowerCase() + " " + ZFilterRule.quotedString(this.getDateString());
        }

        public String getName() {
            return ZFilterCondition.C_DATE;
        }

        Element toElement(Element parent) {
            Element test = parent.addElement("dateTest");
            test.addAttribute("dateComparison", this.mDateOp.toDateComparison().toString());
            if (this.mDateOp.isNegative()) {
                test.addAttribute("negative", true);
            }
            test.addAttribute("d", this.mDate.getTime() / 1000L);
            return test;
        }
    }

    public static class ZSizeCondition
    extends ZFilterCondition {
        private SizeOp mSizeOp;
        private String mSize;

        public ZSizeCondition(SizeOp op, String size) {
            this.mSizeOp = op;
            this.mSize = size;
        }

        public SizeOp getSizeOp() {
            return this.mSizeOp;
        }

        public String getSize() {
            return this.mSize;
        }

        public String getUnits() {
            String val = this.getSize();
            if (val != null) {
                if (val.endsWith("M")) {
                    return "M";
                }
                if (val.endsWith("K")) {
                    return "K";
                }
                if (val.endsWith("G")) {
                    return "G";
                }
            }
            return "B";
        }

        public String getSizeNoUnits() {
            String val = this.getSize();
            if (val != null) {
                if (val.endsWith("M")) {
                    return val.substring(0, val.length() - 1);
                }
                if (val.endsWith("K")) {
                    return val.substring(0, val.length() - 1);
                }
                if (val.endsWith("G")) {
                    return val.substring(0, val.length() - 1);
                }
            }
            return val;
        }

        public String toConditionString() {
            return "size " + this.mSizeOp.name().toLowerCase() + " " + ZFilterRule.quotedString(this.getSize());
        }

        public String getName() {
            return ZFilterCondition.C_SIZE;
        }

        Element toElement(Element parent) {
            Element test = parent.addElement("sizeTest");
            test.addAttribute("numberComparison", this.mSizeOp.toNumberComparison().toString());
            if (this.mSizeOp.isNegative()) {
                test.addAttribute("negative", true);
            }
            test.addAttribute("s", this.mSize);
            return test;
        }
    }

    public static class ZBodyCondition
    extends ZFilterCondition {
        private BodyOp mBodyOp;
        private String mText;

        public ZBodyCondition(BodyOp op, String text) {
            this.mBodyOp = op;
            this.mText = text;
        }

        public String getName() {
            return ZFilterCondition.C_BODY;
        }

        public BodyOp getBodyOp() {
            return this.mBodyOp;
        }

        public String getText() {
            return this.mText;
        }

        public String toConditionString() {
            return (this.mBodyOp == BodyOp.CONTAINS ? "body contains " : "body not_contains ") + ZFilterRule.quotedString(this.getText());
        }

        Element toElement(Element parent) {
            Element test = parent.addElement("bodyTest");
            test.addAttribute("value", this.mText);
            if (this.mBodyOp == BodyOp.NOT_CONTAINS) {
                test.addAttribute("negative", true);
            }
            return test;
        }
    }

    public static class ZAddressBookCondition
    extends ZFilterCondition {
        private AddressBookOp mAddressBookOp;
        private String mHeader;

        public ZAddressBookCondition(AddressBookOp op, String header) {
            this.mAddressBookOp = op;
            this.mHeader = header;
        }

        public String getName() {
            return ZFilterCondition.C_ADDRESSBOOK;
        }

        Element toElement(Element parent) {
            Element test = parent.addElement("addressBookTest");
            test.addAttribute(ZFilterCondition.C_HEADER, this.mHeader);
            test.addAttribute("folderPath", "contacts");
            if (this.mAddressBookOp == AddressBookOp.NOT_IN) {
                test.addAttribute("negative", true);
            }
            return test;
        }

        public String getHeader() {
            return this.mHeader;
        }

        public AddressBookOp getAddressBookOp() {
            return this.mAddressBookOp;
        }

        public String toConditionString() {
            return (this.mAddressBookOp == AddressBookOp.IN ? "addressbook in " : "addressbook not_in ") + ZFilterRule.quotedString(this.getHeader());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AddressBookOp {
        IN,
        NOT_IN;


        public static AddressBookOp fromString(String s) throws ServiceException {
            try {
                return AddressBookOp.valueOf(s.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw ZClientException.CLIENT_ERROR("invalid op: " + s + ", value values: " + Arrays.asList(AddressBookOp.values()), null);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BodyOp {
        CONTAINS,
        NOT_CONTAINS;


        public static BodyOp fromString(String s) throws ServiceException {
            try {
                return BodyOp.valueOf(s.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw ZClientException.CLIENT_ERROR("invalid op: " + s + ", value values: " + Arrays.asList(BodyOp.values()), null);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SizeOp {
        UNDER,
        NOT_UNDER,
        OVER,
        NOT_OVER;


        public static SizeOp fromString(String s) throws ServiceException {
            try {
                return SizeOp.valueOf(s.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw ZClientException.CLIENT_ERROR("invalid op: " + s + ", value values: " + Arrays.asList(SizeOp.values()), null);
            }
        }

        public static SizeOp fromNumberComparison(FilterUtil.NumberComparison comparison, boolean isNegative) {
            if (comparison == FilterUtil.NumberComparison.over) {
                return isNegative ? NOT_OVER : OVER;
            }
            return isNegative ? NOT_UNDER : UNDER;
        }

        public FilterUtil.NumberComparison toNumberComparison() {
            if (this == UNDER || this == NOT_UNDER) {
                return FilterUtil.NumberComparison.under;
            }
            return FilterUtil.NumberComparison.over;
        }

        public boolean isNegative() {
            return this == NOT_UNDER || this == NOT_OVER;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DateOp {
        BEFORE,
        NOT_BEFORE,
        AFTER,
        NOT_AFTER;


        public static DateOp fromString(String s) throws ServiceException {
            try {
                return DateOp.valueOf(s.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw ZClientException.CLIENT_ERROR("invalid op: " + s + ", value values: " + Arrays.asList(DateOp.values()), null);
            }
        }

        public static DateOp fromDateComparison(FilterUtil.DateComparison comparison, boolean isNegative) {
            if (comparison == FilterUtil.DateComparison.before) {
                return isNegative ? NOT_BEFORE : BEFORE;
            }
            return isNegative ? NOT_AFTER : AFTER;
        }

        public FilterUtil.DateComparison toDateComparison() {
            if (this == BEFORE || this == NOT_BEFORE) {
                return FilterUtil.DateComparison.before;
            }
            return FilterUtil.DateComparison.after;
        }

        public boolean isNegative() {
            return this == NOT_BEFORE || this == NOT_AFTER;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HeaderOp {
        IS,
        NOT_IS,
        CONTAINS,
        NOT_CONTAINS,
        MATCHES,
        NOT_MATCHES;


        public static HeaderOp fromString(String s) throws ServiceException {
            try {
                return HeaderOp.valueOf(s.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw ZClientException.CLIENT_ERROR("invalid op: " + s + ", value values: " + Arrays.asList(HeaderOp.values()), null);
            }
        }

        public static HeaderOp fromStringComparison(FilterUtil.StringComparison comparison, boolean isNegative) {
            if (comparison == FilterUtil.StringComparison.is) {
                return isNegative ? NOT_IS : IS;
            }
            if (comparison == FilterUtil.StringComparison.contains) {
                return isNegative ? NOT_CONTAINS : CONTAINS;
            }
            return isNegative ? NOT_MATCHES : MATCHES;
        }

        public FilterUtil.StringComparison toStringComparison() {
            if (this == IS || this == NOT_IS) {
                return FilterUtil.StringComparison.is;
            }
            if (this == CONTAINS || this == NOT_CONTAINS) {
                return FilterUtil.StringComparison.contains;
            }
            return FilterUtil.StringComparison.matches;
        }

        public boolean isNegative() {
            return this == NOT_IS || this == NOT_CONTAINS || this == NOT_MATCHES;
        }
    }
}

