/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.zclient.ZClientException;
import com.zimbra.cs.filter.FilterUtil;
import com.zimbra.cs.zclient.ToZJSONObject;
import com.zimbra.cs.zclient.ZFilterRule;
import com.zimbra.cs.zclient.ZJSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.json.JSONException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ZFilterAction
implements ToZJSONObject {
    public static final String A_DISCARD = "discard";
    public static final String A_FILEINTO = "fileinto";
    public static final String A_FLAG = "flag";
    public static final String A_KEEP = "keep";
    public static final String A_REDIRECT = "redirect";
    public static final String A_STOP = "stop";
    public static final String A_TAG = "tag";
    private String mName;
    protected List<String> mArgs;

    private ZFilterAction(String name, String ... args) {
        this.mName = name;
        this.mArgs = Collections.unmodifiableList(args != null ? Arrays.asList(args) : new ArrayList());
    }

    public String getName() {
        return this.mName;
    }

    public List<String> getArgs() {
        return this.mArgs;
    }

    public abstract String toActionString();

    abstract Element toElement(Element var1);

    public static ZFilterAction getAction(Element actionElement) throws ServiceException {
        String n = actionElement.getName();
        if (n.equals("actionKeep")) {
            return new ZKeepAction();
        }
        if (n.equals("actionDiscard")) {
            return new ZDiscardAction();
        }
        if (n.equals("actionStop")) {
            return new ZStopAction();
        }
        if (n.equals("actionFileInto")) {
            String folderPath = actionElement.getAttribute("folderPath");
            return new ZFileIntoAction(folderPath);
        }
        if (n.equals("actionTag")) {
            String tagName = actionElement.getAttribute("tagName");
            return new ZTagAction(tagName);
        }
        if (n.equals("actionRedirect")) {
            String address = actionElement.getAttribute("a");
            return new ZRedirectAction(address);
        }
        if (n.equals("actionFlag")) {
            FilterUtil.Flag flag = FilterUtil.Flag.fromString(actionElement.getAttribute("flagName"));
            MarkOp op = flag == FilterUtil.Flag.flagged ? MarkOp.FLAGGED : MarkOp.READ;
            return new ZMarkAction(op);
        }
        throw ZClientException.CLIENT_ERROR("unknown filter action: " + n, null);
    }

    @Override
    public ZJSONObject toZJSONObject() throws JSONException {
        ZJSONObject jo = new ZJSONObject();
        jo.put("name", this.mName);
        jo.putList("args", this.mArgs);
        return jo;
    }

    public String toString() {
        return String.format("[ZFilterAction %s]", this.mName);
    }

    public String dump() {
        return ZJSONObject.toString(this);
    }

    public static class ZRedirectAction
    extends ZFilterAction {
        public ZRedirectAction(String address) {
            super(ZFilterAction.A_REDIRECT, new String[]{address});
        }

        public String getAddress() {
            return (String)this.mArgs.get(0);
        }

        public String toActionString() {
            return "redirect " + ZFilterRule.quotedString(this.getAddress());
        }

        Element toElement(Element parent) {
            Element action = parent.addElement("actionRedirect");
            action.addAttribute("a", this.getAddress());
            return action;
        }
    }

    public static class ZMarkAction
    extends ZFilterAction {
        private MarkOp mMarkOp;

        public ZMarkAction(MarkOp op) {
            super(ZFilterAction.A_FLAG, new String[]{op.toProtoArg()});
            this.mMarkOp = op;
        }

        public String getMarkOp() {
            return this.mMarkOp.name();
        }

        public String toActionString() {
            return "mark " + this.mMarkOp.name().toLowerCase();
        }

        Element toElement(Element parent) {
            Element action = parent.addElement("actionFlag");
            FilterUtil.Flag flag = this.mMarkOp == MarkOp.FLAGGED ? FilterUtil.Flag.flagged : FilterUtil.Flag.read;
            action.addAttribute("flagName", flag.toString());
            return action;
        }
    }

    public static class ZTagAction
    extends ZFilterAction {
        public ZTagAction(String tagName) {
            super(ZFilterAction.A_TAG, new String[]{tagName});
        }

        public String getTagName() {
            return (String)this.mArgs.get(0);
        }

        public String toActionString() {
            return "tag " + ZFilterRule.quotedString(this.getTagName());
        }

        Element toElement(Element parent) {
            Element action = parent.addElement("actionTag");
            action.addAttribute("tagName", this.getTagName());
            return action;
        }
    }

    public static class ZFileIntoAction
    extends ZFilterAction {
        public ZFileIntoAction(String folderPath) {
            super(ZFilterAction.A_FILEINTO, new String[]{folderPath});
        }

        public String getFolderPath() {
            return (String)this.mArgs.get(0);
        }

        public String toActionString() {
            return "fileinto " + ZFilterRule.quotedString(this.getFolderPath());
        }

        Element toElement(Element parent) {
            Element action = parent.addElement("actionFileInto");
            action.addAttribute("folderPath", this.getFolderPath());
            return action;
        }
    }

    public static class ZStopAction
    extends ZFilterAction {
        public ZStopAction() {
            super(ZFilterAction.A_STOP, new String[0]);
        }

        public String toActionString() {
            return ZFilterAction.A_STOP;
        }

        Element toElement(Element parent) {
            return parent.addElement("actionStop");
        }
    }

    public static class ZDiscardAction
    extends ZFilterAction {
        public ZDiscardAction() {
            super(ZFilterAction.A_DISCARD, new String[0]);
        }

        public String toActionString() {
            return ZFilterAction.A_DISCARD;
        }

        Element toElement(Element parent) {
            return parent.addElement("actionDiscard");
        }
    }

    public static class ZKeepAction
    extends ZFilterAction {
        public ZKeepAction() {
            super(ZFilterAction.A_KEEP, new String[0]);
        }

        public String toActionString() {
            return ZFilterAction.A_KEEP;
        }

        Element toElement(Element parent) {
            return parent.addElement("actionKeep");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MarkOp {
        READ,
        FLAGGED;

        private static String[] mArgs;

        public static MarkOp fromString(String s) throws ServiceException {
            try {
                return MarkOp.valueOf(s.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw ZClientException.CLIENT_ERROR("invalid op: " + s + ", value values: " + Arrays.asList(MarkOp.values()), null);
            }
        }

        public String toProtoArg() {
            return mArgs[this.ordinal()];
        }

        public static MarkOp fromProtoString(String s) throws ServiceException {
            s = s.trim().toLowerCase();
            for (int i = 0; i < mArgs.length; ++i) {
                if (!mArgs[i].equals(s)) continue;
                return MarkOp.values()[i];
            }
            throw ZClientException.CLIENT_ERROR("invalid arg " + s + ", valid values: " + Arrays.asList(mArgs), null);
        }

        static {
            mArgs = new String[]{"read", "flagged"};
        }
    }
}

