/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient;

import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZFeatures {
    private Map<String, List<String>> mAttrs;

    public ZFeatures(Map<String, List<String>> attrs) {
        this.mAttrs = attrs;
    }

    private String get(String name) {
        List<String> value = this.mAttrs.get(name);
        return value == null || value.isEmpty() ? null : value.get(0);
    }

    public boolean getBool(String name) {
        return "TRUE".equals(this.get(name));
    }

    private long getLong(String name) {
        String v = this.get(name);
        try {
            return v == null ? -1L : Long.parseLong(v);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    public Map<String, List<String>> getAttrs() {
        return this.mAttrs;
    }

    public boolean getContacts() {
        return this.getBool("zimbraFeatureContactsEnabled");
    }

    public boolean getMail() {
        return this.getBool("zimbraFeatureMailEnabled");
    }

    public boolean getVoice() {
        return this.getBool("zimbraFeatureVoiceEnabled");
    }

    public boolean getCalendar() {
        return this.getBool("zimbraFeatureCalendarEnabled");
    }

    public boolean getCalendarUpsell() {
        return this.getBool("zimbraFeatureCalendarUpsellEnabled");
    }

    public String getCalendarUpsellURL() {
        return this.get("zimbraFeatureCalendarUpsellURL");
    }

    public boolean getTasks() {
        return this.getBool("zimbraFeatureTasksEnabled");
    }

    public boolean getTagging() {
        return this.getBool("zimbraFeatureTaggingEnabled");
    }

    public boolean getOptions() {
        return this.getBool("zimbraFeatureOptionsEnabled");
    }

    public boolean getAdvancedSearch() {
        return this.getBool("zimbraFeatureAdvancedSearchEnabled");
    }

    public boolean getSavedSearches() {
        return this.getBool("zimbraFeatureSavedSearchesEnabled");
    }

    public boolean getConversations() {
        return this.getBool("zimbraFeatureConversationsEnabled");
    }

    public boolean getChangePassword() {
        return this.getBool("zimbraFeatureChangePasswordEnabled");
    }

    public boolean getInitialSearchPreference() {
        return this.getBool("zimbraFeatureInitialSearchPreferenceEnabled");
    }

    public boolean getFilters() {
        return this.getBool("zimbraFeatureFiltersEnabled");
    }

    public boolean getGal() {
        return this.getBool("zimbraFeatureGalEnabled");
    }

    public boolean getHtmlCompose() {
        return this.getBool("zimbraFeatureHtmlComposeEnabled");
    }

    public boolean getIM() {
        return this.getBool("zimbraFeatureIMEnabled");
    }

    public boolean getViewInHtml() {
        return this.getBool("zimbraFeatureViewInHtmlEnabled");
    }

    public boolean getSharing() {
        return this.getBool("zimbraFeatureSharingEnabled");
    }

    public boolean getMailForwarding() {
        return this.getBool("zimbraFeatureMailForwardingEnabled");
    }

    public boolean getMailForwardingInFilter() {
        return this.getBool("zimbraFeatureMailForwardingInFiltersEnabled");
    }

    public boolean getMobileSync() {
        return this.getBool("zimbraFeatureMobileSyncEnabled");
    }

    public boolean getSkinChange() {
        return this.getBool("zimbraFeatureSkinChangeEnabled");
    }

    public boolean getNotebook() {
        return this.getBool("zimbraFeatureNotebookEnabled");
    }

    public boolean getBriefcases() {
        return this.getBool("zimbraFeatureBriefcasesEnabled");
    }

    public boolean getGalAutoComplete() {
        return this.getBool("zimbraFeatureGalAutoCompleteEnabled");
    }

    public boolean getOutOfOfficeReply() {
        return this.getBool("zimbraFeatureOutOfOfficeReplyEnabled");
    }

    public boolean getNewMailNotification() {
        return this.getBool("zimbraFeatureNewMailNotificationEnabled");
    }

    public boolean getIdentities() {
        return this.getBool("zimbraFeatureIdentitiesEnabled");
    }

    public boolean getPop3DataSource() {
        return this.getBool("zimbraFeaturePop3DataSourceEnabled");
    }

    public boolean getGroupcalendarEnabled() {
        return this.getBool("zimbraFeatureGroupCalendarEnabled");
    }

    public boolean getFlagging() {
        return this.getBool("zimbraFeatureFlaggingEnabled");
    }

    public boolean getMailPriority() {
        return this.getBool("zimbraFeatureMailPriorityEnabled");
    }

    public boolean getPortalEnabled() {
        return this.getBool("zimbraFeaturePortalEnabled");
    }

    public boolean getWebSearchEnabled() {
        return this.get("zimbraFeatureWebSearchEnabled") == null || this.getBool("zimbraFeatureWebSearchEnabled");
    }

    public boolean getWebClientShowOfflineLink() {
        return this.get("zimbraWebClientShowOfflineLink") == null || this.getBool("zimbraWebClientShowOfflineLink");
    }

    public boolean getNewAddrBookEnabled() {
        return this.get("zimbraFeatureNewAddrBookEnabled") == null || this.getBool("zimbraFeatureNewAddrBookEnabled");
    }

    public boolean getPop3Enabled() {
        return this.get("zimbraPop3Enabled") == null || this.getBool("zimbraPop3Enabled");
    }
}

