/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.zclient.ToZJSONObject;
import com.zimbra.cs.zclient.ZJSONObject;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.json.JSONException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZEmailAddress
implements ToZJSONObject {
    public static final String EMAIL_TYPE_BCC = "b";
    public static final String EMAIL_TYPE_CC = "c";
    public static final String EMAIL_TYPE_FROM = "f";
    public static final String EMAIL_TYPE_SENDER = "s";
    public static final String EMAIL_TYPE_TO = "t";
    public static final String EMAIL_TYPE_REPLY_TO = "r";
    private String mAddress;
    private String mDisplay;
    private String mPersonal;
    private String mType;

    public ZEmailAddress(String address, String display, String personal, String type) {
        this.mAddress = address;
        this.mDisplay = display;
        this.mPersonal = personal;
        this.mType = type;
    }

    public ZEmailAddress(Element e) throws ServiceException {
        this.mAddress = e.getAttribute("a", null);
        this.mDisplay = e.getAttribute("d", null);
        this.mPersonal = e.getAttribute("p", null);
        this.mType = e.getAttribute(EMAIL_TYPE_TO, "");
    }

    public String getType() {
        return this.mType;
    }

    public String getPersonal() {
        return this.mPersonal;
    }

    public String getAddress() {
        return this.mAddress;
    }

    public String getDisplay() {
        return this.mDisplay;
    }

    private String quoteAddress(String addr) {
        if (addr == null) {
            return "";
        }
        if (addr.startsWith("<")) {
            return addr;
        }
        return "<" + addr + ">";
    }

    public String getFullAddressQuoted() {
        if (this.mPersonal == null) {
            return this.quoteAddress(this.mAddress);
        }
        String p = this.mPersonal;
        if (p.indexOf("\"") != -1) {
            p = p.replaceAll("\"", "\\\"");
        }
        return "\"" + p + "\" " + this.quoteAddress(this.mAddress);
    }

    public String getFullAddress() {
        try {
            if (this.mPersonal == null) {
                return this.mAddress;
            }
            return new InternetAddress(this.mAddress, this.mPersonal).toUnicodeString();
        }
        catch (UnsupportedEncodingException e) {
            if (this.mPersonal == null) {
                return this.mAddress;
            }
            String p = this.mPersonal;
            if (p.indexOf("\"") != -1) {
                p = p.replaceAll("\"", "\\\"");
            }
            return p + " " + this.getAddress();
        }
    }

    public boolean isBcc() {
        return EMAIL_TYPE_BCC.equals(this.getType());
    }

    public boolean isCc() {
        return EMAIL_TYPE_CC.equals(this.getType());
    }

    public boolean isFrom() {
        return EMAIL_TYPE_FROM.equals(this.getType());
    }

    public boolean isSender() {
        return EMAIL_TYPE_SENDER.equals(this.getType());
    }

    public boolean isTo() {
        return EMAIL_TYPE_TO.equals(this.getType());
    }

    public boolean isReplyTo() {
        return EMAIL_TYPE_REPLY_TO.equals(this.getType());
    }

    @Override
    public ZJSONObject toZJSONObject() throws JSONException {
        ZJSONObject jo = new ZJSONObject();
        jo.put("address", this.mAddress);
        jo.put("display", this.mDisplay);
        jo.put("personal", this.mPersonal);
        jo.put("type", this.mType);
        jo.put("fullAddressQuoted", this.getFullAddressQuoted());
        return jo;
    }

    public String toString() {
        return String.format("[ZEmailAddress %s]", this.getFullAddressQuoted());
    }

    public String dump() {
        return ZJSONObject.toString(this);
    }

    public static List<ZEmailAddress> parseAddresses(String line, String type) throws ServiceException {
        try {
            line = line.replace(";", ",");
            InternetAddress[] inetAddrs = InternetAddress.parseHeader((String)line, (boolean)false);
            ArrayList<ZEmailAddress> result = new ArrayList<ZEmailAddress>(inetAddrs.length);
            for (InternetAddress ia : inetAddrs) {
                result.add(new ZEmailAddress(ia.getAddress().replaceAll("\"", ""), null, ia.getPersonal(), type));
            }
            return result;
        }
        catch (AddressException e) {
            throw MailServiceException.ADDRESS_PARSE_ERROR(e);
        }
    }
}

