/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.zclient.ZDocument;
import com.zimbra.cs.zclient.ZJSONObject;
import com.zimbra.cs.zclient.ZSearchHit;
import com.zimbra.cs.zclient.event.ZModifyEvent;
import org.json.JSONException;

public class ZDocumentHit
implements ZSearchHit {
    private ZDocument mDoc;
    private String mId;
    private String mSortField;
    private float mScore;

    public ZDocumentHit(Element e) throws ServiceException {
        this.mId = e.getAttribute("id");
        this.mSortField = e.getAttribute("sf", null);
        this.mScore = (float)e.getAttributeDouble("score", 0.0);
        this.mDoc = new ZDocument(e);
    }

    public ZDocument getDocument() {
        return this.mDoc;
    }

    public String getId() {
        return this.mId;
    }

    public float getScore() {
        return this.mScore;
    }

    public String getSortField() {
        return this.mSortField;
    }

    public void modifyNotification(ZModifyEvent event) throws ServiceException {
    }

    public ZJSONObject toZJSONObject() throws JSONException {
        ZJSONObject zjo = new ZJSONObject();
        zjo.put("id", this.mId);
        zjo.put("sortField", this.mSortField);
        zjo.put("score", this.mScore);
        zjo.put("document", this.mDoc);
        return zjo;
    }

    public String toString() {
        return String.format("[ZDocumentHit %s]", this.mId);
    }

    public String dump() {
        return ZJSONObject.toString(this);
    }
}

