/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.zclient.ToZJSONObject;
import com.zimbra.cs.zclient.ZItem;
import com.zimbra.cs.zclient.ZJSONObject;
import com.zimbra.cs.zclient.event.ZModifyEvent;
import org.json.JSONException;

public class ZDocument
implements ZItem,
ToZJSONObject {
    private boolean mIsWiki;
    private String mName;
    private String mId;
    private String mFolderId;
    private String mVersion;
    private String mEditor;
    private String mCreator;
    private String mRestUrl;
    private long mCreatedDate;
    private long mModifiedDate;
    private long mMetaDataChangedDate;
    private long mSize;
    private String mContentType;
    private String mTagIds;

    public ZDocument(Element e) throws ServiceException {
        this.mIsWiki = "w".equals(e.getName());
        this.mName = e.getAttribute("name");
        this.mId = e.getAttribute("id");
        this.mFolderId = e.getAttribute("l");
        this.mVersion = e.getAttribute("ver");
        this.mEditor = e.getAttribute("leb");
        this.mCreator = e.getAttribute("cr");
        this.mRestUrl = e.getAttribute("rest", null);
        this.mCreatedDate = e.getAttributeLong("cd", 0L) * 1000L;
        this.mModifiedDate = e.getAttributeLong("md", 0L) * 1000L;
        this.mMetaDataChangedDate = e.getAttributeLong("md", 0L) * 1000L;
        this.mSize = e.getAttributeLong("s", 0L);
        this.mContentType = this.mIsWiki ? "text/html" : e.getAttribute("ct");
        this.mTagIds = e.getAttribute("t", null);
    }

    public ZJSONObject toZJSONObject() throws JSONException {
        ZJSONObject zjo = new ZJSONObject();
        zjo.put("name", this.mName);
        zjo.put("id", this.mId);
        zjo.put("folderId", this.mFolderId);
        zjo.put("version", this.mVersion);
        zjo.put("editor", this.mEditor);
        zjo.put("createor", this.mCreator);
        zjo.put("restUrl", this.mRestUrl);
        zjo.put("createdDate", this.mCreatedDate);
        zjo.put("modifiedDate", this.mModifiedDate);
        zjo.put("metaDataChangedDate", this.mMetaDataChangedDate);
        zjo.put("size", this.mSize);
        zjo.put("contentType", this.mContentType);
        zjo.put("tags", this.mTagIds);
        return zjo;
    }

    public String toString() {
        return String.format("[ZDocument %s]", this.mId);
    }

    public String dump() {
        return ZJSONObject.toString(this);
    }

    public String getId() {
        return this.mId;
    }

    public String getName() {
        return this.mName;
    }

    public String getFolderId() {
        return this.mFolderId;
    }

    public String getVersion() {
        return this.mVersion;
    }

    public String getEditor() {
        return this.mEditor;
    }

    public String getCreator() {
        return this.mCreator;
    }

    public String getRestUrl() {
        return this.mRestUrl;
    }

    public long getCreatedDate() {
        return this.mCreatedDate;
    }

    public long getModifiedDate() {
        return this.mModifiedDate;
    }

    public long getMetaDataChangedDate() {
        return this.mMetaDataChangedDate;
    }

    public boolean isWiki() {
        return this.mIsWiki;
    }

    public String getContentType() {
        return this.mContentType;
    }

    public long getSize() {
        return this.mSize;
    }

    public String getTagIds() {
        return this.mTagIds;
    }

    public void modifyNotification(ZModifyEvent event) throws ServiceException {
    }
}

