/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient;

import com.zimbra.common.calendar.TZIDMapper;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.zclient.ToZJSONObject;
import com.zimbra.cs.zclient.ZJSONObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.json.JSONException;

public class ZDateTime
implements ToZJSONObject {
    private static final String FMT_DATE = "yyyyMMdd";
    private static final String FMT_DATE_TIME = "yyyyMMdd'T'HHmmss";
    private String mDateTime;
    private String mTimeZoneId;

    public ZDateTime() {
    }

    public ZDateTime(long utcMsecs, boolean dateOnly, TimeZone tz) {
        SimpleDateFormat dateFmt = new SimpleDateFormat(dateOnly ? FMT_DATE : FMT_DATE_TIME);
        dateFmt.setTimeZone(tz);
        this.mTimeZoneId = TZIDMapper.canonicalize(tz.getID());
        this.mDateTime = dateFmt.format(new Date(utcMsecs));
    }

    public ZDateTime(String dateTime) {
        this.mDateTime = dateTime;
    }

    public ZDateTime(String dateTime, String timeZone) {
        this.mDateTime = dateTime;
        this.mTimeZoneId = timeZone;
    }

    public ZDateTime(Element e) throws ServiceException {
        this.mDateTime = e.getAttribute("d");
        this.mTimeZoneId = e.getAttribute("tz", null);
    }

    public Element toElement(String name, Element parent) {
        Element dtEl = parent.addElement(name);
        dtEl.addAttribute("d", this.mDateTime);
        if (this.mTimeZoneId != null) {
            dtEl.addAttribute("tz", this.mTimeZoneId);
        }
        return dtEl;
    }

    public boolean getHasNoTimeZone() {
        return this.mTimeZoneId == null || this.mTimeZoneId.length() == 0;
    }

    public TimeZone getTimeZone() {
        if (!this.getHasNoTimeZone()) {
            return TimeZone.getTimeZone(TZIDMapper.canonicalize(this.mTimeZoneId));
        }
        return TimeZone.getTimeZone("GMT");
    }

    public Calendar getCalendar() {
        SimpleDateFormat df = new SimpleDateFormat(this.mDateTime.indexOf(84) == -1 ? FMT_DATE : FMT_DATE_TIME);
        df.setLenient(false);
        TimeZone tz = null;
        if (this.mTimeZoneId != null && this.mTimeZoneId.length() > 0) {
            tz = TimeZone.getTimeZone(TZIDMapper.canonicalize(this.mTimeZoneId));
            df.setTimeZone(tz);
        } else if (this.mDateTime.indexOf(90) != -1) {
            df.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        Date date = null;
        try {
            date = df.parse(this.mDateTime);
        }
        catch (ParseException e) {
            date = new Date();
        }
        Calendar cal = tz == null ? Calendar.getInstance() : Calendar.getInstance(tz);
        cal.setTime(date);
        return cal;
    }

    public Date getDate() {
        SimpleDateFormat df = new SimpleDateFormat(this.mDateTime.indexOf(84) == -1 ? FMT_DATE : FMT_DATE_TIME);
        df.setLenient(false);
        TimeZone tz = null;
        if (this.mTimeZoneId != null && this.mTimeZoneId.length() > 0) {
            tz = TimeZone.getTimeZone(TZIDMapper.canonicalize(this.mTimeZoneId));
            df.setTimeZone(tz);
        } else if (this.mDateTime.indexOf(90) != -1) {
            df.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        Date date = null;
        try {
            date = df.parse(this.mDateTime);
        }
        catch (ParseException e) {
            date = new Date();
        }
        return date;
    }

    public String getDateTime() {
        return this.mDateTime;
    }

    public void setDateTime(String dateTime) {
        this.mDateTime = dateTime;
    }

    public String getTimeZoneId() {
        return this.mTimeZoneId;
    }

    public void setTimeZoneId(String timeZoneId) {
        this.mTimeZoneId = timeZoneId;
    }

    public ZJSONObject toZJSONObject() throws JSONException {
        ZJSONObject zjo = new ZJSONObject();
        zjo.put("time", this.getDate().getTime());
        zjo.put("dateTime", this.mDateTime);
        zjo.put("timeZoneId", this.mTimeZoneId);
        return zjo;
    }

    public String toString() {
        return String.format("[ZDateTime %s]", this.getDate().toString());
    }

    public String dump() {
        return ZJSONObject.toString(this);
    }
}

