/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.zclient.ZConversation;
import com.zimbra.cs.zclient.ZEmailAddress;
import com.zimbra.cs.zclient.ZJSONObject;
import com.zimbra.cs.zclient.ZSearchHit;
import com.zimbra.cs.zclient.event.ZModifyConversationEvent;
import com.zimbra.cs.zclient.event.ZModifyEvent;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZConversationHit
implements ZSearchHit {
    private String mId;
    private String mFlags;
    private String mFragment;
    private String mSubject;
    private String mSortField;
    private String mTags;
    private float mScore;
    private int mMessageCount;
    private long mDate;
    private List<String> mMessageIds;
    private List<ZEmailAddress> mRecipients;

    public ZConversationHit(Element e) throws ServiceException {
        this.mId = e.getAttribute("id");
        this.mFlags = e.getAttribute("f", null);
        this.mDate = e.getAttributeLong("d");
        this.mTags = e.getAttribute("t", null);
        this.mFragment = e.getAttribute("fr", null);
        this.mSubject = e.getAttribute("su", null);
        this.mSortField = e.getAttribute("sf", null);
        this.mMessageCount = (int)e.getAttributeLong("n");
        this.mScore = (float)e.getAttributeDouble("score", 0.0);
        this.mMessageIds = new ArrayList<String>();
        for (Element m : e.listElements("m")) {
            this.mMessageIds.add(m.getAttribute("id"));
        }
        this.mRecipients = new ArrayList<ZEmailAddress>();
        for (Element emailEl : e.listElements("e")) {
            this.mRecipients.add(new ZEmailAddress(emailEl));
        }
    }

    @Override
    public void modifyNotification(ZModifyEvent event) throws ServiceException {
        if (event instanceof ZModifyConversationEvent) {
            ZModifyConversationEvent cevent = (ZModifyConversationEvent)event;
            this.mFlags = cevent.getFlags(this.mFlags);
            this.mTags = cevent.getTagIds(this.mTags);
            this.mSubject = cevent.getSubject(this.mSubject);
            this.mFragment = cevent.getFragment(this.mFragment);
            this.mMessageCount = cevent.getMessageCount(this.mMessageCount);
            this.mRecipients = cevent.getRecipients(this.mRecipients);
        }
    }

    @Override
    public String getId() {
        return this.mId;
    }

    @Override
    public float getScore() {
        return this.mScore;
    }

    @Override
    public ZJSONObject toZJSONObject() throws JSONException {
        ZJSONObject jo = new ZJSONObject();
        jo.put("id", this.mId);
        jo.put("flags", this.mFlags);
        jo.put("tags", this.mTags);
        jo.put("fragment", this.mFragment);
        jo.put("subject", this.mSubject);
        jo.put("date", this.mDate);
        jo.put("sortField", this.mSortField);
        jo.put("messageCount", this.mMessageCount);
        jo.putList("messageIds", this.mMessageIds);
        jo.put("recipients", this.mRecipients);
        return jo;
    }

    public String toString() {
        return String.format("[ZConversationHit %s]", this.mId);
    }

    public String dump() {
        return ZJSONObject.toString(this);
    }

    public String getFlags() {
        return this.mFlags;
    }

    public long getDate() {
        return this.mDate;
    }

    public String getFragment() {
        return this.mFragment;
    }

    @Override
    public String getSortField() {
        return this.mSortField;
    }

    public String getSubject() {
        return this.mSubject;
    }

    public String getTagIds() {
        return this.mTags;
    }

    public int getMessageCount() {
        return this.mMessageCount;
    }

    public List<String> getMatchedMessageIds() {
        return this.mMessageIds;
    }

    public List<ZEmailAddress> getRecipients() {
        return this.mRecipients;
    }

    public boolean hasFlags() {
        return this.mFlags != null && this.mFlags.length() > 0;
    }

    public boolean hasTags() {
        return this.mTags != null && this.mTags.length() > 0;
    }

    public boolean hasAttachment() {
        return this.hasFlags() && this.mFlags.indexOf(ZConversation.Flag.attachment.getFlagChar()) != -1;
    }

    public boolean isFlagged() {
        return this.hasFlags() && this.mFlags.indexOf(ZConversation.Flag.flagged.getFlagChar()) != -1;
    }

    public boolean isHighPriority() {
        return this.hasFlags() && this.mFlags.indexOf(ZConversation.Flag.highPriority.getFlagChar()) != -1;
    }

    public boolean isLowPriority() {
        return this.hasFlags() && this.mFlags.indexOf(ZConversation.Flag.lowPriority.getFlagChar()) != -1;
    }

    public boolean isSentByMe() {
        return this.hasFlags() && this.mFlags.indexOf(ZConversation.Flag.sentByMe.getFlagChar()) != -1;
    }

    public boolean isUnread() {
        return this.hasFlags() && this.mFlags.indexOf(ZConversation.Flag.unread.getFlagChar()) != -1;
    }

    public boolean isDraft() {
        return this.hasFlags() && this.mFlags.indexOf(ZConversation.Flag.draft.getFlagChar()) != -1;
    }
}

