/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.zclient.ZClientException;
import com.zimbra.cs.zclient.ToZJSONObject;
import com.zimbra.cs.zclient.ZEmailAddress;
import com.zimbra.cs.zclient.ZFolder;
import com.zimbra.cs.zclient.ZItem;
import com.zimbra.cs.zclient.ZJSONObject;
import com.zimbra.cs.zclient.ZMailbox;
import com.zimbra.cs.zclient.ZMessage;
import com.zimbra.cs.zclient.ZTag;
import com.zimbra.cs.zclient.event.ZModifyConversationEvent;
import com.zimbra.cs.zclient.event.ZModifyEvent;
import com.zimbra.cs.zclient.event.ZModifyMessageEvent;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZConversation
implements ZItem,
ToZJSONObject {
    private String mId;
    private String mFlags;
    private String mSubject;
    private String mTags;
    private int mMessageCount;
    private List<ZMessageSummary> mMessageSummaries;
    private ZMailbox mMailbox;

    public ZConversation(Element e, ZMailbox mailbox) throws ServiceException {
        this.mId = e.getAttribute("id");
        this.mFlags = e.getAttribute("f", null);
        this.mTags = e.getAttribute("t", null);
        this.mSubject = e.getAttribute("su", null);
        this.mMessageCount = (int)e.getAttributeLong("n");
        this.mMessageSummaries = new ArrayList<ZMessageSummary>();
        for (Element msgEl : e.listElements("m")) {
            this.mMessageSummaries.add(new ZMessageSummary(msgEl));
        }
    }

    @Override
    public void modifyNotification(ZModifyEvent event) throws ServiceException {
        ZModifyConversationEvent cevent;
        if (event instanceof ZModifyConversationEvent && (cevent = (ZModifyConversationEvent)event).getId().equals(this.mId)) {
            this.mFlags = cevent.getFlags(this.mFlags);
            this.mTags = cevent.getTagIds(this.mTags);
            this.mSubject = cevent.getSubject(this.mSubject);
            this.mMessageCount = cevent.getMessageCount(this.mMessageCount);
        }
    }

    @Override
    public String getId() {
        return this.mId;
    }

    public ZMailbox getMailbox() {
        return this.mMailbox;
    }

    @Override
    public ZJSONObject toZJSONObject() throws JSONException {
        ZJSONObject jo = new ZJSONObject();
        jo.put("id", this.mId);
        jo.put("tagIds", this.mTags);
        jo.put("flags", this.mFlags);
        jo.put("subject", this.mSubject);
        jo.put("messageCount", this.mMessageCount);
        jo.put("messageSummaries", this.mMessageSummaries);
        return jo;
    }

    public String toString() {
        return String.format("[ZConversation %s]", this.mId);
    }

    public String dump() {
        return ZJSONObject.toString(this);
    }

    public String getFlags() {
        return this.mFlags;
    }

    public String getSubject() {
        return this.mSubject;
    }

    public String getTagIds() {
        return this.mTags;
    }

    public int getMessageCount() {
        return this.mMessageCount;
    }

    public List<ZMessageSummary> getMessageSummaries() {
        return this.mMessageSummaries;
    }

    public boolean hasFlags() {
        return this.mFlags != null && this.mFlags.length() > 0;
    }

    public boolean hasTags() {
        return this.mTags != null && this.mTags.length() > 0;
    }

    public boolean hasAttachment() {
        return this.hasFlags() && this.mFlags.indexOf(Flag.attachment.getFlagChar()) != -1;
    }

    public boolean isFlagged() {
        return this.hasFlags() && this.mFlags.indexOf(Flag.flagged.getFlagChar()) != -1;
    }

    public boolean isSentByMe() {
        return this.hasFlags() && this.mFlags.indexOf(Flag.sentByMe.getFlagChar()) != -1;
    }

    public boolean isUnread() {
        return this.hasFlags() && this.mFlags.indexOf(Flag.unread.getFlagChar()) != -1;
    }

    public boolean isForwarded() {
        return this.hasFlags() && this.mFlags.indexOf(Flag.forwarded.getFlagChar()) != -1;
    }

    public boolean isRepliedTo() {
        return this.hasFlags() && this.mFlags.indexOf(Flag.replied.getFlagChar()) != -1;
    }

    public boolean isDraft() {
        return this.hasFlags() && this.mFlags.indexOf(Flag.draft.getFlagChar()) != -1;
    }

    public boolean isHighPriority() {
        return this.hasFlags() && this.mFlags.indexOf(Flag.highPriority.getFlagChar()) != -1;
    }

    public boolean isLowPriority() {
        return this.hasFlags() && this.mFlags.indexOf(Flag.lowPriority.getFlagChar()) != -1;
    }

    public void delete(String tc) throws ServiceException {
        this.getMailbox().deleteConversation(this.getId(), tc);
    }

    public void deleteItem(String tc) throws ServiceException {
        this.delete(tc);
    }

    public void trash(String tc) throws ServiceException {
        this.getMailbox().trashConversation(this.getId(), tc);
    }

    public void markRead(boolean read, String tc) throws ServiceException {
        this.getMailbox().markConversationRead(this.getId(), read, tc);
    }

    public void flag(boolean flag, String tc) throws ServiceException {
        this.getMailbox().flagConversation(this.getId(), flag, tc);
    }

    public void tag(String nameOrId, boolean tagged, String tc) throws ServiceException {
        ZTag tag = this.mMailbox.getTag(nameOrId);
        if (tag == null) {
            throw ZClientException.CLIENT_ERROR("unknown tag: " + nameOrId, null);
        }
        this.tag(tag, tagged, tc);
    }

    public void tag(ZTag tag, boolean tagged, String tc) throws ServiceException {
        this.mMailbox.tagConversation(this.mId, tag.getId(), tagged, tc);
    }

    public void move(String pathOrId, String tc) throws ServiceException {
        ZFolder destFolder = this.mMailbox.getFolder(pathOrId);
        if (destFolder == null) {
            throw ZClientException.CLIENT_ERROR("unknown folder: " + pathOrId, null);
        }
        this.move(destFolder, tc);
    }

    public void move(ZFolder destFolder, String tc) throws ServiceException {
        this.mMailbox.moveConversation(this.mId, destFolder.getId(), tc);
    }

    public void markSpam(boolean spam, String pathOrId, String tc) throws ServiceException {
        ZFolder destFolder = this.mMailbox.getFolder(pathOrId);
        if (destFolder == null) {
            throw ZClientException.CLIENT_ERROR("unknown folder: " + pathOrId, null);
        }
        this.markSpam(spam, destFolder, tc);
    }

    public void markSpam(boolean spam, ZFolder destFolder, String tc) throws ServiceException {
        this.getMailbox().markConversationSpam(this.getId(), spam, destFolder == null ? null : destFolder.getId(), tc);
    }

    public class ZMessageSummary
    implements ZItem,
    ToZJSONObject {
        private long mDate;
        private String mFlags;
        private String mTags;
        private String mFragment;
        private String mId;
        private String mFolderId;
        private ZEmailAddress mSender;
        private long mSize;
        private Element mElement;

        public ZMessageSummary(Element e) throws ServiceException {
            this.mElement = e;
            this.mId = e.getAttribute("id");
            this.mFlags = e.getAttribute("f", null);
            this.mDate = e.getAttributeLong("d");
            this.mTags = e.getAttribute("t", null);
            this.mFolderId = e.getAttribute("l", null);
            this.mFragment = e.getAttribute("fr", null);
            this.mSize = e.getAttributeLong("s");
            Element emailEl = e.getOptionalElement("e");
            if (emailEl != null) {
                this.mSender = new ZEmailAddress(emailEl);
            }
        }

        public Element getElement() {
            return this.mElement;
        }

        public void modifyNotification(ZModifyEvent event) throws ServiceException {
            ZModifyMessageEvent mevent;
            if (event instanceof ZModifyMessageEvent && (mevent = (ZModifyMessageEvent)event).getId().equals(this.mId)) {
                this.mFlags = mevent.getFlags(this.mFlags);
                this.mTags = mevent.getTagIds(this.mTags);
                this.mFolderId = mevent.getFolderId(this.mFolderId);
            }
        }

        public ZJSONObject toZJSONObject() throws JSONException {
            ZJSONObject jo = new ZJSONObject();
            jo.put("id", this.mId);
            jo.put("folderId", this.mFolderId);
            jo.put("flags", this.mFlags);
            jo.put("fragment", this.mFragment);
            jo.put("tags", this.mTags);
            jo.put("size", this.mSize);
            jo.put("sender", this.mSender);
            jo.put("date", this.mDate);
            jo.put("hasAttachment", this.hasAttachment());
            jo.put("hasFlags", this.hasFlags());
            jo.put("hasTags", this.hasTags());
            jo.put("isDeleted", this.isDeleted());
            jo.put("isDraft", this.isDraft());
            jo.put("isFlagged", this.isFlagged());
            jo.put("isHighPriority", this.isHighPriority());
            jo.put("isLowPriority", this.isLowPriority());
            jo.put("isForwarded", this.isForwarded());
            jo.put("isNotificationSent", this.isNotificationSent());
            jo.put("isRepliedTo", this.isRepliedTo());
            jo.put("isSentByMe", this.isSentByMe());
            jo.put("isUnread", this.isUnread());
            return jo;
        }

        public String toString() {
            return String.format("[ZMessageSummary %s]", this.mId);
        }

        public String dump() {
            return ZJSONObject.toString(this);
        }

        public long getDate() {
            return this.mDate;
        }

        public String getFlags() {
            return this.mFlags;
        }

        public String getFragment() {
            return this.mFragment;
        }

        public String getId() {
            return this.mId;
        }

        public ZEmailAddress getSender() {
            return this.mSender;
        }

        public long getSize() {
            return this.mSize;
        }

        public String getFolderId() {
            return this.mFolderId;
        }

        public String getTagIds() {
            return this.mTags;
        }

        public boolean hasFlags() {
            return this.mFlags != null && this.mFlags.length() > 0;
        }

        public boolean hasTags() {
            return this.mTags != null && this.mTags.length() > 0;
        }

        public boolean hasAttachment() {
            return this.hasFlags() && this.mFlags.indexOf(ZMessage.Flag.attachment.getFlagChar()) != -1;
        }

        public boolean isDeleted() {
            return this.hasFlags() && this.mFlags.indexOf(ZMessage.Flag.deleted.getFlagChar()) != -1;
        }

        public boolean isDraft() {
            return this.hasFlags() && this.mFlags.indexOf(ZMessage.Flag.draft.getFlagChar()) != -1;
        }

        public boolean isFlagged() {
            return this.hasFlags() && this.mFlags.indexOf(ZMessage.Flag.flagged.getFlagChar()) != -1;
        }

        public boolean isHighPriority() {
            return this.hasFlags() && this.mFlags.indexOf(ZMessage.Flag.highPriority.getFlagChar()) != -1;
        }

        public boolean isLowPriority() {
            return this.hasFlags() && this.mFlags.indexOf(ZMessage.Flag.lowPriority.getFlagChar()) != -1;
        }

        public boolean isForwarded() {
            return this.hasFlags() && this.mFlags.indexOf(ZMessage.Flag.forwarded.getFlagChar()) != -1;
        }

        public boolean isNotificationSent() {
            return this.hasFlags() && this.mFlags.indexOf(ZMessage.Flag.notificationSent.getFlagChar()) != -1;
        }

        public boolean isRepliedTo() {
            return this.hasFlags() && this.mFlags.indexOf(ZMessage.Flag.replied.getFlagChar()) != -1;
        }

        public boolean isSentByMe() {
            return this.hasFlags() && this.mFlags.indexOf(ZMessage.Flag.sentByMe.getFlagChar()) != -1;
        }

        public boolean isUnread() {
            return this.hasFlags() && this.mFlags.indexOf(ZMessage.Flag.unread.getFlagChar()) != -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Flag {
        unread('u'),
        draft('d'),
        flagged('f'),
        highPriority('!'),
        lowPriority('?'),
        sentByMe('s'),
        replied('r'),
        forwarded('w'),
        attachment('a');

        private char mFlagChar;

        public char getFlagChar() {
            return this.mFlagChar;
        }

        public static String toNameList(String flags) {
            if (flags == null || flags.length() == 0) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < flags.length(); ++i) {
                String v = null;
                for (Flag f : Flag.values()) {
                    if (f.getFlagChar() != flags.charAt(i)) continue;
                    v = f.name();
                    break;
                }
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(v == null ? flags.substring(i, i + 1) : v);
            }
            return sb.toString();
        }

        private Flag(char flagChar) {
            this.mFlagChar = flagChar;
        }
    }
}

