/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.zclient.ZContact;
import com.zimbra.cs.zclient.ZJSONObject;
import com.zimbra.cs.zclient.ZSearchHit;
import com.zimbra.cs.zclient.event.ZModifyContactEvent;
import com.zimbra.cs.zclient.event.ZModifyEvent;
import java.util.Map;
import org.json.JSONException;

public class ZContactHit
implements ZSearchHit {
    private String mId;
    private String mFlags;
    private String mTagIds;
    private String mSortField;
    private String mFileAsStr;
    private String mEmail;
    private String mEmail2;
    private String mEmail3;
    private String mWorkEmail1;
    private String mWorkEmail2;
    private String mWorkEmail3;
    private String mRevision;
    private String mFolderId;
    private String mType;
    private String mDlist;
    private float mScore;
    private long mMetaDataDate;
    private long mDate;
    private String mFullName;

    public ZContactHit(Element e) throws ServiceException {
        this.mId = e.getAttribute("id");
        this.mFlags = e.getAttribute("f", null);
        this.mTagIds = e.getAttribute("t", null);
        this.mSortField = e.getAttribute("sf", null);
        this.mScore = (float)e.getAttributeDouble("score", 0.0);
        this.mFileAsStr = e.getAttribute("fileAsStr", null);
        this.mRevision = e.getAttribute("rev", null);
        this.mFolderId = e.getAttribute("l", null);
        this.mType = e.getAttribute("type", null);
        this.mEmail = e.getAttribute("email", null);
        this.mEmail2 = e.getAttribute("email2", null);
        this.mEmail3 = e.getAttribute("email3", null);
        this.mWorkEmail1 = e.getAttribute("workEmail1", null);
        this.mWorkEmail2 = e.getAttribute("workEmail2", null);
        this.mWorkEmail3 = e.getAttribute("workEmail3", null);
        this.mDate = e.getAttributeLong("d", 0L);
        this.mMetaDataDate = e.getAttributeLong("md", 0L) * 1000L;
        this.mDlist = e.getAttribute("dlist", null);
        this.mFullName = e.getAttribute("fullName", null);
    }

    public ZJSONObject toZJSONObject() throws JSONException {
        ZJSONObject jo = new ZJSONObject();
        jo.put("id", this.mId);
        jo.put("tags", this.mTagIds);
        jo.put("flags", this.mFlags);
        jo.put("sortField", this.mSortField);
        jo.put("type", this.mType);
        jo.put("score", this.mScore);
        jo.put("date", this.mDate);
        jo.put("fileAsStr", this.mFileAsStr);
        jo.put("revision", this.mRevision);
        jo.put("folderId", this.mFolderId);
        jo.put("dlist", this.mDlist);
        jo.put("email", this.mEmail);
        jo.put("email2", this.mEmail2);
        jo.put("email3", this.mEmail3);
        jo.put("workEmail1", this.mWorkEmail1);
        jo.put("workEmail2", this.mWorkEmail2);
        jo.put("workEmail3", this.mWorkEmail3);
        jo.put("fullName", this.mFullName);
        return jo;
    }

    public String toString() {
        return String.format("[ZContactHit %s]", this.mId);
    }

    public String dump() {
        return ZJSONObject.toString(this);
    }

    public boolean isGroup() {
        return "group".equalsIgnoreCase(this.getType());
    }

    public boolean isContact() {
        return !this.isGroup();
    }

    public String getDlist() {
        return this.mDlist;
    }

    public String getType() {
        return this.mType;
    }

    public String getTagIds() {
        return this.mTagIds;
    }

    public boolean hasTags() {
        return this.mTagIds != null && this.mTagIds.length() > 0;
    }

    public String getEmail() {
        return this.mEmail;
    }

    public String getEmail2() {
        return this.mEmail2;
    }

    public String getEmail3() {
        return this.mEmail3;
    }

    public String getWorkEmail1() {
        return this.mWorkEmail1;
    }

    public String getWorkEmail2() {
        return this.mWorkEmail2;
    }

    public String getWorkEmail3() {
        return this.mWorkEmail3;
    }

    public String getFileAsStr() {
        return this.mFileAsStr;
    }

    public String getFolderId() {
        return this.mFolderId;
    }

    public String getId() {
        return this.mId;
    }

    public String getFlags() {
        return this.mFlags;
    }

    public boolean hasFlags() {
        return this.mFlags != null && this.mFlags.length() > 0;
    }

    public boolean isFlagged() {
        return this.hasFlags() && this.mFlags.indexOf(ZContact.Flag.flagged.getFlagChar()) != -1;
    }

    public String getRevision() {
        return this.mRevision;
    }

    public float getScore() {
        return this.mScore;
    }

    public String getSortField() {
        return this.mSortField;
    }

    public long getMetaDataChangedDate() {
        return this.mMetaDataDate;
    }

    public long getDate() {
        return this.mDate;
    }

    public String getFullName() {
        return this.mFullName;
    }

    public void modifyNotification(ZModifyEvent event) throws ServiceException {
        ZModifyContactEvent cevent;
        if (event instanceof ZModifyContactEvent && (cevent = (ZModifyContactEvent)event).getId().equals(this.mId)) {
            String dlist;
            this.mTagIds = cevent.getTagIds(this.mTagIds);
            this.mFolderId = cevent.getFolderId(this.mFolderId);
            this.mFlags = cevent.getFlags(this.mFlags);
            this.mRevision = cevent.getRevision(this.mRevision);
            this.mFileAsStr = cevent.getFileAsStr(this.mFileAsStr);
            this.mEmail = cevent.getEmail(this.mEmail);
            this.mEmail2 = cevent.getEmail(this.mEmail2);
            this.mEmail3 = cevent.getEmail(this.mEmail3);
            Map<String, String> attrs = cevent.getAttrs(null);
            String string = dlist = attrs != null ? attrs.get("dlist") : null;
            if (dlist != null) {
                this.mDlist = dlist;
            }
        }
    }
}

