/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.zclient.ZContact;
import com.zimbra.cs.zclient.ZMailbox;
import com.zimbra.cs.zclient.ZPhone;
import com.zimbra.cs.zclient.event.ZCreateContactEvent;
import com.zimbra.cs.zclient.event.ZCreateEvent;
import com.zimbra.cs.zclient.event.ZDeleteEvent;
import com.zimbra.cs.zclient.event.ZEventHandler;
import com.zimbra.cs.zclient.event.ZModifyContactEvent;
import com.zimbra.cs.zclient.event.ZModifyEvent;
import com.zimbra.cs.zclient.event.ZRefreshEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ZContactByPhoneCache
extends ZEventHandler {
    private static List<String> sATTRS = Arrays.asList("homePhone", "homePhone2", "mobilePhone", "otherPhone", "workPhone", "workPhone2", "homeFax", "workFax", "workMobile", "workAltPhone", "otherFax", "assistantPhone", "companyPhone");
    private Map<String, ContactPhone> mCache = new HashMap<String, ContactPhone>();
    private boolean mCleared = true;
    private Map<String, ZContact> mContacts = new HashMap<String, ZContact>();

    private void addPhoneKey(String field, ZContact contact) {
        String key = contact.getAttrs().get(field);
        if (key == null) {
            return;
        }
        key = ZPhone.getName(key);
        this.mCache.put(key, new ContactPhone(contact, field));
    }

    private void removeKey(String field, ZContact contact) {
        String key = contact.getAttrs().get(field);
        if (key == null) {
            return;
        }
        key = ZPhone.getName(key);
        this.mCache.remove(key);
    }

    public synchronized ContactPhone getByPhone(String phone, ZMailbox mailbox) throws ServiceException {
        if (this.mCleared) {
            this.init(mailbox);
        }
        return this.mCache.get(ZPhone.getName(phone));
    }

    private synchronized void addContact(ZContact contact) {
        this.mContacts.put(contact.getId(), contact);
        for (String attr : sATTRS) {
            this.addPhoneKey(attr, contact);
        }
    }

    private synchronized void removeContact(String id) {
        ZContact contact = this.mContacts.get(id);
        if (contact == null) {
            return;
        }
        this.mContacts.remove(id);
        for (String attr : sATTRS) {
            this.removeKey(attr, contact);
        }
    }

    public synchronized void clear() {
        this.mContacts.clear();
        this.mCleared = true;
        this.mCache.clear();
    }

    private synchronized void init(ZMailbox mailbox) throws ServiceException {
        List<ZContact> contacts = mailbox.getContacts(null, null, false, null);
        for (ZContact contact : contacts) {
            if (contact.getFolderId().equals("3")) continue;
            this.addContact(contact);
        }
        this.mCleared = false;
    }

    public void handleRefresh(ZRefreshEvent refreshEvent, ZMailbox mailbox) throws ServiceException {
        this.clear();
    }

    public void handleCreate(ZCreateEvent event, ZMailbox mailbox) throws ServiceException {
        if (event instanceof ZCreateContactEvent) {
            this.clear();
        }
    }

    public void handleModify(ZModifyEvent event, ZMailbox mailbox) throws ServiceException {
        if (event instanceof ZModifyContactEvent) {
            this.clear();
        }
    }

    public synchronized void handleDelete(ZDeleteEvent event, ZMailbox mailbox) throws ServiceException {
        for (String id : event.toList()) {
            this.removeContact(id);
        }
    }

    public static class ContactPhone {
        private ZContact mContact;
        private String mField;

        public ContactPhone(ZContact contact, String field) {
            this.mContact = contact;
            this.mField = field;
        }

        public ZContact getContact() {
            return this.mContact;
        }

        public String getField() {
            return this.mField;
        }
    }
}

