/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.zclient.ZClientException;
import com.zimbra.cs.zclient.ToZJSONObject;
import com.zimbra.cs.zclient.ZEmailAddress;
import com.zimbra.cs.zclient.ZFolder;
import com.zimbra.cs.zclient.ZItem;
import com.zimbra.cs.zclient.ZJSONObject;
import com.zimbra.cs.zclient.ZMailbox;
import com.zimbra.cs.zclient.ZTag;
import com.zimbra.cs.zclient.event.ZModifyContactEvent;
import com.zimbra.cs.zclient.event.ZModifyEvent;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZContact
implements ZItem,
ToZJSONObject {
    public static final String FA_LAST_C_FIRST = "1";
    public static final String FA_FIRST_LAST = "2";
    public static final String FA_COMPANY = "3";
    public static final String FA_LAST_C_FIRST_COMPANY = "4";
    public static final String FA_FIRST_LAST_COMPANY = "5";
    public static final String FA_COMPANY_LAST_C_FIRST = "6";
    public static final String FA_COMPANY_FIRST_LAST = "7";
    public static final String FA_EXPLICIT = "8";
    private String mId;
    private String mFlags;
    private String mFolderId;
    private String mTagIds;
    private String mRevision;
    private long mDate;
    private long mMetaDataChangedDate;
    private Map<String, String> mAttrs;
    private Map<String, String> mAttachments;
    private boolean mGalContact;
    private ZMailbox mMailbox;

    public ZContact(Element e, boolean galContact, ZMailbox mailbox) throws ServiceException {
        this(e, mailbox);
        this.mGalContact = galContact;
    }

    public ZContact(Element e, ZMailbox mailbox) throws ServiceException {
        this.mMailbox = mailbox;
        this.mId = e.getAttribute("id");
        this.mFolderId = e.getAttribute("l", null);
        this.mFlags = e.getAttribute("f", null);
        this.mTagIds = e.getAttribute("t", null);
        this.mRevision = e.getAttribute("rev", null);
        this.mDate = e.getAttributeLong("d", 0L);
        this.mMetaDataChangedDate = e.getAttributeLong("md", 0L) * 1000L;
        HashMap<String, String> attrs = new HashMap<String, String>();
        HashMap<String, String> attachments = new HashMap<String, String>();
        for (Element attrEl : e.listElements("a")) {
            String name = attrEl.getAttribute("n");
            String part = attrEl.getAttribute("part", null);
            if (part != null) {
                attachments.put(name, part);
                continue;
            }
            attrs.put(name, attrEl.getText());
        }
        this.mAttrs = Collections.unmodifiableMap(attrs);
        this.mAttachments = Collections.unmodifiableMap(attachments);
    }

    public ZMailbox getMailbox() {
        return this.mMailbox;
    }

    public String getFolderId() {
        return this.mFolderId;
    }

    public ZFolder getFolder() throws ServiceException {
        return this.mMailbox.getFolderById(this.mFolderId);
    }

    @Override
    public String getId() {
        return this.mId;
    }

    public boolean isGalContact() {
        return this.mGalContact;
    }

    public boolean isGroup() {
        return this.getAttrs().get("dlist") != null;
    }

    public boolean getIsGroup() {
        return this.isGroup();
    }

    public List<ZEmailAddress> getGroupMembers() throws ServiceException {
        return ZEmailAddress.parseAddresses(this.getAttrs().get("dlist"), "t");
    }

    @Override
    public ZJSONObject toZJSONObject() throws JSONException {
        ZJSONObject jo = new ZJSONObject();
        jo.put("id", this.mId);
        jo.put("folderId", this.mFolderId);
        jo.put("flags", this.mFlags);
        jo.put("tagIds", this.mTagIds);
        jo.put("date", this.mDate);
        jo.put("metaDataChangedDate", this.mMetaDataChangedDate);
        jo.put("revision", this.mRevision);
        jo.put("isFlagged", this.isFlagged());
        jo.put("isGalContact", this.isGalContact());
        jo.put("isGroup", this.isGroup());
        jo.put("hasFlags", this.hasFlags());
        jo.put("hasTags", this.hasTags());
        jo.putMap("attrs", this.mAttrs);
        return jo;
    }

    public String toString() {
        return String.format("[ZContact %s]", this.mId);
    }

    public String dump() {
        return ZJSONObject.toString(this);
    }

    public String getFlags() {
        return this.mFlags;
    }

    public Map<String, String> getAttrs() {
        return this.mAttrs;
    }

    public Set<String> getAttachmentNames() {
        return this.mAttachments.keySet();
    }

    public String getAttachmentPartName(String name) {
        return this.mAttachments.get(name);
    }

    public InputStream getAttachmentData(String name) throws ServiceException {
        String part = this.mAttachments.get(name);
        if (part == null) {
            throw ZClientException.CLIENT_ERROR("Invalid attachment name: " + name, null);
        }
        String url = String.format("?id=%s&part=%s", this.getId(), part);
        return this.mMailbox.getRESTResource(url);
    }

    public long getDate() {
        return this.mDate;
    }

    public long getMetaDataChangedDate() {
        return this.mMetaDataChangedDate;
    }

    public String getRevision() {
        return this.mRevision;
    }

    public String getTagIds() {
        return this.mTagIds;
    }

    public boolean hasFlags() {
        return this.mFlags != null && this.mFlags.length() > 0;
    }

    public boolean hasTags() {
        return this.mTagIds != null && this.mTagIds.length() > 0;
    }

    public boolean hasAttachment() {
        return this.hasFlags() && this.mFlags.indexOf(Flag.attachment.getFlagChar()) != -1;
    }

    public boolean isFlagged() {
        return this.hasFlags() && this.mFlags.indexOf(Flag.flagged.getFlagChar()) != -1;
    }

    @Override
    public void modifyNotification(ZModifyEvent event) throws ServiceException {
        ZModifyContactEvent cevent;
        if (event instanceof ZModifyContactEvent && (cevent = (ZModifyContactEvent)event).getId().equals(this.mId)) {
            this.mTagIds = cevent.getTagIds(this.mTagIds);
            this.mFolderId = cevent.getFolderId(this.mFolderId);
            this.mFlags = cevent.getFlags(this.mFlags);
            this.mRevision = cevent.getRevision(this.mRevision);
            this.mMetaDataChangedDate = cevent.getDate(this.mDate);
            this.mMetaDataChangedDate = cevent.getMetaDataChangedDate(this.mMetaDataChangedDate);
            this.mAttrs = cevent.getAttrs(this.mAttrs);
        }
    }

    public void delete() throws ServiceException {
        if (this.isGalContact()) {
            throw ZClientException.CLIENT_ERROR("can't modify GAL contact", null);
        }
        this.mMailbox.deleteContact(this.mId);
    }

    public void deleteItem() throws ServiceException {
        this.delete();
    }

    public void trash() throws ServiceException {
        if (this.isGalContact()) {
            throw ZClientException.CLIENT_ERROR("can't modify GAL contact", null);
        }
        this.mMailbox.trashContact(this.mId);
    }

    public void flag(boolean flagged) throws ServiceException {
        if (this.isGalContact()) {
            throw ZClientException.CLIENT_ERROR("can't modify GAL contact", null);
        }
        this.mMailbox.flagContact(this.mId, flagged);
    }

    public void tag(String nameOrId, boolean tagged) throws ServiceException {
        ZTag tag = this.mMailbox.getTag(nameOrId);
        if (tag == null) {
            throw ZClientException.CLIENT_ERROR("unknown tag: " + nameOrId, null);
        }
        this.tag(tag, tagged);
    }

    public void tag(ZTag tag, boolean tagged) throws ServiceException {
        if (this.isGalContact()) {
            throw ZClientException.CLIENT_ERROR("can't modify GAL contact", null);
        }
        this.mMailbox.tagContact(this.mId, tag.getId(), tagged);
    }

    public void move(String pathOrId) throws ServiceException {
        ZFolder destFolder = this.mMailbox.getFolder(pathOrId);
        if (destFolder == null) {
            throw ZClientException.CLIENT_ERROR("unknown folder: " + pathOrId, null);
        }
        this.move(destFolder);
    }

    public void move(ZFolder destFolder) throws ServiceException {
        if (this.isGalContact()) {
            throw ZClientException.CLIENT_ERROR("can't modify GAL contact", null);
        }
        this.mMailbox.moveContact(this.mId, destFolder.getId());
    }

    public void modify(Map<String, String> attrs, boolean replace) throws ServiceException {
        if (this.isGalContact()) {
            throw ZClientException.CLIENT_ERROR("can't modify GAL contact", null);
        }
        this.mMailbox.modifyContact(this.mId, replace, attrs);
    }

    public void update(String destFolderId, String tagList, String flags) throws ServiceException {
        if (this.isGalContact()) {
            throw ZClientException.CLIENT_ERROR("can't modify GAL contact", null);
        }
        this.mMailbox.updateContact(this.mId, destFolderId, tagList, flags);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Flag {
        flagged('f'),
        attachment('a');

        private char mFlagChar;

        public char getFlagChar() {
            return this.mFlagChar;
        }

        public static String toNameList(String flags) {
            if (flags == null || flags.length() == 0) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < flags.length(); ++i) {
                String v = null;
                for (Flag f : Flag.values()) {
                    if (f.getFlagChar() != flags.charAt(i)) continue;
                    v = f.name();
                    break;
                }
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(v == null ? flags.substring(i, i + 1) : v);
            }
            return sb.toString();
        }

        private Flag(char flagChar) {
            this.mFlagChar = flagChar;
        }
    }
}

