/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.zclient.ZJSONObject;
import com.zimbra.cs.zclient.ZPhone;
import com.zimbra.cs.zclient.ZSearchHit;
import com.zimbra.cs.zclient.event.ZModifyEvent;
import org.json.JSONException;

public class ZCallHit
implements ZSearchHit {
    private String mId = "ZCallHit";
    private String mSortField;
    private float mScore;
    private long mDate;
    private long mDuration;
    private ZPhone mCaller;
    private ZPhone mRecipient;

    public ZCallHit(Element e) throws ServiceException {
        this.mSortField = e.getAttribute("sf", null);
        this.mScore = (float)e.getAttributeDouble("score", 0.0);
        this.mDate = e.getAttributeLong("d");
        this.mDuration = e.getAttributeLong("du") * 1000L;
        for (Element el : e.listElements("cp")) {
            String addressType = el.getAttribute("t", null);
            if ("f".equals(addressType)) {
                this.mCaller = new ZPhone(el.getAttribute("n"), el.getAttribute("p", null));
                continue;
            }
            this.mRecipient = new ZPhone(el.getAttribute("n"), el.getAttribute("p", null));
        }
    }

    public String getId() {
        return this.mId;
    }

    public float getScore() {
        return this.mScore;
    }

    public String getSortField() {
        return this.mSortField;
    }

    public ZPhone getCaller() {
        return this.mCaller;
    }

    public ZPhone getRecipient() {
        return this.mRecipient;
    }

    public String getDisplayCaller() {
        return this.mCaller.getDisplay();
    }

    public String getDisplayRecipient() {
        return this.mRecipient.getDisplay();
    }

    public long getDate() {
        return this.mDate;
    }

    public long getDuration() {
        return this.mDuration;
    }

    public void modifyNotification(ZModifyEvent event) throws ServiceException {
    }

    public ZJSONObject toZJSONObject() throws JSONException {
        ZJSONObject zjo = new ZJSONObject();
        zjo.put("id", this.mId);
        zjo.put("sortField", this.mSortField);
        zjo.put("score", this.mScore);
        zjo.put("date", this.mDate);
        zjo.put("duration", this.mDuration);
        zjo.put("caller", this.mCaller);
        zjo.put("recipient", this.mRecipient);
        return zjo;
    }

    public String toString() {
        return String.format("[ZCallHit %s]", this.mId);
    }

    public String dump() {
        return ZJSONObject.toString(this);
    }
}

