/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.zclient.ZCallFeature;
import com.zimbra.cs.zclient.ZMailbox;
import com.zimbra.cs.zclient.ZPhone;
import com.zimbra.cs.zclient.ZSelectiveCallForwarding;
import com.zimbra.cs.zclient.ZVoiceMailPrefs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZCallFeatures {
    private ZMailbox mMbox;
    private ZPhone mPhone;
    private Map<String, ZCallFeature> mCallFeatures;
    private boolean mCallFeaturesLoaded;

    public ZCallFeatures(ZMailbox mbox, ZPhone phone) {
        this.mMbox = mbox;
        this.mPhone = phone;
        this.mCallFeatures = new HashMap<String, ZCallFeature>();
        this.mCallFeaturesLoaded = false;
    }

    public ZCallFeatures(ZMailbox mbox, ZPhone phone, Element e) throws ServiceException {
        this(mbox, phone);
        this.addFeature("anoncallrejection");
        this.addFeature("callforward");
        this.addFeature("selectivecallforward");
        this.addFeature("voicemailprefs");
        List<Element> elements = e.listElements("callfeature");
        for (Element element : elements) {
            String name = element.getAttribute("name");
            ZCallFeature feature = this.mCallFeatures.get(name);
            if (feature == null) continue;
            feature.setIsSubscribed(true);
        }
    }

    public ZPhone getPhone() {
        return this.mPhone;
    }

    public void loadCallFeatures() throws ServiceException {
        if (!this.mCallFeaturesLoaded) {
            this.mCallFeaturesLoaded = true;
            this.mMbox.loadCallFeatures(this);
        }
    }

    public synchronized ZCallFeature getFeature(String name) {
        ZCallFeature result = this.mCallFeatures.get(name);
        if (result == null) {
            result = this.addFeature(name);
        }
        return result;
    }

    public ZSelectiveCallForwarding getSelectiveCallForwarding() {
        return (ZSelectiveCallForwarding)this.getFeature("selectivecallforward");
    }

    public ZVoiceMailPrefs getVoiceMailPrefs() {
        return (ZVoiceMailPrefs)this.getFeature("voicemailprefs");
    }

    public synchronized ZCallFeature addFeature(String name) {
        ZCallFeature result = "selectivecallforward".equals(name) ? new ZSelectiveCallForwarding(name) : ("voicemailprefs".equals(name) ? new ZVoiceMailPrefs(name) : new ZCallFeature(name));
        this.mCallFeatures.put(name, result);
        return result;
    }

    public Collection<ZCallFeature> getAllFeatures() {
        return this.mCallFeatures.values();
    }

    public boolean isEmpty() {
        return this.mCallFeatures.isEmpty();
    }

    public List<ZCallFeature> getSubscribedFeatures() {
        Collection<ZCallFeature> allFeatures = this.mCallFeatures.values();
        ArrayList<ZCallFeature> result = new ArrayList<ZCallFeature>();
        for (ZCallFeature feature : allFeatures) {
            if (!feature.getIsSubscribed()) continue;
            result.add(feature);
        }
        return result;
    }
}

