/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ZCallFeature {
    private String mName;
    private boolean mIsSubscribed;
    private boolean mIsActive;
    private Map<String, String> mData;

    public ZCallFeature(String name) {
        this.mName = name;
        this.mIsSubscribed = false;
        this.mIsActive = false;
        this.mData = new HashMap<String, String>();
    }

    public boolean getIsSubscribed() {
        return this.mIsSubscribed;
    }

    public void setIsSubscribed(boolean isSubscribed) {
        this.mIsSubscribed = isSubscribed;
    }

    public boolean getIsActive() {
        return this.mIsActive;
    }

    public void setIsActive(boolean isActive) {
        this.mIsActive = isActive;
    }

    public String getData(String key) {
        return this.mData.get(key);
    }

    public void setData(String key, String value) {
        this.mData.put(key, value);
    }

    public void clearData() {
        this.mData.clear();
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public synchronized void assignFrom(ZCallFeature that) {
        this.mName = that.mName;
        this.mIsActive = that.mIsActive;
        this.mData.clear();
        this.mData.putAll(that.mData);
    }

    synchronized void fromElement(Element element) throws ServiceException {
        Iterator<Element.Attribute> iter = element.attributeIterator();
        while (iter.hasNext()) {
            Element.Attribute attribute = iter.next();
            String key = attribute.getKey();
            String value = attribute.getValue();
            if ("a".equals(key)) {
                this.mIsActive = Element.parseBool(key, value);
                continue;
            }
            if ("s".equals(key)) {
                this.mIsSubscribed = Element.parseBool(key, value);
                continue;
            }
            this.setData(key, value);
        }
    }

    void toElement(Element element) throws ServiceException {
        element.addAttribute("s", true);
        element.addAttribute("a", this.mIsActive);
        for (String key : this.mData.keySet()) {
            Element subEl = element.addElement(key);
            String value = this.mData.get(key);
            if (value == null) continue;
            subEl.setText(value);
        }
    }
}

