/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.zclient.ToZJSONObject;
import com.zimbra.cs.zclient.ZInvite;
import com.zimbra.cs.zclient.ZItem;
import com.zimbra.cs.zclient.ZJSONObject;
import com.zimbra.cs.zclient.ZMessage;
import com.zimbra.cs.zclient.event.ZModifyEvent;
import com.zimbra.cs.zclient.event.ZModifyMessageEvent;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZCalendarItem
implements ZItem,
ToZJSONObject {
    private String mId;
    private String mFlags;
    private String mTags;
    private String mFolderId;
    private long mDate;
    private long mSize;
    private String mUID;
    private List<ZInvite> mInvites;

    public ZCalendarItem(Element e) throws ServiceException {
        this.mId = e.getAttribute("id");
        this.mFlags = e.getAttribute("f", null);
        this.mTags = e.getAttribute("t", null);
        this.mUID = e.getAttribute("uid", null);
        this.mDate = e.getAttributeLong("d", 0L);
        this.mFolderId = e.getAttribute("l", null);
        this.mSize = e.getAttributeLong("s");
        this.mInvites = new ArrayList<ZInvite>();
        for (Element inviteEl : e.listElements("inv")) {
            this.mInvites.add(new ZInvite(inviteEl));
        }
    }

    @Override
    public void modifyNotification(ZModifyEvent event) throws ServiceException {
        ZModifyMessageEvent mevent;
        if (event instanceof ZModifyMessageEvent && (mevent = (ZModifyMessageEvent)event).getId().equals(this.mId)) {
            this.mFlags = mevent.getFlags(this.mFlags);
            this.mTags = mevent.getTagIds(this.mTags);
            this.mFolderId = mevent.getFolderId(this.mFolderId);
        }
    }

    public String getUid() {
        return this.mUID;
    }

    public long getSize() {
        return this.mSize;
    }

    public List<ZInvite> getInvites() {
        return this.mInvites;
    }

    @Override
    public String getId() {
        return this.mId;
    }

    public boolean hasFlags() {
        return this.mFlags != null && this.mFlags.length() > 0;
    }

    public boolean hasTags() {
        return this.mTags != null && this.mTags.length() > 0;
    }

    @Override
    public ZJSONObject toZJSONObject() throws JSONException {
        ZJSONObject zjo = new ZJSONObject();
        zjo.put("id", this.mId);
        zjo.put("flags", this.mFlags);
        zjo.put("tags", this.mTags);
        zjo.put("date", this.mDate);
        zjo.put("folderId", this.mFolderId);
        zjo.put("size", this.mSize);
        zjo.put("uid", this.mUID);
        zjo.put("invites", this.mInvites);
        return zjo;
    }

    public String toString() {
        return String.format("[ZCalendarItem %s]", this.mId);
    }

    public String dump() {
        return ZJSONObject.toString(this);
    }

    public String getFlags() {
        return this.mFlags;
    }

    public String getTagIds() {
        return this.mTags;
    }

    public String getFolderId() {
        return this.mFolderId;
    }

    public long getDate() {
        return this.mDate;
    }

    public boolean hasAttachment() {
        return this.hasFlags() && this.mFlags.indexOf(ZMessage.Flag.attachment.getFlagChar()) != -1;
    }

    public boolean isFlagged() {
        return this.hasFlags() && this.mFlags.indexOf(ZMessage.Flag.flagged.getFlagChar()) != -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Flag {
        flagged('f'),
        attachment('a');

        private char mFlagChar;

        public char getFlagChar() {
            return this.mFlagChar;
        }

        public static String toNameList(String flags) {
            if (flags == null || flags.length() == 0) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < flags.length(); ++i) {
                String v = null;
                for (Flag f : Flag.values()) {
                    if (f.getFlagChar() != flags.charAt(i)) continue;
                    v = f.name();
                    break;
                }
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(v == null ? flags.substring(i, i + 1) : v);
            }
            return sb.toString();
        }

        private Flag(char flagChar) {
            this.mFlagChar = flagChar;
        }
    }
}

