/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.zclient.ToZJSONObject;
import com.zimbra.cs.zclient.ZFolder;
import com.zimbra.cs.zclient.ZJSONObject;
import com.zimbra.cs.zclient.ZMailbox;
import java.util.Comparator;
import org.json.JSONException;

public class ZAutoCompleteMatch
implements ToZJSONObject {
    private String mRanking;
    private String mType;
    private String mEmail;
    private String mFolderId;
    private String mId;
    private String mDisplay;
    private ZMailbox mMailbox;

    public ZAutoCompleteMatch(Element e, ZMailbox mailbox) throws ServiceException {
        this.mMailbox = mailbox;
        this.mRanking = e.getAttribute("ranking");
        this.mType = e.getAttribute("type");
        this.mEmail = e.getAttribute("email");
        this.mFolderId = e.getAttribute("l", null);
        this.mId = e.getAttribute("id", null);
        this.mDisplay = e.getAttribute("display", null);
    }

    public ZMailbox getMailbox() {
        return this.mMailbox;
    }

    public String getRanking() {
        return this.mRanking;
    }

    public String getType() {
        return this.mType;
    }

    public String getFolderId() {
        return this.mFolderId;
    }

    public ZFolder getFolder() throws ServiceException {
        return this.mMailbox.getFolderById(this.mFolderId);
    }

    public String getId() {
        return this.mId;
    }

    public boolean isGalContact() {
        return this.mType.equals("gal");
    }

    public String getEmail() {
        return this.mEmail;
    }

    public String getDisplayName() {
        return this.mDisplay;
    }

    public String getValue() {
        if (this.mDisplay != null) {
            return this.mDisplay;
        }
        return this.mEmail;
    }

    public ZJSONObject toZJSONObject() throws JSONException {
        ZJSONObject jo = new ZJSONObject();
        jo.put("ranking", this.mRanking);
        jo.put("type", this.mType);
        jo.put("email", this.mEmail);
        if (this.mFolderId != null) {
            jo.put("l", this.mFolderId);
        }
        if (this.mId != null) {
            jo.put("id", this.mId);
        }
        if (this.mDisplay != null) {
            jo.put("display", this.mDisplay);
        }
        return jo;
    }

    public String dump() {
        return ZJSONObject.toString(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MatchComparator
    implements Comparator<ZAutoCompleteMatch> {
        @Override
        public int compare(ZAutoCompleteMatch a, ZAutoCompleteMatch b) {
            int r2;
            int r1 = Integer.parseInt(a.mRanking);
            if (r1 != (r2 = Integer.parseInt(b.mRanking))) {
                return r1 - r2;
            }
            if (a.isGalContact() ^ !b.isGalContact()) {
                return a.isGalContact() ? 1 : -1;
            }
            return a.getValue().compareTo(b.getValue());
        }
    }
}

