/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient;

import com.zimbra.common.auth.ZAuthToken;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.zclient.ZGetInfoResult;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZAuthResult {
    private ZAuthToken mAuthToken;
    private long mExpires;
    private long mLifetime;
    private String mRefer;
    private String mSessionId;
    private Map<String, List<String>> mAttrs;
    private Map<String, List<String>> mPrefs;
    private String mSkin;

    public ZAuthResult(Element e) throws ServiceException {
        this.mAuthToken = new ZAuthToken(e.getElement("authToken"), false);
        this.mLifetime = e.getAttributeLong("lifetime");
        this.mExpires = System.currentTimeMillis() + this.mLifetime;
        this.mRefer = e.getAttribute("refer", null);
        this.mAttrs = ZGetInfoResult.getMap(e, "attrs", "attr");
        this.mPrefs = ZGetInfoResult.getMap(e, "prefs", "pref");
        this.mSkin = e.getAttribute("skin", null);
    }

    public ZAuthToken getAuthToken() {
        return this.mAuthToken;
    }

    public String getSessionId() {
        return this.mSessionId;
    }

    void setSessionId(String id) {
        this.mSessionId = id;
    }

    public long getExpires() {
        return this.mExpires;
    }

    public long getLifetime() {
        return this.mLifetime;
    }

    public String getRefer() {
        return this.mRefer;
    }

    public Map<String, List<String>> getAttrs() {
        return this.mAttrs;
    }

    public Map<String, List<String>> getPrefs() {
        return this.mPrefs;
    }

    public String getSkin() {
        return this.mSkin;
    }
}

