/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.zclient.ZAppointmentHit;
import com.zimbra.cs.zclient.ZMailbox;
import com.zimbra.cs.zclient.event.ZCreateAppointmentEvent;
import com.zimbra.cs.zclient.event.ZCreateEvent;
import com.zimbra.cs.zclient.event.ZDeleteEvent;
import com.zimbra.cs.zclient.event.ZEventHandler;
import com.zimbra.cs.zclient.event.ZModifyAppointmentEvent;
import com.zimbra.cs.zclient.event.ZModifyEvent;
import com.zimbra.cs.zclient.event.ZRefreshEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZApptSummaryCache
extends ZEventHandler {
    private static final long MSECS_PER_MINUTE = 60000L;
    private static final long MSECS_PER_HOUR = 3600000L;
    private static final long MSECS_PER_DAY = 86400000L;
    private static final long MSECS_PER_MONTH_GRID = 3628800000L;
    private Map<String, ZMailbox.ZApptSummaryResult> mResults = new HashMap<String, ZMailbox.ZApptSummaryResult>();
    private Set<String> mIds = new HashSet<String>();
    private Map<String, Set<String>> mMiniCalCache = new HashMap<String, Set<String>>();

    private String makeKey(long start, long end, String folderId, TimeZone timezone, String query) {
        if (query == null) {
            query = "";
        }
        return start + ":" + end + ":" + folderId + ":" + timezone.getID() + ":" + query;
    }

    private String makeMiniCalKey(long start, long end, String[] folderIds) {
        if (folderIds.length == 1) {
            return start + ":" + end + ":" + folderIds[0];
        }
        List<String> folders = Arrays.asList(folderIds);
        Collections.sort(folders);
        return start + ":" + end + ":" + folders;
    }

    synchronized void add(ZMailbox.ZApptSummaryResult result, TimeZone timezone) {
        for (ZAppointmentHit appt : result.getAppointments()) {
            this.mIds.add(appt.getId());
        }
        this.mResults.put(this.makeKey(result.getStart(), result.getEnd(), result.getFolderId(), timezone, result.getQuery()), result);
    }

    synchronized ZMailbox.ZApptSummaryResult get(long start, long end, String folderId, TimeZone timezone, String query) {
        ZMailbox.ZApptSummaryResult result;
        if (query == null) {
            query = "";
        }
        if ((result = this.mResults.get(this.makeKey(start, end, folderId, timezone, query))) == null && end - start < 3628800000L) {
            for (ZMailbox.ZApptSummaryResult cached : this.mResults.values()) {
                if (!cached.getQuery().equals(query) || !cached.getTimeZone().getID().equals(timezone.getID()) || !cached.getFolderId().equals(folderId) || cached.getStart() > start || end > cached.getEnd()) continue;
                ArrayList<ZAppointmentHit> appts = new ArrayList<ZAppointmentHit>();
                for (ZAppointmentHit appt : cached.getAppointments()) {
                    if (!appt.isInRange(start, end)) continue;
                    appts.add(appt);
                }
                return new ZMailbox.ZApptSummaryResult(start, end, folderId, timezone, appts, query);
            }
        }
        return result;
    }

    synchronized void putMiniCal(Set<String> result, long start, long end, String[] folderIds) {
        this.mMiniCalCache.put(this.makeMiniCalKey(start, end, folderIds), result);
    }

    synchronized Set<String> getMiniCal(long start, long end, String[] folderIds) {
        return this.mMiniCalCache.get(this.makeMiniCalKey(start, end, folderIds));
    }

    public synchronized void clear() {
        this.mIds.clear();
        this.mResults.clear();
        this.mMiniCalCache.clear();
    }

    @Override
    public void handleRefresh(ZRefreshEvent refreshEvent, ZMailbox mailbox) throws ServiceException {
        this.clear();
    }

    @Override
    public void handleCreate(ZCreateEvent event, ZMailbox mailbox) throws ServiceException {
        if (event instanceof ZCreateAppointmentEvent) {
            this.clear();
        }
    }

    @Override
    public void handleModify(ZModifyEvent event, ZMailbox mailbox) throws ServiceException {
        if (event instanceof ZModifyAppointmentEvent) {
            this.clear();
        }
    }

    @Override
    public synchronized void handleDelete(ZDeleteEvent event, ZMailbox mailbox) throws ServiceException {
        for (String id : event.toList()) {
            if (!this.mIds.contains(id)) continue;
            this.clear();
            return;
        }
    }
}

