/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.mailbox.calendar.Geo;
import com.zimbra.cs.zclient.ZAppointment;
import com.zimbra.cs.zclient.ZInvite;
import com.zimbra.cs.zclient.ZJSONObject;
import com.zimbra.cs.zclient.ZMailbox;
import com.zimbra.cs.zclient.ZMessage;
import com.zimbra.cs.zclient.ZSearchHit;
import com.zimbra.cs.zclient.ZTaskHit;
import com.zimbra.cs.zclient.event.ZModifyAppointmentEvent;
import com.zimbra.cs.zclient.event.ZModifyEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import org.json.JSONException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZAppointmentHit
implements ZSearchHit {
    public static final String FBA_FREE = "F";
    public static final String FBA_BUSY = "B";
    public static final String FBA_TENTATIVE = "T";
    public static final String FBA_UNAVAILABLE = "U";
    public static final String FBA_OUTOFOFFICE = "O";
    public static final String TRANSP_OPAQUE = "O";
    public static final String TRANSP_TRANSPARENT = "T";
    public static final String STATUS_TENTATIVE = "TENT";
    public static final String STATUS_CONFIRMED = "CONF";
    public static final String STATUS_CANCELLED = "CANC";
    public static final String STATUS_COMPLETED = "COMP";
    public static final String STATUS_DEFERRED = "DEFERRED";
    public static final String STATUS_INPROGRESS = "INPR";
    public static final String STATUS_NOT_STARTED = "NEED";
    public static final String STATUS_WAITING = "WAITING";
    public static final String PSTATUS_NEEDS_ACTION = "NE";
    public static final String PSTATUS_TENTATIVE = "TE";
    public static final String PSTATUS_ACCEPT = "AC";
    public static final String PSTATUS_DECLINED = "DE";
    public static final String PSTATUS_DELEGATED = "DG";
    public static final String CLASS_PUBLIC = "PUB";
    public static final String CLASS_PRIVATE = "PRI";
    public static final String CLASS_CONFIDENTIAL = "CON";
    private String mId;
    private String mFlags;
    private String mTags;
    private String mFreeBusyActual;
    private String mTransparency;
    private String mStatus;
    private String mClass;
    private String mPartStatus;
    private boolean mIsAllDay;
    private boolean mIsOtherAttendees;
    private boolean mIsAlarm;
    private boolean mIsRecurring;
    private String mName;
    private String mLocation;
    private List<String> mCategories;
    private Geo mGeo;
    private String mInviteId;
    private String mSeriesInviteId;
    private String mSeriesComponentNumber;
    private String mInviteComponentNumber;
    private boolean mIsOrganizer;
    private String mPriority;
    private String mPercentComplete;
    private long mDueDate;
    private long mDuration;
    private String mFragment;
    private String mSortField;
    private float mScore;
    private long mSize;
    private String mConvId;
    private long mHitDate;
    private boolean mInstanceExpanded;
    private boolean mIsTask;
    private long mStartTime;
    private long mEndTime;
    private long mTimeZoneOffset;
    private boolean mIsException;
    private String mRecurrenceIdZ;
    private String mFolderId;
    private String mUid;
    private long mModifiedSeq;
    private long mModifiedDate;
    private long mSavedSeq;
    private boolean mIsFromFreeBusy;

    ZAppointmentHit() {
    }

    ZAppointmentHit(ZMailbox.ZFreeBusyTimeSlot slot) {
        switch (slot.getType()) {
            case BUSY: {
                this.mFreeBusyActual = FBA_BUSY;
                break;
            }
            case TENTATIVE: {
                this.mFreeBusyActual = "T";
                break;
            }
            case UNAVAILABLE: {
                this.mFreeBusyActual = FBA_UNAVAILABLE;
                break;
            }
            case OUT_OF_OFFICE: {
                this.mFreeBusyActual = "O";
                break;
            }
            default: {
                this.mFreeBusyActual = FBA_FREE;
            }
        }
        this.mStartTime = slot.getStartTime();
        this.mEndTime = slot.getEndTime();
        this.mDuration = this.mEndTime - this.mStartTime;
        this.mIsFromFreeBusy = true;
    }

    static void addInstances(Element e, List<ZSearchHit> appts, TimeZone timeZone, boolean isTask) throws ServiceException {
        String id = e.getAttribute("id");
        String freeBusyActual = e.getAttribute("fba", null);
        String transparency = e.getAttribute("transp", null);
        String status = e.getAttribute("status", null);
        String classProp = e.getAttribute("class", null);
        String pstatus = e.getAttribute("ptst", null);
        boolean isAllDay = e.getAttributeBool("allDay", false);
        boolean otherAtt = e.getAttributeBool("otherAtt", false);
        boolean isAlarm = e.getAttributeBool("alarm", false);
        boolean isRecurring = e.getAttributeBool("recur", false);
        String flags = e.getAttribute("f", null);
        String tags = e.getAttribute("t", null);
        String name = e.getAttribute("name", null);
        String location = e.getAttribute("loc", null);
        ArrayList<String> categories = null;
        Iterator<Element> catIter = e.elementIterator("category");
        if (catIter.hasNext()) {
            categories = new ArrayList<String>();
            while (catIter.hasNext()) {
                String cat = catIter.next().getTextTrim();
                categories.add(cat);
            }
        }
        Geo geo = null;
        Element geoElem = e.getOptionalElement("geo");
        if (geoElem != null) {
            geo = Geo.parse(geoElem);
        }
        String inviteId = e.getAttribute("invId", null);
        String inviteCompNumber = e.getAttribute("compNum", null);
        boolean isOrganizer = e.getAttributeBool("isOrg", false);
        String priority = e.getAttribute("priority", null);
        String percentComplete = e.getAttribute("percentComplete", null);
        long dueDate = e.getAttributeLong("dueDate", 0L);
        long duration = e.getAttributeLong("dur", 0L);
        long hitDate = e.getAttributeLong("d", 0L);
        String sortField = e.getAttribute("sf", null);
        long size = (int)e.getAttributeLong("s", 0L);
        String convId = e.getAttribute("cid", null);
        float score = (float)e.getAttributeDouble("score", 0.0);
        String folderId = e.getAttribute("l", null);
        String fragment = e.getAttribute("fr", null);
        String uid = e.getAttribute("uid", null);
        long ms = e.getAttributeLong("ms", 0L);
        long md = e.getAttributeLong("d", 0L);
        long ss = e.getAttributeLong("rev", 0L);
        List<Element> instances = e.listElements("inst");
        boolean noInstances = instances.isEmpty();
        if (noInstances) {
            instances = new ArrayList<Element>();
            instances.add(e);
        }
        for (Element inst : instances) {
            ZAppointmentHit appt = isTask ? new ZTaskHit() : new ZAppointmentHit();
            appt.mTimeZoneOffset = e.getAttributeLong("tzo", 0L);
            appt.mInstanceExpanded = !noInstances;
            appt.mFolderId = folderId;
            appt.mId = id;
            appt.mScore = score;
            appt.mSize = size;
            appt.mSortField = sortField;
            appt.mConvId = convId;
            appt.mHitDate = hitDate;
            appt.mIsTask = isTask;
            appt.mIsAllDay = inst.getAttributeBool("allDay", isAllDay);
            appt.mStartTime = inst.getAttributeLong("s", 0L);
            if (appt.mIsAllDay) {
                appt.mStartTime += appt.mTimeZoneOffset - (long)timeZone.getOffset(appt.mStartTime);
            }
            appt.mIsException = inst.getAttributeBool("ex", false);
            appt.mRecurrenceIdZ = inst.getAttribute("ridZ", null);
            appt.mFreeBusyActual = inst.getAttribute("fba", freeBusyActual);
            appt.mTransparency = inst.getAttribute("transp", transparency);
            appt.mStatus = inst.getAttribute("status", status);
            appt.mClass = inst.getAttribute("class", classProp);
            appt.mPartStatus = inst.getAttribute("ptst", pstatus);
            appt.mIsOtherAttendees = inst.getAttributeBool("otherAtt", otherAtt);
            appt.mIsAlarm = inst.getAttributeBool("alarm", isAlarm);
            appt.mIsRecurring = inst.getAttributeBool("recur", isRecurring);
            appt.mFlags = inst.getAttribute("f", flags);
            appt.mTags = inst.getAttribute("t", tags);
            appt.mName = inst.getAttribute("name", name);
            appt.mLocation = inst.getAttribute("loc", location);
            ArrayList<String> instCategories = null;
            Iterator<Element> instCatIter = inst.elementIterator("category");
            if (instCatIter.hasNext()) {
                instCategories = new ArrayList<String>();
                while (instCatIter.hasNext()) {
                    String cat = instCatIter.next().getTextTrim();
                    instCategories.add(cat);
                }
                appt.mCategories = instCategories;
            } else {
                appt.mCategories = categories;
            }
            Element instGeoElem = inst.getOptionalElement("geo");
            appt.mGeo = instGeoElem != null ? Geo.parse(instGeoElem) : geo;
            appt.mInviteId = inst.getAttribute("invId", inviteId);
            appt.mSeriesInviteId = inviteId;
            appt.mInviteComponentNumber = inst.getAttribute("compNum", inviteCompNumber);
            appt.mSeriesComponentNumber = inviteCompNumber;
            appt.mIsOrganizer = inst.getAttributeBool("isOrg", isOrganizer);
            appt.mPriority = inst.getAttribute("priority", priority);
            appt.mPercentComplete = inst.getAttribute("percentComplete", percentComplete);
            appt.mDueDate = inst.getAttributeLong("dueDate", dueDate);
            appt.mDuration = inst.getAttributeLong("dur", duration);
            appt.mEndTime = appt.mStartTime + appt.mDuration;
            appt.mFragment = inst.getAttribute("fr", fragment);
            appt.mUid = inst.getAttribute("uid", uid);
            appt.mModifiedSeq = inst.getAttributeLong("ms", ms);
            appt.mModifiedDate = inst.getAttributeLong("md", md);
            appt.mSavedSeq = inst.getAttributeLong("rev", ss);
            appts.add(appt);
        }
    }

    private String getStr(String value, String def) {
        return value == null ? def : value;
    }

    @Override
    public void modifyNotification(ZModifyEvent event) throws ServiceException {
        if (event instanceof ZModifyAppointmentEvent) {
            ZInvite inv;
            ZInvite.ZComponent comp;
            ZModifyAppointmentEvent mevent = (ZModifyAppointmentEvent)event;
            ZAppointment appt = (ZAppointment)mevent.getItem();
            this.mFlags = this.getStr(appt.getFlags(), this.mFlags);
            this.mTags = this.getStr(appt.getTagIds(), this.mTags);
            this.mFolderId = this.getStr(appt.getFolderId(), this.mFolderId);
            List<ZInvite> invites = appt.getInvites();
            if (invites.size() > 0 && (comp = (inv = invites.get(0)).getComponent()) != null) {
                ZInvite.ZStatus stat = comp.getStatus();
                if (stat != null) {
                    this.mStatus = stat.name();
                }
                this.mPercentComplete = this.getStr(comp.getPercentCompleted(), this.mPercentComplete);
                this.mPriority = this.getStr(comp.getPriority(), this.mPriority);
                this.mName = this.getStr(comp.getName(), this.mName);
                this.mLocation = this.getStr(comp.getLocation(), this.mLocation);
                if (comp.getCategories() != null) {
                    this.mCategories = comp.getCategories();
                }
                if (comp.getGeo() != null) {
                    this.mGeo = comp.getGeo();
                }
            }
        }
    }

    public boolean getIsFromFreeBusy() {
        return this.mIsFromFreeBusy;
    }

    @Override
    public String getId() {
        return this.mId;
    }

    @Override
    public String getSortField() {
        return this.mSortField;
    }

    @Override
    public float getScore() {
        return this.mScore;
    }

    public String getFolderId() {
        return this.mFolderId;
    }

    public boolean getIsTask() {
        return this.mIsTask;
    }

    public long getSize() {
        return this.mSize;
    }

    public String getConversationId() {
        return this.mConvId;
    }

    public long getHitDate() {
        return this.mHitDate;
    }

    public boolean getInstanceExpanded() {
        return this.mInstanceExpanded;
    }

    @Override
    public ZJSONObject toZJSONObject() throws JSONException {
        ZJSONObject jo = new ZJSONObject();
        jo.put("id", this.mId);
        jo.put("folderId", this.mFolderId);
        jo.put("tags", this.mTags);
        jo.put("flags", this.mFlags);
        jo.put("name", this.mName);
        jo.put("location", this.mLocation);
        jo.putList("categories", this.mCategories);
        if (this.mGeo != null) {
            jo.put("geo", this.mGeo.toString());
        }
        jo.put("inviteId", this.mInviteId);
        jo.put("inviteComponentNumber", this.mInviteComponentNumber);
        jo.put("freeBusyActual", this.mFreeBusyActual);
        jo.put("transparency", this.mTransparency);
        jo.put("status", this.mStatus);
        jo.put("class", this.mClass);
        jo.put("participantStatus", this.mPartStatus);
        jo.put("allDay", this.mIsAllDay);
        jo.put("otherAttendees", this.mIsOtherAttendees);
        jo.put("alarm", this.mIsAlarm);
        jo.put("recurring", this.mIsRecurring);
        jo.put("isOrganizer", this.mIsOrganizer);
        jo.put("priority", this.mPriority);
        jo.put("percentComplete", this.mPercentComplete);
        jo.put("duration", this.mDuration);
        jo.put("startTime", this.mStartTime);
        jo.put("timeZoneOffset", this.mTimeZoneOffset);
        jo.put("exception", this.mIsException);
        jo.put("recurrenceId", this.mRecurrenceIdZ);
        jo.put("fragment", this.mFragment);
        jo.put("sortField", this.mSortField);
        jo.put("score", this.mScore);
        jo.put("conversationId", this.mConvId);
        jo.put("size", this.mSize);
        jo.put("isTask", this.mIsTask);
        jo.put("hitDate", this.mHitDate);
        return jo;
    }

    public String toString() {
        return String.format("[ZAppointmentHit %s]", this.mId);
    }

    public String dump() {
        return ZJSONObject.toString(this);
    }

    public String getFreeBusyActual() {
        return this.mFreeBusyActual;
    }

    public boolean isFreeBusyActualFree() {
        return FBA_FREE.equals(this.mFreeBusyActual);
    }

    public boolean isFreeBusyActualBusy() {
        return FBA_BUSY.equals(this.mFreeBusyActual);
    }

    public boolean isFreeBusyActualTentative() {
        return "T".equals(this.mFreeBusyActual);
    }

    public boolean isFreeBusyActualOufOfOffice() {
        return "O".equals(this.mFreeBusyActual);
    }

    public boolean isFreeBusyActualUnavailable() {
        return FBA_UNAVAILABLE.equals(this.mFreeBusyActual);
    }

    public String getTransparency() {
        return this.mTransparency;
    }

    public boolean isTransparencyOpaque() {
        return "O".equals(this.mTransparency);
    }

    public boolean isTransparencyTransparent() {
        return "T".equals(this.mTransparency);
    }

    public String getStatus() {
        return this.mStatus;
    }

    public boolean isStatusTentative() {
        return STATUS_TENTATIVE.equals(this.mStatus);
    }

    public boolean isStatusCancelled() {
        return STATUS_CANCELLED.equals(this.mStatus);
    }

    public boolean isStatusConfirmed() {
        return STATUS_CONFIRMED.equals(this.mStatus);
    }

    public String getClassProp() {
        return this.mClass;
    }

    public boolean isClassPublic() {
        return CLASS_PUBLIC.equals(this.mClass);
    }

    public boolean isClassPrivate() {
        return CLASS_PRIVATE.equals(this.mClass);
    }

    public boolean isClassConfidential() {
        return CLASS_CONFIDENTIAL.equals(this.mClass);
    }

    public String getParticipantStatus() {
        return this.mPartStatus;
    }

    public boolean isPartStatusAccept() {
        return PSTATUS_ACCEPT.equals(this.mPartStatus);
    }

    public boolean isPartStatusDeclined() {
        return PSTATUS_DECLINED.equals(this.mPartStatus);
    }

    public boolean isPartStatusDelegated() {
        return PSTATUS_DELEGATED.equals(this.mPartStatus);
    }

    public boolean isPartStatusNeedsAction() {
        return PSTATUS_NEEDS_ACTION.equals(this.mPartStatus);
    }

    public boolean isPartStatusTentative() {
        return PSTATUS_TENTATIVE.equals(this.mPartStatus);
    }

    public boolean isAllDay() {
        return this.mIsAllDay;
    }

    public boolean isOtherAttendees() {
        return this.mIsOtherAttendees;
    }

    public boolean isAlarm() {
        return this.mIsAlarm;
    }

    public boolean isRecurring() {
        return this.mIsRecurring;
    }

    public String getFlags() {
        return this.mFlags;
    }

    public String getName() {
        return this.mName;
    }

    public String getLocation() {
        return this.mLocation;
    }

    public List<String> getCategories() {
        return this.mCategories;
    }

    public Geo getGeo() {
        return this.mGeo;
    }

    public String getInviteId() {
        return this.mInviteId;
    }

    public String getSeriesInviteId() {
        return this.mSeriesInviteId;
    }

    public String getSeriesComponentNumber() {
        return this.mSeriesComponentNumber;
    }

    public String getInviteComponentNumber() {
        return this.mInviteComponentNumber;
    }

    public boolean isOrganizer() {
        return this.mIsOrganizer;
    }

    public String getPriority() {
        return this.mPriority;
    }

    public String getPercentComplete() {
        return this.mPercentComplete;
    }

    public long getDuration() {
        return this.mDuration;
    }

    public long getStartTime() {
        return this.mStartTime;
    }

    public long getDueDateTime() {
        return this.mDueDate;
    }

    public Date getDueDate() {
        return new Date(this.mDueDate);
    }

    public long getEndTime() {
        return this.mEndTime;
    }

    public Date getStartDate() {
        return new Date(this.mStartTime);
    }

    public Date getEndDate() {
        return new Date(this.mEndTime);
    }

    public long getTimeZoneOffset() {
        return this.mTimeZoneOffset;
    }

    public boolean isException() {
        return this.mIsException;
    }

    public String getRecurrenceIdZ() {
        return this.mRecurrenceIdZ;
    }

    public String getFragment() {
        return this.mFragment;
    }

    public String getTagIds() {
        return this.mTags;
    }

    public String getUid() {
        return this.mUid;
    }

    public long getModifiedSeq() {
        return this.mModifiedSeq;
    }

    public long getModifiedDate() {
        return this.mModifiedDate;
    }

    public long getSavedSeq() {
        return this.mSavedSeq;
    }

    public boolean hasFlags() {
        return this.mFlags != null && this.mFlags.length() > 0;
    }

    public boolean getHasTags() {
        return this.mTags != null && this.mTags.length() > 0;
    }

    public boolean getHasAttachment() {
        return this.hasFlags() && this.mFlags.indexOf(Flag.attachment.getFlagChar()) != -1;
    }

    public boolean getIsFlagged() {
        return this.hasFlags() && this.mFlags.indexOf(ZMessage.Flag.flagged.getFlagChar()) != -1;
    }

    public boolean isInRange(long start, long end) {
        return this.mStartTime < end && this.mEndTime > start;
    }

    public boolean isOverLapping(ZAppointmentHit that) {
        return this.mStartTime < that.mEndTime && this.mEndTime > that.mStartTime;
    }

    public boolean isOverLapping(ZAppointmentHit that, long msecsIncr) {
        long thisStart = this.mStartTime / msecsIncr * msecsIncr;
        long thisEnd = (this.mEndTime + msecsIncr - 1L) / msecsIncr * msecsIncr;
        long thatStart = that.mStartTime / msecsIncr * msecsIncr;
        long thatEnd = (that.mEndTime + msecsIncr - 1L) / msecsIncr * msecsIncr;
        return thisStart < thatEnd && thisEnd > thatStart;
    }

    public boolean isOverLapping(long thatStartTime, long thatEndTime) {
        return this.mStartTime < thatEndTime && this.mEndTime > thatStartTime;
    }

    public static boolean isOverLapping(long start1, long end1, long start2, long end2) {
        return start1 < end2 && end1 > start2;
    }

    public static boolean isOverLapping(long start1, long end1, long start2, long end2, long msecsIncr) {
        start1 = start1 / msecsIncr * msecsIncr;
        end1 = (end1 + msecsIncr - 1L) / msecsIncr * msecsIncr;
        start2 = start2 / msecsIncr * msecsIncr;
        return start1 < (end2 = (end2 + msecsIncr - 1L) / msecsIncr * msecsIncr) && end1 > start2;
    }

    public static class SortByTimeDurationFolder
    implements Comparator {
        public int compare(Object obja, Object objb) {
            if (!(obja instanceof ZAppointmentHit) || !(objb instanceof ZAppointmentHit)) {
                return 0;
            }
            ZAppointmentHit a = (ZAppointmentHit)obja;
            ZAppointmentHit b = (ZAppointmentHit)objb;
            if (!a.isAllDay() && b.isAllDay()) {
                return 1;
            }
            if (a.isAllDay() && !b.isAllDay()) {
                return -1;
            }
            if (a.getStartTime() > b.getStartTime()) {
                return 1;
            }
            if (a.getStartTime() < b.getStartTime()) {
                return -1;
            }
            if (a.getDuration() < b.getDuration()) {
                return 1;
            }
            if (a.getDuration() > b.getDuration()) {
                return -1;
            }
            return a.getFolderId().compareTo(b.getFolderId());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Flag {
        flagged('f'),
        attachment('a');

        private char mFlagChar;

        public char getFlagChar() {
            return this.mFlagChar;
        }

        public static String toNameList(String flags) {
            if (flags == null || flags.length() == 0) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < flags.length(); ++i) {
                String v = null;
                for (Flag f : Flag.values()) {
                    if (f.getFlagChar() != flags.charAt(i)) continue;
                    v = f.name();
                    break;
                }
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(v == null ? flags.substring(i, i + 1) : v);
            }
            return sb.toString();
        }

        private Flag(char flagChar) {
            this.mFlagChar = flagChar;
        }
    }
}

