/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.mailbox.calendar.Attach;
import com.zimbra.cs.mailbox.calendar.ParsedDateTime;
import com.zimbra.cs.mailbox.calendar.ParsedDuration;
import com.zimbra.cs.zclient.ZInvite;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZAlarm {
    private ZAction mAction;
    private ZTriggerType mTriggerType = ZTriggerType.RELATIVE;
    private ZRelated mTriggerRelated;
    private ParsedDuration mTriggerRelative;
    private ParsedDateTime mTriggerAbsolute;
    private ParsedDuration mRepeatDuration;
    private int mRepeatCount;
    private String mSummary;
    private Attach mAttach;
    private List<ZInvite.ZAttendee> mAttendees;
    private String mDescription;

    public ZAlarm() {
    }

    public ZAlarm(Element alarmElem) throws ServiceException {
        Element attachElem;
        Element summaryElem;
        Element descElem;
        ZAction action = ZAction.DISPLAY;
        ZTriggerType triggerType = ZTriggerType.RELATIVE;
        ZRelated triggerRelated = null;
        ParsedDuration triggerRelative = null;
        ParsedDateTime triggerAbsolute = null;
        ParsedDuration repeatDuration = null;
        int repeatCount = 0;
        String description = null;
        String summary = null;
        Attach attach = null;
        Object attendees = null;
        String val = alarmElem.getAttribute("action");
        action = ZAction.lookup(val);
        if (action == null) {
            throw ServiceException.INVALID_REQUEST("Invalid action value " + val, null);
        }
        Element triggerElem = alarmElem.getElement("trigger");
        Element triggerRelativeElem = triggerElem.getOptionalElement("rel");
        if (triggerRelativeElem != null) {
            triggerType = ZTriggerType.RELATIVE;
            String related = triggerRelativeElem.getAttribute("related", null);
            if (related != null && (triggerRelated = ZRelated.lookup(related)) == null) {
                throw ServiceException.INVALID_REQUEST("Invalid related value " + val, null);
            }
            triggerRelative = ParsedDuration.parse(triggerRelativeElem);
        } else {
            triggerType = ZTriggerType.ABSOLUTE;
            Element triggerAbsoluteElem = triggerElem.getOptionalElement("abs");
            if (triggerAbsoluteElem == null) {
                throw ServiceException.INVALID_REQUEST("<trigger> must have either <rel> or <abs> child element", null);
            }
            String datetime = triggerAbsoluteElem.getAttribute("d");
            try {
                triggerAbsolute = ParsedDateTime.parseUtcOnly(datetime);
            }
            catch (ParseException e) {
                throw ServiceException.INVALID_REQUEST("Invalid absolute trigger value " + val, e);
            }
        }
        Element repeatElem = alarmElem.getOptionalElement("repeat");
        if (repeatElem != null) {
            repeatDuration = ParsedDuration.parse(repeatElem);
            repeatCount = (int)repeatElem.getAttributeLong("count", 0L);
        }
        if ((descElem = alarmElem.getOptionalElement("desc")) != null) {
            description = descElem.getText();
        }
        if ((summaryElem = alarmElem.getOptionalElement("summary")) != null) {
            summary = summaryElem.getText();
        }
        if ((attachElem = alarmElem.getOptionalElement("attach")) != null) {
            attach = Attach.parse(attachElem);
        }
        Iterator<Element> attendeesIter = alarmElem.elementIterator("at");
        while (attendeesIter.hasNext()) {
            ZInvite.ZAttendee at = new ZInvite.ZAttendee(attendeesIter.next());
            if (this.mAttendees == null) {
                this.mAttendees = new ArrayList<ZInvite.ZAttendee>();
            }
            this.mAttendees.add(at);
        }
        this.setAction(action);
        this.setDescription(description);
        this.setSummary(summary);
        this.setTriggerRelative(triggerRelative);
    }

    public ZAction getAction() {
        return this.mAction;
    }

    public void setAction(ZAction mAction) {
        this.mAction = mAction;
    }

    public ZTriggerType getTriggerType() {
        return this.mTriggerType;
    }

    public void setTriggerType(ZTriggerType triggerType) {
        this.mTriggerType = triggerType;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public void setDescription(String mDescription) {
        this.mDescription = mDescription;
    }

    public int getRepeatCount() {
        return this.mRepeatCount;
    }

    public void setRepeatCount(int mRepeatCount) {
        this.mRepeatCount = mRepeatCount;
    }

    public void setTriggerRelative(ParsedDuration dur) {
        this.mTriggerRelative = dur;
    }

    public ParsedDuration getTriggerRelated() {
        return this.mTriggerRelative;
    }

    public void setTriggerAbsolute(ParsedDateTime abs) {
        this.mTriggerAbsolute = abs;
    }

    public ParsedDateTime getTriggerAbsolute() {
        return this.mTriggerAbsolute;
    }

    public void setSummary(String summary) {
        this.mSummary = summary;
    }

    public String getSummary() {
        return this.mSummary;
    }

    public List<ZInvite.ZAttendee> getAttendees() {
        return this.mAttendees;
    }

    public void setAttendees(List<ZInvite.ZAttendee> attendees) {
        this.mAttendees = attendees;
    }

    public void addAttendee(ZInvite.ZAttendee attendee) {
        if (this.mAttendees == null) {
            this.mAttendees = new ArrayList<ZInvite.ZAttendee>();
        }
        this.mAttendees.add(attendee);
    }

    public Element toElement(Element parent) {
        Element alarm = parent.addElement("alarm");
        alarm.addAttribute("action", this.mAction.toString());
        Element trigger = alarm.addElement("trigger");
        if (ZTriggerType.ABSOLUTE.equals((Object)this.mTriggerType)) {
            Element absolute = trigger.addElement("abs");
            absolute.addAttribute("d", this.mTriggerAbsolute.toString());
        } else {
            Element relative = this.mTriggerRelative.toXml(trigger, "rel");
            if (this.mTriggerRelated != null) {
                relative.addAttribute("related", this.mTriggerRelated.toString());
            }
        }
        if (this.mRepeatDuration != null) {
            Element repeat = this.mRepeatDuration.toXml(alarm, "repeat");
            repeat.addAttribute("count", this.mRepeatCount);
        }
        if (!ZAction.AUDIO.equals((Object)this.mAction) && this.mDescription != null) {
            Element desc = alarm.addElement("desc");
            desc.setText(this.mDescription);
        }
        if (this.mAttach != null) {
            this.mAttach.toXml(alarm);
        }
        if (ZAction.EMAIL.equals((Object)this.mAction) || ZAction.X_YAHOO_CALENDAR_ACTION_IM.equals((Object)this.mAction) || ZAction.X_YAHOO_CALENDAR_ACTION_MOBILE.equals((Object)this.mAction)) {
            Element summary = alarm.addElement("summary");
            if (this.mSummary != null) {
                summary.setText(this.mSummary);
            }
            if (this.mAttendees != null) {
                for (ZInvite.ZAttendee attendee : this.mAttendees) {
                    attendee.toElement(alarm);
                }
            }
        }
        return alarm;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ZTriggerType {
        ABSOLUTE,
        RELATIVE;


        public static ZTriggerType lookup(String str) {
            if (str != null) {
                try {
                    str = str.replace('-', '_').toUpperCase();
                    return ZTriggerType.valueOf(str);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ZRelated {
        START,
        END;


        public static ZRelated lookup(String str) {
            if (str != null) {
                try {
                    str = str.replace('-', '_').toUpperCase();
                    return ZRelated.valueOf(str);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ZAction {
        DISPLAY("DISPLAY"),
        AUDIO("AUDIO"),
        EMAIL("EMAIL"),
        X_YAHOO_CALENDAR_ACTION_IM("X-YAHOO-CALENDAR-ACTION-IM"),
        X_YAHOO_CALENDAR_ACTION_MOBILE("X-YAHOO-CALENDAR-ACTION-MOBILE"),
        PROCEDURE("PROCEDURE");

        private String mValue;

        private ZAction(String value) {
            this.mValue = value;
        }

        public String toString() {
            return this.mValue;
        }

        public static ZAction lookup(String str) {
            if (str != null) {
                try {
                    str = str.replace('-', '_').toUpperCase();
                    return ZAction.valueOf(str);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

