/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.zclient.ZClientException;
import com.zimbra.cs.zclient.ToZJSONObject;
import com.zimbra.cs.zclient.ZJSONObject;
import java.util.Arrays;
import org.json.JSONException;

public class ZAce
implements ToZJSONObject {
    private String mGranteeName;
    private String mGranteeId;
    private GranteeType mGranteeType;
    private String mRight;
    private boolean mDeny;
    private String mSecret;
    public static final String GUID_AUTHUSER = "00000000-0000-0000-0000-000000000000";
    public static final String GUID_PUBLIC = "99999999-9999-9999-9999-999999999999";

    public ZAce(Element e) throws ServiceException {
        this.mRight = e.getAttribute("right");
        this.mDeny = e.getAttributeBool("deny", false);
        this.mGranteeName = e.getAttribute("d", null);
        this.mGranteeId = e.getAttribute("zid", null);
        this.mGranteeType = GranteeType.fromString(e.getAttribute("gt"));
        this.mSecret = e.getAttribute("pw", null);
    }

    public ZAce(GranteeType granteeType, String granteeId, String granteeName, String right, boolean deny, String secret) throws ServiceException {
        this.mRight = right;
        this.mDeny = deny;
        this.mGranteeName = granteeName;
        this.mGranteeId = granteeId;
        this.mGranteeType = granteeType;
        this.mSecret = secret;
    }

    public void toElement(Element parent) {
        Element ace = parent.addElement("ace");
        ace.addAttribute("right", this.mRight);
        ace.addAttribute("gt", this.mGranteeType.name());
        ace.addAttribute("zid", this.mGranteeId);
        ace.addAttribute("d", this.mGranteeName);
        if (this.mGranteeType == GranteeType.gst) {
            ace.addAttribute("pw", this.mSecret);
        } else if (this.mGranteeType == GranteeType.key) {
            ace.addAttribute("key", this.mSecret);
        }
        if (this.mDeny) {
            ace.addAttribute("deny", this.mDeny);
        }
    }

    public String getRight() {
        return this.mRight;
    }

    public boolean getDeny() {
        return this.mDeny;
    }

    public String getRightDisplay() {
        return (this.mDeny ? "-" : "") + this.mRight;
    }

    public GranteeType getGranteeType() {
        return this.mGranteeType;
    }

    public String getGranteeName() {
        if (this.mGranteeName == null) {
            return "";
        }
        return this.mGranteeName;
    }

    public String getGranteeId() {
        return this.mGranteeId;
    }

    public void setGranteeId(String granteeId) {
        this.mGranteeId = granteeId;
    }

    public String getPassword() {
        return this.mSecret;
    }

    public String getAccessKey() {
        return this.mSecret;
    }

    public boolean isPublic() {
        return this.getGranteeType().equals((Object)GranteeType.pub);
    }

    public ZJSONObject toZJSONObject() throws JSONException {
        ZJSONObject jo = new ZJSONObject();
        jo.put("type", this.mGranteeType.name());
        jo.put("name", this.mGranteeName);
        jo.put("id", this.mGranteeId);
        jo.put("right", this.mRight);
        jo.put("deny", this.mDeny);
        return jo;
    }

    public String toString() {
        return String.format("[ZGrant %s %s]", this.mGranteeName, this.mRight);
    }

    public String dump() {
        return ZJSONObject.toString(this);
    }

    public String getGranteeTypeDisplay() {
        switch (this.mGranteeType) {
            case usr: {
                return "account";
            }
            case grp: {
                return "group";
            }
            case pub: {
                return "public";
            }
            case all: {
                return "all";
            }
            case gst: {
                return "guest";
            }
            case key: {
                return "key";
            }
        }
        return "unknown";
    }

    public int getGranteeTypeSortOrder() {
        switch (this.mGranteeType) {
            case usr: {
                return 0;
            }
            case grp: {
                return 3;
            }
            case pub: {
                return 5;
            }
            case all: {
                return 4;
            }
            case gst: {
                return 1;
            }
            case key: {
                return 2;
            }
        }
        return 6;
    }

    public static GranteeType getGranteeTypeFromDisplay(String name) throws ServiceException {
        if (name.equalsIgnoreCase("account")) {
            return GranteeType.usr;
        }
        if (name.equalsIgnoreCase("group")) {
            return GranteeType.grp;
        }
        if (name.equalsIgnoreCase("public")) {
            return GranteeType.pub;
        }
        if (name.equalsIgnoreCase("all")) {
            return GranteeType.all;
        }
        if (name.equalsIgnoreCase("key")) {
            return GranteeType.key;
        }
        throw ZClientException.CLIENT_ERROR("unknown grantee type: " + name, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GranteeType {
        usr,
        grp,
        pub,
        all,
        gst,
        key;


        public static GranteeType fromString(String s) throws ServiceException {
            try {
                if (gst.name().equals(s)) {
                    throw ZClientException.CLIENT_ERROR("guest grantee not yet supported", null);
                }
                return GranteeType.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                throw ZClientException.CLIENT_ERROR("invalid grantee: " + s + ", valid values: " + Arrays.asList(GranteeType.values()), e);
            }
        }
    }
}

