/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.wiki;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.SoapTransport;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.CliUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.Config;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.soap.SoapProvisioning;
import com.zimbra.cs.mailbox.ACL;
import com.zimbra.cs.mailbox.Document;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.service.wiki.WikiServiceException;
import com.zimbra.cs.util.BuildInfo;
import com.zimbra.cs.zclient.ZFolder;
import com.zimbra.cs.zclient.ZGrant;
import com.zimbra.cs.zclient.ZMailbox;
import com.zimbra.cs.zclient.ZSearchHit;
import com.zimbra.cs.zclient.ZSearchParams;
import com.zimbra.cs.zclient.ZSearchResult;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public abstract class WikiUtil {
    private static final String sDEFAULTFOLDER = "Notebook";
    private static final String sDEFAULTTEMPLATEFOLDER = "Template";
    private static final String sDEFAULTVIEW = "wiki";
    protected String mUsername;
    protected Provisioning mProv;

    public abstract void startImport(String var1, String var2, File var3) throws ServiceException, IOException;

    public abstract void updateTemplates(Server var1, File var2) throws ServiceException, IOException;

    protected abstract void emptyNotebooks(String var1) throws ServiceException, IOException;

    protected abstract void setFolderPermission(Account var1, String var2, String var3, String var4) throws ServiceException, IOException;

    private void initFolders(Account account, Entry entry) throws ServiceException, IOException {
        String id;
        String name;
        String grantee;
        Domain dom = null;
        if (entry instanceof Domain) {
            dom = (Domain)entry;
        }
        if (dom == null) {
            grantee = "pub";
            name = "99999999-9999-9999-9999-999999999999";
            id = "99999999-9999-9999-9999-999999999999";
        } else {
            grantee = "dom";
            name = dom.getName();
            id = dom.getId();
        }
        this.setFolderPermission(account, grantee, name, id);
    }

    public void initDefaultWiki(String username) throws ServiceException {
        Config globalConfig = this.mProv.getConfig();
        this.mUsername = globalConfig.getAttr("zimbraNotebookAccount", null);
        this.initWiki(globalConfig, username);
    }

    public void initDomainWiki(String domain, String username) throws ServiceException {
        if (domain == null) {
            throw WikiServiceException.ERROR("invalid argument - empty domain");
        }
        Domain dom = this.mProv.get(Provisioning.DomainBy.name, domain);
        if (dom == null) {
            throw WikiServiceException.ERROR("invalid domain: " + domain);
        }
        this.initDomainWiki(dom, username);
    }

    public void initDomainWiki(Domain dom, String username) throws ServiceException {
        Config globalConfig = this.mProv.getConfig();
        String globalWikiAcct = globalConfig.getAttr("zimbraNotebookAccount", null);
        if (globalWikiAcct == null) {
            throw WikiServiceException.ERROR("must initialize global wiki before domain wiki");
        }
        if (globalWikiAcct.equals(username)) {
            throw WikiServiceException.ERROR("domain wiki account must be different from global wiki account");
        }
        this.initWiki(dom, username);
    }

    public void initWiki(Entry entry, String username) throws ServiceException {
        String defaultUsername = entry.getAttr("zimbraNotebookAccount", null);
        if (username == null && defaultUsername == null) {
            String errStr = entry instanceof Config ? " in globalConfig" : " in domain " + ((Domain)entry).getName();
            throw WikiServiceException.ERROR("zimbraNotebookAccount must be set" + errStr);
        }
        if (username != null && !username.equals(defaultUsername)) {
            HashMap<String, String> attrMap = new HashMap<String, String>();
            attrMap.put("zimbraNotebookAccount", username);
            this.mProv.modifyAttrs(entry, attrMap);
        } else if (username == null) {
            username = defaultUsername;
        }
        if (this.mProv.get(Provisioning.AccountBy.name, username) == null) {
            throw AccountServiceException.NO_SUCH_ACCOUNT(username);
        }
        this.mUsername = username;
        Account acct = this.mProv.get(Provisioning.AccountBy.name, this.mUsername);
        if (!acct.getBooleanAttr("zimbraHideInGal", false) || !acct.getBooleanAttr("zimbraIsSystemResource", false)) {
            HashMap<String, String> attrs = new HashMap<String, String>();
            attrs.put("zimbraHideInGal", "TRUE");
            attrs.put("zimbraIsSystemResource", "TRUE");
            this.mProv.modifyAttrs(acct, attrs, true);
        }
        try {
            this.initFolders(acct, entry);
        }
        catch (IOException e) {
            throw WikiServiceException.ERROR("cannot initialize folders", e);
        }
    }

    public static WikiUtil getInstance() {
        return new WikiMboxUtil();
    }

    public static WikiUtil getInstance(Provisioning prov) throws ServiceException {
        return new WikiSoapUtil(prov);
    }

    public static void main(String[] args) throws Exception {
        String defaultUsername = "user1";
        CliUtil.toolSetup();
        SoapTransport.setDefaultUserAgent("WikiUtil", BuildInfo.VERSION);
        GnuParser parser = new GnuParser();
        Options options = new Options();
        options.addOption("v", "verbose", false, "verbose");
        options.addOption("s", "server", true, "server name");
        options.addOption("u", "username", true, "username of the target account");
        Option opt = new Option("d", "dir", true, "top level directory");
        opt.setArgName("top-level-dir");
        opt.setRequired(true);
        options.addOption(opt);
        CommandLine cl = null;
        try {
            cl = parser.parse(options, args);
        }
        catch (ParseException pe) {
            System.err.println("error: " + pe.getMessage());
            System.exit(1);
        }
        assert (cl != null);
        String dir = cl.getOptionValue("d");
        String server = cl.getOptionValue("s", LC.zimbra_zmprov_default_soap_server.value());
        String username = cl.getOptionValue("u", defaultUsername);
        SoapProvisioning sp = new SoapProvisioning();
        sp.soapSetURI("https://" + server + ":" + LC.zimbra_admin_service_port.intValue() + "/service/admin/soap/");
        sp.soapAdminAuthenticate(LC.zimbra_ldap_user.value(), LC.zimbra_ldap_password.value());
        WikiUtil prog = WikiUtil.getInstance(sp);
        prog.initDefaultWiki(username);
        prog.startImport(username, sDEFAULTTEMPLATEFOLDER, new File(dir));
    }

    private static class WikiSoapUtil
    extends WikiUtil {
        private ZMailbox mMbox;

        public WikiSoapUtil(Provisioning soapProv) throws ServiceException {
            this.mProv = soapProv;
        }

        private void auth() throws ServiceException {
            if (!(this.mProv instanceof SoapProvisioning)) {
                return;
            }
            SoapProvisioning prov = (SoapProvisioning)this.mProv;
            SoapProvisioning.DelegateAuthResponse dar = prov.delegateAuth(Provisioning.AccountBy.name, this.mUsername, 86400);
            ZMailbox.Options options = new ZMailbox.Options(dar.getAuthToken(), prov.soapGetURI());
            options.setTargetAccount(this.mUsername);
            this.mMbox = ZMailbox.getMailbox(options);
        }

        private ZFolder findFolder(ZFolder root, String dir) {
            if (root == null) {
                return null;
            }
            if (dir.equals("/")) {
                dir = "USER_ROOT";
            }
            if (root.getName().equals(dir)) {
                return root;
            }
            List<ZFolder> list = root.getSubFolders();
            if (list == null) {
                return null;
            }
            for (ZFolder f : list) {
                if (!f.getName().equals(dir)) continue;
                return f;
            }
            return null;
        }

        private ZFolder createFolder(ZFolder parent, String dir) throws ServiceException {
            System.out.println("Creating folder " + dir);
            return this.mMbox.createFolder(parent.getId(), dir, ZFolder.View.valueOf(WikiUtil.sDEFAULTVIEW), null, null, null);
        }

        private ZFolder getRootFolder() throws ServiceException {
            return this.mMbox.getUserRoot();
        }

        protected void setFolderPermission(Account account, String grantee, String name, String id) throws ServiceException {
            System.out.println("Initializing folders ");
            this.auth();
            ZFolder root = this.getRootFolder();
            ZFolder f = this.findFolder(root, WikiUtil.sDEFAULTFOLDER);
            if (f == null) {
                throw WikiServiceException.ERROR("can't open mailbox for " + account.getName() + " (wrong host?)");
            }
            this.mMbox.modifyFolderGrant(f.getId(), ZGrant.GranteeType.fromString(grantee), name, "rwid", null);
            f = this.findFolder(root, WikiUtil.sDEFAULTTEMPLATEFOLDER);
            if (f == null) {
                f = this.createFolder(root, WikiUtil.sDEFAULTTEMPLATEFOLDER);
            }
            this.mMbox.modifyFolderGrant(f.getId(), ZGrant.GranteeType.pub, name, "r", null);
        }

        private boolean purgeFolder(ZFolder folder) throws ServiceException {
            if (folder == null) {
                return true;
            }
            if (folder.getDefaultView() == null || !folder.getDefaultView().equals((Object)ZFolder.View.valueOf(WikiUtil.sDEFAULTVIEW))) {
                return false;
            }
            this.mMbox.emptyFolder(folder.getId());
            return true;
        }

        private void deleteAllItemsInFolder(ZFolder folder) throws IOException, ServiceException {
            if (this.purgeFolder(folder)) {
                return;
            }
            StringBuilder buf = new StringBuilder();
            ZSearchParams params = new ZSearchParams("inid:" + folder.getId());
            params.setTypes("wiki,document");
            ZSearchResult result = this.mMbox.search(params);
            for (ZSearchHit hit : result.getHits()) {
                if (buf.length() > 0) {
                    buf.append(",");
                }
                buf.append(hit.getId());
            }
            if (buf.length() > 0) {
                this.mMbox.deleteItem(buf.toString(), null);
            }
            for (ZFolder f : new ArrayList<ZFolder>(folder.getSubFolders())) {
                int fid = Integer.valueOf(f.getId());
                ZFolder.View v = f.getDefaultView();
                if (fid == 12 || fid >= 256) {
                    this.deleteAllItemsInFolder(f);
                }
                if (v == null || !v.equals((Object)ZFolder.View.valueOf(WikiUtil.sDEFAULTVIEW)) || fid < 256) continue;
                this.mMbox.deleteFolder(f.getId());
            }
        }

        private void createItem(ZFolder where, File what) throws IOException, ServiceException {
            byte[] content = ByteUtil.getContent(what);
            String name = what.getName();
            if (name.endsWith(".wiki") || name.startsWith("_")) {
                if (name.endsWith(".wiki")) {
                    name = name.substring(0, name.length() - 5);
                }
                System.out.println("Creating wiki page " + name + " in folder " + where.getName());
                this.mMbox.createWiki(where.getId(), name, new String(content, "UTF-8"));
            } else {
                System.out.println("Creating file document " + name + " in folder " + where.getName());
                String contentType = URLConnection.getFileNameMap().getContentTypeFor(name);
                if (contentType == null) {
                    contentType = "application/octet-stream";
                }
                String attachmentId = this.mMbox.uploadAttachment(name, content, contentType, 10000);
                this.mMbox.createDocument(where.getId(), name, attachmentId);
            }
        }

        private void populateFolders(ZFolder where, File file) throws IOException, ServiceException {
            if (where == null) {
                throw new IllegalArgumentException("null folder");
            }
            File[] list = file.listFiles();
            if (list == null) {
                throw WikiServiceException.ERROR("directory does not exist : " + file.getPath());
            }
            for (int i = 0; i < list.length; ++i) {
                File f = list[i];
                if (f.getName().startsWith(".")) continue;
                if (f.isDirectory()) {
                    ZFolder sub = this.findFolder(where, f.getName());
                    if (sub == null) {
                        sub = this.createFolder(where, f.getName());
                    }
                    this.populateFolders(sub, f);
                    continue;
                }
                this.createItem(where, f);
            }
        }

        protected void emptyNotebooks(String where) throws IOException, ServiceException {
            ZFolder root = this.getRootFolder();
            ZFolder f = this.findFolder(root, where);
            this.deleteAllItemsInFolder(f);
        }

        public void startImport(String username, String where, File what) throws IOException, ServiceException {
            ZFolder f;
            this.mUsername = username;
            System.out.println("Initializing...");
            this.auth();
            if (where.startsWith("/") && where.length() > 1) {
                where = where.substring(1);
            }
            if (where == null) {
                where = WikiUtil.sDEFAULTFOLDER;
            }
            this.emptyNotebooks(where);
            ZFolder root = this.getRootFolder();
            if (where.equals("/")) {
                f = root;
            } else {
                f = this.findFolder(root, where);
                if (f == null) {
                    f = this.createFolder(root, where);
                }
            }
            this.populateFolders(f, what);
        }

        public void updateTemplates(Server server, File templateDir) throws IOException, ServiceException {
            if (!templateDir.exists()) {
                throw WikiServiceException.ERROR("template dir " + templateDir.getCanonicalPath() + " doesn't exist");
            }
            Config globalConfig = this.mProv.getConfig();
            String wikiAccount = globalConfig.getAttr("zimbraNotebookAccount", null);
            if (this.isAccountOnServer(wikiAccount, server)) {
                System.out.println("updating global wiki account " + wikiAccount);
                this.startImport(wikiAccount, WikiUtil.sDEFAULTTEMPLATEFOLDER, templateDir);
            }
            for (Domain d : this.mProv.getAllDomains()) {
                wikiAccount = d.getAttr("zimbraNotebookAccount", null);
                if (!this.isAccountOnServer(wikiAccount, server)) continue;
                System.out.println("updating wiki account " + wikiAccount + " for domain " + d.getName());
                this.startImport(wikiAccount, WikiUtil.sDEFAULTTEMPLATEFOLDER, templateDir);
            }
        }

        private boolean isAccountOnServer(String acct, Server server) throws ServiceException {
            if (acct == null) {
                return false;
            }
            Account a = this.mProv.get(Provisioning.AccountBy.name, acct);
            if (a == null) {
                return false;
            }
            if (server == null) {
                return true;
            }
            String target = a.getAttr("zimbraMailHost");
            String host = server.getAttr("zimbraServiceHostname");
            return target != null && target.equalsIgnoreCase(host);
        }
    }

    private static class WikiMboxUtil
    extends WikiUtil {
        public WikiMboxUtil() {
            this.mProv = Provisioning.getInstance();
        }

        private void populateFolders(OperationContext octxt, Mailbox mbox, Folder where, File file) throws ServiceException, IOException {
            File[] list = file.listFiles();
            if (list == null) {
                return;
            }
            for (int i = 0; i < list.length; ++i) {
                String contentType;
                File f = list[i];
                if (f.getName().startsWith(".")) continue;
                if (f.isDirectory()) {
                    Folder sub = mbox.createFolder(octxt, f.getName(), where.getId(), MailItem.getTypeForName(WikiUtil.sDEFAULTVIEW), 0, (byte)0, null);
                    this.populateFolders(octxt, mbox, sub, f);
                    continue;
                }
                byte type = 0;
                FileInputStream in = new FileInputStream(f);
                String name = f.getName();
                if (name.endsWith(".wiki") || name.startsWith("_")) {
                    if (name.endsWith(".wiki")) {
                        name = name.substring(0, name.length() - 5);
                    }
                    contentType = "text/html; charset=utf-8";
                    type = 14;
                } else {
                    contentType = URLConnection.getFileNameMap().getContentTypeFor(name);
                    if (contentType == null) {
                        contentType = "application/octet-stream";
                    }
                    type = 8;
                }
                mbox.createDocument(octxt, where.getId(), name, contentType, mbox.getAccount().getName(), in, type);
            }
        }

        private void deleteItems(OperationContext octxt, Mailbox mbox, Folder where) throws ServiceException {
            if (where.getDefaultView() == 14) {
                mbox.emptyFolder(octxt, where.getId(), true);
                return;
            }
            List<Document> items = mbox.getDocumentList(octxt, where.getId());
            for (Document doc : items) {
                mbox.delete(octxt, doc, null);
            }
            List<Folder> folders = where.getSubfolders(octxt);
            for (Folder f : folders) {
                this.deleteItems(octxt, mbox, f);
                if (f.getDefaultView() != 14) continue;
                mbox.delete(octxt, f, null);
            }
        }

        protected void emptyNotebooks(String where) throws ServiceException {
            Account acct = this.mProv.get(Provisioning.AccountBy.name, this.mUsername);
            Mailbox mbox = MailboxManager.getInstance().getMailboxByAccount(acct);
            OperationContext octxt = new OperationContext(acct);
            try {
                Folder f = mbox.getFolderByPath(octxt, where);
                this.deleteItems(octxt, mbox, f);
            }
            catch (ServiceException se) {
                ZimbraLog.wiki.error((Object)"error emptying Notebook folders", se);
            }
        }

        public void startImport(String username, String where, File what) throws ServiceException, IOException {
            this.mUsername = username;
            this.emptyNotebooks(where);
            Account acct = this.mProv.get(Provisioning.AccountBy.name, this.mUsername);
            Mailbox mbox = MailboxManager.getInstance().getMailboxByAccount(acct);
            OperationContext octxt = new OperationContext(acct);
            Folder f = null;
            try {
                f = mbox.getFolderByPath(octxt, where);
            }
            catch (ServiceException se) {
                f = mbox.createFolder(octxt, where, 1, (byte)14, 0, (byte)0, null);
            }
            this.populateFolders(octxt, mbox, f, what);
        }

        protected void setFolderPermission(Account account, String grantee, String name, String id) throws ServiceException {
            Folder template;
            Mailbox mbox = MailboxManager.getInstance().getMailboxByAccount(account);
            OperationContext octxt = new OperationContext(account);
            try {
                template = mbox.getFolderByPath(octxt, WikiUtil.sDEFAULTTEMPLATEFOLDER);
            }
            catch (ServiceException se) {
                template = mbox.createFolder(octxt, WikiUtil.sDEFAULTTEMPLATEFOLDER, 1, MailItem.getTypeForName(WikiUtil.sDEFAULTVIEW), 0, (byte)0, null);
            }
            mbox.grantAccess(octxt, 12, id, grantee.equals("pub") ? (byte)6 : 4, ACL.stringToRights("rwid"), null);
            mbox.grantAccess(octxt, template.getId(), "99999999-9999-9999-9999-999999999999", (byte)6, ACL.stringToRights("r"), null);
        }

        public void updateTemplates(Server server, File templateDir) throws ServiceException {
            throw WikiServiceException.ERROR("use soap based utility.");
        }
    }
}

