/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.wiki;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.L10nUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.mailbox.Document;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.Tag;
import com.zimbra.cs.mailbox.WikiItem;
import com.zimbra.cs.service.UserServlet;
import com.zimbra.cs.service.wiki.WikiServiceException;
import com.zimbra.cs.wiki.WikiPage;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiTemplate
implements Comparable<WikiTemplate> {
    private String mId;
    private long mModifiedTime;
    private boolean mParsed;
    private List<Token> mTokens;
    private String mTemplate;
    private static final int WIKI_FOLDER_ID = 12;

    public static WikiTemplate getDefaultTOC() {
        return new WikiTemplate("{{TOC}}");
    }

    public WikiTemplate(String item, String id, String key, String name) {
        this(item);
        StringBuilder buf = new StringBuilder();
        if (id != null) {
            buf.append(id);
        }
        buf.append(":");
        if (key != null) {
            buf.append(key);
        }
        buf.append(":");
        if (name != null) {
            buf.append(name);
        }
        this.mId = buf.toString();
    }

    public WikiTemplate(String item) {
        this.mTemplate = item;
        this.mTokens = new ArrayList<Token>();
        this.mModifiedTime = 0L;
        this.mId = "";
        this.touch();
    }

    public String getRaw() {
        return this.mTemplate;
    }

    public static WikiTemplate findTemplate(Context ctxt, String name) throws ServiceException {
        WikiPage page = WikiPage.findTemplate(ctxt.wctxt, ctxt.item.getAccount().getId(), name);
        if (page == null) {
            page = WikiPage.missingPage(name);
        }
        return page.getTemplate(ctxt.wctxt);
    }

    public String toString(WikiPage.WikiContext ctxt, MailItem item) throws ServiceException, IOException {
        return this.toString(new Context(ctxt, item, this));
    }

    public String toString(WikiPage.WikiContext ctxt, MailItem item, MailItem latestVersionItem) throws ServiceException, IOException {
        return this.toString(new Context(ctxt, item, this, latestVersionItem));
    }

    public String toString(Context ctxt) throws ServiceException, IOException {
        if (!this.mParsed) {
            this.parse();
        }
        StringBuffer buf = new StringBuffer();
        Iterator<Token> i$ = this.mTokens.iterator();
        while (i$.hasNext()) {
            Token tok;
            ctxt.token = tok = i$.next();
            buf.append(this.apply(ctxt));
        }
        this.touch();
        return buf.toString();
    }

    private List<Token> getTokens() {
        return this.mTokens;
    }

    public long getModifiedTime() {
        return this.mModifiedTime;
    }

    public String getComposedPage(WikiPage.WikiContext wctxt, MailItem item, String chrome) throws ServiceException, IOException {
        String templateVal;
        Context ctxt = new Context(wctxt, item, this);
        WikiPage chromePage = WikiPage.findTemplate(ctxt.wctxt, item.getAccount().getId(), chrome);
        if (chromePage == null) {
            chromePage = WikiPage.missingPage(chrome);
        }
        WikiTemplate chromeTemplate = chromePage.getTemplate(ctxt.wctxt);
        if (ctxt.item instanceof WikiItem) {
            templateVal = chromeTemplate.toString(ctxt);
        } else {
            String inner;
            ctxt.content = inner = this.toString(ctxt);
            templateVal = chromeTemplate.toString(ctxt);
        }
        return templateVal;
    }

    public void parse() {
        if (!this.mParsed) {
            Token.parse(this.mTemplate, this.mTokens);
        }
        this.mParsed = true;
    }

    public String getId() {
        return this.mId;
    }

    @Override
    public int compareTo(WikiTemplate t) {
        return this.mId.compareTo(t.mId);
    }

    public void getInclusions(Context ctxt, List<WikiTemplate> inclusions) {
        this.parse();
        for (Token tok : this.mTokens) {
            if (tok.getType() == Token.TokenType.TEXT) continue;
            Wiklet w = Wiklet.get(tok);
            WikiTemplate t = null;
            if (w == null) continue;
            try {
                ctxt.token = tok;
                t = w.findInclusion(ctxt);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (t == null || inclusions.contains(t)) continue;
            inclusions.add(t);
            t.getInclusions(ctxt, inclusions);
        }
    }

    private String apply(Context ctxt) throws ServiceException, IOException {
        if (ctxt.token.getType() == Token.TokenType.TEXT || ctxt.token.getType() == Token.TokenType.COMMENT) {
            return ctxt.token.getValue();
        }
        Wiklet w = Wiklet.get(ctxt.token);
        if (w != null) {
            String ret = w.apply(ctxt);
            return ret;
        }
        return "";
    }

    private void touch() {
        this.mModifiedTime = System.currentTimeMillis();
    }

    static class WikiUrl {
        private int mId;
        private String mUrl;
        private String mFilename;
        private List<String> mTokens;
        private boolean mIsFolder;

        public WikiUrl(MailItem item) {
            this(item.getName(), item.getFolderId());
            if (item instanceof Folder) {
                this.mIsFolder = true;
            }
        }

        public WikiUrl(String url) {
            this(url, -1);
        }

        public WikiUrl(String url, int currentPos) {
            this.mUrl = url;
            this.mId = currentPos;
            this.parse();
        }

        private void parse() {
            this.mTokens = new ArrayList<String>();
            int begin = 0;
            int end = 0;
            if (this.mUrl.startsWith("//")) {
                begin = 2;
                end = this.mUrl.indexOf(47, begin);
                this.mTokens.add("//");
                this.mTokens.add(this.mUrl.substring(begin, end));
                begin = end;
            } else if (this.mUrl.startsWith("/")) {
                this.mTokens.add("/");
            } else {
                if (this.mId == -1) {
                    throw new IllegalArgumentException("not absolute url: " + this.mUrl);
                }
                this.mTokens.add(Integer.toString(this.mId));
            }
            this.mTokens.add(this.mUrl.substring(begin));
            begin = this.mUrl.lastIndexOf("/");
            this.mFilename = begin > 0 ? this.mUrl.substring(begin + 1) : this.mUrl;
        }

        public String getFullUrl(WikiPage.WikiContext ctxt, String referenceAccount) throws ServiceException {
            if (this.mUrl != null && this.mUrl.startsWith("http://")) {
                return this.mUrl;
            }
            Account ownerAccount = this.getOwnerAccount(referenceAccount);
            return UserServlet.getRestUrl(ownerAccount) + this.getPath(ctxt, ownerAccount);
        }

        public Account getOwnerAccount(String referenceAccount) throws ServiceException {
            return this.inAnotherMailbox() ? Provisioning.getInstance().get(Provisioning.AccountBy.name, this.mTokens.get(1)) : (referenceAccount == null ? null : Provisioning.getInstance().get(Provisioning.AccountBy.id, referenceAccount));
        }

        public String getPath(WikiPage.WikiContext ctxt, Account acct) throws ServiceException {
            if (!this.isAbsolute() && this.mId < 1) {
                throw WikiServiceException.INVALID_PATH(this.mUrl);
            }
            StringBuilder p = new StringBuilder();
            if (this.inAnotherMailbox() || acct == null) {
                p.append(this.mTokens.get(2));
            } else if (this.isAbsolute()) {
                p.append(this.mUrl);
            } else if (Provisioning.onLocalServer(acct)) {
                Mailbox mbox = MailboxManager.getInstance().getMailboxByAccount(acct);
                Folder f = mbox.getFolderById(ctxt.octxt, this.mId);
                p.append(f.getPath());
                if (p.charAt(p.length() - 1) != '/') {
                    p.append("/");
                }
                p.append(this.mUrl);
            } else {
                throw WikiServiceException.INVALID_PATH(this.mUrl);
            }
            return this.normalizePath(p.toString());
        }

        public String getFolderPath(WikiPage.WikiContext ctxt, String referenceAccount) throws ServiceException {
            Account acct = this.getOwnerAccount(referenceAccount);
            String url = this.getPath(ctxt, acct);
            int index = url.lastIndexOf(47);
            if (index > 0) {
                return url.substring(0, index);
            }
            return "/";
        }

        private String normalizePath(String path) throws ServiceException {
            ArrayList<String> tokens = new ArrayList<String>();
            StringTokenizer tok = new StringTokenizer(path, "/");
            while (tok.hasMoreElements()) {
                String token = tok.nextToken();
                if (token.equals(".")) continue;
                if (token.equals("..")) {
                    if (tokens.isEmpty()) {
                        throw WikiServiceException.INVALID_PATH(path);
                    }
                    tokens.remove(tokens.size() - 1);
                    continue;
                }
                tokens.add(token);
            }
            if (tokens.isEmpty()) {
                return "/";
            }
            if (path.endsWith("/")) {
                tokens.add("");
            }
            StringBuilder newPath = new StringBuilder();
            for (String token : tokens) {
                newPath.append("/").append(this.urlEscape(token));
            }
            if (this.mIsFolder) {
                newPath.append("/");
            }
            return newPath.toString();
        }

        private String urlEscape(String str) {
            if (str.indexOf(32) == -1 && str.indexOf(39) == -1 && str.indexOf(34) == -1 && str.indexOf(35) == -1 && str.indexOf(63) == -1) {
                return str;
            }
            StringBuilder buf = new StringBuilder();
            for (char c : str.toCharArray()) {
                if (c == ' ') {
                    buf.append("%20");
                    continue;
                }
                if (c == '\"') {
                    buf.append("%22");
                    continue;
                }
                if (c == '\'') {
                    buf.append("%27");
                    continue;
                }
                if (c == '#') {
                    buf.append("%23");
                    continue;
                }
                if (c == '?') {
                    buf.append("%3F");
                    continue;
                }
                buf.append(c);
            }
            return buf.toString();
        }

        public boolean isAbsolute() {
            return this.mTokens != null && this.mTokens.get(0).startsWith("/");
        }

        public boolean inAnotherMailbox() {
            return this.mTokens != null && this.mTokens.get(0).equals("//");
        }

        public String getToken(int pos) {
            return this.mTokens.get(pos);
        }

        public String getFilename() {
            return this.mFilename;
        }

        public String getUrl() {
            return this.mUrl;
        }

        public String toString() {
            return "wikiUrl: " + this.mUrl + " in folderId" + this.mId;
        }
    }

    public static class MsgWiklet
    extends Wiklet {
        private static final String sKEY = "key";

        public String getName() {
            return "Msg";
        }

        public String getPattern() {
            return "MSG";
        }

        public WikiTemplate findInclusion(Context ctxt) {
            return null;
        }

        public String getMessage(String key, Context ctxt) {
            String mText = "";
            try {
                String msgText;
                Locale lc = ctxt.item.getMailbox().getAccount().getLocale();
                L10nUtil.MsgKey msgKey = L10nUtil.MsgKey.valueOf(key);
                if (msgKey != null && (msgText = L10nUtil.getMessage(msgKey, lc, new Object[0])) != null) {
                    mText = msgText;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return mText;
        }

        public String apply(Context ctxt) {
            try {
                Map<String, String> params = ctxt.token.parseParam();
                String key = params.get(sKEY);
                String mText = this.getMessage(key, ctxt);
                return mText;
            }
            catch (Exception e) {
                return "";
            }
        }
    }

    public static class UrlWiklet
    extends Wiklet {
        private static final String sLABEL = "label";
        private static final String sKEY = "key";
        private static final String sTYPE = "type";
        private static final String sVERSIONURL = "version";
        private static final String sHISTORYURL = "history";

        public String getName() {
            return "Url";
        }

        public String getPattern() {
            return "URL";
        }

        public WikiTemplate findInclusion(Context ctxt) {
            return null;
        }

        public String apply(Context ctxt) {
            if (ctxt.item == null) {
                return "<!-- cannot resolve item for url wiklet -->";
            }
            String title = ctxt.item.getName();
            title = title.replaceAll("<", "&lt;");
            title = title.replaceAll(">", "&gt;");
            WikiUrl wurl = new WikiUrl(ctxt.item);
            try {
                Map<String, String> params = ctxt.token.parseParam();
                String type = params.get(sTYPE);
                StringBuffer buf = new StringBuffer();
                String url = null;
                if (type != null && type.equals(sVERSIONURL) && ctxt.latestVersionItem != null) {
                    wurl = new WikiUrl(ctxt.latestVersionItem);
                    url = wurl.getFullUrl(ctxt.wctxt, ctxt.latestVersionItem.getMailbox().getAccountId()) + "?ver=" + ctxt.item.getVersion();
                } else if (type != null && type.equals(sHISTORYURL)) {
                    if (ctxt.item instanceof Folder) {
                        url = null;
                    } else {
                        wurl = new WikiUrl(ctxt.item);
                        title = params.get(sLABEL);
                        String msgKey = params.get(sKEY);
                        if (msgKey != null) {
                            MsgWiklet msgWiklet = (MsgWiklet)Wiklet.get("MSG");
                            title = msgWiklet.getMessage(msgKey, ctxt);
                        }
                        if (title == null) {
                            title = sHISTORYURL;
                        }
                        url = wurl.getFullUrl(ctxt.wctxt, ctxt.item.getMailbox().getAccountId()) + "?view=" + sHISTORYURL;
                    }
                } else {
                    url = wurl.getFullUrl(ctxt.wctxt, ctxt.item.getMailbox().getAccountId());
                }
                if (url != null) {
                    MsgWiklet msgWiklet;
                    String msgText;
                    if (ctxt.item.getId() == 12 && (msgText = (msgWiklet = (MsgWiklet)Wiklet.get("MSG")).getMessage(title, ctxt)) != null && !msgText.equals("")) {
                        title = msgText;
                    }
                    buf.append("<a href='");
                    buf.append(url);
                    buf.append("'>").append(title).append("</a>");
                }
                return buf.toString();
            }
            catch (Exception e) {
                return "<!-- cannot generate URL for item " + title + " -->" + title;
            }
        }
    }

    public static class WikilinkWiklet
    extends Wiklet {
        private static final String PAGENAME = "pagename";
        private static final String TEXT = "text";

        public String getName() {
            return "Wikilink";
        }

        public String getPattern() {
            return "WIKILINK";
        }

        public WikiTemplate findInclusion(Context ctxt) {
            return null;
        }

        public String apply(Context ctxt) throws ServiceException, IOException {
            String link;
            String title;
            if (ctxt.token.getType() == Token.TokenType.WIKILINK) {
                String text;
                link = title = (text = ctxt.token.getValue());
                int pos = text.indexOf(124);
                if (pos != -1) {
                    link = text.substring(0, pos);
                    title = text.substring(pos + 1);
                } else {
                    pos = text.indexOf("][");
                    if (pos != -1) {
                        title = text.substring(0, pos);
                        link = text.substring(pos + 2);
                    }
                }
                if (text.startsWith("<wiklet")) {
                    WikiTemplate template = new WikiTemplate(link);
                    link = template.toString(ctxt);
                }
            } else {
                Map<String, String> params = ctxt.token.parseParam();
                link = params.get(PAGENAME);
                title = params.get(TEXT);
                if (title == null) {
                    title = link;
                }
            }
            WikiUrl wurl = ctxt.item instanceof Folder ? new WikiUrl(link, ctxt.item.getId()) : new WikiUrl(link, ctxt.item.getFolderId());
            try {
                StringBuffer buf = new StringBuffer();
                buf.append("<a href='");
                buf.append(wurl.getFullUrl(ctxt.wctxt, ctxt.item.getMailbox().getAccountId()));
                buf.append("'>").append(title).append("</a>");
                return buf.toString();
            }
            catch (Exception e) {
                return "<!-- invalid wiki url " + link + " -->" + title;
            }
        }
    }

    public static class IncludeWiklet
    extends Wiklet {
        public static final String sPAGE = "page";

        public String getName() {
            return "Include";
        }

        public String getPattern() {
            return "INCLUDE";
        }

        public WikiTemplate findInclusion(Context ctxt) throws ServiceException {
            Map<String, String> params = ctxt.token.parseParam();
            String page = params.get(sPAGE);
            if (page == null) {
                page = params.keySet().iterator().next();
            }
            return WikiTemplate.findTemplate(ctxt, page);
        }

        public String apply(Context ctxt) {
            try {
                WikiTemplate template = this.findInclusion(ctxt);
                return template.toString(ctxt);
            }
            catch (Exception e) {
                return "<!-- missing template " + ctxt.token + " -->";
            }
        }
    }

    public static class InlineWiklet
    extends IncludeWiklet {
        public String getPattern() {
            return "INLINE";
        }
    }

    public static class ContentWiklet
    extends Wiklet {
        public String getName() {
            return "Content";
        }

        public String getPattern() {
            return "CONTENT";
        }

        public WikiTemplate findInclusion(Context ctxt) throws ServiceException {
            WikiItem wiki = (WikiItem)ctxt.item;
            return WikiTemplate.findTemplate(ctxt, wiki.getWikiWord());
        }

        public String apply(Context ctxt) throws ServiceException, IOException {
            if (ctxt.content != null) {
                return ctxt.content;
            }
            if (!(ctxt.item instanceof WikiItem)) {
                return "<!-- cotent wiklet on non-wiki item -->";
            }
            WikiTemplate template = ctxt.itemTemplate;
            if (template == null) {
                WikiItem wiki = (WikiItem)ctxt.item;
                template = WikiTemplate.findTemplate(ctxt, wiki.getWikiWord());
            }
            for (Token t : template.getTokens()) {
                Wiklet w = Wiklet.get(t);
                if (w != null && !w.getName().equals(this.getName())) continue;
                return template.getRaw();
            }
            return template.toString(ctxt);
        }
    }

    public static class VersionWiklet
    extends Wiklet {
        public String getName() {
            return "Version";
        }

        public String getPattern() {
            return "VERSION";
        }

        public WikiTemplate findInclusion(Context ctxt) {
            return null;
        }

        public String apply(Context ctxt) {
            if (!(ctxt.item instanceof Document)) {
                return "1";
            }
            Document doc = (Document)ctxt.item;
            return Integer.toString(doc.getVersion());
        }
    }

    public static class ModifyDateWiklet
    extends DateTimeWiklet {
        public String getName() {
            return "Modified Date";
        }

        public String getPattern() {
            return "MODIFYDATE";
        }

        public String apply(Context ctxt) {
            Date modifyDate = new Date(ctxt.item.getDate());
            return this.formatDate(ctxt, modifyDate);
        }
    }

    public static class CreateDateWiklet
    extends DateTimeWiklet {
        public String getName() {
            return "Create Date";
        }

        public String getPattern() {
            return "CREATEDATE";
        }

        public String apply(Context ctxt) throws ServiceException {
            MailItem item = ctxt.item.getMailbox().getItemRevision(ctxt.wctxt.octxt, ctxt.item.getId(), ctxt.item.getType(), 1);
            Date createDate = new Date((item == null ? ctxt.item : item).getDate());
            return this.formatDate(ctxt, createDate);
        }
    }

    public static abstract class DateTimeWiklet
    extends Wiklet {
        private static final String sFORMAT = "format";
        private static final String sSHORTDATE = "shortdate";
        private static final String sMEDIUMDATE = "mediumdate";
        private static final String sLONGDATE = "longdate";
        private static final String sFULLDATE = "fulldate";
        private static final String sSHORTTIME = "shorttime";
        private static final String sMEDIUMTIME = "mediumtime";
        private static final String sLONGTIME = "longtime";
        private static final String sFULLTIME = "fulltime";
        private static final String sSHORTDATETIME = "shortdateandtime";
        private static final String sMEDIUMDATETIME = "mediumdateandtime";
        private static final String sLONGDATETIME = "longdateandtime";
        private static final String sFULLDATETIME = "fulldateandtime";
        protected static Map<String, DateFormat> sFORMATS;
        protected static Map<Locale, Map<String, DateFormat>> sLOCALEMAPS;

        public WikiTemplate findInclusion(Context ctxt) {
            return null;
        }

        protected DateFormat getDateFormat(Locale locale, String dateTimeStyle) {
            Map<String, DateFormat> dateFormat = sLOCALEMAPS.get(locale);
            if (dateFormat == null) {
                dateFormat = new HashMap<String, DateFormat>();
                dateFormat.put(sSHORTDATE, DateFormat.getDateInstance(3, locale));
                dateFormat.put(sMEDIUMDATE, DateFormat.getDateInstance(2, locale));
                dateFormat.put(sLONGDATE, DateFormat.getDateInstance(1, locale));
                dateFormat.put(sFULLDATE, DateFormat.getDateInstance(0, locale));
                dateFormat.put(sSHORTTIME, DateFormat.getTimeInstance(3, locale));
                dateFormat.put(sMEDIUMTIME, DateFormat.getTimeInstance(2, locale));
                dateFormat.put(sLONGTIME, DateFormat.getTimeInstance(1, locale));
                dateFormat.put(sFULLTIME, DateFormat.getTimeInstance(0, locale));
                dateFormat.put(sSHORTDATETIME, DateFormat.getDateTimeInstance(3, 3, locale));
                dateFormat.put(sMEDIUMDATETIME, DateFormat.getDateTimeInstance(2, 2, locale));
                dateFormat.put(sLONGDATETIME, DateFormat.getDateTimeInstance(1, 1, locale));
                dateFormat.put(sFULLDATETIME, DateFormat.getDateTimeInstance(0, 0, locale));
                sLOCALEMAPS.put(locale, dateFormat);
                return dateFormat.get(dateTimeStyle);
            }
            return dateFormat.get(dateTimeStyle);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected String formatDate(Context ctxt, Date date) {
            Locale locale = ctxt.locale;
            Map<String, String> params = ctxt.token.parseParam();
            String format = params.get(sFORMAT);
            if (format == null || !sFORMATS.containsKey(format)) {
                format = sSHORTDATETIME;
            }
            DateFormat formatter = null;
            formatter = locale == null ? sFORMATS.get(format) : this.getDateFormat(locale, format);
            DateFormat dateFormat = formatter;
            synchronized (dateFormat) {
                return formatter.format(date);
            }
        }

        static {
            sLOCALEMAPS = new HashMap<Locale, Map<String, DateFormat>>();
            sFORMATS = new HashMap<String, DateFormat>();
            sFORMATS.put(sSHORTDATE, DateFormat.getDateInstance(3));
            sFORMATS.put(sMEDIUMDATE, DateFormat.getDateInstance(2));
            sFORMATS.put(sLONGDATE, DateFormat.getDateInstance(1));
            sFORMATS.put(sFULLDATE, DateFormat.getDateInstance(0));
            sFORMATS.put(sSHORTTIME, DateFormat.getTimeInstance(3));
            sFORMATS.put(sMEDIUMTIME, DateFormat.getTimeInstance(2));
            sFORMATS.put(sLONGTIME, DateFormat.getTimeInstance(1));
            sFORMATS.put(sFULLTIME, DateFormat.getTimeInstance(0));
            sFORMATS.put(sSHORTDATETIME, DateFormat.getDateTimeInstance(3, 3));
            sFORMATS.put(sMEDIUMDATETIME, DateFormat.getDateTimeInstance(2, 2));
            sFORMATS.put(sLONGDATETIME, DateFormat.getDateTimeInstance(1, 1));
            sFORMATS.put(sFULLDATETIME, DateFormat.getDateTimeInstance(0, 0));
        }
    }

    public static class ModifierWiklet
    extends Wiklet {
        public String getName() {
            return "Modifier";
        }

        public String getPattern() {
            return "MODIFIER";
        }

        public WikiTemplate findInclusion(Context ctxt) {
            return null;
        }

        public String apply(Context ctxt) {
            if (!(ctxt.item instanceof Document)) {
                return "";
            }
            Document doc = (Document)ctxt.item;
            return doc.getCreator();
        }
    }

    public static class TagsWiklet
    extends Wiklet {
        public String getName() {
            return "Tags";
        }

        public String getPattern() {
            return "TAGS";
        }

        public WikiTemplate findInclusion(Context ctxt) {
            return null;
        }

        public String apply(Context ctxt) throws ServiceException {
            if (ctxt.item instanceof Folder) {
                return "";
            }
            if (ctxt.item instanceof Document) {
                Document doc = (Document)ctxt.item;
                List<Tag> tags = doc.getTagList();
                StringBuffer names = new StringBuffer();
                int count = 0;
                int size = tags.size();
                if (size > 0) {
                    names.append("<span class='zmwiki-tagsTitle'>Tags: </span>");
                }
                for (Tag tag : tags) {
                    names.append("<span class='zmwiki-tags'>");
                    names.append(tag.getName() + (size == ++count ? " " : ", "));
                    names.append(" </span>");
                }
                return names.toString();
            }
            return "";
        }
    }

    public static class CreatorWiklet
    extends Wiklet {
        public String getName() {
            return "Creator";
        }

        public String getPattern() {
            return "CREATOR";
        }

        public WikiTemplate findInclusion(Context ctxt) {
            return null;
        }

        public String apply(Context ctxt) throws ServiceException {
            Document doc;
            if (ctxt.item instanceof Folder) {
                return ctxt.item.getMailbox().getAccount().getName();
            }
            if (ctxt.item instanceof Document && (doc = (Document)ctxt.item.getMailbox().getItemRevision(ctxt.wctxt.octxt, ctxt.item.getId(), ctxt.item.getType(), 1)) != null) {
                return doc.getCreator();
            }
            return "";
        }
    }

    public static class FragmentWiklet
    extends Wiklet {
        public String getName() {
            return "Fragment";
        }

        public String getPattern() {
            return "FRAGMENT";
        }

        public WikiTemplate findInclusion(Context ctxt) {
            return null;
        }

        public String apply(Context ctxt) {
            if (!(ctxt.item instanceof Document)) {
                return "";
            }
            Document doc = (Document)ctxt.item;
            return doc.getFragment();
        }
    }

    public static class NameWiklet
    extends Wiklet {
        public String getName() {
            return "Name";
        }

        public String getPattern() {
            return "NAME";
        }

        public WikiTemplate findInclusion(Context ctxt) {
            return null;
        }

        public String apply(Context ctxt) {
            MsgWiklet msgWiklet;
            String msgText;
            String mText = ctxt.item.getName();
            if (ctxt.item.getId() == 12 && (msgText = (msgWiklet = (MsgWiklet)Wiklet.get("MSG")).getMessage(mText, ctxt)) != null && !msgText.equals("")) {
                mText = msgText;
            }
            mText = mText.replaceAll("<", "&lt;");
            mText = mText.replaceAll(">", "&gt;");
            return mText;
        }
    }

    public static class IconWiklet
    extends Wiklet {
        public String getName() {
            return "Icon";
        }

        public String getPattern() {
            return "ICON";
        }

        public WikiTemplate findInclusion(Context ctxt) {
            return null;
        }

        public String apply(Context ctxt) {
            if (ctxt.item instanceof Document) {
                if (ctxt.item instanceof WikiItem) {
                    return "<div class='ImgPage'></div>";
                }
                return "<div class='ImgAttachment'></div>";
            }
            if (ctxt.item.getFolderId() == 1) {
                return "<div class='ImgNotebook'></div>";
            }
            return "<div class='ImgSection'></div>";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BreadcrumbsWiklet
    extends Wiklet {
        public static final String sPAGE = "page";
        public static final String sFORMAT = "format";
        public static final String sBODYTEMPLATE = "bodyTemplate";
        public static final String sITEMTEMPLATE = "itemTemplate";
        public static final String sSEPARATOR = "separator";
        public static final String sSIMPLE = "simple";
        public static final String sTEMPLATE = "template";
        public static final String sDEFAULTBODYTEMPLATE = "_PathBodyTemplate";
        public static final String sDEFAULTITEMTEMPLATE = "_PathItemTemplate";

        @Override
        public String getName() {
            return "Breadcrumbs";
        }

        @Override
        public String getPattern() {
            return "PATH";
        }

        @Override
        public WikiTemplate findInclusion(Context ctxt) {
            return null;
        }

        private Folder getFolder(Context ctxt, MailItem item) throws ServiceException {
            Mailbox mbox = item.getMailbox();
            return mbox.getFolderById(ctxt.wctxt.octxt, item.getFolderId());
        }

        private List<MailItem> getBreadcrumbs(Context ctxt) {
            ArrayList<MailItem> list = new ArrayList<MailItem>();
            try {
                Folder f = this.getFolder(ctxt, ctxt.item);
                while (f.getId() != 1) {
                    list.add(0, f);
                    f = this.getFolder(ctxt, f);
                }
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
            return list;
        }

        @Override
        public String apply(Context ctxt) throws ServiceException, IOException {
            List<MailItem> list = this.getBreadcrumbs(ctxt);
            Map<String, String> params = ctxt.token.parseParam();
            String format = params.get(sFORMAT);
            if (format == null || format.equals(sSIMPLE)) {
                StringBuffer buf = new StringBuffer();
                buf.append("<span class='zmwiki-breadcrumbsSimple'>");
                StringBuffer path = new StringBuffer();
                path.append("/");
                for (MailItem item : list) {
                    MsgWiklet msgWiklet;
                    String msgText;
                    String name = item.getName();
                    if (item.getId() == 12 && (msgText = (msgWiklet = (MsgWiklet)Wiklet.get("MSG")).getMessage(name, ctxt)) != null && !msgText.equals("")) {
                        name = msgText;
                    }
                    path.append(name);
                    buf.append("<span class='zmwiki-pageLink'>");
                    buf.append("[[").append(name).append("][").append(path).append("]]");
                    buf.append("</span>");
                    path.append("/");
                }
                buf.append("</span>");
                return new WikiTemplate(buf.toString()).toString(ctxt);
            }
            if (format.equals(sTEMPLATE)) {
                String bt = params.get(sBODYTEMPLATE);
                String it = params.get(sITEMTEMPLATE);
                if (bt == null) {
                    bt = sDEFAULTBODYTEMPLATE;
                }
                if (it == null) {
                    it = sDEFAULTITEMTEMPLATE;
                }
                return this.handleTemplates(ctxt, list, bt, it);
            }
            return this.reportError("format " + format + " not recognized");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HistoryWiklet
    extends Wiklet {
        public static final String sFORMAT = "format";
        public static final String sBODYTEMPLATE = "bodyTemplate";
        public static final String sITEMTEMPLATE = "itemTemplate";
        public static final String sDEFAULTBODYTEMPLATE = "_TocVersionBodyTemplate";
        public static final String sDEFAULTITEMTEMPLATE = "_TocVersionItemTemplate";

        @Override
        public String getName() {
            return "Version";
        }

        @Override
        public String getPattern() {
            return "HISTORY";
        }

        @Override
        public WikiTemplate findInclusion(Context ctxt) {
            return null;
        }

        public String applyTemplates(Context ctxt, Map<String, String> params) throws ServiceException, IOException {
            Mailbox mbox = ctxt.item.getMailbox();
            List<MailItem> list = mbox.getAllRevisions(ctxt.wctxt.octxt, ctxt.item.getId(), ctxt.item.getType());
            Collections.reverse(list);
            String bt = params.get(sBODYTEMPLATE);
            String it = params.get(sITEMTEMPLATE);
            if (bt == null) {
                bt = sDEFAULTBODYTEMPLATE;
            }
            if (it == null) {
                it = sDEFAULTITEMTEMPLATE;
            }
            return this.handleTemplates(ctxt, list, bt, it);
        }

        @Override
        protected String handleTemplates(Context ctxt, List<MailItem> list, String bodyTemplate, String itemTemplate) throws ServiceException, IOException {
            StringBuffer buf = new StringBuffer();
            WikiTemplate t = WikiTemplate.findTemplate(ctxt, itemTemplate);
            buf.append(t.toString(ctxt.wctxt, ctxt.item, ctxt.item));
            for (MailItem item : list) {
                buf.append(t.toString(ctxt.wctxt, item, ctxt.item));
            }
            Context newCtxt = new Context(ctxt);
            newCtxt.content = buf.toString();
            WikiTemplate body = WikiTemplate.findTemplate(newCtxt, bodyTemplate);
            return body.toString(newCtxt);
        }

        @Override
        public String apply(Context ctxt) throws ServiceException, IOException {
            Map<String, String> params = ctxt.token.parseParam();
            return this.applyTemplates(ctxt, params);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TocWiklet
    extends Wiklet {
        public static final String sFORMAT = "format";
        public static final String sBODYTEMPLATE = "bodyTemplate";
        public static final String sITEMTEMPLATE = "itemTemplate";
        public static final String sDEFAULTBODYTEMPLATE = "_TocBodyTemplate";
        public static final String sDEFAULTITEMTEMPLATE = "_TocItemTemplate";
        public static final String sSIMPLE = "simple";
        public static final String sLIST = "list";
        public static final String sTEMPLATE = "template";
        public static final String[][] sTAGS = new String[][]{{"zmwiki-tocList", "zmwiki-tocSimple"}, {"ul", "span"}, {"li", "span"}};
        public static final int sTAGLIST = 0;
        public static final int sTAGSIMPLE = 1;
        public static final int sCLASS = 0;
        public static final int sOUTER = 1;
        public static final int sINNER = 2;

        @Override
        public String getName() {
            return "Table of contents";
        }

        @Override
        public String getPattern() {
            return "TOC";
        }

        @Override
        public WikiTemplate findInclusion(Context ctxt) {
            return null;
        }

        private String createLink(String folder, String name) {
            StringBuffer buf = new StringBuffer();
            buf.append("<a href=\"");
            buf.append(folder + name);
            buf.append("\">");
            buf.append(name);
            buf.append("</a>");
            return buf.toString();
        }

        public String generateList(Context ctxt, int style) throws ServiceException {
            Folder folder;
            String prefix = "";
            if (ctxt.item instanceof Folder) {
                folder = (Folder)ctxt.item;
                prefix = folder.getName() + "/";
            } else {
                folder = ctxt.item.getMailbox().getFolderById(ctxt.wctxt.octxt, ctxt.item.getFolderId());
            }
            StringBuffer buf = new StringBuffer();
            buf.append("<");
            buf.append(sTAGS[1][style]);
            buf.append(" class='");
            buf.append(sTAGS[0][style]);
            buf.append("'>");
            List<Folder> subfolders = folder.getSubfolders(ctxt.wctxt.octxt);
            for (Folder f : subfolders) {
                buf.append("<");
                buf.append(sTAGS[2][style]);
                buf.append(" class='zmwiki-pageLink'>");
                buf.append(this.createLink(prefix, f.getName() + "/"));
                buf.append("</");
                buf.append(sTAGS[2][style]);
                buf.append(">");
            }
            Mailbox mbox = ctxt.item.getMailbox();
            for (Document doc : mbox.getDocumentList(ctxt.wctxt.octxt, folder.getId(), SortBy.NAME_NATURAL_ORDER_ASCENDING)) {
                buf.append("<");
                buf.append(sTAGS[2][style]);
                buf.append(" class='zmwiki-pageLink'>");
                buf.append(this.createLink(prefix, doc.getName()));
                buf.append("</");
                buf.append(sTAGS[2][style]);
                buf.append(">");
            }
            buf.append("</");
            buf.append(sTAGS[1][style]);
            buf.append(">");
            return buf.toString();
        }

        public String applyTemplates(Context ctxt, Map<String, String> params) throws ServiceException, IOException {
            ArrayList<MailItem> list = new ArrayList<MailItem>();
            Folder folder = ctxt.item instanceof Folder ? (Folder)ctxt.item : ctxt.item.getMailbox().getFolderById(ctxt.wctxt.octxt, ctxt.item.getFolderId());
            list.addAll(folder.getSubfolders(ctxt.wctxt.octxt));
            Mailbox mbox = ctxt.item.getMailbox();
            byte type = folder.getDefaultView();
            if (ctxt.wctxt.view == null) {
                list.addAll(mbox.getItemList(ctxt.wctxt.octxt, type, folder.getId(), SortBy.NAME_NATURAL_ORDER_ASCENDING));
            } else {
                list.addAll(mbox.getItemList(ctxt.wctxt.octxt, MailItem.getTypeForName(ctxt.wctxt.view), folder.getId(), SortBy.NAME_NATURAL_ORDER_ASCENDING));
            }
            String bt = params.get(sBODYTEMPLATE);
            String it = params.get(sITEMTEMPLATE);
            if (bt == null) {
                bt = sDEFAULTBODYTEMPLATE;
            }
            if (it == null) {
                it = sDEFAULTITEMTEMPLATE;
            }
            return this.handleTemplates(ctxt, list, bt, it);
        }

        @Override
        public String apply(Context ctxt) throws ServiceException, IOException {
            Map<String, String> params = ctxt.token.parseParam();
            String format = params.get(sFORMAT);
            if (format == null) {
                format = sLIST;
            }
            if (format.equals(sTEMPLATE)) {
                return this.applyTemplates(ctxt, params);
            }
            return this.generateList(ctxt, format.equals(sSIMPLE) ? 1 : 0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Wiklet {
        private static Map<String, Wiklet> sWIKLETS = new HashMap<String, Wiklet>();

        public abstract String getName();

        public abstract String getPattern();

        public abstract String apply(Context var1) throws ServiceException, IOException;

        public abstract WikiTemplate findInclusion(Context var1) throws ServiceException, IOException;

        public String reportError(String errorMsg) {
            String msg = "Error handling wiklet " + this.getName() + ": " + errorMsg;
            ZimbraLog.wiki.error(msg);
            return msg;
        }

        protected String handleTemplates(Context ctxt, List<MailItem> list, String bodyTemplate, String itemTemplate) throws ServiceException, IOException {
            StringBuffer buf = new StringBuffer();
            for (MailItem item : list) {
                WikiTemplate t = WikiTemplate.findTemplate(ctxt, itemTemplate);
                buf.append(t.toString(ctxt.wctxt, item));
            }
            Context newCtxt = new Context(ctxt);
            newCtxt.content = buf.toString();
            WikiTemplate body = WikiTemplate.findTemplate(ctxt, bodyTemplate);
            return body.toString(newCtxt);
        }

        public String toString() {
            return "Wiklet: " + this.getName();
        }

        private static void addWiklet(Wiklet w) {
            sWIKLETS.put(w.getPattern(), w);
        }

        public static Wiklet get(Token tok) {
            Wiklet w;
            String tokenStr = tok.getValue();
            if (tok.getType() == Token.TokenType.WIKILINK) {
                w = sWIKLETS.get("WIKILINK");
            } else {
                int index = tokenStr.indexOf(32);
                String firstTok = index != -1 ? tokenStr.substring(0, index) : tokenStr;
                if (firstTok.equals("wiklet")) {
                    Map<String, String> params = tok.parseParam();
                    String cls = params.get("class");
                    if (cls == null) {
                        return null;
                    }
                    w = cls.equals("link") ? sWIKLETS.get("WIKILINK") : sWIKLETS.get(cls.toUpperCase());
                } else {
                    w = sWIKLETS.get(firstTok);
                }
            }
            return w;
        }

        public static Wiklet get(String name) {
            return sWIKLETS.get(name);
        }

        static {
            Wiklet.addWiklet(new TocWiklet());
            Wiklet.addWiklet(new HistoryWiklet());
            Wiklet.addWiklet(new BreadcrumbsWiklet());
            Wiklet.addWiklet(new IconWiklet());
            Wiklet.addWiklet(new NameWiklet());
            Wiklet.addWiklet(new CreatorWiklet());
            Wiklet.addWiklet(new TagsWiklet());
            Wiklet.addWiklet(new ModifierWiklet());
            Wiklet.addWiklet(new CreateDateWiklet());
            Wiklet.addWiklet(new ModifyDateWiklet());
            Wiklet.addWiklet(new VersionWiklet());
            Wiklet.addWiklet(new ContentWiklet());
            Wiklet.addWiklet(new IncludeWiklet());
            Wiklet.addWiklet(new InlineWiklet());
            Wiklet.addWiklet(new WikilinkWiklet());
            Wiklet.addWiklet(new UrlWiklet());
            Wiklet.addWiklet(new FragmentWiklet());
            Wiklet.addWiklet(new MsgWiklet());
        }
    }

    public static class Context {
        public WikiPage.WikiContext wctxt;
        public MailItem item;
        public WikiTemplate itemTemplate;
        public Token token;
        public String content;
        public MailItem latestVersionItem;
        public Locale locale;

        public Context(Context copy) {
            this(copy.wctxt, copy.item, copy.itemTemplate);
            this.locale = copy.wctxt.locale;
        }

        public Context(WikiPage.WikiContext wc, MailItem it, WikiTemplate itt) {
            this(wc, it, itt, null);
            this.locale = wc.locale;
        }

        public Context(WikiPage.WikiContext wc, MailItem it, WikiTemplate itt, MailItem tit) {
            this.wctxt = wc;
            this.item = it;
            this.itemTemplate = itt;
            this.content = null;
            this.latestVersionItem = tit;
            this.locale = wc.locale;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Token {
        public static final String sWIKLETTAG = "wiklet";
        public static final String sCLASSATTR = "class";
        private TokenType mType;
        private String mVal;
        private String mData;
        private Map<String, String> mParams;

        public static void parse(String str, List<Token> tokens) throws IllegalArgumentException {
            int len = str.length();
            int pos = 0;
            while (pos < len) {
                Token tok = null;
                int padding = 2;
                int end = pos;
                int lastPos = len - 1;
                if (pos >= lastPos) {
                    return;
                }
                if (str.startsWith("<!--", pos)) {
                    end = str.indexOf("-->", pos);
                    if (end > 0) {
                        tok = new Token(str.substring(pos, end += 3), TokenType.COMMENT);
                    }
                } else if (str.startsWith("{{", pos)) {
                    end = str.indexOf("}}", pos);
                    if (end > 0) {
                        tok = new Token(str.substring(pos + 2, end), TokenType.WIKLET);
                        end += padding;
                    }
                } else if (str.startsWith("[[", pos)) {
                    end = str.indexOf("]]", pos);
                    if (end > 0) {
                        tok = new Token(str.substring(pos + 2, end), TokenType.WIKILINK);
                        end += padding;
                    }
                } else if (str.startsWith("<wiklet", pos) && (end = str.indexOf(">", pos)) > 0) {
                    if (str.charAt(end - 1) == '/') {
                        padding = 1;
                    } else {
                        int endSection = str.indexOf("</wiklet>", end);
                        padding = endSection - end + 9;
                    }
                    tok = new Token(str.substring(pos + 1, end), TokenType.WIKLET);
                    end += padding;
                }
                if (tok == null) {
                    for (end = pos + 1; !(end >= lastPos || str.startsWith("<!--", end) || str.startsWith("{{", end) || str.startsWith("[[", end) || str.startsWith("<wiklet", end)); ++end) {
                    }
                    if (end == lastPos) {
                        end = len;
                    }
                    if (end > pos) {
                        tok = new Token(str.substring(pos, end), TokenType.TEXT);
                    }
                }
                if (tok != null) {
                    tokens.add(tok);
                }
                pos = end;
            }
        }

        public Token(String text, TokenType type) {
            this.mVal = text;
            this.mType = type;
        }

        public TokenType getType() {
            return this.mType;
        }

        public String getValue() {
            return this.mVal;
        }

        public String getData() {
            return this.mData;
        }

        public void setData(String str) {
            this.mData = str;
        }

        public Map<String, String> parseParam() {
            return this.parseParam(this.mVal);
        }

        public Map<String, String> parseParam(String text) {
            if (this.mParams != null) {
                return this.mParams;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            ParseState state = ParseState.K;
            String key = null;
            boolean done = false;
            int c = 0;
            int start = 0;
            int end = 0;
            while (!done) {
                int cprev = c;
                if (end == text.length()) {
                    c = 32;
                    done = true;
                } else {
                    c = text.charAt(end);
                }
                if (state == ParseState.K) {
                    if (c == 32 || c == 61) {
                        key = text.substring(start, end);
                        start = end + 1;
                        if (c == 32) {
                            map.put(key, key);
                        } else if (c == 61) {
                            state = ParseState.V;
                        }
                    }
                } else if (state == ParseState.V) {
                    if (c == 34 || c == 39) {
                        ++start;
                        state = ParseState.VQ;
                    } else if (c == 32) {
                        map.put(key, text.substring(start, end));
                        start = end + 1;
                        state = ParseState.K;
                    }
                } else if (state == ParseState.VQ && (c == 34 || c == 39) && cprev != 92) {
                    map.put(key, text.substring(start, end));
                    start = end + 1;
                    state = ParseState.K;
                }
                ++end;
            }
            this.mParams = map;
            return map;
        }

        public String toString() {
            return "Token: type=" + (Object)((Object)this.mType) + ", text=" + this.mVal;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum ParseState {
            K,
            V,
            VQ;

        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum TokenType {
            TEXT,
            WIKLET,
            WIKILINK,
            COMMENT;

        }
    }
}

