/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.wiki;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.Pair;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.mailbox.Document;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.service.UserServlet;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.service.wiki.WikiServiceException;
import com.zimbra.cs.wiki.WikiTemplate;
import java.io.IOException;
import java.util.Locale;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.httpclient.Header;

public abstract class WikiPage {
    protected long mTimestamp = System.currentTimeMillis();
    protected String mAccountId;
    protected String mWikiWord;
    protected int mId;
    protected int mFolderId;
    protected int mVersion;
    protected long mCreatedDate;
    protected long mModifiedDate;
    protected String mCreator;
    protected String mModifiedBy;
    protected String mFragment;
    protected String mContents;
    private static LRUMap sPageCache = new LRUMap(1024);
    private static long TTL = 600000L;

    public static WikiPage create(Document page) {
        return new LocalWikiPage(page);
    }

    public static WikiPage create(String accountId, String path) throws ServiceException {
        return new RemoteWikiPage(accountId, path);
    }

    public abstract String getContents(WikiContext var1) throws ServiceException;

    public abstract String getFolderKey();

    public synchronized WikiTemplate getTemplate(WikiContext ctxt) throws ServiceException {
        return new WikiTemplate(this.getContents(ctxt), this.mAccountId, this.getFolderKey(), this.mWikiWord);
    }

    public long getTimestamp() {
        return this.mTimestamp;
    }

    public String getAccountId() {
        return this.mAccountId;
    }

    public String getWikiWord() {
        return this.mWikiWord;
    }

    public long getLastVersion() {
        return this.mVersion;
    }

    public long getCreatedDate() {
        return this.mCreatedDate;
    }

    public long getModifiedDate() {
        return this.mModifiedDate;
    }

    public String getCreator() {
        return this.mCreator;
    }

    public String getLastEditor() {
        return this.mModifiedBy;
    }

    public String getFolderId() {
        ItemId iid = new ItemId(this.mAccountId, this.mFolderId);
        return iid.toString((String)null);
    }

    public String getId() {
        ItemId iid = new ItemId(this.mAccountId, this.mId);
        return iid.toString((String)null);
    }

    public String getFragment() {
        return this.mFragment;
    }

    public static WikiPage findPage(WikiContext ctxt, String accountId, int id) throws ServiceException {
        Account account = Provisioning.getInstance().get(Provisioning.AccountBy.id, accountId, ctxt.auth);
        if (!Provisioning.onLocalServer(account)) {
            throw new WikiServiceException.NoSuchWikiException("not on local host");
        }
        Mailbox mbox = MailboxManager.getInstance().getMailboxByAccount(account);
        MailItem item = mbox.getItemById(ctxt.octxt, id, (byte)-1);
        if (item.getType() != 8 && item.getType() != 14) {
            throw WikiServiceException.NOT_WIKI_ITEM("not a wiki item");
        }
        return WikiPage.create((Document)item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WikiPage getCachedTemplate(Domain domain, String template) {
        long now = System.currentTimeMillis();
        String key = domain.getId() + template;
        WikiPage page = null;
        LRUMap lRUMap = sPageCache;
        synchronized (lRUMap) {
            page = (WikiPage)sPageCache.get((Object)key);
            if (page != null && page.getTimestamp() + TTL < now) {
                sPageCache.remove((Object)key);
                page = null;
            }
        }
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cacheTemplate(Domain domain, String template, WikiPage page) {
        if (page == null) {
            return;
        }
        String key = domain.getId() + template;
        LRUMap lRUMap = sPageCache;
        synchronized (lRUMap) {
            sPageCache.put((Object)key, (Object)page);
        }
    }

    public static WikiPage findTemplate(WikiContext ctxt, String accountId, String template) throws ServiceException {
        String defaultWiki;
        Provisioning prov = Provisioning.getInstance();
        Account acct = prov.get(Provisioning.AccountBy.id, accountId, ctxt.auth);
        Domain domain = prov.getDomain(acct);
        template = "/Template/" + template;
        WikiPage page = null;
        if (domain != null) {
            page = WikiPage.getCachedTemplate(domain, template);
            if (page != null) {
                return page;
            }
            String domainWiki = domain.getAttr("zimbraNotebookAccount", null);
            if (domainWiki != null) {
                page = WikiPage.findTemplatePage(ctxt, domainWiki, template);
            }
        }
        if (page == null && (defaultWiki = prov.getConfig().getAttr("zimbraNotebookAccount", null)) != null) {
            page = WikiPage.findTemplatePage(ctxt, defaultWiki, template);
        }
        if (domain != null) {
            WikiPage.cacheTemplate(domain, template, page);
        }
        return page;
    }

    public static WikiPage missingPage(String template) {
        return new ErrorPage(template);
    }

    private static WikiPage findTemplatePage(WikiContext ctxt, String wikiAccountName, String template) throws ServiceException {
        Provisioning prov = Provisioning.getInstance();
        Account acct = prov.get(Provisioning.AccountBy.name, wikiAccountName);
        if (acct == null) {
            throw ServiceException.FAILURE("wiki account " + wikiAccountName + " does not exist, please check " + "zimbraNotebookAccount" + " on the domain or global config", null);
        }
        WikiPage page = null;
        if (Provisioning.onLocalServer(acct)) {
            try {
                Mailbox mbox = MailboxManager.getInstance().getMailboxByAccount(acct);
                MailItem item = mbox.getItemByPath(ctxt.octxt, template);
                if (item instanceof Document) {
                    page = WikiPage.create((Document)item);
                }
            }
            catch (ServiceException se) {}
        } else {
            page = WikiPage.create(acct.getId(), template);
            try {
                page.getContents(ctxt);
            }
            catch (ServiceException se) {
                page = null;
            }
        }
        return page;
    }

    private static class ErrorPage
    extends WikiPage {
        String template;

        ErrorPage(String template) {
            this.template = template;
        }

        public String getContents(WikiContext ctxt) {
            return "<!-- missing template" + this.template + " -->";
        }

        public String getFolderKey() {
            return "";
        }
    }

    public static class RemoteWikiPage
    extends WikiPage {
        private String mPath;
        private String mRestUrl;
        private String mContents;

        RemoteWikiPage(String accountId, String path) throws ServiceException {
            Provisioning prov = Provisioning.getInstance();
            Account acct = prov.getAccountById(accountId);
            this.mRestUrl = UserServlet.getRestUrl(acct) + path;
        }

        public String getContents(WikiContext ctxt) throws ServiceException {
            AuthToken auth;
            if (this.mContents != null) {
                return this.mContents;
            }
            if (ctxt != null && ctxt.auth != null) {
                auth = ctxt.auth;
            } else {
                try {
                    auth = AuthToken.getZimbraAdminAuthToken();
                }
                catch (Exception ate) {
                    auth = null;
                }
            }
            String url = this.mRestUrl + "?fmt=native&disp=attachment";
            Pair<Header[], byte[]> resource = UserServlet.getRemoteResource(auth.toZAuthToken(), url);
            int status = 0;
            for (Header h : resource.getFirst()) {
                if (h.getName().compareTo("X-Zimbra-Http-Status") != 0) continue;
                status = Integer.parseInt(h.getValue());
            }
            if (status != 200) {
                throw ServiceException.RESOURCE_UNREACHABLE("http error " + status, null, new ServiceException.Argument[0]);
            }
            try {
                this.mContents = new String(resource.getSecond(), "UTF-8");
            }
            catch (IOException ioe) {
                throw ServiceException.RESOURCE_UNREACHABLE("invalid url", ioe, new ServiceException.Argument[0]);
            }
            return this.mContents;
        }

        public String getFolderKey() {
            return this.mPath;
        }
    }

    public static class LocalWikiPage
    extends WikiPage {
        LocalWikiPage(Document doc) {
            this.addWikiItem(doc);
        }

        private void addWikiItem(Document newItem) {
            this.mWikiWord = newItem.getName();
            this.mId = newItem.getId();
            this.mVersion = newItem.getVersion();
            this.mModifiedDate = newItem.getDate();
            this.mModifiedBy = newItem.getCreator();
            this.mCreatedDate = newItem.getDate();
            this.mCreator = newItem.getCreator();
            this.mFolderId = newItem.getFolderId();
            this.mFragment = newItem.getFragment();
            this.mContents = null;
            this.mAccountId = newItem.getMailbox().getAccountId();
        }

        public Document getWikiRevision(WikiContext ctxt, int version) throws ServiceException {
            Mailbox mbox = MailboxManager.getInstance().getMailboxByAccountId(this.mAccountId);
            return (Document)mbox.getItemRevision(ctxt.octxt, this.mId, (byte)8, version);
        }

        public String getContents(WikiContext ctxt) throws ServiceException {
            if (this.mContents == null) {
                try {
                    byte[] raw = this.getWikiRevision(ctxt, this.mVersion).getContent();
                    this.mContents = new String(raw, "UTF-8");
                }
                catch (IOException ioe) {
                    throw WikiServiceException.ERROR("can't get contents", ioe);
                }
            }
            return this.mContents;
        }

        public String getFolderKey() {
            return Integer.toString(this.mFolderId);
        }
    }

    public static class WikiContext {
        OperationContext octxt;
        AuthToken auth;
        String view;
        Locale locale;

        public WikiContext(OperationContext o, AuthToken a) {
            this.octxt = o;
            this.auth = a;
            this.view = null;
        }

        public WikiContext(OperationContext o, AuthToken a, String v) {
            this.octxt = o;
            this.auth = a;
            this.view = v;
        }

        public WikiContext(OperationContext o, AuthToken a, String v, Locale l) {
            this.octxt = o;
            this.auth = a;
            this.view = v;
            this.locale = l;
        }
    }
}

