/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.wiki;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.CliUtil;
import com.zimbra.cs.db.DbPool;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.store.MailboxBlob;
import com.zimbra.cs.store.StoreManager;
import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiDigestFixup {
    private static StoreManager sStore;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Mbox> getMboxList(DbPool.Connection conn) throws SQLException {
        PreparedStatement stmt;
        ArrayList<Mbox> list;
        block6: {
            list = new ArrayList<Mbox>(1000);
            String sql = "SELECT id, comment FROM mailbox ORDER BY id";
            stmt = null;
            ResultSet rs = null;
            try {
                stmt = conn.prepareStatement(sql);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    int id = rs.getInt(1);
                    String email = rs.getString(2);
                    list.add(new Mbox(id, email));
                }
                Object var8_7 = null;
                if (rs == null) break block6;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                throw throwable;
            }
            rs.close();
        }
        if (stmt != null) {
            stmt.close();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<WikiDigest> getWikiDigests(long mboxId) throws IOException, ServiceException {
        List documents;
        Mailbox mbox = null;
        try {
            mbox = MailboxManager.getInstance().getMailboxById(mboxId);
        }
        catch (ServiceException e) {
            String code = e.getCode();
            if ("account.NO_SUCH_ACCOUNT".equals(code) || "service.WRONG_HOST".equals(code)) {
                return null;
            }
            throw e;
        }
        OperationContext octxt = new OperationContext(mbox);
        ArrayList items = new ArrayList();
        List wikis = mbox.getItemList(octxt, (byte)14);
        if (wikis != null && wikis.size() > 0) {
            items.addAll(wikis);
        }
        if ((documents = mbox.getItemList(octxt, (byte)8)) != null && documents.size() > 0) {
            items.addAll(documents);
        }
        int len = items.size();
        ArrayList<WikiDigest> list = new ArrayList<WikiDigest>(len);
        if (len > 0) {
            for (MailItem item : items) {
                Object var19_19;
                if (item.getSize() > Integer.MAX_VALUE) continue;
                int id = item.getId();
                MailboxBlob blob = sStore.getMailboxBlob(item);
                InputStream is = null;
                try {
                    is = sStore.getContent(blob);
                    byte[] data = ByteUtil.getContent(is, (int)item.getSize());
                    String digest = ByteUtil.getDigest(data);
                    String currentDigest = item.getDigest();
                    if (!digest.equals(currentDigest)) {
                        System.out.println("Found id " + id + ", current digest = \"" + currentDigest + "\"");
                        WikiDigest wd = new WikiDigest(mboxId, id, digest);
                        list.add(wd);
                    } else {
                        System.out.println("Found id " + id + " but skipping because digest is correct.");
                    }
                    var19_19 = null;
                }
                catch (Throwable throwable) {
                    var19_19 = null;
                    ByteUtil.closeStream(is);
                    throw throwable;
                }
                ByteUtil.closeStream(is);
                {
                }
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void fixupItems(DbPool.Connection conn, long mboxId, List<WikiDigest> digests) throws SQLException, ServiceException {
        block6: {
            StringBuilder sql = new StringBuilder("UPDATE ");
            sql.append("mailbox" + mboxId + ".mail_item");
            sql.append(" SET blob_digest = ? WHERE id = ? AND type in (");
            sql.append(14);
            sql.append(", ");
            sql.append(8);
            sql.append(")");
            String sqlStr = sql.toString();
            boolean success = false;
            try {
                for (WikiDigest wd : digests) {
                    Object var14_12;
                    int id = wd.getItemId();
                    String digest = wd.getDigest();
                    System.out.println("Setting digest = \"" + digest + "\" for id = " + id);
                    PreparedStatement stmt = null;
                    try {
                        stmt = conn.prepareStatement(sqlStr);
                        int pos = 1;
                        stmt.setString(pos++, digest);
                        stmt.setInt(pos++, id);
                        stmt.executeUpdate();
                        var14_12 = null;
                        if (stmt == null) continue;
                    }
                    catch (Throwable throwable) {
                        var14_12 = null;
                        if (stmt == null) throw throwable;
                        stmt.close();
                        throw throwable;
                    }
                    stmt.close();
                }
                success = true;
                Object var16_14 = null;
                if (!success) break block6;
            }
            catch (Throwable throwable) {
                Object var16_15 = null;
                if (success) {
                    conn.commit();
                    throw throwable;
                }
                conn.rollback();
                throw throwable;
            }
            conn.commit();
            return;
        }
        conn.rollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        CliUtil.toolSetup("WARN");
        sStore = StoreManager.getInstance();
        DbPool.startup();
        DbPool.Connection conn = null;
        try {
            try {
                int numFixed = 0;
                conn = DbPool.getConnection();
                System.out.println("Getting mailbox list...");
                List<Mbox> mboxList = WikiDigestFixup.getMboxList(conn);
                for (Mbox m : mboxList) {
                    long mboxId = m.getId();
                    System.out.println("Processing mailbox " + mboxId + " (" + m.getEmail() + ") ...");
                    System.out.println("Getting wiki items needing fixup...");
                    List<WikiDigest> digests = WikiDigestFixup.getWikiDigests(mboxId);
                    int howmany = digests != null ? digests.size() : 0;
                    System.out.println("Got " + howmany + " wiki items to fixup.");
                    if (howmany > 0) {
                        WikiDigestFixup.fixupItems(conn, mboxId, digests);
                        numFixed += howmany;
                    }
                    System.out.println("Done with mailbox " + mboxId + ".");
                }
                System.out.println("Done.  Fixed " + numFixed + " wiki items.");
            }
            catch (Exception e) {
                System.err.println("Error: " + e.getMessage());
                e.printStackTrace(System.err);
                Object var11_11 = null;
                DbPool.quietClose(conn);
                return;
            }
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            DbPool.quietClose(conn);
            throw throwable;
        }
        DbPool.quietClose(conn);
    }

    private static class WikiDigest {
        private long mMboxId;
        private int mItemId;
        private String mDigest;

        public WikiDigest(long mboxId, int itemId, String digest) {
            this.mMboxId = mboxId;
            this.mItemId = itemId;
            this.mDigest = digest;
        }

        public long getMboxid() {
            return this.mMboxId;
        }

        public int getItemId() {
            return this.mItemId;
        }

        public String getDigest() {
            return this.mDigest;
        }
    }

    private static class Mbox {
        private long mId;
        private String mEmail;

        public Mbox(long id, String email) {
            this.mId = id;
            this.mEmail = email;
        }

        public long getId() {
            return this.mId;
        }

        public String getEmail() {
            return this.mEmail;
        }
    }
}

