/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.wiki;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.Pair;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.mailbox.MailItem;
import org.apache.commons.collections.map.LRUMap;

public class PageCache {
    private static final int DEFAULT_CACHE_SIZE = 10240;
    private static final int TTL = 600000;
    private LRUMap mCache;
    private static final String SEP = ":";

    public PageCache() {
        int cacheSize;
        Provisioning prov = Provisioning.getInstance();
        try {
            Server localServer = prov.getLocalServer();
            cacheSize = localServer.getIntAttr("zimbraNotebookPageCacheSize", 10240);
        }
        catch (ServiceException se) {
            cacheSize = 10240;
        }
        this.mCache = new LRUMap(cacheSize);
    }

    public PageCache(int cacheSize) {
        this.mCache = new LRUMap(cacheSize);
    }

    public synchronized void addPage(String key, String page) {
        Pair<Long, String> v = new Pair<Long, String>(this.getExpirationTime(), page);
        this.mCache.put((Object)key, v);
    }

    private long getExpirationTime() {
        return System.currentTimeMillis() + 600000L;
    }

    public synchronized String getPage(String key) {
        Pair v = (Pair)this.mCache.get((Object)key);
        if (v != null && (Long)v.getFirst() < System.currentTimeMillis()) {
            this.mCache.remove((Object)key);
            v = null;
        }
        if (v == null) {
            return null;
        }
        return (String)v.getSecond();
    }

    public synchronized void removePage(String key) {
        Pair v = (Pair)this.mCache.get((Object)key);
        if (v != null) {
            this.mCache.remove((Object)key);
        }
    }

    public String generateKey(Account user, MailItem item) {
        String auth = user == null ? "guest" : user.getId();
        StringBuilder buf = new StringBuilder();
        buf.append(auth).append(SEP).append(item.getMailboxId()).append(SEP).append(item.getId());
        return buf.toString();
    }
}

