/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.wiki;

import com.zimbra.common.util.ByteUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Diff {
    public static final long MAX_LENGTH = 0x100000L;

    private static void addString(ArrayList<Chunk> chunks, String str, Type disp) {
        if (chunks.size() == 0) {
            chunks.add(new Chunk(str, disp));
            return;
        }
        Chunk c = chunks.get(chunks.size() - 1);
        if (c.disposition == disp) {
            c.content.add(str);
        } else {
            chunks.add(new Chunk(str, disp));
        }
    }

    private static String[] readInputStream(InputStream in) throws IOException {
        byte[] buf = ByteUtil.getContent(in, -1);
        return new String(buf, "UTF-8").split("\\n");
    }

    public static Collection<Chunk> getResult(InputStream i1, InputStream i2) throws IOException {
        int j;
        int i;
        String[] x = Diff.readInputStream(i1);
        String[] y = Diff.readInputStream(i2);
        ArrayList<Chunk> result = new ArrayList<Chunk>();
        int M = x.length;
        int N = y.length;
        int[][] opt = new int[M + 1][N + 1];
        for (i = M - 1; i >= 0; --i) {
            for (j = N - 1; j >= 0; --j) {
                opt[i][j] = x[i].equals(y[j]) ? opt[i + 1][j + 1] + 1 : Math.max(opt[i + 1][j], opt[i][j + 1]);
            }
        }
        i = 0;
        j = 0;
        while (i < M && j < N) {
            if (x[i].equals(y[j])) {
                Diff.addString(result, x[i], Type.common);
                ++i;
                ++j;
                continue;
            }
            if (opt[i + 1][j] >= opt[i][j + 1]) {
                Diff.addString(result, x[i++], Type.first);
                continue;
            }
            Diff.addString(result, y[j++], Type.second);
        }
        while (i < M || j < N) {
            if (i == M) {
                Diff.addString(result, y[j++], Type.second);
                continue;
            }
            if (j != N) continue;
            Diff.addString(result, x[i++], Type.first);
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        FileInputStream f1 = new FileInputStream(args[0]);
        FileInputStream f2 = new FileInputStream(args[1]);
        Collection<Chunk> chunks = Diff.getResult(f1, f2);
        for (Chunk c : chunks) {
            switch (c.disposition) {
                case common: {
                    break;
                }
                case first: {
                    for (String str : c.content) {
                        System.out.println("< " + str);
                    }
                    break;
                }
                case second: {
                    for (String str : c.content) {
                        System.out.println("> " + str);
                    }
                    break;
                }
            }
        }
    }

    public static class Chunk {
        public Type disposition;
        public ArrayList<String> content = new ArrayList();

        public Chunk(String c, Type disp) {
            this.content.add(c);
            this.disposition = disp;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        common,
        first,
        second;

    }
}

