/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.util.yauth;

import com.zimbra.cs.util.yauth.AuthenticationException;
import com.zimbra.cs.util.yauth.RawAuth;
import java.io.IOException;

public abstract class TokenStore {
    public String newToken(String appId, String user, String pass) throws AuthenticationException, IOException {
        this.removeToken(appId, user);
        String token = RawAuth.getToken(appId, user, pass);
        this.putToken(appId, user, token);
        return token;
    }

    public boolean hasToken(String appId, String user) {
        return this.getToken(appId, user) != null;
    }

    protected abstract void putToken(String var1, String var2, String var3);

    public abstract String getToken(String var1, String var2);

    public abstract void removeToken(String var1, String var2);

    public abstract int size();
}

