/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.util.yauth;

import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.methods.GetMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenAuthenticateV1 {
    private String mCrumb;
    private String mY;
    private String mT;

    public static String getToken(String username, String passwd) throws IOException, HttpException {
        HttpClient client = new HttpClient();
        GetMethod method = new GetMethod("https://login.yahoo.com/config/pwtoken_get?src=ymsgr&login=" + username + "&passwd=" + passwd);
        int response = client.executeMethod(method);
        if (response >= 200 && response < 300) {
            String body = method.getResponseBodyAsString();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("ymsgr", null);
            TokenAuthenticateV1.parseResponseBody(body, map);
            return map.get("ymsgr");
        }
        throw new IOException("HTTPClient response: " + response);
    }

    private static void parseResponseBody(String responseBody, HashMap<String, String> map) {
        String[] lines;
        for (String line : lines = responseBody.split("\n")) {
            int eqIdx = line.indexOf(61);
            if (eqIdx <= 0) continue;
            String[] cols = new String[2];
            line = line.trim();
            cols[0] = line.substring(0, eqIdx);
            cols[1] = "";
            if (eqIdx >= line.length() - 1) continue;
            cols[1] = line.substring(eqIdx + 1);
            if (!map.containsKey(cols[0]) || map.get(cols[0]) != null) continue;
            map.put(cols[0], cols[1]);
        }
    }

    public static TokenAuthenticateV1 doAuth(String username, String token) throws IOException, HttpException {
        HttpClient client = new HttpClient();
        GetMethod method = new GetMethod("https://login.yahoo.com/config/pwtoken_login?src=ymsgr&token=" + token);
        int response = client.executeMethod(method);
        if (response >= 200 && response < 300) {
            String body = method.getResponseBodyAsString();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("crumb", null);
            map.put("Y", null);
            map.put("T", null);
            TokenAuthenticateV1.parseResponseBody(body, map);
            return new TokenAuthenticateV1(map.get("crumb"), map.get("Y"), map.get("T"));
        }
        throw new IOException("HTTPClient response: " + response);
    }

    public String toString() {
        return "YToken(crumb=" + this.mCrumb + ",Y=" + this.mY + ",T=" + this.mT + ")";
    }

    private TokenAuthenticateV1(String crumb, String Y, String T) {
        if (crumb == null || Y == null || T == null) {
            throw new IllegalArgumentException("Missing part of auth response");
        }
        this.mCrumb = crumb;
        this.mY = Y;
        this.mT = T;
    }

    public String getCrumb() {
        return this.mCrumb;
    }

    public String getY() {
        return this.mY;
    }

    public String getT() {
        return this.mT;
    }

    public static void main(String[] argv) {
        try {
            String ymsgr = TokenAuthenticateV1.getToken("XXXX", "XXXX");
            System.out.println("Got token: " + ymsgr);
            TokenAuthenticateV1 ta = TokenAuthenticateV1.doAuth("XXXX", ymsgr);
            System.out.println("Got token: " + ta.toString());
        }
        catch (Exception e) {
            System.out.println("Caught exception" + e);
            e.printStackTrace();
        }
    }
}

