/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.util.yauth;

import com.zimbra.cs.util.yauth.AuthenticationException;
import com.zimbra.cs.util.yauth.Authenticator;
import com.zimbra.cs.util.yauth.RawAuth;
import com.zimbra.cs.util.yauth.TokenStore;
import java.io.IOException;
import java.util.HashMap;
import org.apache.log4j.Logger;

public final class RawAuthManager {
    private final TokenStore store;
    private final HashMap<String, RawAuth> cookies;
    private static final Logger LOG = Logger.getLogger(RawAuthManager.class);

    public RawAuthManager(TokenStore store) {
        this.store = store;
        this.cookies = new HashMap();
    }

    public RawAuth authenticate(String appId, String user, String pass) throws AuthenticationException, IOException {
        RawAuth auth = this.cookies.get(this.key(appId, user));
        if (auth == null || auth.isExpired()) {
            String token = this.store.getToken(appId, user);
            if (token == null) {
                token = this.store.newToken(appId, user, pass);
            }
            try {
                auth = RawAuth.authenticate(appId, token);
            }
            catch (AuthenticationException e) {
                switch (e.getErrorCode()) {
                    case TOKEN_REQUIRED: 
                    case INVALID_TOKEN: {
                        this.invalidate(appId, user);
                        token = this.store.newToken(appId, user, pass);
                        auth = RawAuth.authenticate(appId, token);
                        break;
                    }
                    default: {
                        throw e;
                    }
                }
            }
            this.cookies.put(this.key(appId, user), auth);
        }
        return auth;
    }

    public void invalidate(String appId, String user) {
        this.cookies.remove(this.key(appId, user));
    }

    public Authenticator newAuthenticator(final String appId, final String user, final String pass) {
        return new Authenticator(){

            public RawAuth authenticate() throws AuthenticationException, IOException {
                return RawAuthManager.this.authenticate(appId, user, pass);
            }

            public void invalidate() {
                RawAuthManager.this.invalidate(appId, user);
            }
        };
    }

    public TokenStore getTokenStore() {
        return this.store;
    }

    private String key(String appId, String user) {
        return appId + " " + user;
    }

    public String toString() {
        return String.format("{cookies=%d,tokens=%d}", this.cookies.size(), this.store.size());
    }
}

