/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.util.yauth;

import com.zimbra.common.localconfig.LC;
import com.zimbra.cs.util.yauth.Auth;
import com.zimbra.cs.util.yauth.AuthenticationException;
import com.zimbra.cs.util.yauth.ErrorCode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;

public class RawAuth
implements Auth {
    private final String appId;
    private String cookie;
    private String wssId;
    private long expiration;
    private static final Logger LOG = Logger.getLogger(RawAuth.class);
    private static final boolean DEBUG = false;
    private static final String GET_AUTH_TOKEN = "get_auth_token";
    private static final String GET_AUTH = "get_auth";
    private static final String LOGIN = "login";
    private static final String PASSWD = "passwd";
    private static final String APPID = "appid";
    private static final String TOKEN = "token";
    private static final String AUTH_TOKEN = "AuthToken";
    private static final String COOKIE = "Cookie";
    private static final String WSSID = "WSSID";
    private static final String EXPIRATION = "Expiration";
    private static final String ERROR = "Error";
    private static final String ERROR_DESCRIPTION = "ErrorDescription";
    private static final String CAPTCHA_URL = "CaptchaUrl";
    private static final String CAPTCHA_DATA = "CaptchaData";
    private static final long EXPIRATION_LIMIT = 60000L;

    public static String getToken(String appId, String user, String pass) throws AuthenticationException, IOException {
        RawAuth.debug("Sending getToken request: appId = %s, user = %s", appId, user);
        Response res = RawAuth.doGet(GET_AUTH_TOKEN, new NameValuePair(APPID, appId), new NameValuePair(LOGIN, user), new NameValuePair(PASSWD, pass));
        String token = res.getRequiredField(AUTH_TOKEN);
        RawAuth.debug("Got getToken response: token = %s", token);
        return token;
    }

    public static RawAuth authenticate(String appId, String token) throws AuthenticationException, IOException {
        RawAuth.debug("Sending authenticate request: appId = %s, token = %s", appId, token);
        RawAuth auth = new RawAuth(appId);
        auth.authenticate(token);
        RawAuth.debug("Got authenticate response: %s", auth);
        return auth;
    }

    private RawAuth(String appId) {
        this.appId = appId;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getCookie() {
        return this.cookie;
    }

    public String getWSSID() {
        return this.wssId;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() + 60000L > this.expiration;
    }

    private void authenticate(String token) throws AuthenticationException, IOException {
        Response res = RawAuth.doGet(GET_AUTH, new NameValuePair(APPID, this.appId), new NameValuePair(TOKEN, token));
        this.cookie = res.getRequiredField(COOKIE);
        this.wssId = res.getRequiredField(WSSID);
        String s = res.getRequiredField(EXPIRATION);
        try {
            this.expiration = System.currentTimeMillis() + Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            throw new IOException("Invalid integer value for field 'Expiration': " + s);
        }
    }

    private static Response doGet(String action, NameValuePair ... params) throws AuthenticationException, IOException {
        String uri = LC.yauth_baseuri.value() + '/' + action;
        GetMethod method = new GetMethod(uri);
        method.setQueryString(params);
        int rc = new HttpClient().executeMethod(method);
        Response res = new Response(method);
        String error = res.getField(ERROR);
        if (rc == 200 && error == null) {
            return res;
        }
        if (rc == 999) {
            throw new AuthenticationException(ErrorCode.TEMP_ERROR, "Unable to process request at this time");
        }
        ErrorCode code = error != null ? ErrorCode.get(error) : ErrorCode.GENERIC_ERROR;
        String description = res.getField(ERROR_DESCRIPTION);
        if (description == null) {
            description = code.getDescription();
        }
        AuthenticationException e = new AuthenticationException(code, description);
        e.setCaptchaUrl(res.getField(CAPTCHA_URL));
        e.setCaptchaData(res.getField(CAPTCHA_DATA));
        throw e;
    }

    public String toString() {
        return super.toString();
    }

    private static void debug(String fmt, Object ... args) {
        LOG.debug((Object)String.format(fmt, args));
    }

    private static class Response {
        final Map<String, String> attributes;

        Response(GetMethod method) throws IOException {
            String line;
            RawAuth.debug("Response status: %s", new Object[]{method.getStatusLine()});
            this.attributes = new HashMap<String, String>();
            InputStream is = method.getResponseBodyAsStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is, method.getResponseCharSet()));
            while ((line = br.readLine()) != null) {
                RawAuth.debug("Response line: %s", new Object[]{line});
                int i = line.indexOf(61);
                if (i == -1) continue;
                String name = line.substring(0, i);
                String value = line.substring(i + 1);
                this.attributes.put(name.toLowerCase(), value);
            }
        }

        String getRequiredField(String name) throws IOException {
            String value = this.getField(name);
            if (value == null) {
                throw new IOException("Response missing required '" + name + "' field");
            }
            return value;
        }

        String getField(String name) {
            String s = this.attributes.get(name.toLowerCase());
            if (s != null && (s = s.trim()).length() > 0) {
                return s;
            }
            return null;
        }
    }
}

