/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.util.yauth;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.mailbox.MetadataList;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.util.yauth.AuthenticationException;
import com.zimbra.cs.util.yauth.TokenStore;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataTokenStore
extends TokenStore {
    private final Mailbox mbox;
    private final Map<String, String> tokens;
    private static final Log LOG = ZimbraLog.datasource;
    private static final String YAUTH_KEY = "YAUTH";
    private static final String VERSION_KEY = "VERSION";
    private static final String TOKENS_KEY = "TOKENS";
    private static final long VERSION = 2L;

    public static void clearTokens(Mailbox mbox) throws ServiceException {
        mbox.setConfig(new OperationContext(mbox), YAUTH_KEY, null);
    }

    public static void copyTokens(Mailbox from, Mailbox to) throws ServiceException {
        Metadata md = from.getConfig(new OperationContext(from), YAUTH_KEY);
        if (md != null) {
            LOG.debug("Copying auth tokens from mailbox '%s' to '%s'", from.getId(), to.getId());
            to.setConfig(new OperationContext(to), YAUTH_KEY, md);
        }
    }

    public MetadataTokenStore(Mailbox mbox) throws ServiceException {
        this.mbox = mbox;
        this.tokens = new HashMap<String, String>();
        this.loadTokens();
    }

    @Override
    public String newToken(String appId, String user, String pass) throws AuthenticationException, IOException {
        LOG.debug("Generating new token for user '%s'", user);
        return super.newToken(appId, user, pass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getToken(String appId, String user) {
        MetadataTokenStore metadataTokenStore = this;
        synchronized (metadataTokenStore) {
            return this.tokens.get(MetadataTokenStore.key(appId, user));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putToken(String appId, String user, String token) {
        MetadataTokenStore metadataTokenStore = this;
        synchronized (metadataTokenStore) {
            this.tokens.put(MetadataTokenStore.key(appId, user), token);
            this.saveTokens();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeToken(String appId, String user) {
        MetadataTokenStore metadataTokenStore = this;
        synchronized (metadataTokenStore) {
            this.tokens.remove(MetadataTokenStore.key(appId, user));
        }
    }

    @Override
    public int size() {
        return this.tokens.size();
    }

    private void loadTokens() throws ServiceException {
        Metadata md = this.mbox.getConfig(new OperationContext(this.mbox), YAUTH_KEY);
        if (md != null) {
            MetadataList ml;
            long version = md.getLong(VERSION_KEY, 0L);
            if (version == 2L && (ml = md.getList(TOKENS_KEY)) != null) {
                this.loadTokens(ml);
            }
        } else {
            LOG.debug("Creating new token store for mailbox '%s'", this.mbox.getId());
        }
    }

    private void loadTokens(MetadataList ml) throws ServiceException {
        int size = ml.size();
        for (int i = 0; i < size; ++i) {
            String[] parts = ml.get(i).split(" ");
            if (parts.length != 3) continue;
            String appId = parts[0];
            String user = parts[1];
            String token = parts[2];
            this.tokens.put(MetadataTokenStore.key(appId, user), token);
        }
        LOG.debug("Loaded %d yauth token(s) for mailbox '%s'", size, this.mbox.getId());
    }

    private void saveTokens() {
        LOG.debug("Saving %d yauth token(s) for mailbox '%s'", this.tokens.size(), this.mbox.getId());
        try {
            Metadata md = new Metadata();
            md.put(VERSION_KEY, 2L);
            md.put(TOKENS_KEY, this.saveTokens(this.tokens));
            this.mbox.setConfig(new OperationContext(this.mbox), YAUTH_KEY, md);
        }
        catch (ServiceException e) {
            throw new IllegalStateException("Unable to save tokens", e);
        }
    }

    private MetadataList saveTokens(Map<String, String> tokens) {
        MetadataList ml = new MetadataList();
        for (Map.Entry<String, String> e : tokens.entrySet()) {
            ml.add(e.getKey() + " " + e.getValue());
        }
        return ml;
    }

    private static String key(String appId, String user) {
        return appId + " " + user;
    }
}

