/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.util.yauth;

import com.zimbra.cs.util.yauth.TokenStore;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class FileTokenStore
extends TokenStore {
    private final File file;
    private final Map<String, String> tokens;
    private static final Logger LOG = Logger.getLogger(FileTokenStore.class);

    public FileTokenStore(File file) throws IOException {
        this.file = file;
        this.tokens = new HashMap<String, String>();
        this.loadTokens();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getToken(String appId, String user) {
        FileTokenStore fileTokenStore = this;
        synchronized (fileTokenStore) {
            return this.tokens.get(FileTokenStore.key(appId, user));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putToken(String appId, String user, String token) {
        FileTokenStore fileTokenStore = this;
        synchronized (fileTokenStore) {
            this.tokens.put(FileTokenStore.key(appId, user), token);
            this.saveTokens();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeToken(String appId, String user) {
        FileTokenStore fileTokenStore = this;
        synchronized (fileTokenStore) {
            this.tokens.remove(FileTokenStore.key(appId, user));
        }
    }

    public int size() {
        return this.tokens.size();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveTokens() {
        FileTokenStore.debug("Saving yauth tokens to file '%s'", this.file);
        FileWriter w = null;
        w = new FileWriter(this.file);
        this.writeTokens(w);
        Object var4_2 = null;
        if (w == null) return;
        try {
            ((Writer)w).close();
            return;
        }
        catch (IOException e) {
            FileTokenStore.debug("Error closing tokens file '" + this.file + "'", e);
        }
        return;
        {
            catch (IOException e) {
                throw new IllegalStateException("Unable to save tokens", e);
            }
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (w == null) throw throwable;
            try {
                ((Writer)w).close();
                throw throwable;
            }
            catch (IOException e) {
                FileTokenStore.debug("Error closing tokens file '" + this.file + "'", e);
            }
            throw throwable;
        }
    }

    private void writeTokens(Writer w) throws IOException {
        BufferedWriter bw = new BufferedWriter(w);
        for (Map.Entry<String, String> e : this.tokens.entrySet()) {
            bw.write(e.getKey());
            bw.write(32);
            bw.write(e.getValue());
            bw.newLine();
        }
        bw.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadTokens() throws IOException {
        FileReader r = null;
        try {
            try {
                r = new FileReader(this.file);
                this.readTokens(r);
                FileTokenStore.debug("Loaded yauth tokens from file '%s'", this.file);
            }
            catch (FileNotFoundException e) {
                Object var4_3 = null;
                if (r == null) return;
                ((Reader)r).close();
                return;
            }
            catch (IOException e) {
                FileTokenStore.debug("Deleting invalid tokens file ''%s'", this.file);
                ((Reader)r).close();
                this.file.delete();
                Object var4_4 = null;
                if (r == null) return;
                ((Reader)r).close();
                return;
            }
            Object var4_2 = null;
            if (r == null) return;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (r == null) throw throwable;
            ((Reader)r).close();
            throw throwable;
        }
        ((Reader)r).close();
    }

    private void readTokens(Reader r) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(r);
        while ((line = br.readLine()) != null) {
            String[] parts = line.split(" ");
            if (parts.length != 3) {
                throw new IOException("Invalid token file");
            }
            this.tokens.put(FileTokenStore.key(parts[0], parts[1]), parts[2]);
        }
    }

    private static void debug(String fmt, Object ... args) {
        LOG.debug((Object)String.format(fmt, args));
    }

    private static String key(String appId, String user) {
        return appId + " " + user;
    }
}

