/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.util.yauth;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ErrorCode {
    INVALID_PASSWORD("InvalidPassword", "Invalid Password"),
    UNDER_AGE_USER("UnderAgeUser", "User is under age"),
    CAPTCHA_REQUIRED("CaptchaRequired", "Captcha is required"),
    USER_MUST_LOGIN("UserMustLogin", "Browser login required"),
    LOGIN_DOESNT_EXIST("LoginDoesntExist", "User login does not exist"),
    LOCKED_USER("LockedUser", "User is in locked state"),
    TEMP_ERROR("TempError", "Temporary Error"),
    HTTPS_REQUIRED("HttpsRequired", "This webservice call requires HTTPS"),
    TOKEN_REQUIRED("TokenRequired", "Invalid (missing) token"),
    INVALID_APP_ID("InvalidAppId", "Invalid (missing) appid"),
    INVALID_TOKEN("InvalidToken", "Invalid (missing) token"),
    INVALID_LOGIN_OR_PASSWORD("InvalidLoginOrPassword", "Invalid (missing) login or password"),
    INVALID_CAPTCHA_WORD_LEN("InvalidCaptchaWordLen", "Invalid (missing) captchaword"),
    INVALID_CAPTCHA_DATA("InvalidCaptchaData", "Invalid (missing) captchadata"),
    INVALID_CAPTCHA("InvalidCaptcha", "Validation of captcha failed"),
    DEACTIVATED_APP_ID("DeactivatedAppId", "Application id disabled"),
    GENERIC_ERROR("GenericError", "Unspecified error");

    private static final Map<String, ErrorCode> byName;
    private final String name;
    private final String description;

    public static ErrorCode get(String name) {
        return byName.get(name);
    }

    private ErrorCode(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    static {
        byName = new HashMap<String, ErrorCode>();
        for (ErrorCode error : ErrorCode.values()) {
            byName.put(error.name, error);
        }
    }
}

