/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.util.yauth;

import com.zimbra.cs.util.yauth.AuthenticationException;
import com.zimbra.cs.util.yauth.RawAuth;
import junit.framework.TestCase;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class AuthTest
extends TestCase {
    private static final String APPID = "D2hTUBHAkY0IEL5MA7ibTS_1K86E8RErSSaTGn4-";
    private static final String USER = "dacztest";
    private static final String PASS = "test1234";
    private static String token;

    private static String getToken() throws Exception {
        if (token == null) {
            token = RawAuth.getToken(APPID, USER, PASS);
        }
        return token;
    }

    public void testToken() throws Exception {
        token = AuthTest.getToken();
        AuthTest.assertNotNull((Object)token);
    }

    public void testAuthenticate() throws Exception {
        RawAuth auth = RawAuth.authenticate(APPID, AuthTest.getToken());
        AuthTest.assertNotNull((Object)auth.getWSSID());
        AuthTest.assertNotNull((Object)auth.getCookie());
    }

    public void testInvalidPassword() throws Exception {
        AuthenticationException error = null;
        try {
            RawAuth.getToken(APPID, USER, "invalid");
        }
        catch (AuthenticationException e) {
            error = e;
        }
        AuthTest.assertNotNull((Object)error);
    }

    static {
        BasicConfigurator.configure();
        Logger.getRootLogger().setLevel(Level.DEBUG);
    }
}

