/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.util;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.SoapTransport;
import com.zimbra.common.util.ZimbraHttpConnectionManager;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.AttributeManager;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.accesscontrol.RightManager;
import com.zimbra.cs.account.ldap.LdapProvisioning;
import com.zimbra.cs.account.ldap.ZimbraLdapContext;
import com.zimbra.cs.db.DbPool;
import com.zimbra.cs.db.Versions;
import com.zimbra.cs.extension.ExtensionUtil;
import com.zimbra.cs.im.IMRouter;
import com.zimbra.cs.im.ZimbraIM;
import com.zimbra.cs.imap.ImapServer;
import com.zimbra.cs.index.MailboxIndex;
import com.zimbra.cs.lmtpserver.LmtpServer;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.PurgeThread;
import com.zimbra.cs.mailbox.ScheduledTaskManager;
import com.zimbra.cs.mailbox.calendar.WellKnownTimeZones;
import com.zimbra.cs.memcached.MemcachedConnector;
import com.zimbra.cs.pop3.Pop3Server;
import com.zimbra.cs.redolog.RedoLogProvider;
import com.zimbra.cs.servlet.FirstServlet;
import com.zimbra.cs.session.SessionCache;
import com.zimbra.cs.session.WaitSetMgr;
import com.zimbra.cs.stats.ZimbraPerf;
import com.zimbra.cs.store.StoreManager;
import com.zimbra.cs.util.BuildInfo;
import com.zimbra.cs.util.MemoryStats;
import com.zimbra.cs.util.ZimbraApplication;
import com.zimbra.znative.Util;
import java.io.File;
import java.io.IOException;
import java.util.Timer;
import org.apache.mina.common.ByteBuffer;

public class Zimbra {
    private static boolean sInited = false;
    private static boolean sIsMailboxd = false;
    public static Timer sTimer = new Timer("Timer-Zimbra", true);

    private static void setSystemProperties() {
        System.setProperty("mail.mime.decodetext.strict", "false");
    }

    private static void checkForClass(String clzName, String jarName) {
        try {
            String s = Class.forName(clzName).getName();
            ZimbraLog.misc.debug("checked for class " + s + " and found it");
        }
        catch (ClassNotFoundException cnfe) {
            ZimbraLog.misc.error((Object)(jarName + " not in your common/lib?"), cnfe);
        }
        catch (UnsatisfiedLinkError ule) {
            ZimbraLog.misc.error((Object)("error in shared library used by " + jarName + "?"), ule);
        }
    }

    private static String getSysProperty(String prop) {
        try {
            return System.getProperty(prop);
        }
        catch (SecurityException e) {
            return "(accessing " + prop + " is not allowed by security manager)";
        }
    }

    private static void logVersionAndSysInfo() {
        ZimbraLog.misc.info("version=" + BuildInfo.VERSION + " release=" + BuildInfo.RELEASE + " builddate=" + BuildInfo.DATE + " buildhost=" + BuildInfo.HOST);
        ZimbraLog.misc.info("LANG environment is set to: " + System.getenv("LANG"));
        ZimbraLog.misc.info("System property java.home=" + Zimbra.getSysProperty("java.home"));
        ZimbraLog.misc.info("System property java.runtime.version=" + Zimbra.getSysProperty("java.runtime.version"));
        ZimbraLog.misc.info("System property java.version=" + Zimbra.getSysProperty("java.version"));
        ZimbraLog.misc.info("System property java.vm.info=" + Zimbra.getSysProperty("java.vm.info"));
        ZimbraLog.misc.info("System property java.vm.name=" + Zimbra.getSysProperty("java.vm.name"));
        ZimbraLog.misc.info("System property java.vm.version=" + Zimbra.getSysProperty("java.vm.version"));
        ZimbraLog.misc.info("System property os.arch=" + Zimbra.getSysProperty("os.arch"));
        ZimbraLog.misc.info("System property os.name=" + Zimbra.getSysProperty("os.name"));
        ZimbraLog.misc.info("System property os.version=" + Zimbra.getSysProperty("os.version"));
        ZimbraLog.misc.info("System property sun.arch.data.model=" + Zimbra.getSysProperty("sun.arch.data.model"));
        ZimbraLog.misc.info("System property sun.cpu.endian=" + Zimbra.getSysProperty("sun.cpu.endian"));
        ZimbraLog.misc.info("System property sun.cpu.isalist=" + Zimbra.getSysProperty("sun.cpu.isalist"));
        ZimbraLog.misc.info("System property sun.os.patch.level=" + Zimbra.getSysProperty("sun.os.patch.level"));
    }

    private static void checkForClasses() {
        Zimbra.checkForClass("javax.activation.DataSource", "activation.jar");
        Zimbra.checkForClass("javax.mail.internet.MimeMessage", "mail.jar");
        Zimbra.checkForClass("com.zimbra.znative.IO", "zimbra-native.jar");
    }

    public static void startup() {
        try {
            Zimbra.startup(true);
        }
        catch (ServiceException se) {
            Zimbra.halt("Exception during startup, aborting server, please check your config", se);
        }
    }

    public static void startupCLI() throws ServiceException {
        Zimbra.startup(false);
    }

    private static synchronized void startup(boolean forMailboxd) throws ServiceException {
        if (sInited) {
            return;
        }
        sIsMailboxd = forMailboxd;
        if (sIsMailboxd) {
            FirstServlet.waitForInitialization();
        }
        Zimbra.setSystemProperties();
        Zimbra.logVersionAndSysInfo();
        SoapTransport.setDefaultUserAgent("ZCS", BuildInfo.VERSION);
        Zimbra.checkForClasses();
        ZimbraApplication app = ZimbraApplication.getInstance();
        DbPool.startup();
        app.initializeZimbraDb(forMailboxd);
        if (!Versions.checkVersions()) {
            Zimbra.halt("Data version mismatch.  Reinitialize or upgrade the backend data store.");
        }
        DbPool.loadSettings();
        String tzFilePath = LC.timezone_file.value();
        try {
            File tzFile = new File(tzFilePath);
            WellKnownTimeZones.loadFromFile(tzFile);
        }
        catch (Throwable t) {
            Zimbra.halt("Unable to load timezones from " + tzFilePath, t);
        }
        Provisioning prov = Provisioning.getInstance();
        if (prov instanceof LdapProvisioning) {
            ZimbraLdapContext.waitForServer();
            if (forMailboxd) {
                AttributeManager.loadLdapSchemaExtensionAttrs((LdapProvisioning)prov);
            }
        }
        try {
            RightManager.getInstance();
        }
        catch (ServiceException e) {
            Util.halt((String)"cannot initialize RightManager", (Throwable)e);
        }
        ZimbraHttpConnectionManager.startReaperThread();
        try {
            StoreManager.getInstance().startup();
        }
        catch (IOException e) {
            throw ServiceException.FAILURE("Unable to initialize StoreManager.", e);
        }
        MailboxManager.getInstance();
        app.startup();
        if (app.supports(MemcachedConnector.class.getName())) {
            MemcachedConnector.startup();
        }
        if (app.supports(ExtensionUtil.class.getName())) {
            ExtensionUtil.initAll();
        }
        MailboxIndex.startup();
        RedoLogProvider redoLog = RedoLogProvider.getInstance();
        if (sIsMailboxd) {
            redoLog.startup();
        } else {
            redoLog.initRedoLogManager();
        }
        System.setProperty("ical4j.unfolding.relaxed", "true");
        MailboxManager.getInstance().startup();
        app.initialize(sIsMailboxd);
        if (sIsMailboxd) {
            SessionCache.startup();
            if (!redoLog.isSlave()) {
                Server server = Provisioning.getInstance().getLocalServer();
                boolean useDirectBuffers = server.getBooleanAttr("zimbraMailUseDirectBuffers", false);
                ByteBuffer.setUseDirectBuffers((boolean)useDirectBuffers);
                ZimbraLog.misc.info("MINA setUseDirectBuffers(" + useDirectBuffers + ")");
                if (app.supports(ZimbraIM.class.getName()) && server.getBooleanAttr("zimbraXMPPEnabled", false)) {
                    ZimbraIM.startup();
                }
                if (app.supports(LmtpServer.class.getName())) {
                    LmtpServer.startupLmtpServer();
                }
                if (app.supports(Pop3Server.class.getName()) && server.getBooleanAttr("zimbraPop3ServerEnabled", false)) {
                    Pop3Server.startupPop3Server();
                }
                if (app.supports(Pop3Server.class.getName()) && server.getBooleanAttr("zimbraPop3SSLServerEnabled", false)) {
                    Pop3Server.startupPop3SSLServer();
                }
                if (app.supports(ImapServer.class.getName()) && server.getBooleanAttr("zimbraImapServerEnabled", false)) {
                    ImapServer.startupImapServer();
                }
                if (app.supports(ImapServer.class.getName()) && server.getBooleanAttr("zimbraImapSSLServerEnabled", false)) {
                    ImapServer.startupImapSSLServer();
                }
            }
            if (app.supports(WaitSetMgr.class.getName())) {
                WaitSetMgr.startup();
            }
            if (app.supports(MemoryStats.class.getName())) {
                MemoryStats.startup();
            }
            if (app.supports(ScheduledTaskManager.class.getName())) {
                ScheduledTaskManager.startup();
            }
            if (app.supports(PurgeThread.class.getName())) {
                PurgeThread.startup();
            }
            if (app.supports(ZimbraPerf.class.getName())) {
                ZimbraPerf.initialize();
            }
        }
        if (app.supports(ExtensionUtil.class.getName())) {
            ExtensionUtil.postInitAll();
        }
        sInited = true;
    }

    public static synchronized void shutdown() throws ServiceException {
        if (!sInited) {
            return;
        }
        sInited = false;
        if (sIsMailboxd) {
            PurgeThread.shutdown();
        }
        ZimbraApplication app = ZimbraApplication.getInstance();
        app.shutdown();
        if (sIsMailboxd) {
            if (app.supports(MemoryStats.class.getName())) {
                MemoryStats.shutdown();
            }
            if (app.supports(WaitSetMgr.class.getName())) {
                WaitSetMgr.shutdown();
            }
        }
        RedoLogProvider redoLog = RedoLogProvider.getInstance();
        if (sIsMailboxd) {
            if (!redoLog.isSlave()) {
                if (app.supports(LmtpServer.class.getName())) {
                    LmtpServer.shutdownLmtpServer();
                }
                if (app.supports(Pop3Server.class.getName())) {
                    Pop3Server.shutdownPop3Servers();
                }
                if (app.supports(ImapServer.class.getName())) {
                    ImapServer.shutdownImapServers();
                }
            }
            if (app.supports(ZimbraIM.class.getName())) {
                ZimbraIM.shutdown();
            }
            SessionCache.shutdown();
        }
        MailboxIndex.shutdown();
        if (sIsMailboxd && app.supports(IMRouter.class.getName())) {
            IMRouter.getInstance().shutdown();
        }
        if (sIsMailboxd) {
            redoLog.shutdown();
        }
        if (app.supports(ExtensionUtil.class.getName())) {
            ExtensionUtil.destroyAll();
        }
        if (app.supports(MemcachedConnector.class.getName())) {
            MemcachedConnector.shutdown();
        }
        MailboxManager.getInstance().shutdown();
        if (sIsMailboxd) {
            StoreManager.getInstance().shutdown();
        }
        ZimbraHttpConnectionManager.shutdownReaperThread();
        sTimer.cancel();
    }

    public static synchronized boolean started() {
        return sInited;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void halt(String message) {
        try {
            ZimbraLog.system.fatal(message);
            Object var2_1 = null;
            Runtime.getRuntime().halt(1);
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            Runtime.getRuntime().halt(1);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void halt(String message, Throwable t) {
        try {
            ZimbraLog.system.fatal((Object)message, t);
            Object var3_2 = null;
            Runtime.getRuntime().halt(1);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Runtime.getRuntime().halt(1);
            throw throwable;
        }
    }
}

